/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-file.h DvdFileIO object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif


#ifndef __DVD_FILE_IO_H__
#define __DVD_FILE_IO_H__

G_BEGIN_DECLS

/* --- type macros --- */
#define DVD_FILE_IO_TYPE	(dvd_file_io_get_type())
#define DVD_FILE_IO(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_FILE_IO_TYPE, DvdFileIO))
#define DVD_FILE_IO_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_FILE_IO_TYPE, DvdFileIOClass))
#define DVD_IS_FILE_IO(o)	(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_FILE_IO_TYPE))
#define DVD_IS_FILE_IO_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_FILE_IO_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdFileIO	DvdFileIO;
typedef struct	_DvdFileIOClass	DvdFileIOClass;
typedef struct	_DvdFileIOPriv	DvdFileIOPriv;
typedef enum	_DvdFileIORW	DvdFileIORW;

enum _DvdFileIORW {
	DVD_FILE_IO_READ,
	DVD_FILE_IO_WRITE
};

struct _DvdFileIO {
	GObject	parent;
	
	/*<private>*/
	DvdFileIOPriv	*priv;
};

struct _DvdFileIOClass {
	GObjectClass parent;
	
	void (*file_progress)	(DvdFileIO	*file,
				 guint8		 percent);
};

/* --- prototypes --- */
GType		dvd_file_io_get_type	(void);
DvdFileIO*	dvd_file_io_new		(void);
gboolean	dvd_file_io_open	(DvdFileIO	 *file,
					 const gchar	 *file_path,
					 DvdFileIORW	  rw,
					 gboolean	  allow_trunc,
					 GError		**error);
gboolean	dvd_file_io_open_temp	(DvdFileIO	 *file,
					 gchar		 *template,
					 GError		**error);
gsize		dvd_file_io_size	(DvdFileIO	 *file);
G_CONST_RETURN
gchar*		dvd_file_io_get_path	(DvdFileIO	 *file);
gint		dvd_file_io_get_fd	(DvdFileIO	 *file);
gsize		dvd_file_io_get_position(DvdFileIO	 *file);
void		dvd_file_io_set_position(DvdFileIO	 *file,
					 gsize		  position);
gboolean	dvd_file_io_close	(DvdFileIO	 *file,
					 GError		**error);
gboolean	dvd_file_io_get_contents(DvdFileIO	 *file,
					 guint8		**data,
					 gsize		 *length,
					 GError		**error);
gboolean	dvd_file_io_read_line	(DvdFileIO	 *file,
					 guint8		**line,
					 gboolean	  ignore_comments,
					 GError		**error);
gboolean	dvd_file_io_read	(DvdFileIO	 *file,
					 guint8		 *data,
					 gsize		  length,
					 gsize		 *bytes_read,
					 GError		**error);
gssize		dvd_file_io_read_byte	(DvdFileIO	 *file,
					 guint8		 *byte,
					 GError		**error);
gboolean	dvd_file_io_seek	(DvdFileIO	 *file,
					 gsize		  position,
					 GError		**error);
gboolean	dvd_file_io_write	(DvdFileIO	 *file,
					 const guint8	 *data,
					 gsize		  length,
					 GError		**error);
gboolean	dvd_file_io_move	(DvdFileIO	 *file,
					 const gchar	 *file_path,
					 GError		**error);
gboolean	dvd_file_io_copy	(DvdFileIO	 *src_file,
					 const gchar	 *file_path,
					 gboolean	  allow_trunc,
					 GError		**error);
gboolean	dvd_file_io_truncate	(DvdFileIO	 *file,
					 GError		**error);

G_END_DECLS

#endif /*__DVD_FILE_IO_H__*/
