/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-file-track.h DvdFileTrack object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_FILE_TRACK_H__
#define __DVD_FILE_TRACK_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_FILE_TRACK_TYPE		(dvd_file_track_get_type())
#define DVD_FILE_TRACK(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_FILE_TRACK_TYPE, DvdFileTrack))
#define DVD_FILE_TRACK_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, DVD_FILE_TRACK_TYPE, DvdFileTrackClass))
#define DVD_IS_FILE_TRACK(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_FILE_TRACK_TYPE))
#define DVD_IS_FILE_TRACK_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_FILE_TRACK_TYPE))

/* --- typedefs & structures --- */
/** Object representing a DVD track */
typedef struct	_DvdFileTrack		DvdFileTrack;
/** Object class representing a DVD track */
typedef struct	_DvdFileTrackClass	DvdFileTrackClass;

/** Type of track */
typedef enum _DvdFileTrackType {
	DVD_FILE_TRACK_VIDEO,		/**< The track is a DVD compliant mpeg video stream */
	DVD_FILE_TRACK_AUDIO,		/**< The track is a DVD compliant audio stream */
	DVD_FILE_TRACK_SUB_PICTURE,	/**< Not in use yet */
	DVD_FILE_TRACK_UNKNOWN
} DvdFileTrackType;


struct _DvdFileTrack {
	DvdFileIO	 parent;
	
	DvdFileTrackType track_type;
	union {
		DvdVideo *dvd_video;
		DvdAudio *dvd_audio;
		void	 *pad_sub_picture;
	};
	guint32	  time_stamp;
	gboolean  time_stamp_set;
};

struct _DvdFileTrackClass {
	DvdFileIOClass	parent;
};

/* --- prototypes --- */
GType		 dvd_file_track_get_type		(void);
DvdFileTrack*	 dvd_file_track_new			(void);
void		 dvd_file_track_set_audio_properties	(DvdFileTrack	*file_track,
							 const DvdAudio	*dvd_audio);
DvdAudio*	 dvd_file_track_get_audio_properties	(DvdFileTrack	*file_track);
void		 dvd_file_track_set_video_properties	(DvdFileTrack	*file_track,
							 const DvdVideo	*dvd_video);
DvdVideo*	 dvd_file_track_get_video_properties	(DvdFileTrack	*file_track);
void		 dvd_file_track_set_time_stamp		(DvdFileTrack	*file_track,
							 guint32	 time_stamp);
guint32		 dvd_file_track_get_time_stamp		(DvdFileTrack	*file_track);
gboolean	 dvd_file_track_get_time_stamp_set	(DvdFileTrack	*file_track);
DvdFileTrackType dvd_file_track_get_track_type		(DvdFileTrack	*file_track);

G_END_DECLS

#endif /*__DVD_FILE_TRACK_H__*/
