/* qshutdown, a program to shutdown/reboot/suspend/hibernate the system
 * Copyright (C) 2009 2010  Christian Metscher <hakaishi@web.de>

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "gui.h"
#include <QApplication>

bool verbose; //this is a global variable needed in power.cpp

int main(int argc, char *argv[]){

     // here the QT_program is created
     QApplication app(argc, argv);

     //Qt translations
     QTranslator qtTranslator;
     qtTranslator.load("qt_" + QLocale::system().name(),
       QLibraryInfo::location(QLibraryInfo::TranslationsPath));
     app.installTranslator(&qtTranslator);

     //My translations
     QString lo = ":/locale/" + QLocale::system().name();
     QTranslator translator;
     translator.load(lo);
     app.installTranslator(&translator);

     QString info = QString(QObject::tr("qshutdown will show it self 3 times as a warning "
     "if there are less than 70 seconds left.\n\n"
     "This program uses qdbus to send a shutdown/reboot/suspend/hibernate request to either "
     "the gnome- or kde-session-manager, to HAL or to DeviceKit and if none of "
     "these works, the command 'sudo shutdown' will be used (note that when sending the "
     "request to HAL or DeviceKit, or the shutdown command is used, the Session will never "
     "be saved. If the shutdown command is used, the program will only be able to shutdown and "
     "reboot). So if nothing happens when the shutdown- or reboot-time is reached, it means "
     "that one lacks the rights for the shutdown command. In this case one can do the following:\n\n"
     "Paste the following in a terminal:\n"
     "\"EDITOR:nano sudo -E visudo\" and add this line:\n"
     "\"* ALL = NOPASSWD:/sbin/shutdown\" whereas * replaces the username or %groupname.\n\n"
     "The maximum Number of countdown_minutes is 1440 (24 hours).\n"
     "The configurationfile (and logfile) is located at ~/.qshutdown (under Linux/Unix).\n\n"
     "For admins:\nWith the option Lock_all in qshutdown.conf set to true the user won't be able "
     "to change any settings. If you change the permissions of qshutdown.conf with \"sudo chown "
     "root -R ~/.qshutdown\" and \"sudo chmod 744 ~/.qshutdown/qshutdown.conf\", the user won't "
     "be able to change anything in the configurationfile too."));

     //Get the arguments passed from the terminal
     QStringList args = QApplication::arguments();
     args.removeFirst(); //this is just the program
     for(int i=1; i<args.size();args.removeLast());
     if(!args.empty()){
       QString arg = args[0];
       if(arg[0] == '-'){
         if(arg.contains("h") || args.contains("--help"))
           qDebug() << "\nqshutdown [ options ... ]\n\nOptions are:\n\t-h "
                       "or --help\tPrints this message.\n\t-i\t\tPrints "
                       "informations.\n\t-v\t\tPrints all errors and warnings.\n";
         if(arg.contains("i"))
           qDebug() << info;
       }
       if(!((arg[0] == '-') && (arg.contains("h") || args.contains("--help")
          || arg.contains("i") || arg.contains("-v"))))
         qDebug() << " Wrong options! Try qshutdown -h";
       if(args.first() == "-v")
         verbose = true;
     }
     if(!args.empty() && !(args.first() == "-v"))
       exit(0);

     Gui window; //Create the main widget

     #ifndef Q_OS_WIN32
       QDBusConnection::sessionBus().registerObject(OBJECT_NAME, &window,
         QDBusConnection::ExportScriptableSlots);
       if(QDBusConnection::sessionBus().registerService(SERVICE_NAME)){
         //if possible register qshutdown as a service in the session bus
     #endif //Q_OS_WIN32
         window.informations = info;
         window.loadSettings();
     #ifdef Q_OS_WIN32
         window.center();
     #endif //Q_OS_WIN32
         window.show();
         app.setQuitOnLastWindowClosed(false);

         return app.exec();

     #ifndef Q_OS_WIN32
       }
       else{ //if registering qshutdown fails (also because it is already
             // registered, show window
         QDBusInterface(SERVICE_NAME, OBJECT_NAME, "org.qshutdown.iface",
           QDBusConnection::sessionBus(), &window).call("showRunningProgram");
       }
     #endif //Q_OS_WIN32
}
