/* qshutdown, a program to shutdown the shutdown/reboot/suspend/hibernate
 * Copyright (C) 2009 2010  Christian Metscher <hakaishi@web.de>

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "power.h"
#ifndef Q_OS_WIN32
  #include <QtDBus>
#endif

extern bool verbose;

namespace Power{

void shutdown(){
   #ifdef Q_OS_WIN32
     QProcess::startDetached("shutdown -s -f -t 00"); // Windows command to shutdown immediately
   #else
     bool shutdown_works = false;
     bool gnome_power1 = false;
     bool gnome_power2 = false;
     bool hal_works = false;
     QDBusMessage response;

     QDBusInterface gnomeSessionManager("org.gnome.SessionManager",
       "/org/gnome/SessionManager", "org.gnome.SessionManager",
       QDBusConnection::sessionBus());
     response = gnomeSessionManager.call("RequestShutdown");
     if(response.type() == QDBusMessage::ErrorMessage){
       if(verbose)
         qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       gnome_power1 = QProcess::startDetached("gnome-power-cmd.sh shutdown");
       gnome_power2 = QProcess::startDetached("gnome-power-cmd shutdown");
       if(verbose && !gnome_power1 && !gnome_power2)
         qWarning() << "W: gnome-power-cmd and gnome-power-cmd.sh didn't work";
     }
     else
       shutdown_works = true;

     QDBusInterface kdeSessionManager("org.kde.ksmserver", "/KSMServer",
       "org.kde.KSMServerInterface", QDBusConnection::sessionBus());
     response = kdeSessionManager.call("logout", 0, 2, 2);
     if(response.type() == QDBusMessage::ErrorMessage){
       if(verbose)
         qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
     }
     else
       shutdown_works = true;

     if(!shutdown_works && !gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.Hal",
         "/org/freedesktop/Hal/devices/computer",
         "org.freedesktop.Hal.Device.SystemPowerManagement",
         QDBusConnection::systemBus());
       response = powermanagement.call("Shutdown");
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       }
       else
         hal_works = true;
     }

     if(!hal_works && !shutdown_works && !gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.ConsoleKit",
         "/org/freedesktop/ConsoleKit/Manager", "org.freedesktop.ConsoleKit.Manager",
         QDBusConnection::systemBus());
       response = powermanagement.call("Stop");
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
         QProcess::startDetached("sudo shutdown -P now");
       }
     }
   #endif
}

void reboot(){
   #ifdef Q_OS_WIN32
     QProcess::startDetached("shutdown -r -f -t 00"); // Windows command to reboot immediately
   #else
     bool reboot_works = false;
     bool gnome_power1 = false;
     bool gnome_power2 = false;
     bool hal_works = false;
     QDBusMessage response;

     QDBusInterface gnomeSessionManager("org.gnome.SessionManager",
       "/org/gnome/SessionManager", "org.gnome.SessionManager",
       QDBusConnection::sessionBus());
     response = gnomeSessionManager.call("RequestReboot");
     if(response.type() == QDBusMessage::ErrorMessage){
       if(verbose)
         qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       gnome_power1 = QProcess::startDetached("gnome-power-cmd.sh reboot");
       gnome_power2 = QProcess::startDetached("gnome-power-cmd reboot");
       if(verbose && !gnome_power1 && !gnome_power2)
         qWarning() << "W: gnome-power-cmd and gnome-power-cmd.sh didn't work";
     }
     else
       reboot_works = true;

     QDBusInterface kdeSessionManager("org.kde.ksmserver", "/KSMServer",
       "org.kde.KSMServerInterface", QDBusConnection::sessionBus());
     response = kdeSessionManager.call("logout", 0, 2, 1);
     if(response.type() == QDBusMessage::ErrorMessage){
       if(verbose)
         qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
     }
     else
       reboot_works = true;

     if(!reboot_works && !gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.Hal",
         "/org/freedesktop/Hal/devices/computer",
         "org.freedesktop.Hal.Device.SystemPowerManagement",
         QDBusConnection::systemBus());
       response = powermanagement.call("Reboot");
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       }
       else
         hal_works = true;
     }

     if(!hal_works && !reboot_works && !gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.ConsoleKit",
         "/org/freedesktop/ConsoleKit/Manager", "org.freedesktop.ConsoleKit.Manager",
         QDBusConnection::systemBus());
       response = powermanagement.call("Restart");
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
         QProcess::startDetached("sudo shutdown -r now");
       }
     }
   #endif
}

void suspend(){
   #ifdef Q_OS_WIN32
     QProcess::startDetached("rundll32 powrprof.dll,SetSuspendState"); // Windows command to suspend immediately
   #else
     bool gnome_power1 = false;
     bool gnome_power2 = false;
     bool hal_works = false;
     QDBusMessage response;

     gnome_power1 = QProcess::startDetached("gnome-power-cmd.sh suspend");
     gnome_power2 = QProcess::startDetached("gnome-power-cmd suspend");
     if(!gnome_power1 && !gnome_power2 && verbose)
       qWarning() << "W: gnome-power-cmd and gnome-power-cmd.sh didn't work";

     if(!gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.Hal",
         "/org/freedesktop/Hal/devices/computer",
         "org.freedesktop.Hal.Device.SystemPowerManagement",
         QDBusConnection::systemBus());
       response = powermanagement.call("Suspend",0);
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       }
       else
         hal_works = true;
     }

     if(!hal_works && !gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.DeviceKit.Power",
         "/org/freedesktop/DeviceKit/Power",
         "org.freedesktop.DeviceKit.Power", QDBusConnection::systemBus());
       response = powermanagement.call("Suspend");
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       }
     }
   #endif
}

void hibernate(){
   #ifdef Q_OS_WIN32
     QProcess::startDetached("rundll32 powrprof.dll,SetSuspendState"); // Windows command to hibernate immediately
   #else
     bool gnome_power1 = false;
     bool gnome_power2 = false;
     bool hal_works = false;
     QDBusMessage response;

     gnome_power1 = QProcess::startDetached("gnome-power-cmd.sh hibernate");
     gnome_power2 = QProcess::startDetached("gnome-power-cmd hibernate");
     if(!gnome_power1 && !gnome_power2 && verbose)
       qWarning() << "W: gnome-power-cmd and gnome-power-cmd.sh didn't work";

     if(!gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.Hal",
         "/org/freedesktop/Hal/devices/computer",
         "org.freedesktop.Hal.Device.SystemPowerManagement",
         QDBusConnection::systemBus());
       response = powermanagement.call("Hibernate");
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       }
       else
         hal_works = true;
     }

     if(!hal_works && !gnome_power1 && !gnome_power2){
       QDBusInterface powermanagement("org.freedesktop.DeviceKit.Power", "/org/freedesktop/DeviceKit/Power",
         "org.freedesktop.DeviceKit.Power", QDBusConnection::systemBus());
       if(response.type() == QDBusMessage::ErrorMessage){
         if(verbose)
           qWarning() << "W: " << response.errorName() << ":" << response.errorMessage();
       }
     }
   #endif
}

}
