/* $Id: partition.c,v 1.5 2003/05/30 00:42:37 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "partition.h"
#include "cfe_api.h"
#include "libc.h"


/*
 * Recurse down the current chain of partitions.  Return 0 if found, nonzero otherwise
 */
static int part_table_recurse(int handle, unsigned long ext_part_sector, unsigned long sector_offset, int *cur_part, 
			       int desired_part, part_entry_t *part_info)
{
	int i;
	long long offset = (512 * ((long long)ext_part_sector + sector_offset)) + 0x1be;
	part_entry_t entry;
	int res;

	for (i = 0; i < 4; i++) {
		res =cfe_readblk(handle, offset, (char *)&entry, sizeof(part_entry_t));
		if (res != sizeof(part_entry_t)) {
		    return -1;
		    }

		if (entry.size) {
			if (entry.id == 0x5) {
				if (!part_table_recurse(handle, ext_part_sector, le_to_cpu32(entry.start_sector), 
							cur_part, desired_part, part_info)) {
					return 0;
				}
			} else if ((*cur_part == desired_part) ||
			           ((desired_part == -1) && (entry.id == 0x83))) {
				lib_memcpy(part_info, &entry, sizeof(part_entry_t));
				return 0;
			}
			*cur_part++;
		}
		offset += 16;
	}
	/* Didn't find it */
	return -1;
}


int part_get_info(int handle, int partno, part_entry_t *part_info)
{
	int part = 0;
	return part_table_recurse(handle, 0, 0, &part, partno, part_info);
}
