##
## This file is part of the sigrok project.
##
## Copyright (C) 2011 Uwe Hermann <uwe@hermann-uwe.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
##

#
# This file is used to create the official sigrok Windows installer via NSIS.
# Read the HACKING file in the sigrok source tree for details.
#
# NSIS documentation:
# http://nsis.sourceforge.net/Docs/
# http://nsis.sourceforge.net/Docs/Modern%20UI%202/Readme.html
#

# Include the "Modern UI" header, which gives us the usual Windows look-n-feel.
!include "MUI2.nsh"

# --- Global stuff ------------------------------------------------------------

# Installer/product name.
Name "sigrok"

# Filename of the installer executable.
OutFile "sigrok-installer-0.1.exe"

# Where to install the application.
InstallDir "$PROGRAMFILES\sigrok"

# Request application privileges for Windows Vista.
RequestExecutionLevel user


# --- MUI interface configuration ---------------------------------------------

# Use the following icon for the installer EXE file.
!define MUI_ICON "..\..\gui\icons\sigrok-logo-notext.ico"

# Show a nice image at the top of each installer page.
!define MUI_HEADERIMAGE

# Don't automatically go to the Finish page so the user can check the log.
!define MUI_FINISHPAGE_NOAUTOCLOSE

# Upon "cancel", ask the user if he really wants to abort the installer.
!define MUI_ABORTWARNING

# Don't force the user to accept the license, just show it.
# Details: http://trac.videolan.org/vlc/ticket/3124
!define MUI_LICENSEPAGE_BUTTON $(^NextBtn)
!define MUI_LICENSEPAGE_TEXT_BOTTOM "Click Next to continue."


# --- MUI pages ---------------------------------------------------------------

# Show a nice "Welcome to the ... Setup Wizard" page.
!insertmacro MUI_PAGE_WELCOME

# Show the license text which the user has to accept.
!insertmacro MUI_PAGE_LICENSE "..\..\COPYING"

# Allow the user to select a different install directory.
!insertmacro MUI_PAGE_DIRECTORY

# Perform the actual installation, i.e. install the files.
!insertmacro MUI_PAGE_INSTFILES

# Show a final "We're done, click Finish to close this wizard" message.
!insertmacro MUI_PAGE_FINISH

# Pages used for the uninstaller.
!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH


# --- MUI language files ------------------------------------------------------

# Select an installer language (required!).
!insertmacro MUI_LANGUAGE "English"


# --- Default section ---------------------------------------------------------

Section

	# Install the file(s) specified below into the specified directory.
	SetOutPath "$INSTDIR"

	# License file
	File "..\..\COPYING"

	# sigrok libs
	File "dist\lib\libsigrok.a"
	File "dist\lib\libsigrok.la"
	File "dist\lib\libsigrokdecode.a"
	File "dist\lib\libsigrokdecode.la"

	# sigrok-cli
	File "dist\bin\sigrok-cli.exe"

	# sigrok-gui
	File "..\..\gui\release\sigrok-gui.exe"

	# MinGW libs
	File "c:\MinGW\bin\intl.dll"
	File "c:\MinGW\bin\libiconv-2.dll"
	File "c:\MinGW\bin\libstdc++-6.dll"

	# External libs
	File "c:\MinGW\msys\1.0\local\bin\libglib-2.0-0.dll"
	File "c:\MinGW\msys\1.0\local\bin\libgthread-2.0-0.dll"
	File "c:\MinGW\msys\1.0\local\bin\libusb-1.0.dll"
	File "c:\MinGW\msys\1.0\local\bin\libzip-1.dll"

	# Qt libs
	File "c:\Qt\2010.05\qt\bin\libgcc_s_dw2-1.dll"
	File "c:\Qt\2010.05\qt\bin\mingwm10.dll"
	File "c:\Qt\2010.05\qt\bin\QtCore4.dll"
	File "c:\Qt\2010.05\qt\bin\QtGui4.dll"

	# Install the file(s) specified below into the specified directory.
	SetOutPath "$INSTDIR\decoders"

	# Protocol decoders
	File "dist\share\sigrok\*.py"

	# Generate the uninstaller executable.
	WriteUninstaller "$INSTDIR\Uninstall.exe"

	# Create a sub-directory in the start menu.
	CreateDirectory "$SMPROGRAMS\sigrok"

	# Create a shortcut for the application.
	CreateShortCut "$SMPROGRAMS\sigrok\sigrok.lnk" \
		"$INSTDIR\sigrok-gui.exe" "" "$INSTDIR\sigrok-gui.exe" \
		0 SW_SHOWNORMAL \
		"" "Open-source, portable logic analyzer software"

	# Create a shortcut for the uninstaller.
	CreateShortCut "$SMPROGRAMS\sigrok\Uninstall.lnk" \
		"$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0 \
		SW_SHOWNORMAL "" "Uninstall sigrok"

SectionEnd

# --- Uninstaller section -----------------------------------------------------

Section "Uninstall"

	# Always delete the uninstaller first (yes, this really works).
	Delete "$INSTDIR\Uninstall.exe"

	# Delete the application, the application data, and related libs.
	Delete "$INSTDIR\COPYING"
	Delete "$INSTDIR\libsigrok.a"
	Delete "$INSTDIR\libsigrok.la"
	Delete "$INSTDIR\libsigrokdecode.a"
	Delete "$INSTDIR\libsigrokdecode.la"
	Delete "$INSTDIR\sigrok-cli.exe"
	Delete "$INSTDIR\sigrok-gui.exe"
	Delete "$INSTDIR\intl.dll"
	Delete "$INSTDIR\libiconv-2.dll"
	Delete "$INSTDIR\libstdc++-6.dll"
	Delete "$INSTDIR\libglib-2.0-0.dll"
	Delete "$INSTDIR\libgthread-2.0-0.dll"
	Delete "$INSTDIR\libusb-1.0.dll"
	Delete "$INSTDIR\libzip-1.dll"
	Delete "$INSTDIR\libgcc_s_dw2-1.dll"
	Delete "$INSTDIR\mingwm10.dll"
	Delete "$INSTDIR\QtCore4.dll"
	Delete "$INSTDIR\QtGui4.dll"
	Delete "$INSTDIR\decoders\*.py"

	# Delete the install directory and its sub-directories.
	RMDir "$INSTDIR\decoders"
	RMDir "$INSTDIR"

	# Delete the links from the start menu.
	Delete "$SMPROGRAMS\sigrok\sigrok.lnk"
	Delete "$SMPROGRAMS\sigrok\Uninstall.lnk"

	# Delete the sub-directory in the start menu.
	RMDir "$SMPROGRAMS\sigrok"

SectionEnd

