;;  Filename : test-number-cmp.scm
;;  About    : unit tests for number comparators
;;
;;  Copyright (C) 2006 YAMAMOTO Kengo <yamaken AT bp.iij4u.or.jp>
;;  Copyright (c) 2007 SigScheme Project <uim AT freedesktop.org>
;;
;;  All rights reserved.
;;
;;  Redistribution and use in source and binary forms, with or without
;;  modification, are permitted provided that the following conditions
;;  are met:
;;
;;  1. Redistributions of source code must retain the above copyright
;;     notice, this list of conditions and the following disclaimer.
;;  2. Redistributions in binary form must reproduce the above copyright
;;     notice, this list of conditions and the following disclaimer in the
;;     documentation and/or other materials provided with the distribution.
;;  3. Neither the name of authors nor the names of its contributors
;;     may be used to endorse or promote products derived from this software
;;     without specific prior written permission.
;;
;;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
;;  IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
;;  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;;  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
;;  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;;  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
;;  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

(load "./test/unittest.scm")

(if (not (symbol-bound? 'number?))
    (test-skip "R5RS numbers is not enabled"))

(define tn test-name)


(tn "= invalid forms")
(assert-error  (tn) (lambda () (=)))
(assert-error  (tn) (lambda () (= 1)))
(assert-error  (tn) (lambda () (= #t #t)))
(assert-error  (tn) (lambda () (= #f #f)))
(assert-error  (tn) (lambda () (= '() '())))
(tn "= 2 args")
(assert-eq?    (tn) #t (= -2 -2))
(assert-eq?    (tn) #f (= -2 -1))
(assert-eq?    (tn) #f (= -2 0))
(assert-eq?    (tn) #f (= -2 1))
(assert-eq?    (tn) #f (= -2 2))
(assert-eq?    (tn) #f (= -1 -2))
(assert-eq?    (tn) #t (= -1 -1))
(assert-eq?    (tn) #f (= -1 0))
(assert-eq?    (tn) #f (= -1 1))
(assert-eq?    (tn) #f (= -1 2))
(assert-eq?    (tn) #f (= 0 -2))
(assert-eq?    (tn) #f (= 0 -1))
(assert-eq?    (tn) #t (= 0 0))
(assert-eq?    (tn) #f (= 0 1))
(assert-eq?    (tn) #f (= 0 2))
(assert-eq?    (tn) #f (= 1 -2))
(assert-eq?    (tn) #f (= 1 -1))
(assert-eq?    (tn) #f (= 1 0))
(assert-eq?    (tn) #t (= 1 1))
(assert-eq?    (tn) #f (= 1 2))
(assert-eq?    (tn) #f (= 2 -2))
(assert-eq?    (tn) #f (= 2 -1))
(assert-eq?    (tn) #f (= 2 0))
(assert-eq?    (tn) #f (= 2 1))
(assert-eq?    (tn) #t (= 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "= 2 args 64-bit")
      (string-eval "(assert-eq? (tn) #t (=    956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #f (=    956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (=   -956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #t (=   -956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (=    956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=   -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=    956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=   -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=  13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #f (=  13121090146595   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (= -13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #f (= -13121090146595   -956397711204))")))
(tn "= 3 args")
(assert-eq?    (tn) #t (= -2 -2 -2))
(assert-eq?    (tn) #f (= -2 -2 -1))
(assert-eq?    (tn) #f (= -2 -2 0))
(assert-eq?    (tn) #f (= -2 -2 1))
(assert-eq?    (tn) #f (= -2 -2 2))
(assert-eq?    (tn) #f (= -2 -1 -2))
(assert-eq?    (tn) #f (= -2 -1 -1))
(assert-eq?    (tn) #f (= -2 -1 0))
(assert-eq?    (tn) #f (= -2 -1 1))
(assert-eq?    (tn) #f (= -2 -1 2))
(assert-eq?    (tn) #f (= -2 0 -2))
(assert-eq?    (tn) #f (= -2 0 -1))
(assert-eq?    (tn) #f (= -2 0 0))
(assert-eq?    (tn) #f (= -2 0 1))
(assert-eq?    (tn) #f (= -2 0 2))
(assert-eq?    (tn) #f (= -2 1 -2))
(assert-eq?    (tn) #f (= -2 1 -1))
(assert-eq?    (tn) #f (= -2 1 0))
(assert-eq?    (tn) #f (= -2 1 1))
(assert-eq?    (tn) #f (= -2 1 2))
(assert-eq?    (tn) #f (= -2 2 -2))
(assert-eq?    (tn) #f (= -2 2 -1))
(assert-eq?    (tn) #f (= -2 2 0))
(assert-eq?    (tn) #f (= -2 2 1))
(assert-eq?    (tn) #f (= -2 2 2))
(assert-eq?    (tn) #f (= -1 -2 -2))
(assert-eq?    (tn) #f (= -1 -2 -1))
(assert-eq?    (tn) #f (= -1 -2 0))
(assert-eq?    (tn) #f (= -1 -2 1))
(assert-eq?    (tn) #f (= -1 -2 2))
(assert-eq?    (tn) #f (= -1 -1 -2))
(assert-eq?    (tn) #t (= -1 -1 -1))
(assert-eq?    (tn) #f (= -1 -1 0))
(assert-eq?    (tn) #f (= -1 -1 1))
(assert-eq?    (tn) #f (= -1 -1 2))
(assert-eq?    (tn) #f (= -1 0 -2))
(assert-eq?    (tn) #f (= -1 0 -1))
(assert-eq?    (tn) #f (= -1 0 0))
(assert-eq?    (tn) #f (= -1 0 1))
(assert-eq?    (tn) #f (= -1 0 2))
(assert-eq?    (tn) #f (= -1 1 -2))
(assert-eq?    (tn) #f (= -1 1 -1))
(assert-eq?    (tn) #f (= -1 1 0))
(assert-eq?    (tn) #f (= -1 1 1))
(assert-eq?    (tn) #f (= -1 1 2))
(assert-eq?    (tn) #f (= -1 2 -2))
(assert-eq?    (tn) #f (= -1 2 -1))
(assert-eq?    (tn) #f (= -1 2 0))
(assert-eq?    (tn) #f (= -1 2 1))
(assert-eq?    (tn) #f (= -1 2 2))
(assert-eq?    (tn) #f (= 0 -2 -2))
(assert-eq?    (tn) #f (= 0 -2 -1))
(assert-eq?    (tn) #f (= 0 -2 0))
(assert-eq?    (tn) #f (= 0 -2 1))
(assert-eq?    (tn) #f (= 0 -2 2))
(assert-eq?    (tn) #f (= 0 -1 -2))
(assert-eq?    (tn) #f (= 0 -1 -1))
(assert-eq?    (tn) #f (= 0 -1 0))
(assert-eq?    (tn) #f (= 0 -1 1))
(assert-eq?    (tn) #f (= 0 -1 2))
(assert-eq?    (tn) #f (= 0 0 -2))
(assert-eq?    (tn) #f (= 0 0 -1))
(assert-eq?    (tn) #t (= 0 0 0))
(assert-eq?    (tn) #f (= 0 0 1))
(assert-eq?    (tn) #f (= 0 0 2))
(assert-eq?    (tn) #f (= 0 1 -2))
(assert-eq?    (tn) #f (= 0 1 -1))
(assert-eq?    (tn) #f (= 0 1 0))
(assert-eq?    (tn) #f (= 0 1 1))
(assert-eq?    (tn) #f (= 0 1 2))
(assert-eq?    (tn) #f (= 0 2 -2))
(assert-eq?    (tn) #f (= 0 2 -1))
(assert-eq?    (tn) #f (= 0 2 0))
(assert-eq?    (tn) #f (= 0 2 1))
(assert-eq?    (tn) #f (= 0 2 2))
(assert-eq?    (tn) #f (= 1 -2 -2))
(assert-eq?    (tn) #f (= 1 -2 -1))
(assert-eq?    (tn) #f (= 1 -2 0))
(assert-eq?    (tn) #f (= 1 -2 1))
(assert-eq?    (tn) #f (= 1 -2 2))
(assert-eq?    (tn) #f (= 1 -1 -2))
(assert-eq?    (tn) #f (= 1 -1 -1))
(assert-eq?    (tn) #f (= 1 -1 0))
(assert-eq?    (tn) #f (= 1 -1 1))
(assert-eq?    (tn) #f (= 1 -1 2))
(assert-eq?    (tn) #f (= 1 0 -2))
(assert-eq?    (tn) #f (= 1 0 -1))
(assert-eq?    (tn) #f (= 1 0 0))
(assert-eq?    (tn) #f (= 1 0 1))
(assert-eq?    (tn) #f (= 1 0 2))
(assert-eq?    (tn) #f (= 1 1 -2))
(assert-eq?    (tn) #f (= 1 1 -1))
(assert-eq?    (tn) #f (= 1 1 0))
(assert-eq?    (tn) #t (= 1 1 1))
(assert-eq?    (tn) #f (= 1 1 2))
(assert-eq?    (tn) #f (= 1 2 -2))
(assert-eq?    (tn) #f (= 1 2 -1))
(assert-eq?    (tn) #f (= 1 2 0))
(assert-eq?    (tn) #f (= 1 2 1))
(assert-eq?    (tn) #f (= 1 2 2))
(assert-eq?    (tn) #f (= 2 -2 -2))
(assert-eq?    (tn) #f (= 2 -2 -1))
(assert-eq?    (tn) #f (= 2 -2 0))
(assert-eq?    (tn) #f (= 2 -2 1))
(assert-eq?    (tn) #f (= 2 -2 2))
(assert-eq?    (tn) #f (= 2 -1 -2))
(assert-eq?    (tn) #f (= 2 -1 -1))
(assert-eq?    (tn) #f (= 2 -1 0))
(assert-eq?    (tn) #f (= 2 -1 1))
(assert-eq?    (tn) #f (= 2 -1 2))
(assert-eq?    (tn) #f (= 2 0 -2))
(assert-eq?    (tn) #f (= 2 0 -1))
(assert-eq?    (tn) #f (= 2 0 0))
(assert-eq?    (tn) #f (= 2 0 1))
(assert-eq?    (tn) #f (= 2 0 2))
(assert-eq?    (tn) #f (= 2 1 -2))
(assert-eq?    (tn) #f (= 2 1 -1))
(assert-eq?    (tn) #f (= 2 1 0))
(assert-eq?    (tn) #f (= 2 1 1))
(assert-eq?    (tn) #f (= 2 1 2))
(assert-eq?    (tn) #f (= 2 2 -2))
(assert-eq?    (tn) #f (= 2 2 -1))
(assert-eq?    (tn) #f (= 2 2 0))
(assert-eq?    (tn) #f (= 2 2 1))
(assert-eq?    (tn) #t (= 2 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "= 3 args 64-bit")
      (string-eval "(assert-eq? (tn) #t (=  956397711204  956397711204  956397711204))")
      (string-eval "(assert-eq? (tn) #t (= -956397711204 -956397711204 -956397711204))")
      (string-eval "(assert-eq? (tn) #f (= 0  956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (= 0 -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (= 0  956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (= 0 -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=  13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (=  13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (= -13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (= -13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (=  956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (= -956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=  956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (= -956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (=  13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (=  13121090146595 0 -956397711204))")
      (string-eval "(assert-eq? (tn) #f (= -13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (= -13121090146595 0 -956397711204))")))
(tn "= many args")
(assert-eq?    (tn) #t (= 2 2 2 2))
(assert-eq?    (tn) #f (= 0 2 2 2))
(assert-eq?    (tn) #f (= 2 0 2 2))
(assert-eq?    (tn) #f (= 2 2 0 2))
(assert-eq?    (tn) #f (= 2 2 2 0))
(assert-eq?    (tn) #f (= -2 -1 0 1 2))
(assert-eq?    (tn) #f (= 2 1 0 -1 -2))
(assert-eq?    (tn) #f (= -2 -1 0 -1 1 2))
(assert-eq?    (tn) #f (= 2 1 0 -1 1 -2))
(assert-eq?    (tn) #f (= -2 -2 -1 -1 0 0 1 1 2 2))
(assert-eq?    (tn) #f (= 2 2 1 1 0 0 -1 -1 -2 -2))

(tn "< invalid forms")
(assert-error  (tn) (lambda () (<)))
(assert-error  (tn) (lambda () (< 1)))
(assert-error  (tn) (lambda () (< #t #t)))
(assert-error  (tn) (lambda () (< #f #f)))
(assert-error  (tn) (lambda () (< '() '())))
(tn "< 2 args")
(assert-eq?    (tn) #f (< -2 -2))
(assert-eq?    (tn) #t (< -2 -1))
(assert-eq?    (tn) #t (< -2 0))
(assert-eq?    (tn) #t (< -2 1))
(assert-eq?    (tn) #t (< -2 2))
(assert-eq?    (tn) #f (< -1 -2))
(assert-eq?    (tn) #f (< -1 -1))
(assert-eq?    (tn) #t (< -1 0))
(assert-eq?    (tn) #t (< -1 1))
(assert-eq?    (tn) #t (< -1 2))
(assert-eq?    (tn) #f (< 0 -2))
(assert-eq?    (tn) #f (< 0 -1))
(assert-eq?    (tn) #f (< 0 0))
(assert-eq?    (tn) #t (< 0 1))
(assert-eq?    (tn) #t (< 0 2))
(assert-eq?    (tn) #f (< 1 -2))
(assert-eq?    (tn) #f (< 1 -1))
(assert-eq?    (tn) #f (< 1 0))
(assert-eq?    (tn) #f (< 1 1))
(assert-eq?    (tn) #t (< 1 2))
(assert-eq?    (tn) #f (< 2 -2))
(assert-eq?    (tn) #f (< 2 -1))
(assert-eq?    (tn) #f (< 2 0))
(assert-eq?    (tn) #f (< 2 1))
(assert-eq?    (tn) #f (< 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "< 2 args 64-bit")
      (string-eval "(assert-eq? (tn) #f (<    956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #f (<    956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<   -956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #f (<   -956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<    956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (<   -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<    956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<   -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<  13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #f (<  13121090146595   -956397711204))")
      (string-eval "(assert-eq? (tn) #t (< -13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #t (< -13121090146595   -956397711204))")))
(tn "< 3 args")
(assert-eq?    (tn) #f (< -2 -2 -2))
(assert-eq?    (tn) #f (< -2 -2 -1))
(assert-eq?    (tn) #f (< -2 -2 0))
(assert-eq?    (tn) #f (< -2 -2 1))
(assert-eq?    (tn) #f (< -2 -2 2))
(assert-eq?    (tn) #f (< -2 -1 -2))
(assert-eq?    (tn) #f (< -2 -1 -1))
(assert-eq?    (tn) #t (< -2 -1 0))
(assert-eq?    (tn) #t (< -2 -1 1))
(assert-eq?    (tn) #t (< -2 -1 2))
(assert-eq?    (tn) #f (< -2 0 -2))
(assert-eq?    (tn) #f (< -2 0 -1))
(assert-eq?    (tn) #f (< -2 0 0))
(assert-eq?    (tn) #t (< -2 0 1))
(assert-eq?    (tn) #t (< -2 0 2))
(assert-eq?    (tn) #f (< -2 1 -2))
(assert-eq?    (tn) #f (< -2 1 -1))
(assert-eq?    (tn) #f (< -2 1 0))
(assert-eq?    (tn) #f (< -2 1 1))
(assert-eq?    (tn) #t (< -2 1 2))
(assert-eq?    (tn) #f (< -2 2 -2))
(assert-eq?    (tn) #f (< -2 2 -1))
(assert-eq?    (tn) #f (< -2 2 0))
(assert-eq?    (tn) #f (< -2 2 1))
(assert-eq?    (tn) #f (< -2 2 2))
(assert-eq?    (tn) #f (< -1 -2 -2))
(assert-eq?    (tn) #f (< -1 -2 -1))
(assert-eq?    (tn) #f (< -1 -2 0))
(assert-eq?    (tn) #f (< -1 -2 1))
(assert-eq?    (tn) #f (< -1 -2 2))
(assert-eq?    (tn) #f (< -1 -1 -2))
(assert-eq?    (tn) #f (< -1 -1 -1))
(assert-eq?    (tn) #f (< -1 -1 0))
(assert-eq?    (tn) #f (< -1 -1 1))
(assert-eq?    (tn) #f (< -1 -1 2))
(assert-eq?    (tn) #f (< -1 0 -2))
(assert-eq?    (tn) #f (< -1 0 -1))
(assert-eq?    (tn) #f (< -1 0 0))
(assert-eq?    (tn) #t (< -1 0 1))
(assert-eq?    (tn) #t (< -1 0 2))
(assert-eq?    (tn) #f (< -1 1 -2))
(assert-eq?    (tn) #f (< -1 1 -1))
(assert-eq?    (tn) #f (< -1 1 0))
(assert-eq?    (tn) #f (< -1 1 1))
(assert-eq?    (tn) #t (< -1 1 2))
(assert-eq?    (tn) #f (< -1 2 -2))
(assert-eq?    (tn) #f (< -1 2 -1))
(assert-eq?    (tn) #f (< -1 2 0))
(assert-eq?    (tn) #f (< -1 2 1))
(assert-eq?    (tn) #f (< -1 2 2))
(assert-eq?    (tn) #f (< 0 -2 -2))
(assert-eq?    (tn) #f (< 0 -2 -1))
(assert-eq?    (tn) #f (< 0 -2 0))
(assert-eq?    (tn) #f (< 0 -2 1))
(assert-eq?    (tn) #f (< 0 -2 2))
(assert-eq?    (tn) #f (< 0 -1 -2))
(assert-eq?    (tn) #f (< 0 -1 -1))
(assert-eq?    (tn) #f (< 0 -1 0))
(assert-eq?    (tn) #f (< 0 -1 1))
(assert-eq?    (tn) #f (< 0 -1 2))
(assert-eq?    (tn) #f (< 0 0 -2))
(assert-eq?    (tn) #f (< 0 0 -1))
(assert-eq?    (tn) #f (< 0 0 0))
(assert-eq?    (tn) #f (< 0 0 1))
(assert-eq?    (tn) #f (< 0 0 2))
(assert-eq?    (tn) #f (< 0 1 -2))
(assert-eq?    (tn) #f (< 0 1 -1))
(assert-eq?    (tn) #f (< 0 1 0))
(assert-eq?    (tn) #f (< 0 1 1))
(assert-eq?    (tn) #t (< 0 1 2))
(assert-eq?    (tn) #f (< 0 2 -2))
(assert-eq?    (tn) #f (< 0 2 -1))
(assert-eq?    (tn) #f (< 0 2 0))
(assert-eq?    (tn) #f (< 0 2 1))
(assert-eq?    (tn) #f (< 0 2 2))
(assert-eq?    (tn) #f (< 1 -2 -2))
(assert-eq?    (tn) #f (< 1 -2 -1))
(assert-eq?    (tn) #f (< 1 -2 0))
(assert-eq?    (tn) #f (< 1 -2 1))
(assert-eq?    (tn) #f (< 1 -2 2))
(assert-eq?    (tn) #f (< 1 -1 -2))
(assert-eq?    (tn) #f (< 1 -1 -1))
(assert-eq?    (tn) #f (< 1 -1 0))
(assert-eq?    (tn) #f (< 1 -1 1))
(assert-eq?    (tn) #f (< 1 -1 2))
(assert-eq?    (tn) #f (< 1 0 -2))
(assert-eq?    (tn) #f (< 1 0 -1))
(assert-eq?    (tn) #f (< 1 0 0))
(assert-eq?    (tn) #f (< 1 0 1))
(assert-eq?    (tn) #f (< 1 0 2))
(assert-eq?    (tn) #f (< 1 1 -2))
(assert-eq?    (tn) #f (< 1 1 -1))
(assert-eq?    (tn) #f (< 1 1 0))
(assert-eq?    (tn) #f (< 1 1 1))
(assert-eq?    (tn) #f (< 1 1 2))
(assert-eq?    (tn) #f (< 1 2 -2))
(assert-eq?    (tn) #f (< 1 2 -1))
(assert-eq?    (tn) #f (< 1 2 0))
(assert-eq?    (tn) #f (< 1 2 1))
(assert-eq?    (tn) #f (< 1 2 2))
(assert-eq?    (tn) #f (< 2 -2 -2))
(assert-eq?    (tn) #f (< 2 -2 -1))
(assert-eq?    (tn) #f (< 2 -2 0))
(assert-eq?    (tn) #f (< 2 -2 1))
(assert-eq?    (tn) #f (< 2 -2 2))
(assert-eq?    (tn) #f (< 2 -1 -2))
(assert-eq?    (tn) #f (< 2 -1 -1))
(assert-eq?    (tn) #f (< 2 -1 0))
(assert-eq?    (tn) #f (< 2 -1 1))
(assert-eq?    (tn) #f (< 2 -1 2))
(assert-eq?    (tn) #f (< 2 0 -2))
(assert-eq?    (tn) #f (< 2 0 -1))
(assert-eq?    (tn) #f (< 2 0 0))
(assert-eq?    (tn) #f (< 2 0 1))
(assert-eq?    (tn) #f (< 2 0 2))
(assert-eq?    (tn) #f (< 2 1 -2))
(assert-eq?    (tn) #f (< 2 1 -1))
(assert-eq?    (tn) #f (< 2 1 0))
(assert-eq?    (tn) #f (< 2 1 1))
(assert-eq?    (tn) #f (< 2 1 2))
(assert-eq?    (tn) #f (< 2 2 -2))
(assert-eq?    (tn) #f (< 2 2 -1))
(assert-eq?    (tn) #f (< 2 2 0))
(assert-eq?    (tn) #f (< 2 2 1))
(assert-eq?    (tn) #f (< 2 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "< 3 args 64-bit")
      (string-eval "(assert-eq? (tn) #f (<  956397711204  956397711204  956397711204))")
      (string-eval "(assert-eq? (tn) #f (< -956397711204 -956397711204 -956397711204))")
      (string-eval "(assert-eq? (tn) #t (< 0  956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (< 0 -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (< 0  956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (< 0 -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<  13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (<  13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (< -13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #t (< -13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (<  956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (< -956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<  956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (< -956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<  13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (<  13121090146595 0 -956397711204))")
      (string-eval "(assert-eq? (tn) #t (< -13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (< -13121090146595 0 -956397711204))")))
(tn "< many args")
(assert-eq?    (tn) #f (< 2 2 2 2))
(assert-eq?    (tn) #f (< 0 2 2 2))
(assert-eq?    (tn) #f (< 2 0 2 2))
(assert-eq?    (tn) #f (< 2 2 0 2))
(assert-eq?    (tn) #f (< 2 2 2 0))
(assert-eq?    (tn) #t (< -2 -1 0 1 2))
(assert-eq?    (tn) #f (< 2 1 0 -1 -2))
(assert-eq?    (tn) #f (< -2 -1 0 -1 1 2))
(assert-eq?    (tn) #f (< 2 1 0 -1 1 -2))
(assert-eq?    (tn) #f (< -2 -2 -1 -1 0 0 1 1 2 2))
(assert-eq?    (tn) #f (< 2 2 1 1 0 0 -1 -1 -2 -2))

(tn "> invalid forms")
(assert-error  (tn) (lambda () (>)))
(assert-error  (tn) (lambda () (> 1)))
(assert-error  (tn) (lambda () (> #t #t)))
(assert-error  (tn) (lambda () (> #f #f)))
(assert-error  (tn) (lambda () (> '() '())))
(tn "> 2 args")
(assert-eq?    (tn) #f (> -2 -2))
(assert-eq?    (tn) #f (> -2 -1))
(assert-eq?    (tn) #f (> -2 0))
(assert-eq?    (tn) #f (> -2 1))
(assert-eq?    (tn) #f (> -2 2))
(assert-eq?    (tn) #t (> -1 -2))
(assert-eq?    (tn) #f (> -1 -1))
(assert-eq?    (tn) #f (> -1 0))
(assert-eq?    (tn) #f (> -1 1))
(assert-eq?    (tn) #f (> -1 2))
(assert-eq?    (tn) #t (> 0 -2))
(assert-eq?    (tn) #t (> 0 -1))
(assert-eq?    (tn) #f (> 0 0))
(assert-eq?    (tn) #f (> 0 1))
(assert-eq?    (tn) #f (> 0 2))
(assert-eq?    (tn) #t (> 1 -2))
(assert-eq?    (tn) #t (> 1 -1))
(assert-eq?    (tn) #t (> 1 0))
(assert-eq?    (tn) #f (> 1 1))
(assert-eq?    (tn) #f (> 1 2))
(assert-eq?    (tn) #t (> 2 -2))
(assert-eq?    (tn) #t (> 2 -1))
(assert-eq?    (tn) #t (> 2 0))
(assert-eq?    (tn) #t (> 2 1))
(assert-eq?    (tn) #f (> 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "> 2 args 64-bit")
      (string-eval "(assert-eq? (tn) #f (>    956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #t (>    956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>   -956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #f (>   -956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>    956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>   -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>    956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>   -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>  13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #t (>  13121090146595   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (> -13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #f (> -13121090146595   -956397711204))")))
(tn "> 3 args")
(assert-eq?    (tn) #f (> -2 -2 -2))
(assert-eq?    (tn) #f (> -2 -2 -1))
(assert-eq?    (tn) #f (> -2 -2 0))
(assert-eq?    (tn) #f (> -2 -2 1))
(assert-eq?    (tn) #f (> -2 -2 2))
(assert-eq?    (tn) #f (> -2 -1 -2))
(assert-eq?    (tn) #f (> -2 -1 -1))
(assert-eq?    (tn) #f (> -2 -1 0))
(assert-eq?    (tn) #f (> -2 -1 1))
(assert-eq?    (tn) #f (> -2 -1 2))
(assert-eq?    (tn) #f (> -2 0 -2))
(assert-eq?    (tn) #f (> -2 0 -1))
(assert-eq?    (tn) #f (> -2 0 0))
(assert-eq?    (tn) #f (> -2 0 1))
(assert-eq?    (tn) #f (> -2 0 2))
(assert-eq?    (tn) #f (> -2 1 -2))
(assert-eq?    (tn) #f (> -2 1 -1))
(assert-eq?    (tn) #f (> -2 1 0))
(assert-eq?    (tn) #f (> -2 1 1))
(assert-eq?    (tn) #f (> -2 1 2))
(assert-eq?    (tn) #f (> -2 2 -2))
(assert-eq?    (tn) #f (> -2 2 -1))
(assert-eq?    (tn) #f (> -2 2 0))
(assert-eq?    (tn) #f (> -2 2 1))
(assert-eq?    (tn) #f (> -2 2 2))
(assert-eq?    (tn) #f (> -1 -2 -2))
(assert-eq?    (tn) #f (> -1 -2 -1))
(assert-eq?    (tn) #f (> -1 -2 0))
(assert-eq?    (tn) #f (> -1 -2 1))
(assert-eq?    (tn) #f (> -1 -2 2))
(assert-eq?    (tn) #f (> -1 -1 -2))
(assert-eq?    (tn) #f (> -1 -1 -1))
(assert-eq?    (tn) #f (> -1 -1 0))
(assert-eq?    (tn) #f (> -1 -1 1))
(assert-eq?    (tn) #f (> -1 -1 2))
(assert-eq?    (tn) #f (> -1 0 -2))
(assert-eq?    (tn) #f (> -1 0 -1))
(assert-eq?    (tn) #f (> -1 0 0))
(assert-eq?    (tn) #f (> -1 0 1))
(assert-eq?    (tn) #f (> -1 0 2))
(assert-eq?    (tn) #f (> -1 1 -2))
(assert-eq?    (tn) #f (> -1 1 -1))
(assert-eq?    (tn) #f (> -1 1 0))
(assert-eq?    (tn) #f (> -1 1 1))
(assert-eq?    (tn) #f (> -1 1 2))
(assert-eq?    (tn) #f (> -1 2 -2))
(assert-eq?    (tn) #f (> -1 2 -1))
(assert-eq?    (tn) #f (> -1 2 0))
(assert-eq?    (tn) #f (> -1 2 1))
(assert-eq?    (tn) #f (> -1 2 2))
(assert-eq?    (tn) #f (> 0 -2 -2))
(assert-eq?    (tn) #f (> 0 -2 -1))
(assert-eq?    (tn) #f (> 0 -2 0))
(assert-eq?    (tn) #f (> 0 -2 1))
(assert-eq?    (tn) #f (> 0 -2 2))
(assert-eq?    (tn) #t (> 0 -1 -2))
(assert-eq?    (tn) #f (> 0 -1 -1))
(assert-eq?    (tn) #f (> 0 -1 0))
(assert-eq?    (tn) #f (> 0 -1 1))
(assert-eq?    (tn) #f (> 0 -1 2))
(assert-eq?    (tn) #f (> 0 0 -2))
(assert-eq?    (tn) #f (> 0 0 -1))
(assert-eq?    (tn) #f (> 0 0 0))
(assert-eq?    (tn) #f (> 0 0 1))
(assert-eq?    (tn) #f (> 0 0 2))
(assert-eq?    (tn) #f (> 0 1 -2))
(assert-eq?    (tn) #f (> 0 1 -1))
(assert-eq?    (tn) #f (> 0 1 0))
(assert-eq?    (tn) #f (> 0 1 1))
(assert-eq?    (tn) #f (> 0 1 2))
(assert-eq?    (tn) #f (> 0 2 -2))
(assert-eq?    (tn) #f (> 0 2 -1))
(assert-eq?    (tn) #f (> 0 2 0))
(assert-eq?    (tn) #f (> 0 2 1))
(assert-eq?    (tn) #f (> 0 2 2))
(assert-eq?    (tn) #f (> 1 -2 -2))
(assert-eq?    (tn) #f (> 1 -2 -1))
(assert-eq?    (tn) #f (> 1 -2 0))
(assert-eq?    (tn) #f (> 1 -2 1))
(assert-eq?    (tn) #f (> 1 -2 2))
(assert-eq?    (tn) #t (> 1 -1 -2))
(assert-eq?    (tn) #f (> 1 -1 -1))
(assert-eq?    (tn) #f (> 1 -1 0))
(assert-eq?    (tn) #f (> 1 -1 1))
(assert-eq?    (tn) #f (> 1 -1 2))
(assert-eq?    (tn) #t (> 1 0 -2))
(assert-eq?    (tn) #t (> 1 0 -1))
(assert-eq?    (tn) #f (> 1 0 0))
(assert-eq?    (tn) #f (> 1 0 1))
(assert-eq?    (tn) #f (> 1 0 2))
(assert-eq?    (tn) #f (> 1 1 -2))
(assert-eq?    (tn) #f (> 1 1 -1))
(assert-eq?    (tn) #f (> 1 1 0))
(assert-eq?    (tn) #f (> 1 1 1))
(assert-eq?    (tn) #f (> 1 1 2))
(assert-eq?    (tn) #f (> 1 2 -2))
(assert-eq?    (tn) #f (> 1 2 -1))
(assert-eq?    (tn) #f (> 1 2 0))
(assert-eq?    (tn) #f (> 1 2 1))
(assert-eq?    (tn) #f (> 1 2 2))
(assert-eq?    (tn) #f (> 2 -2 -2))
(assert-eq?    (tn) #f (> 2 -2 -1))
(assert-eq?    (tn) #f (> 2 -2 0))
(assert-eq?    (tn) #f (> 2 -2 1))
(assert-eq?    (tn) #f (> 2 -2 2))
(assert-eq?    (tn) #t (> 2 -1 -2))
(assert-eq?    (tn) #f (> 2 -1 -1))
(assert-eq?    (tn) #f (> 2 -1 0))
(assert-eq?    (tn) #f (> 2 -1 1))
(assert-eq?    (tn) #f (> 2 -1 2))
(assert-eq?    (tn) #t (> 2 0 -2))
(assert-eq?    (tn) #t (> 2 0 -1))
(assert-eq?    (tn) #f (> 2 0 0))
(assert-eq?    (tn) #f (> 2 0 1))
(assert-eq?    (tn) #f (> 2 0 2))
(assert-eq?    (tn) #t (> 2 1 -2))
(assert-eq?    (tn) #t (> 2 1 -1))
(assert-eq?    (tn) #t (> 2 1 0))
(assert-eq?    (tn) #f (> 2 1 1))
(assert-eq?    (tn) #f (> 2 1 2))
(assert-eq?    (tn) #f (> 2 2 -2))
(assert-eq?    (tn) #f (> 2 2 -1))
(assert-eq?    (tn) #f (> 2 2 0))
(assert-eq?    (tn) #f (> 2 2 1))
(assert-eq?    (tn) #f (> 2 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "> 3 args 64-bit")
      (string-eval "(assert-eq? (tn) #f (>  956397711204  956397711204  956397711204))")
      (string-eval "(assert-eq? (tn) #f (> -956397711204 -956397711204 -956397711204))")
      (string-eval "(assert-eq? (tn) #f (> 0  956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (> 0 -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (> 0  956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (> 0 -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>  13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (>  13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (> -13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (> -13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (>  956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (> -956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>  956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (> -956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>  13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #t (>  13121090146595 0 -956397711204))")
      (string-eval "(assert-eq? (tn) #f (> -13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (> -13121090146595 0 -956397711204))")))
(tn "> many args")
(assert-eq?    (tn) #f (> 2 2 2 2))
(assert-eq?    (tn) #f (> 0 2 2 2))
(assert-eq?    (tn) #f (> 2 0 2 2))
(assert-eq?    (tn) #f (> 2 2 0 2))
(assert-eq?    (tn) #f (> 2 2 2 0))
(assert-eq?    (tn) #f (> -2 -1 0 1 2))
(assert-eq?    (tn) #t (> 2 1 0 -1 -2))
(assert-eq?    (tn) #f (> -2 -1 0 -1 1 2))
(assert-eq?    (tn) #f (> 2 1 0 -1 1 -2))
(assert-eq?    (tn) #f (> -2 -2 -1 -1 0 0 1 1 2 2))
(assert-eq?    (tn) #f (> 2 2 1 1 0 0 -1 -1 -2 -2))

(tn "<= invalid forms")
(assert-error  (tn) (lambda () (<=)))
(assert-error  (tn) (lambda () (<= 1)))
(assert-error  (tn) (lambda () (<= #t #t)))
(assert-error  (tn) (lambda () (<= #f #f)))
(assert-error  (tn) (lambda () (<= '() '())))
(tn "<= 2 args")
(assert-eq?    (tn) #t (<= -2 -2))
(assert-eq?    (tn) #t (<= -2 -1))
(assert-eq?    (tn) #t (<= -2 0))
(assert-eq?    (tn) #t (<= -2 1))
(assert-eq?    (tn) #t (<= -2 2))
(assert-eq?    (tn) #f (<= -1 -2))
(assert-eq?    (tn) #t (<= -1 -1))
(assert-eq?    (tn) #t (<= -1 0))
(assert-eq?    (tn) #t (<= -1 1))
(assert-eq?    (tn) #t (<= -1 2))
(assert-eq?    (tn) #f (<= 0 -2))
(assert-eq?    (tn) #f (<= 0 -1))
(assert-eq?    (tn) #t (<= 0 0))
(assert-eq?    (tn) #t (<= 0 1))
(assert-eq?    (tn) #t (<= 0 2))
(assert-eq?    (tn) #f (<= 1 -2))
(assert-eq?    (tn) #f (<= 1 -1))
(assert-eq?    (tn) #f (<= 1 0))
(assert-eq?    (tn) #t (<= 1 1))
(assert-eq?    (tn) #t (<= 1 2))
(assert-eq?    (tn) #f (<= 2 -2))
(assert-eq?    (tn) #f (<= 2 -1))
(assert-eq?    (tn) #f (<= 2 0))
(assert-eq?    (tn) #f (<= 2 1))
(assert-eq?    (tn) #t (<= 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "<= 2 args 64-bit")
      (string-eval "(assert-eq? (tn) #t (<=    956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #f (<=    956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<=   -956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #t (<=   -956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<=    956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (<=   -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<=    956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<=   -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<=  13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #f (<=  13121090146595   -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<= -13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #t (<= -13121090146595   -956397711204))")))
(tn "<= 3 args")
(assert-eq?    (tn) #t (<= -2 -2 -2))
(assert-eq?    (tn) #t (<= -2 -2 -1))
(assert-eq?    (tn) #t (<= -2 -2 0))
(assert-eq?    (tn) #t (<= -2 -2 1))
(assert-eq?    (tn) #t (<= -2 -2 2))
(assert-eq?    (tn) #f (<= -2 -1 -2))
(assert-eq?    (tn) #t (<= -2 -1 -1))
(assert-eq?    (tn) #t (<= -2 -1 0))
(assert-eq?    (tn) #t (<= -2 -1 1))
(assert-eq?    (tn) #t (<= -2 -1 2))
(assert-eq?    (tn) #f (<= -2 0 -2))
(assert-eq?    (tn) #f (<= -2 0 -1))
(assert-eq?    (tn) #t (<= -2 0 0))
(assert-eq?    (tn) #t (<= -2 0 1))
(assert-eq?    (tn) #t (<= -2 0 2))
(assert-eq?    (tn) #f (<= -2 1 -2))
(assert-eq?    (tn) #f (<= -2 1 -1))
(assert-eq?    (tn) #f (<= -2 1 0))
(assert-eq?    (tn) #t (<= -2 1 1))
(assert-eq?    (tn) #t (<= -2 1 2))
(assert-eq?    (tn) #f (<= -2 2 -2))
(assert-eq?    (tn) #f (<= -2 2 -1))
(assert-eq?    (tn) #f (<= -2 2 0))
(assert-eq?    (tn) #f (<= -2 2 1))
(assert-eq?    (tn) #t (<= -2 2 2))
(assert-eq?    (tn) #f (<= -1 -2 -2))
(assert-eq?    (tn) #f (<= -1 -2 -1))
(assert-eq?    (tn) #f (<= -1 -2 0))
(assert-eq?    (tn) #f (<= -1 -2 1))
(assert-eq?    (tn) #f (<= -1 -2 2))
(assert-eq?    (tn) #f (<= -1 -1 -2))
(assert-eq?    (tn) #t (<= -1 -1 -1))
(assert-eq?    (tn) #t (<= -1 -1 0))
(assert-eq?    (tn) #t (<= -1 -1 1))
(assert-eq?    (tn) #t (<= -1 -1 2))
(assert-eq?    (tn) #f (<= -1 0 -2))
(assert-eq?    (tn) #f (<= -1 0 -1))
(assert-eq?    (tn) #t (<= -1 0 0))
(assert-eq?    (tn) #t (<= -1 0 1))
(assert-eq?    (tn) #t (<= -1 0 2))
(assert-eq?    (tn) #f (<= -1 1 -2))
(assert-eq?    (tn) #f (<= -1 1 -1))
(assert-eq?    (tn) #f (<= -1 1 0))
(assert-eq?    (tn) #t (<= -1 1 1))
(assert-eq?    (tn) #t (<= -1 1 2))
(assert-eq?    (tn) #f (<= -1 2 -2))
(assert-eq?    (tn) #f (<= -1 2 -1))
(assert-eq?    (tn) #f (<= -1 2 0))
(assert-eq?    (tn) #f (<= -1 2 1))
(assert-eq?    (tn) #t (<= -1 2 2))
(assert-eq?    (tn) #f (<= 0 -2 -2))
(assert-eq?    (tn) #f (<= 0 -2 -1))
(assert-eq?    (tn) #f (<= 0 -2 0))
(assert-eq?    (tn) #f (<= 0 -2 1))
(assert-eq?    (tn) #f (<= 0 -2 2))
(assert-eq?    (tn) #f (<= 0 -1 -2))
(assert-eq?    (tn) #f (<= 0 -1 -1))
(assert-eq?    (tn) #f (<= 0 -1 0))
(assert-eq?    (tn) #f (<= 0 -1 1))
(assert-eq?    (tn) #f (<= 0 -1 2))
(assert-eq?    (tn) #f (<= 0 0 -2))
(assert-eq?    (tn) #f (<= 0 0 -1))
(assert-eq?    (tn) #t (<= 0 0 0))
(assert-eq?    (tn) #t (<= 0 0 1))
(assert-eq?    (tn) #t (<= 0 0 2))
(assert-eq?    (tn) #f (<= 0 1 -2))
(assert-eq?    (tn) #f (<= 0 1 -1))
(assert-eq?    (tn) #f (<= 0 1 0))
(assert-eq?    (tn) #t (<= 0 1 1))
(assert-eq?    (tn) #t (<= 0 1 2))
(assert-eq?    (tn) #f (<= 0 2 -2))
(assert-eq?    (tn) #f (<= 0 2 -1))
(assert-eq?    (tn) #f (<= 0 2 0))
(assert-eq?    (tn) #f (<= 0 2 1))
(assert-eq?    (tn) #t (<= 0 2 2))
(assert-eq?    (tn) #f (<= 1 -2 -2))
(assert-eq?    (tn) #f (<= 1 -2 -1))
(assert-eq?    (tn) #f (<= 1 -2 0))
(assert-eq?    (tn) #f (<= 1 -2 1))
(assert-eq?    (tn) #f (<= 1 -2 2))
(assert-eq?    (tn) #f (<= 1 -1 -2))
(assert-eq?    (tn) #f (<= 1 -1 -1))
(assert-eq?    (tn) #f (<= 1 -1 0))
(assert-eq?    (tn) #f (<= 1 -1 1))
(assert-eq?    (tn) #f (<= 1 -1 2))
(assert-eq?    (tn) #f (<= 1 0 -2))
(assert-eq?    (tn) #f (<= 1 0 -1))
(assert-eq?    (tn) #f (<= 1 0 0))
(assert-eq?    (tn) #f (<= 1 0 1))
(assert-eq?    (tn) #f (<= 1 0 2))
(assert-eq?    (tn) #f (<= 1 1 -2))
(assert-eq?    (tn) #f (<= 1 1 -1))
(assert-eq?    (tn) #f (<= 1 1 0))
(assert-eq?    (tn) #t (<= 1 1 1))
(assert-eq?    (tn) #t (<= 1 1 2))
(assert-eq?    (tn) #f (<= 1 2 -2))
(assert-eq?    (tn) #f (<= 1 2 -1))
(assert-eq?    (tn) #f (<= 1 2 0))
(assert-eq?    (tn) #f (<= 1 2 1))
(assert-eq?    (tn) #t (<= 1 2 2))
(assert-eq?    (tn) #f (<= 2 -2 -2))
(assert-eq?    (tn) #f (<= 2 -2 -1))
(assert-eq?    (tn) #f (<= 2 -2 0))
(assert-eq?    (tn) #f (<= 2 -2 1))
(assert-eq?    (tn) #f (<= 2 -2 2))
(assert-eq?    (tn) #f (<= 2 -1 -2))
(assert-eq?    (tn) #f (<= 2 -1 -1))
(assert-eq?    (tn) #f (<= 2 -1 0))
(assert-eq?    (tn) #f (<= 2 -1 1))
(assert-eq?    (tn) #f (<= 2 -1 2))
(assert-eq?    (tn) #f (<= 2 0 -2))
(assert-eq?    (tn) #f (<= 2 0 -1))
(assert-eq?    (tn) #f (<= 2 0 0))
(assert-eq?    (tn) #f (<= 2 0 1))
(assert-eq?    (tn) #f (<= 2 0 2))
(assert-eq?    (tn) #f (<= 2 1 -2))
(assert-eq?    (tn) #f (<= 2 1 -1))
(assert-eq?    (tn) #f (<= 2 1 0))
(assert-eq?    (tn) #f (<= 2 1 1))
(assert-eq?    (tn) #f (<= 2 1 2))
(assert-eq?    (tn) #f (<= 2 2 -2))
(assert-eq?    (tn) #f (<= 2 2 -1))
(assert-eq?    (tn) #f (<= 2 2 0))
(assert-eq?    (tn) #f (<= 2 2 1))
(assert-eq?    (tn) #t (<= 2 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn "<= 3 args 64-bit")
      (string-eval "(assert-eq? (tn) #t (<=  956397711204  956397711204  956397711204))")
      (string-eval "(assert-eq? (tn) #t (<= -956397711204 -956397711204 -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<= 0  956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<= 0 -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<= 0  956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<= 0 -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<=  13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (<=  13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (<= -13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #t (<= -13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (<=  956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (<= -956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<=  956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<= -956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (<=  13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (<=  13121090146595 0 -956397711204))")
      (string-eval "(assert-eq? (tn) #t (<= -13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (<= -13121090146595 0 -956397711204))")))
(tn "<= many args")
(assert-eq?    (tn) #t (<= 2 2 2 2))
(assert-eq?    (tn) #t (<= 0 2 2 2))
(assert-eq?    (tn) #f (<= 2 0 2 2))
(assert-eq?    (tn) #f (<= 2 2 0 2))
(assert-eq?    (tn) #f (<= 2 2 2 0))
(assert-eq?    (tn) #t (<= -2 -1 0 1 2))
(assert-eq?    (tn) #f (<= 2 1 0 -1 -2))
(assert-eq?    (tn) #f (<= -2 -1 0 -1 1 2))
(assert-eq?    (tn) #f (<= 2 1 0 -1 1 -2))
(assert-eq?    (tn) #t (<= -2 -2 -1 -1 0 0 1 1 2 2))
(assert-eq?    (tn) #f (<= 2 2 1 1 0 0 -1 -1 -2 -2))

(tn ">= invalid forms")
(assert-error  (tn) (lambda () (>=)))
(assert-error  (tn) (lambda () (>= 1)))
(assert-error  (tn) (lambda () (>= #t #t)))
(assert-error  (tn) (lambda () (>= #f #f)))
(assert-error  (tn) (lambda () (>= '() '())))
(tn ">= 2 args")
(assert-eq?    (tn) #t (>= -2 -2))
(assert-eq?    (tn) #f (>= -2 -1))
(assert-eq?    (tn) #f (>= -2 0))
(assert-eq?    (tn) #f (>= -2 1))
(assert-eq?    (tn) #f (>= -2 2))
(assert-eq?    (tn) #t (>= -1 -2))
(assert-eq?    (tn) #t (>= -1 -1))
(assert-eq?    (tn) #f (>= -1 0))
(assert-eq?    (tn) #f (>= -1 1))
(assert-eq?    (tn) #f (>= -1 2))
(assert-eq?    (tn) #t (>= 0 -2))
(assert-eq?    (tn) #t (>= 0 -1))
(assert-eq?    (tn) #t (>= 0 0))
(assert-eq?    (tn) #f (>= 0 1))
(assert-eq?    (tn) #f (>= 0 2))
(assert-eq?    (tn) #t (>= 1 -2))
(assert-eq?    (tn) #t (>= 1 -1))
(assert-eq?    (tn) #t (>= 1 0))
(assert-eq?    (tn) #t (>= 1 1))
(assert-eq?    (tn) #f (>= 1 2))
(assert-eq?    (tn) #t (>= 2 -2))
(assert-eq?    (tn) #t (>= 2 -1))
(assert-eq?    (tn) #t (>= 2 0))
(assert-eq?    (tn) #t (>= 2 1))
(assert-eq?    (tn) #t (>= 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn ">= 2 args 64-bit")
      (string-eval "(assert-eq? (tn) #t (>=    956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #t (>=    956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>=   -956397711204    956397711204))")
      (string-eval "(assert-eq? (tn) #t (>=   -956397711204   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>=    956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>=   -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>=    956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>=   -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>=  13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #t (>=  13121090146595   -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>= -13121090146595    956397711204))")
      (string-eval "(assert-eq? (tn) #f (>= -13121090146595   -956397711204))")))
(tn ">= 3 args")
(assert-eq?    (tn) #t (>= -2 -2 -2))
(assert-eq?    (tn) #f (>= -2 -2 -1))
(assert-eq?    (tn) #f (>= -2 -2 0))
(assert-eq?    (tn) #f (>= -2 -2 1))
(assert-eq?    (tn) #f (>= -2 -2 2))
(assert-eq?    (tn) #f (>= -2 -1 -2))
(assert-eq?    (tn) #f (>= -2 -1 -1))
(assert-eq?    (tn) #f (>= -2 -1 0))
(assert-eq?    (tn) #f (>= -2 -1 1))
(assert-eq?    (tn) #f (>= -2 -1 2))
(assert-eq?    (tn) #f (>= -2 0 -2))
(assert-eq?    (tn) #f (>= -2 0 -1))
(assert-eq?    (tn) #f (>= -2 0 0))
(assert-eq?    (tn) #f (>= -2 0 1))
(assert-eq?    (tn) #f (>= -2 0 2))
(assert-eq?    (tn) #f (>= -2 1 -2))
(assert-eq?    (tn) #f (>= -2 1 -1))
(assert-eq?    (tn) #f (>= -2 1 0))
(assert-eq?    (tn) #f (>= -2 1 1))
(assert-eq?    (tn) #f (>= -2 1 2))
(assert-eq?    (tn) #f (>= -2 2 -2))
(assert-eq?    (tn) #f (>= -2 2 -1))
(assert-eq?    (tn) #f (>= -2 2 0))
(assert-eq?    (tn) #f (>= -2 2 1))
(assert-eq?    (tn) #f (>= -2 2 2))
(assert-eq?    (tn) #t (>= -1 -2 -2))
(assert-eq?    (tn) #f (>= -1 -2 -1))
(assert-eq?    (tn) #f (>= -1 -2 0))
(assert-eq?    (tn) #f (>= -1 -2 1))
(assert-eq?    (tn) #f (>= -1 -2 2))
(assert-eq?    (tn) #t (>= -1 -1 -2))
(assert-eq?    (tn) #t (>= -1 -1 -1))
(assert-eq?    (tn) #f (>= -1 -1 0))
(assert-eq?    (tn) #f (>= -1 -1 1))
(assert-eq?    (tn) #f (>= -1 -1 2))
(assert-eq?    (tn) #f (>= -1 0 -2))
(assert-eq?    (tn) #f (>= -1 0 -1))
(assert-eq?    (tn) #f (>= -1 0 0))
(assert-eq?    (tn) #f (>= -1 0 1))
(assert-eq?    (tn) #f (>= -1 0 2))
(assert-eq?    (tn) #f (>= -1 1 -2))
(assert-eq?    (tn) #f (>= -1 1 -1))
(assert-eq?    (tn) #f (>= -1 1 0))
(assert-eq?    (tn) #f (>= -1 1 1))
(assert-eq?    (tn) #f (>= -1 1 2))
(assert-eq?    (tn) #f (>= -1 2 -2))
(assert-eq?    (tn) #f (>= -1 2 -1))
(assert-eq?    (tn) #f (>= -1 2 0))
(assert-eq?    (tn) #f (>= -1 2 1))
(assert-eq?    (tn) #f (>= -1 2 2))
(assert-eq?    (tn) #t (>= 0 -2 -2))
(assert-eq?    (tn) #f (>= 0 -2 -1))
(assert-eq?    (tn) #f (>= 0 -2 0))
(assert-eq?    (tn) #f (>= 0 -2 1))
(assert-eq?    (tn) #f (>= 0 -2 2))
(assert-eq?    (tn) #t (>= 0 -1 -2))
(assert-eq?    (tn) #t (>= 0 -1 -1))
(assert-eq?    (tn) #f (>= 0 -1 0))
(assert-eq?    (tn) #f (>= 0 -1 1))
(assert-eq?    (tn) #f (>= 0 -1 2))
(assert-eq?    (tn) #t (>= 0 0 -2))
(assert-eq?    (tn) #t (>= 0 0 -1))
(assert-eq?    (tn) #t (>= 0 0 0))
(assert-eq?    (tn) #f (>= 0 0 1))
(assert-eq?    (tn) #f (>= 0 0 2))
(assert-eq?    (tn) #f (>= 0 1 -2))
(assert-eq?    (tn) #f (>= 0 1 -1))
(assert-eq?    (tn) #f (>= 0 1 0))
(assert-eq?    (tn) #f (>= 0 1 1))
(assert-eq?    (tn) #f (>= 0 1 2))
(assert-eq?    (tn) #f (>= 0 2 -2))
(assert-eq?    (tn) #f (>= 0 2 -1))
(assert-eq?    (tn) #f (>= 0 2 0))
(assert-eq?    (tn) #f (>= 0 2 1))
(assert-eq?    (tn) #f (>= 0 2 2))
(assert-eq?    (tn) #t (>= 1 -2 -2))
(assert-eq?    (tn) #f (>= 1 -2 -1))
(assert-eq?    (tn) #f (>= 1 -2 0))
(assert-eq?    (tn) #f (>= 1 -2 1))
(assert-eq?    (tn) #f (>= 1 -2 2))
(assert-eq?    (tn) #t (>= 1 -1 -2))
(assert-eq?    (tn) #t (>= 1 -1 -1))
(assert-eq?    (tn) #f (>= 1 -1 0))
(assert-eq?    (tn) #f (>= 1 -1 1))
(assert-eq?    (tn) #f (>= 1 -1 2))
(assert-eq?    (tn) #t (>= 1 0 -2))
(assert-eq?    (tn) #t (>= 1 0 -1))
(assert-eq?    (tn) #t (>= 1 0 0))
(assert-eq?    (tn) #f (>= 1 0 1))
(assert-eq?    (tn) #f (>= 1 0 2))
(assert-eq?    (tn) #t (>= 1 1 -2))
(assert-eq?    (tn) #t (>= 1 1 -1))
(assert-eq?    (tn) #t (>= 1 1 0))
(assert-eq?    (tn) #t (>= 1 1 1))
(assert-eq?    (tn) #f (>= 1 1 2))
(assert-eq?    (tn) #f (>= 1 2 -2))
(assert-eq?    (tn) #f (>= 1 2 -1))
(assert-eq?    (tn) #f (>= 1 2 0))
(assert-eq?    (tn) #f (>= 1 2 1))
(assert-eq?    (tn) #f (>= 1 2 2))
(assert-eq?    (tn) #t (>= 2 -2 -2))
(assert-eq?    (tn) #f (>= 2 -2 -1))
(assert-eq?    (tn) #f (>= 2 -2 0))
(assert-eq?    (tn) #f (>= 2 -2 1))
(assert-eq?    (tn) #f (>= 2 -2 2))
(assert-eq?    (tn) #t (>= 2 -1 -2))
(assert-eq?    (tn) #t (>= 2 -1 -1))
(assert-eq?    (tn) #f (>= 2 -1 0))
(assert-eq?    (tn) #f (>= 2 -1 1))
(assert-eq?    (tn) #f (>= 2 -1 2))
(assert-eq?    (tn) #t (>= 2 0 -2))
(assert-eq?    (tn) #t (>= 2 0 -1))
(assert-eq?    (tn) #t (>= 2 0 0))
(assert-eq?    (tn) #f (>= 2 0 1))
(assert-eq?    (tn) #f (>= 2 0 2))
(assert-eq?    (tn) #t (>= 2 1 -2))
(assert-eq?    (tn) #t (>= 2 1 -1))
(assert-eq?    (tn) #t (>= 2 1 0))
(assert-eq?    (tn) #t (>= 2 1 1))
(assert-eq?    (tn) #f (>= 2 1 2))
(assert-eq?    (tn) #t (>= 2 2 -2))
(assert-eq?    (tn) #t (>= 2 2 -1))
(assert-eq?    (tn) #t (>= 2 2 0))
(assert-eq?    (tn) #t (>= 2 2 1))
(assert-eq?    (tn) #t (>= 2 2 2))
(if (>= fixnum-bits 60)
    (begin
      (tn ">= 3 args 64-bit")
      (string-eval "(assert-eq? (tn) #t (>=  956397711204  956397711204  956397711204))")
      (string-eval "(assert-eq? (tn) #t (>= -956397711204 -956397711204 -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>= 0  956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>= 0 -956397711204  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>= 0  956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>= 0 -956397711204 -13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>=  13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (>=  13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (>= -13121090146595  956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (>= -13121090146595 -956397711204 0))")
      (string-eval "(assert-eq? (tn) #f (>=  956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>= -956397711204 0  13121090146595))")
      (string-eval "(assert-eq? (tn) #t (>=  956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>= -956397711204 0 -13121090146595))")
      (string-eval "(assert-eq? (tn) #f (>=  13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #t (>=  13121090146595 0 -956397711204))")
      (string-eval "(assert-eq? (tn) #f (>= -13121090146595 0  956397711204))")
      (string-eval "(assert-eq? (tn) #f (>= -13121090146595 0 -956397711204))")))
(tn ">= many args")
(assert-eq?    (tn) #t (>= 2 2 2 2))
(assert-eq?    (tn) #f (>= 0 2 2 2))
(assert-eq?    (tn) #f (>= 2 0 2 2))
(assert-eq?    (tn) #f (>= 2 2 0 2))
(assert-eq?    (tn) #t (>= 2 2 2 0))
(assert-eq?    (tn) #f (>= -2 -1 0 1 2))
(assert-eq?    (tn) #t (>= 2 1 0 -1 -2))
(assert-eq?    (tn) #f (>= -2 -1 0 -1 1 2))
(assert-eq?    (tn) #f (>= 2 1 0 -1 1 -2))
(assert-eq?    (tn) #f (>= -2 -2 -1 -1 0 0 1 1 2 2))
(assert-eq?    (tn) #t (>= 2 2 1 1 0 0 -1 -1 -2 -2))


(total-report)
