#ifndef GUI_H__
#define GUI_H__


#include "channel.h"

void on_settings_change_passphrase(GtkWidget *widget, gpointer user_data);
void on_settings_server_add(GtkWidget *widget, gpointer user_data);
void on_settings_server_remove(GtkWidget *widget, gpointer user_data);
void on_settings_select_font(GtkWidget *widget, gpointer user_data);


void silky_gui_show_main();
void silky_gui_check_channel_cmodes();
gboolean on_topic_restore(GtkWidget *widget, gpointer user_data);
gboolean on_topic(GtkWidget *widget, gpointer user_data);

void silky_print(gint type, void *target, gchar *text, ...);
void silky_print_channel(gint type, SilkyChannel *channel, gchar *string);
void silky_print_buffer(GtkTextView *textview, gchar *text);

gint gui_tab_type(gint pagenr);
void gui_renumber_tabs();

void set_textview_colors(GtkTextView *widget_textview);

void gui_prefs_set_up_server_treeview();



void populate_prefs_serverlist();

typedef enum {
  MSG_PUBLIC	= 1<<0,
  MSG_PRIVATE	= 1<<1,

  MSG_CONSOLE	= 1<<2,
  MSG_ALL	= 1<<3,

  MSG_MESSAGE	= 1<<4,
  MSG_ACTION	= 1<<5,
  MSG_MOTION	= 1<<6,

  MSG_SERVER	= 1<<7,
  MSG_INFO	= 1<<8,

  MSG_SIGNED	= 1<<9
} SilkyGUIMessageFlags;

#define template_signed		"[%s]%s"
#define template_motion		"*** %s"
#define template_timestamp	"%s | %s"

enum {
  TAB_TYPE_CONSOLE,
  TAB_TYPE_CHANNEL,
  TAB_TYPE_QUERY,
  TAB_TYPE_UNKNOWN,
  NUM_TAB_TYPES
};


#endif
