#ifndef BUDDYLIST_H__
#define BUDDYLIST_H__


struct silkybuddy_t {
  struct silkybuddy_t	*next;
  gchar			*nickname;
  gchar			*realname;
  gchar			*fingerprint;

  gchar			*languages;
  gchar			*preferred_contact;
  gchar			*timezone;
  gchar			*geolocation;
  SilcUInt32 mode;
};

typedef struct silkybuddy_t SilkyBuddy;

SilkyBuddy *buddy_find_by_nick(gchar *nick);
SilkyBuddy *buddy_find_by_fp(gchar *fingerprint);

gboolean buddy_add(gchar *nick, gchar *fingerprint);
void watch_add(gchar *nick);
void watch_del(gchar *nick);
void buddy_init_watchlist();

gboolean buddy_set_mode_by_fp(gchar *fingerprint, SilcUInt32 mode);
gboolean buddy_set_nick_by_fp(gchar *fingerprint, gchar *nick);
gboolean buddy_set_realname_by_fp(gchar *fingerprint, gchar *realname);

gboolean buddy_set_languages_by_fp(gchar *fingerprint, gchar *languages);
gboolean buddy_set_pref_contact_by_fp(gchar *fingerprint, gchar *pref_cont);
gboolean buddy_set_timezone_by_fp(gchar *fingerprint, gchar *timezone);
gboolean buddy_set_geolocation_by_fp(gchar *fingerprint, gchar *geolocation);

gboolean buddy_remove_by_fp(gchar *fingerprint);

gboolean init_buddies(gchar *buddiespath);
gboolean parse_buddies();
gboolean save_buddies();

gboolean buddy_selected (GtkTreeView*, GdkEventButton*);

#endif
