#ifndef GUI_H__
#define GUI_H__


#include "channel.h"
#include "support.h"


void silky_gui_show_main();
void silky_gui_check_channel_cmodes();

void silky_print(gint type, void *target, gchar *text, ...);
void silky_print_channel(gint type, SilkyChannel *channel, gchar *string);
void silky_print_buffer(GtkTextView *textview, gchar *text);

gint gui_tab_type(gint pagenr);
void gui_renumber_tabs();

void set_textview_colors(GtkTextView *widget_textview);
void errordialog(const char *errormessage);
void close_all_tabs( void );
int printconsole (const char *msg);

void silky_show_user_info(SilkyUserInfo *user);
void silky_free_user_info(SilkyUserInfo *user);


typedef enum {
  MSG_PUBLIC	= 1<<0,
  MSG_PRIVATE	= 1<<1,

  MSG_CONSOLE	= 1<<2,
  MSG_ALL	= 1<<3,

  MSG_MESSAGE	= 1<<4,
  MSG_ACTION	= 1<<5,
  MSG_MOTION	= 1<<6,

  MSG_SERVER	= 1<<7,
  MSG_INFO	= 1<<8,

  MSG_SIGNED	= 1<<9
} SilkyGUIMessageFlags;

#define template_signed		"[%s]%s"
#define template_motion		"*** %s"
#define template_timestamp	"%s | %s"

enum {
  TAB_TYPE_CONSOLE,
  TAB_TYPE_CHANNEL,
  TAB_TYPE_QUERY,
  TAB_TYPE_UNKNOWN,
  NUM_TAB_TYPES
};


#endif
