/* Copyright (c) 2014-2015. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

/* Warning: autogenerated, do not edit! */

#include <dwarf.h>
#include <elfutils/libdw.h>
#include "src/mc/mc_dwarf.hpp"

#include "xbt/base.h"

namespace simgrid {
namespace dwarf {

/** \brief Get the name of a dwarf tag (DW_TAG_*) from its code
 *
 *  \param tag tag code (see the DWARF specification)
 *  \return name of the tag
 */
XBT_PRIVATE
const char *tagname(int tag)
{
  switch (tag) {
  case 0x01: return "DW_TAG_array_type";
  case 0x02: return "DW_TAG_class_type";
  case 0x03: return "DW_TAG_entry_point";
  case 0x04: return "DW_TAG_enumeration_type";
  case 0x05: return "DW_TAG_formal_parameter";
  case 0x08: return "DW_TAG_imported_declaration";
  case 0x0a: return "DW_TAG_label";
  case 0x0b: return "DW_TAG_lexical_block";
  case 0x0d: return "DW_TAG_member";
  case 0x0f: return "DW_TAG_pointer_type";
  case 0x10: return "DW_TAG_reference_type";
  case 0x11: return "DW_TAG_compile_unit";
  case 0x12: return "DW_TAG_string_type";
  case 0x13: return "DW_TAG_structure_type";
  case 0x15: return "DW_TAG_subroutine_type";
  case 0x16: return "DW_TAG_typedef";
  case 0x17: return "DW_TAG_union_type";
  case 0x18: return "DW_TAG_unspecified_parameters";
  case 0x19: return "DW_TAG_variant";
  case 0x1a: return "DW_TAG_common_block";
  case 0x1b: return "DW_TAG_common_inclusion";
  case 0x1c: return "DW_TAG_inheritance";
  case 0x1d: return "DW_TAG_inlined_subroutine";
  case 0x1e: return "DW_TAG_module";
  case 0x1f: return "DW_TAG_ptr_to_member_type";
  case 0x20: return "DW_TAG_set_type";
  case 0x21: return "DW_TAG_subrange_type";
  case 0x22: return "DW_TAG_with_stmt";
  case 0x23: return "DW_TAG_access_declaration";
  case 0x24: return "DW_TAG_base_type";
  case 0x25: return "DW_TAG_catch_block";
  case 0x26: return "DW_TAG_const_type";
  case 0x27: return "DW_TAG_constant";
  case 0x28: return "DW_TAG_enumerator";
  case 0x29: return "DW_TAG_file_type";
  case 0x2a: return "DW_TAG_friend";
  case 0x2b: return "DW_TAG_namelist";
  case 0x2c: return "DW_TAG_namelist_item";
  case 0x2d: return "DW_TAG_packed_type";
  case 0x2e: return "DW_TAG_subprogram";
  case 0x2f: return "DW_TAG_template_type_parameter";
  case 0x30: return "DW_TAG_template_value_parameter";
  case 0x31: return "DW_TAG_thrown_type";
  case 0x32: return "DW_TAG_try_block";
  case 0x33: return "DW_TAG_variant_part";
  case 0x34: return "DW_TAG_variable";
  case 0x35: return "DW_TAG_volatile_type";
  case 0x36: return "DW_TAG_dwarf_procedure";
  case 0x37: return "DW_TAG_restrict_type";
  case 0x38: return "DW_TAG_interface_type";
  case 0x39: return "DW_TAG_namespace";
  case 0x3a: return "DW_TAG_imported_module";
  case 0x3b: return "DW_TAG_unspecified_type";
  case 0x3c: return "DW_TAG_partial_unit";
  case 0x3d: return "DW_TAG_imported_unit";
  case 0x3e: return "DW_TAG_mutable_type";
  case 0x3f: return "DW_TAG_condition";
  case 0x40: return "DW_TAG_shared_type";
  case 0x41: return "DW_TAG_type_unit";
  case 0x42: return "DW_TAG_rvalue_reference_type";
  case 0x43: return "DW_TAG_template_alias";
  case 0x4080: return "DW_TAG_lo_user";
  case 0x4081: return "DW_TAG_MIPS_loop";
  case 0x4101: return "DW_TAG_format_label";
  case 0x4102: return "DW_TAG_function_template";
  case 0x4103: return "DW_TAG_class_template";
  case 0x4104: return "DW_TAG_GNU_BINCL";
  case 0x4105: return "DW_TAG_GNU_EINCL";
  case 0x4106: return "DW_TAG_GNU_template_template_param";
  case 0x4107: return "DW_TAG_GNU_template_parameter_pack";
  case 0x4108: return "DW_TAG_GNU_formal_parameter_pack";
  case 0x4109: return "DW_TAG_GNU_call_site";
  case 0x410a: return "DW_TAG_GNU_call_site_parameter";
  case 0xffff: return "DW_TAG_hi_user";
  case DW_TAG_invalid:
    return "DW_TAG_invalid";
  default:
    return "DW_TAG_unknown";
  }
}

}
}
