var NAVTREE =
[
  [ "SimGrid", "index.html", [
    [ "SimGrid Documentation", "index.html", null ],
    [ "SimGrid in 30mn", "getting_started.html", null ],
    [ "Introduction to SimGrid", "introduction.html", null ],
    [ "Installing Simgrid", "install.html", [
      [ "Installing a binary package", "install.html#install_binary", [
        [ "Binary packages for linux", "install.html#install_binary_linux", null ],
        [ "Installation wizard for Windows", "install.html#install_binary_win", null ],
        [ "Using the binary jar file", "install.html#install_binary_java", null ]
      ] ],
      [ "Installing from source", "install.html#install_src", [
        [ "Resolving the dependencies", "install.html#install_src_deps", null ],
        [ "Retrieving the source", "install.html#install_src_fetch", null ],
        [ "Configuring the build", "install.html#install_src_config", [
          [ "Setting compilation options", "install.html#install_cmake_howto", null ],
          [ "SimGrid compilation options", "install.html#install_cmake_list", null ],
          [ "Resetting the compilation configuration", "install.html#install_cmake_reset", null ],
          [ "Compiling into a separate directory", "install.html#install_cmake_outsrc", null ],
          [ "Cmake on Windows (with MinGW)", "install.html#install_cmake_win", null ],
          [ "Cmake on Mac OSX", "install.html#install_cmake_mac", null ]
        ] ],
        [ "Compiling SimGrid", "install.html#install_src_compil", null ],
        [ "Testing SimGrid", "install.html#install_src_test", null ]
      ] ],
      [ "Setting up your own code", "install.html#install_setting_own", [
        [ "MSG code on Unix (Linux or Mac OSX)", "install.html#install_setting_MSG", null ],
        [ "Compile the \"HelloWorld\" project on Windows", "install.html#install_setting_win_provided", null ],
        [ "Adding and Compiling a new example on Windows", "install.html#install_setting_win_new", null ],
        [ "Setup a virtualbox to use SimGrid-Ruby on windows", "install.html#install_Win_ruby", null ]
      ] ]
    ] ],
    [ "Using SimGrid", "use.html", "use" ],
    [ "Advanced Topics", "advanced.html", "advanced" ],
    [ "Frequently Asked Questions", "FAQ.html", [
      [ "I'm new to SimGrid. I have some questions. Where should I start?", "FAQ.html#faq_simgrid", [
        [ "What is the difference between MSG and SimDag? Do they serve the same purpose?", "FAQ.html#faq_interfaces", null ],
        [ "Visualizing and analyzing the results", "FAQ.html#faq_visualization", null ],
        [ "Argh! Do I really have to code in C?", "FAQ.html#faq_C", null ]
      ] ],
      [ "Feature related questions", "FAQ.html#faq_howto", [
        [ "\"Could you please add (your favorite feature here) to SimGrid?\"", "FAQ.html#faq_MIA", null ],
        [ "MSG features", "FAQ.html#faq_MIA_MSG", [
          [ "I want some more complex MSG examples!", "FAQ.html#faq_MIA_examples", null ],
          [ "Missing in action: MSG Task duplication/replication", "FAQ.html#faq_MIA_taskdup", null ],
          [ "I want to do asynchronous communications in MSG", "FAQ.html#faq_MIA_asynchronous", null ],
          [ "I need to synchronize my MSG processes", "FAQ.html#faq_MIA_thread_synchronization", null ],
          [ "Where is the get_host_load function hidden in MSG?", "FAQ.html#faq_MIA_host_load", null ],
          [ "How can I get the *real* communication time?", "FAQ.html#faq_MIA_communication_time", null ]
        ] ],
        [ "SimDag related questions", "FAQ.html#faq_MIA_SimDag", [
          [ "Implementing communication delays between tasks.", "FAQ.html#faq_SG_comm", null ],
          [ "How to implement a distributed dynamic scheduler of DAGs.", "FAQ.html#faq_SG_DAG", null ]
        ] ],
        [ "Generic features", "FAQ.html#faq_MIA_generic", [
          [ "Increasing the amount of simulated processes", "FAQ.html#faq_more_processes", null ],
          [ "Is there a native support for batch schedulers in SimGrid?", "FAQ.html#faq_MIA_batch_scheduler", null ],
          [ "I need a checkpointing thing", "FAQ.html#faq_MIA_checkpointing", null ]
        ] ],
        [ "Platform building and Dynamic resources", "FAQ.html#faq_platform", [
          [ "Where can I find SimGrid platform files?", "FAQ.html#faq_platform_example", null ],
          [ "How can I automatically map an existing platform?", "FAQ.html#faq_platform_alnem", null ],
          [ "Generating synthetic but realistic platforms", "FAQ.html#faq_platform_synthetic", null ],
          [ "Using random variable for the resource power or availability", "FAQ.html#faq_platform_random", null ]
        ] ]
      ] ],
      [ "Troubleshooting", "FAQ.html#faq_troubleshooting", [
        [ "The feature X stopped to work after my last update", "FAQ.html#faq_trouble_changelog", null ],
        [ "SimGrid compilation and installation problems", "FAQ.html#faq_trouble_lib_compil", [
          [ "cmake fails!", "FAQ.html#faq_trouble_lib_config", null ],
          [ "Dude! \"ctest\" fails on my machine!", "FAQ.html#faq_trouble_distcheck", null ]
        ] ],
        [ "User code compilation problems", "FAQ.html#faq_trouble_compil", [
          [ "\"gcc: _simgrid_this_log_category_does_not_exist__??? undeclared (first use in this function)\"", "FAQ.html#faq_trouble_err_logcat", null ],
          [ "\"gcc: undefined reference to pthread_key_create\"", "FAQ.html#faq_trouble_pthreadstatic", null ],
          [ "\"gcc: undefined reference to MSG_*\"", "FAQ.html#faq_trouble_lib_msg_deprecated", null ]
        ] ],
        [ "Runtime error messages", "FAQ.html#faq_trouble_errors", [
          [ "\"surf_parse_lex: Assertion `next limit' failed.\"", "FAQ.html#faq_flexml_limit", null ],
          [ "I'm told that my XML files are too old.", "FAQ.html#faq_trouble_errors_big_fat_warning", null ]
        ] ],
        [ "Valgrind-related and other debugger issues", "FAQ.html#faq_trouble_valgrind", [
          [ "longjmp madness in valgrind", "FAQ.html#faq_trouble_vg_longjmp", null ],
          [ "Valgrind spits tons of errors about backtraces!", "FAQ.html#faq_trouble_vg_libc", null ],
          [ "Truncated backtraces", "FAQ.html#faq_trouble_backtraces", null ]
        ] ],
        [ "There is a deadlock in my code!!!", "FAQ.html#faq_deadlock", null ],
        [ "I get weird timings when I play with the latencies.", "FAQ.html#faq_surf_network_latency", null ],
        [ "So I've found a bug in SimGrid. How to report it?", "FAQ.html#faq_bugrepport", null ]
      ] ]
    ] ],
    [ "Data Structures", "annotated.html", "annotated" ],
    [ "Data Fields", "functions.html", [
      [ "All", "functions.html", null ],
      [ "Variables", "functions_vars.html", null ]
    ] ],
    [ "APIs Reference", "modules.html", "modules" ]
  ] ]
];

var NAVTREEINDEX =
[
"FAQ.html",
"group__TRACE__user__variables.html#ga8f2371c0b41d2e462a2b94d81be4e148",
"group__XBT__graph.html#gaa5d7e658935aa26a17acaa1cdcd575a4",
"group__m__task__management.html#gaa7cd89c7f542d19fd817a614d1c1cc95",
"options.html#options_tracing",
"structsurf__storage__model__extension__public.html#a42319a48e89b0993946e5f682b0985f3"
];

var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  return 'localStorage' in window && window['localStorage'] !== null;
}

function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode) {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  imgNode.width = 16;
  imgNode.height = 22;
  if (level==0 && node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast) {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        } else {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  } else {
    domNode.appendChild(imgNode);
  }
  if (level==0) {
    if (node.isLast) {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    } else {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2pnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  } else {
    if (node.isLast) {
      imgNode.src = node.relpath+"ftv2blank.png";
    } else {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : '#';
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var pos, anchor = $(aname), docContent = $('#doc-content');
        if (anchor.parent().attr('class')=='memItemLeft') {
          pos = anchor.parent().position().top;
        } else if (anchor.position()) {
          pos = anchor.position().top;
        }
        if (pos) {
          var dist = Math.abs(Math.min(
                     pos-docContent.offset().top,
                     docContent[0].scrollHeight-
                     docContent.height()-docContent.scrollTop()));
          docContent.animate({
            scrollTop: pos + docContent.scrollTop() - docContent.offset().top
          },Math.max(50,Math.min(500,dist)),function(){
            window.location.replace(aname);
          });
        }
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var anchor = $($(location).attr('hash'));
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (root==NAVTREE[0][1]) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    navSync.html('<img src="'+relpath+'sync_off.png"/>');
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    navSync.html('<img src="'+relpath+'sync_on.png"/>');
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      navSync.html('<img src="'+relpath+'sync_off.png"/>');
      navSync.removeClass('sync');
    } else {
      navSync.html('<img src="'+relpath+'sync_on.png"/>');
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     }
  })

  $(window).load(showRoot);
}

