#include <string>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include "audiocdops.h"
#include "string2int.h"
#include "craparray.h"
#include "interface.h"
#include "support.h"
#include "copycd.h"
#include "simplecdr.h"
#include "string2int.h"
#include "setup.h"
#include "rip.h"
#include "play.h"
#include "masteraudiocd.h"
#include "masterdatacd.h"
#include "id3.h"
#include "clist_common.h"
#include "datacdops.h"

extern GtkWidget *main_win, *filesel, *working, *new_dir_popup, *progress_win,
  *bad_data, *stdout_window, *burn_conf, *mkisowin, *cdaudwin, *multicopy,
  *copy_options, *copy_cdrdao, *burn_bin_win, imagewin;

//Class initialization
extern Setup setupData1;
extern Setupconf setup;
extern String2int convert;
extern RipEncode ripenc;
extern RipType ripping;
extern Play play;
extern Copy copycd;
extern MasterAudioCD master_aud;
extern MasterDataCD master_data;
extern id3Tag id3;

//Enumerated Data Types
extern songType song;
extern imageType image;
extern addType mode;

//Global variables
extern string filename;
extern CrapArray < string > file_array, dir_array, subdir_array;
extern int total_members_dir, total_members_file, total_members_subdir;
extern bool refresh_lists;
extern gint r, r1, col, rowtemp, columntemp;
extern int tracks, total_time_;
extern bool simulate, normalize, onthefly, dao, cdrdao_aud;
using namespace std;

void
save_tracklist (string filename)
{
  int count = 1;
  gchar *temp[2];
  ofstream listOut;

  listOut.open (filename.c_str ());
  if (!listOut)
    {
      cout << "Cannot open file, check permissions" << endl;
      return;
    }

  while (count < tracks)
    {
      r = count - 1;
      gtk_clist_get_text (GTK_CLIST (get_widget (main_win, "audio_list")), r,
			  0, &temp[0]);
      listOut << temp[0] << "\n";
      count++;
    }

  listOut.close ();
  gtk_widget_destroy (filesel);
}


void
playlist_selection (char *temp)
{
  int if_added = -1;
  GtkCList *audio_tracks;
  ifstream inFile;
  string filename_, command, time_ind, time_total;

  audio_tracks = GTK_CLIST (get_widget (main_win, "audio_list"));

  inFile.open (temp);
  if (!inFile)
    {
      cout << "Unable to open file, try again" << temp << endl;
      return;
    }
  getline (inFile, filename_);
  while (inFile)
    {
      gchar *Track[2] = { (gchar *) filename_.c_str (), "" };


      if (int (filename_.find (".mp3")) != -1
	  || int (filename_.find (".Mp3")) != -1
	  || int (filename_.find (".mP3")) != -1
	  || int (filename_.find (".MP3")) != -1)
	{
	  song = MP3;
	  master_aud.time_est (filename_, time_ind, time_total, song,
			       total_time_);
	  Track[1] = (gchar *) time_ind.c_str ();
	  gtk_clist_append (GTK_CLIST (audio_tracks), Track);
	  tracks++;
	  if_added++;
	}
      if (int (filename_.find (".wav")) != -1
	  || int (filename_.find (".Wav")) != -1
	  || int (filename_.find (".WAv")) != -1
	  || int (filename_.find (".WAV")) != -1
	  || int (filename_.find (".wAV")) != -1
	  || int (filename_.find (".waV")) != -1
	  || int (filename_.find (".wAv")) != -1
	  || int (filename_.find (".WaV")) != -1)
	{
	  song = WAV;
	  master_aud.time_est (filename_, time_ind, time_total, song,
			       total_time_);
	  Track[1] = (gchar *) time_ind.c_str ();
	  gtk_clist_append (GTK_CLIST (audio_tracks), Track);
	  tracks++;
	  if_added++;
	}

      if (int (filename_.find (".ogg")) != -1
	  || int (filename_.find (".Ogg")) != -1
	  || int (filename_.find (".OGg")) != -1
	  || int (filename_.find (".OGG")) != -1
	  || int (filename_.find (".oGG")) != -1
	  || int (filename_.find (".ogG")) != -1
	  || int (filename_.find (".oGg")) != -1
	  || int (filename_.find (".OgG")) != -1)
	{
	  song = OGG;
	  master_aud.time_est (filename_, time_ind, time_total, song,
			       total_time_);
	  Track[1] = (gchar *) time_ind.c_str ();
	  gtk_clist_append (GTK_CLIST (audio_tracks), Track);
	  tracks++;
	  if_added++;
	}

      if (if_added == -1)
	cout << "Invalid file type " << filename_ << endl;

      getline (inFile, filename_);
      if_added = -1;
    }
  inFile.close ();
  gtk_label_set_text (GTK_LABEL (get_widget (main_win, "total_time")),
		      (gchar *) time_total.c_str ());
}

//***********************************

void
cd_track_add (string filename)
{
  string time_ind, time_total;
  int if_added = -1;
  GtkCList *audio_tracks;
  gchar *Track[2] = { (gchar *) filename.c_str (), "" };

  audio_tracks = GTK_CLIST (get_widget (main_win, "audio_list"));

  if (int (filename.find (".mp3")) != -1 || int (filename.find (".Mp3")) != -1
      || int (filename.find (".mP3")) != -1
      || int (filename.find (".MP3")) != -1)
    {
      song = MP3;
      master_aud.time_est (filename, time_ind, time_total, song, total_time_);
      Track[1] = (gchar *) time_ind.c_str ();
      gtk_clist_append (GTK_CLIST (audio_tracks), Track);
      tracks++;
      if_added++;
    }
  if (int (filename.find (".wav")) != -1 || int (filename.find (".Wav")) != -1
      || int (filename.find (".WAv")) != -1
      || int (filename.find (".WAV")) != -1
      || int (filename.find (".wAV")) != -1
      || int (filename.find (".waV")) != -1
      || int (filename.find (".wAv")) != -1
      || int (filename.find (".WaV")) != -1)
    {
      song = WAV;
      master_aud.time_est (filename, time_ind, time_total, song, total_time_);
      Track[1] = (gchar *) time_ind.c_str ();
      gtk_clist_append (GTK_CLIST (audio_tracks), Track);
      tracks++;
      if_added++;
    }

  if (int (filename.find (".ogg")) != -1 || int (filename.find (".Ogg")) != -1
      || int (filename.find (".OGg")) != -1
      || int (filename.find (".OGG")) != -1
      || int (filename.find (".oGG")) != -1
      || int (filename.find (".ogG")) != -1
      || int (filename.find (".oGg")) != -1
      || int (filename.find (".OgG")) != -1)
    {
      song = OGG;
      master_aud.time_est (filename, time_ind, time_total, song, total_time_);
      Track[1] = (gchar *) time_ind.c_str ();
      gtk_clist_append (GTK_CLIST (audio_tracks), Track);
      tracks++;
      if_added++;
    }

  if (if_added == -1)
    cout << "Invalid file type " << filename << endl;

  gtk_label_set_text (GTK_LABEL (get_widget (main_win, "total_time")),
		      (gchar *) time_total.c_str ());
}

