/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */

//#define MAX_NUM_TRACK 99
//#define MAX_FILE_NAME_LENGTH 100

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <string>
#include <cstdlib>
#include "audiocdops.h"
#include "datacdops.h"
#include "callbacks.h"
#include "string2int.h"
#include "craparray.h"
#include "interface.h"
#include "support.h"
#include "copycd.h"
#include "simplecdr.h"
#include "string2int.h"
#include "setup.h"
#include "rip.h"
#include "play.h"
#include "masteraudiocd.h"
#include "masterdatacd.h"
#include "id3.h"
#include "clist_common.h"
#include "cddb.h"


GtkWidget *main_win, *filesel, *working, *new_dir_popup, *progress_win,
  *bad_data, *stdout_window, *burn_conf, *mkisowin, *cdaudwin, *multicopy,
  *copy_options, *copy_cdrdao, *burn_bin_win, *imagewin, *blankwin, *mkisoimagewin;
    static GtkWidget *track_selected_button[ MAX_NUM_TRACK ];
	static GtkWidget *filename_entry[ MAX_NUM_TRACK ];
	static GtkWidget *artist_entry[ MAX_NUM_TRACK ];
	static char saved_filename_entry[ MAX_NUM_TRACK ][ MAX_FILE_NAME_LENGTH ];
//Class initialization
Setup setupData1;
Setupconf setup;
String2int convert;
RipEncode ripenc;
RipType ripping;
Play play;
Copy copycd;
MasterAudioCD master_aud;
MasterDataCD master_data;
id3Tag id3;

//Enumerated Data Types
songType song;
imageType image;
addType mode;
blankType blank;

//Global variables
string filename;
//static string current_dir = "/";
CrapArray < string > file_array, dir_array, subdir_array;
int total_members_dir = -1, total_members_file = -1, total_members_subdir = -1;
bool refresh_lists;
gint r = -1, r1 = -1, col = -1, rowtemp = -1, columntemp = -1;
int tracks = 1, total_time_ = 0;
bool simulate, normalize, onthefly, dao, cdrdao_aud;
static bool detailVisible = false;
static int num_tracks;

#define MOZILLA " /opt/mozilla9/mozilla"
#include <assert.h>
// always useful for runtime debuging
using namespace std;

GtkTargetEntry drop_types[] = {
  {"text/uri-list", 0, 0}
};
int n_drop_types = sizeof (drop_types) / sizeof (drop_types[0]);

void
main_menu (GtkWidget * SimpleCDR_X, Setup setupData)
{
  main_win = SimpleCDR_X;
  setupData1 = setupData;
}

//***********************************

void
on_add_playlist_clicked (GtkButton * button, gpointer user_data)
{
  mode = EPLAYLIST;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
on_save_tracklist_button_clicked (GtkButton * button, gpointer user_data)
{
  mode = ESAVE_PLAYLIST;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************



//***********************************

void
on_add_file_clicked (GtkButton * button, gpointer user_data)
{
  mode = ECD_TRACK;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************
/*
void
on_rip_n_add_clicked (GtkButton * button, gpointer user_data)
{
  static int rip_add = 1;
  char list_[350];
  string time_total, time_ind;
  string list, suffix, track, filename;

  strcpy (list_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_n_add_entry"))));
  list = list_;

  if (list == "")
    {
      bad_data_show ();
      return;
    }
  while (list.substr (list.length () - 1, list.length ()) == " ")
    list = list.substr (0, list.length () - 1);

  while (list.substr (0, 1) == " ")
    list = list.substr (1, list.length () - 1);

  while (list != "end")
    {
      convert.selTracks (list, track);
      if (track == "error" || track == "")
	{
	  bad_data_show ();
	  break;
	}

      convert.trackSuf (rip_add, suffix);
      filename = convert.randName ();
      filename =
	setupData1.tempdiraudio + "/" + filename + "_" + suffix + ".wav";

      int cont = master_aud.ripNAdd (filename, suffix, track, setupData1);
      if (cont == 1)
	break;

      //cout << endl << "Finished  ripping track... " << track << endl;
      gchar *Track[2] = { (gchar *) filename.c_str (), "" };

      song = WAV;
      master_aud.time_est (filename, time_ind, time_total, song, total_time_);
      Track[1] = (gchar *) time_ind.c_str ();


      gtk_label_set_text (GTK_LABEL (get_widget (main_win, "total_time")),
			  (gchar *) time_total.c_str ());
      gtk_clist_append (GTK_CLIST (get_widget (main_win, "audio_list")),
			Track);

      rip_add++;
      tracks++;
    }
  progress_show ();
}
*/
//***********************************

void
on_play_cd_clicked (GtkButton * button, gpointer user_data)
{
  int track;

  track =
    (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
				      (get_widget
				       (main_win, "cd_track_sel_spin")));
  play.cdplay (track, setupData1);
}

//***********************************

void
on_play_cd_master_clicked (GtkButton * button, gpointer user_data)
{
  int track;

  track =
    (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
				      (get_widget
				       (main_win, "cd_master_spin_button")));
  play.cdplay (track, setupData1);
}

//***********************************

void
on_burn_audio_clicked (GtkButton * button, gpointer user_data)
{
  cdaudwin = create_cdaudopts ();
  gtk_widget_show (cdaudwin);
}

//***********************************


void
on_aud_burn_button_clicked (GtkButton * button, gpointer user_data)
{
  gboolean norm, cdrdao_audio;
  norm =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				  (get_widget
				   (cdaudwin, "normalize_button")));
  cdrdao_audio =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				  (get_widget (cdaudwin, "use_cdrdao")));
  if (norm == TRUE)
    normalize = true;
  else
    normalize = false;
  if (cdrdao_audio == TRUE)
    cdrdao_aud = true;
  else
    cdrdao_aud = false;

  mode = EBURN_MASTERAUDIO;
  burn_conf_show ();
}


void
on_aud_abort_button_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (cdaudwin);
}


void
on_rip_sel_wav_clicked (GtkButton * button, gpointer user_data)
{
  char tracks_[350], dir_[350], prefix_[350];
  string tracks, dir, prefix, bitrate;

  strcpy (tracks_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_sel_track"))));
  strcpy (dir_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "directory_save_entry"))));
  strcpy (prefix_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_prefix"))));

  //conversion to C++ strings
  tracks = tracks_;
  dir = dir_;
  prefix = prefix_;
  ripping = RIPONLY;


  if (tracks == "" || prefix == "" || dir == "")
    {
      bad_data_show ();
      return;
    }
  stdout_window = create_stdout_window();
  gtk_widget_show(stdout_window);
  ripenc.trackList (ripping, tracks, dir, prefix, bitrate, setupData1);
  gtk_widget_destroy(stdout_window);
  progress_show ();

}

//***********************************

void
on_rip_all_wav_clicked (GtkButton * button, gpointer user_data)
{
  char prefix_[350], dir_[350];
  string prefix, dir;

  strcpy (dir_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "directory_save_entry"))));
  strcpy (prefix_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_prefix"))));

  dir = dir_;
  prefix = prefix_;

  if (prefix == "" || dir == "")
    {
      bad_data_show ();
      return;
    }
  stdout_window = create_stdout_window();
  gtk_widget_show(stdout_window);
	ripenc.ripAll (dir, prefix, setupData1);
  gtk_widget_destroy(stdout_window);
	progress_show ();
}

//***********************************

void
on_play_cd_track_clicked (GtkButton * button, gpointer user_data)
{
  int track;

  track =
    (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
				      (get_widget
				       (main_win, "cd_track_sel_spin")));
  play.cdplay (track, setupData1);
}

//***********************************

void
on_rip_sel_enc_clicked (GtkButton * button, gpointer user_data)
{
  char tracks_[350], dir_[350], prefix_[350], bitrate_[350];
  string tracks, dir, prefix, bitrate;

  strcpy (tracks_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_sel_track"))));
  strcpy (dir_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "directory_save_entry"))));
  strcpy (prefix_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_prefix"))));
  strcpy (bitrate_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "bitrate_entry"))));

  //conversion to C++ strings
  tracks = tracks_;
  dir = dir_;
  prefix = prefix_;
  bitrate = bitrate_;

  ripping = ENCODE;

  if (tracks == "" || prefix == "" || dir == "")
    {
      bad_data_show ();
      return;
    }
  stdout_window = create_stdout_window();
  gtk_widget_show(stdout_window);
	ripenc.trackList (ripping, tracks, dir, prefix, bitrate, setupData1);
  gtk_widget_destroy(stdout_window);
	progress_show ();
}

//***********************************

void
on_rip_all_enc_clicked (GtkButton * button, gpointer user_data)
{
  char dir_[350], prefix_[350], bitrate_[350];
  string dir, prefix, bitrate;

  strcpy (dir_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "directory_save_entry"))));
  strcpy (prefix_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_prefix"))));
  strcpy (bitrate_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "bitrate_entry"))));

//conversion to C++ strings
  dir = dir_;
  prefix = prefix_;
  bitrate = bitrate_;

  if (prefix == "" || dir == "")
    {
      bad_data_show ();
      return;
    }
  stdout_window = create_stdout_window();
  gtk_widget_show(stdout_window);
  ripenc.encAll (dir, prefix, bitrate, setupData1);
  gtk_widget_destroy(stdout_window);
	progress_show ();
}

//***********************************

void
on_encode_ind_clicked (GtkButton * button, gpointer user_data)
{
  mode = EENCODE_FILE;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
on_encode_ind_button_clicked (GtkButton * button, gpointer user_data)
{
  char bitrate_[5], *filen = NULL;
  string bitrate, filename_;

  strcpy (bitrate_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "bitrate_entry"))));
  bitrate = bitrate_;

  filen =
    gtk_entry_get_text (GTK_ENTRY (get_widget (main_win, "enc_ind_entry")));
  filename_ = filen;

  if (filename_ == "")
    {
      bad_data_show ();
      return;
    }
  stdout_window = create_stdout_window();
  gtk_widget_show(stdout_window);
	ripenc.encInd (filename_, bitrate, setupData1);
  gtk_widget_destroy(stdout_window);
	progress_show ();
}

//***********************************

void
dir_select (string filename)
{
  gtk_object_destroy (GTK_OBJECT (filesel));
  gtk_entry_set_text (GTK_ENTRY
		      (get_widget (main_win, "directory_save_entry")),
		      (gchar *) filename.c_str ());
}


void
on_dir_save_button_clicked (GtkButton * button, gpointer user_data)
{
  mode = EDIR_SEL;
  filesel = create_filesel ();
  gtk_widget_show (filesel);

}

//***********************************

void
on_copy_audio_button_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_AUDIOCOPY;
  copy_options_show ();
}

//***********************************

void
on_copy_data_mkisofs_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_MKISOFSCOPY;
  copy_options_show ();
}

//***********************************

void
on_copy_with_cdrdao_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_CDRDAOCOPY;
  copy_cdrdao_show ();
}

//***********************************

void
on_save_button_clicked (GtkButton * button, gpointer user_data)
{
  string filename;
  char burner[7], reader[7], burnerdev[100], readerdev[100], customopts[100],
    tempdiraudio[100], tempdirdata[100], cdrdaoburner[100], cdrdaoreader[100],
    encoder_[20], decoder_[20], ripper_[20], fifo[20];
  int speed;
  ofstream setupStore;

  strcpy (burner,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "burner_id_entry"))));
  strcpy (burnerdev,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "burner_dev"))));
  strcpy (reader,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "reader_id_entry"))));
  strcpy (readerdev,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "reader_dev"))));
  speed =
    (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON
				      (get_widget
				       (main_win, "cd_burner_speed")));
  strcpy (cdrdaoburner,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "cdrdao_burner_entry"))));
  strcpy (cdrdaoreader,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "cdrdao_reader_entry"))));
  strcpy (ripper_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "ripper_entry"))));
  strcpy (encoder_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "encoder_entry"))));
  strcpy (decoder_,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "decoder_entry"))));
  strcpy (customopts,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "cdrecord_opts"))));
  strcpy (tempdiraudio,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "temp_dir_audio_entry"))));
  strcpy (tempdirdata,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget
			       (main_win, "temp_dir_data_entry"))));
  strcpy (fifo,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "fifo_entry"))));

  filename = setupData1.home + "/.simplecdr/cdr.conf";
  setupStore.open (filename.c_str ());

  if (!setupStore)
    cout << "File open failed, check permissions" << endl;

  setupStore << "reader " << reader << "\n";
  setupStore << "readerdev " << readerdev << "\n";
  setupStore << "recorder " << burner << "\n";
  setupStore << "recorderdev " << burnerdev << "\n";
  setupStore << "speed " << speed << "\n";
  setupStore << "tempdirdata " << tempdirdata << "\n";
  setupStore << "ripper " << ripper_ << "\n";
  setupStore << "cdrdaoburner " << cdrdaoburner << "\n";
  setupStore << "cdrdaoreader " << cdrdaoreader << "\n";
  setupStore << "tempdiraudio " << tempdiraudio << "\n";
  setupStore << "encoder " << encoder_ << "\n";
  setupStore << "decoder " << decoder_ << "\n";
  setupStore << "custom_cdrecord  " << customopts << "\n";
  setupStore << "fifo  " << fifo << "\n";
  setupStore.close ();
  setup.initconf (setupData1);
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (get_widget(main_win, "swap_reader_button")))==TRUE)
  { 
  	setupData1.reader = setupData1.recorder;
  	setupData1.readerdev = setupData1.recorderdev;
  }
}

//***********************************

void
setupvalues (int &firstrun)
{
  string function = "other";	//for conversion of string to integer
  int speed;			//for conversion of string to integer

  convert.sizeEstimator (setupData1.speed, function, speed);
  ifstream inFile;
  string filename = setupData1.home + "/.simplecdr/cdr.conf";
  inFile.open (filename.c_str ());

  if (inFile)
    {
      gtk_entry_set_text (GTK_ENTRY
			  (get_widget (main_win, "burner_id_entry")),
			  (gchar *) setupData1.recorder.c_str ());
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "burner_dev")),
			  (gchar *) setupData1.recorderdev.c_str ());
      gtk_entry_set_text (GTK_ENTRY
			  (get_widget (main_win, "reader_id_entry")),
			  (gchar *) setupData1.reader.c_str ());
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "reader_dev")),
			  (gchar *) setupData1.readerdev.c_str ());
      gtk_entry_set_text (GTK_ENTRY
			  (get_widget (main_win, "cdrdao_burner_entry")),
			  (gchar *) setupData1.cdrdaoburner.c_str ());
      gtk_entry_set_text (GTK_ENTRY
			  (get_widget (main_win, "cdrdao_reader_entry")),
			  (gchar *) setupData1.cdrdaoreader.c_str ());
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "ripper_entry")),
			  (gchar *) setupData1.ripper.c_str ());
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "encoder_entry")),
			  (gchar *) setupData1.encoder.c_str ());
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "decoder_entry")),
			  (gchar *) setupData1.decoder.c_str ());
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "cdrecord_opts")),
			  (gchar *) setupData1.custom_cdrecord.c_str ());
      gtk_entry_set_text (GTK_ENTRY
			  (get_widget (main_win, "temp_dir_audio_entry")),
			  (gchar *) setupData1.tempdiraudio.c_str ());
      gtk_entry_set_text (GTK_ENTRY
			  (get_widget (main_win, "temp_dir_data_entry")),
			  (gchar *) setupData1.tempdirdata.c_str ());
      gtk_spin_button_set_value (GTK_SPIN_BUTTON
				 (get_widget (main_win, "cd_burner_speed")),
				 speed);
      gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "fifo_entry")),
			  (gchar *) setupData1.fifo.c_str ());
    }
  else
    {
      cout << "No config file, defaults loaded" << endl;
      firstrun = 1;
    }
}

//***********************************

void
on_cd_stop_button_clicked (GtkButton * button, gpointer user_data)
{
  play.cdstop (setupData1);
}

//***********************************

void
on_delete_clicked (GtkButton * button, gpointer user_data)
{
  string filename_, time_total;
  gchar *temp[2];
  char *temp_;
  if (r == -1)
	  return;
  if (tracks == 1)
    return;
  gtk_clist_get_text (GTK_CLIST (get_widget (main_win, "audio_list")), r, 0,
		      &temp[0]);
  (gchar *) temp_ = temp[0];
  filename_ = temp_;

  if (int (filename_.find (".mp3")) != -1
      || int (filename_.find (".Mp3")) != -1
      || int (filename_.find (".mP3")) != -1
      || int (filename_.find (".MP3")) != -1)
    {
      song = MP3;
      master_aud.time_sub (filename_, song, total_time_);
    }

  if (int (filename_.find (".wav")) != -1
      || int (filename_.find (".Wav")) != -1
      || int (filename_.find (".WAv")) != -1
      || int (filename_.find (".WAV")) != -1
      || int (filename_.find (".wAV")) != -1
      || int (filename_.find (".waV")) != -1
      || int (filename_.find (".wAv")) != -1
      || int (filename_.find (".WaV")) != -1)
    {
      song = WAV;
      master_aud.time_sub (filename_, song, total_time_);
    }

  if (int (filename_.find (".ogg")) != -1
      || int (filename_.find (".Ogg")) != -1
      || int (filename_.find (".OGg")) != -1
      || int (filename_.find (".OGG")) != -1
      || int (filename_.find (".oGG")) != -1
      || int (filename_.find (".ogG")) != -1
      || int (filename_.find (".oGg")) != -1
      || int (filename_.find (".OgG")) != -1)
    {
      song = OGG;
      master_aud.time_sub (filename_, song, total_time_);
    }
  song = NONE;
  master_aud.time_est (time_total, time_total, time_total, song, total_time_);
/*First three variables are just there so I don't have to declare anymore, 
I'm just trying to run the total time back through*/

  gtk_clist_remove (GTK_CLIST (get_widget (main_win, "audio_list")), r);
  gtk_label_set_text (GTK_LABEL (get_widget (main_win, "total_time")),
		      (gchar *) time_total.c_str ());

  tracks--;
	r = -1;
}

//***********************************

void
on_delete_all_clicked (GtkButton * button, gpointer user_data)
{
  string time_total;
  gtk_clist_clear (GTK_CLIST (get_widget (main_win, "audio_list")));
  tracks = 1;
  total_time_ = 0;

  string command = "rm -r " + setupData1.tempdiraudio + "/simplecdrx*";
  system (command.c_str ());

  song = MP3;
  master_aud.time_est (time_total, time_total, time_total, song, total_time_);
//First three variables are just there so I don't have to declare anymore, 
//I'm just trying to run the total time back through

  gtk_clist_remove (GTK_CLIST (get_widget (main_win, "audio_list")), r);
  gtk_label_set_text (GTK_LABEL (get_widget (main_win, "total_time")),
		      (gchar *) time_total.c_str ());
}

//***********************************

void on_audio_list_select_row (GtkCList * clist,
			  gint row,
			  gint column, GdkEvent * event, gpointer user_data)
{
  r = row;
  col = column;

}

//***********************************

//OK Buttons
void
on_filesel_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *temp;
  temp = gtk_file_selection_get_filename (GTK_FILE_SELECTION (filesel));
  filename = temp;

  printf("[DEBUG] on_filesel_ok_clicked, mode is %d\n", mode);

  switch(mode)
  {
  case EENCODE_FILE:
  	printf("[DEBUG] EENCODE_FILE\n");
	encode_music_file (filename);
  	break;
  case EPLAYLIST:
  	printf("[DEBUG] EPLAYLIST\n");
	playlist_selection (temp);
 	break;
  case ESAVE_PLAYLIST:
	printf("[DEBUG] ESAVE_PLAYLIST\n");
	save_tracklist (filename);
	break;
  case ECD_TRACK:
	printf("[DEBUG] ECD_TRACK\n");
	cd_track_add (filename);
	break;
  case EDIRECTORY_CONTENTS:
	printf("[DEBUG] EDIRECTORY_CONTENTS\n");
	add_dir_contents(filename);
	break;
  case EFILE:
	printf("[DEBUG] EFILE\n");
	add_file(filename);
	break;
  case EDIRECTORY:
	printf("[DEBUG] EDIRECTORY\n");
	add_directory(filename);
	break;
  case ECD_IMAGE_LOAD:
	printf("[DEBUG] ECD_IMAGE_LOAD\n");
	cd_image_load_file (filename);
	break;
  case ECD_IMAGE_SAVE:
	printf("[DEBUG] ECD_IMAGE_SAVE\n");
	cd_image_save_file (filename);
	break;	
  case EBURN_ISO:
	printf("[DEBUG] EBURN_ISO\n");
	gtk_object_destroy (GTK_OBJECT (filesel));
	copy_options_show();
	break;
  case EBURN_BIN:
	printf("[DEBUG] EBURN_BIN\n");
	gtk_object_destroy (GTK_OBJECT (filesel));

	assert(filename != "");

	burn_bin_win = create_bin_burn_opts ();
	gtk_widget_show (burn_bin_win);
	break;
  case ETOC_SEL:
  gtk_object_destroy (GTK_OBJECT (filesel));
  if (filename == "")
	{
	  bad_data_show ();
	  break;
	}
	gtk_entry_set_text (GTK_ENTRY (get_widget (burn_bin_win, "toc_cue_entry")),
		      (gchar *) filename.c_str ());
	break;  
  case ECREATE_ISO:
	gtk_object_destroy (GTK_OBJECT (filesel));
	if (filename == "")
	{
	  bad_data_show ();
	  break;
	}
	gtk_entry_set_text (GTK_ENTRY (get_widget (imagewin, "create_image_entry")),
		      (gchar *) filename.c_str ());
	break;
  case ECREATE_BIN:
	gtk_object_destroy (GTK_OBJECT (filesel));
   gtk_entry_set_text (GTK_ENTRY (get_widget (imagewin, "create_image_entry")),
		      (gchar *) filename.c_str ());
	break;
  case EDIR_SEL:
	printf("[DEBUG] EDIR_SEL\n");
	dir_select (filename);
	break;	
  case EID3_TAG:
	printf("[DEBUG] EID3_TAG\n");
	gtk_object_destroy (GTK_OBJECT (filesel));
	gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "mp3list_entry")),
			  (gchar *) filename.c_str ());
	break;
  case ECREATE_IMG:
	mkisoimagewin = create_mkiso_image ();
	gtk_widget_show (mkisoimagewin);
  break;
  default:
	printf("[DEBUG] Error Unhandled case, mode is %d\n", mode);
	break;
  }
}

//**********************************

void
encode_music_file (string filename)
{
  gtk_object_destroy (GTK_OBJECT (filesel));
  gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "enc_ind_entry")),
		      (gchar *) filename.c_str ());
}

//***********************************
//***********************************

//Cancel buttons

void
on_cancel_button_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_hide (filesel);
}

//***********************************

void
on_simulate_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (togglebutton)) == TRUE)
    simulate = true;
  else
    simulate = false;
}

//***********************************

void
on_add_dir_clicked (GtkButton * button, gpointer user_data)
{
  new_dir_popup = create_new_dir_popup ();
  gtk_widget_show (new_dir_popup);
}

//***********************************

void
on_add_dir_contents_clicked (GtkButton * button, gpointer user_data)
{
  mode = EDIRECTORY_CONTENTS;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
on_delete_file_clicked (GtkButton * button, gpointer user_data)
{
  gchar *temp_file[2];
  char *temp_ = NULL;
  string tmp_file, tmp_dir, tmp;
  int i;
  if (total_members_file == -1)
    return;
// Initializing localized lists 
  gtk_clist_get_text (GTK_CLIST (get_widget (main_win, "data_master_list")),
		      r1, 0, &temp_file[0]);
  (gchar *) temp_ = temp_file[0];
  
  tmp_file = temp_;
  tmp_dir = current_dir;
  tmp = tmp_dir + "=" + tmp_file;

/*finds the array member with the matching filename and overwrites it by shifting 	
all the array members up one level to fill in any gaps*/

  if (tmp != "" || r1 == -1)
    {
      for (i = 0; i <= total_members_file; i++)
	{
	  if (0 == total_members_file)
	    {
	      file_array.clear ();
	      total_members_file = -1;
	      break;
	    }

	  if (int (file_array[i].find (tmp)) != -1)
	    {
	      file_array.Remove (i, total_members_file);
	      total_members_file--;
	      break;
	    }
	}
    }
  rowtemp = -1;
  r1 = -1;
  
  refresh_lists = false;
  refresh_list ();
}

//***********************************
void
on_remove_dir_button_clicked (GtkButton * button, gpointer user_data)
{
 remove_dir();
}

//***********************************

void
mkisofs_options ()
{
  mkisowin = create_mkisofsopt ();
  gtk_widget_show (mkisowin);
}

//***********************************

void
on_mkisofs_button1_clicked (GtkButton * button, gpointer user_data)
{
  burn_conf_show ();
}

//***********************************

void
on_mkisofs_button2_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (mkisowin);
}

//***********************************
void
on_write_image_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_MASTERDATA;
  mkisofs_options ();
}

//***********************************

void
on_delete_all_file_clicked (GtkButton * button, gpointer user_data)
{
remove_all();
}

//***********************************

void
on_add_file_data_clicked (GtkButton * button, gpointer user_data)
{
  mode = EFILE;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
on_new_dir_ok_clicked (GtkButton * button, gpointer user_data)
{
  int i;
  char *temp1;
  string tmp, temp_name, find_name;

  tmp = current_dir;
  temp1 =
    gtk_entry_get_text (GTK_ENTRY
			(get_widget (new_dir_popup, "create_dir_entry")));
  temp_name = temp1;
  total_members_dir++;

  if (current_dir != "/")
    {
      for (i = 0; i <= total_members_dir; i++)
	{

	  find_name = current_dir.substr (0, current_dir.length () - 1);
	  if (dir_array[i] == find_name)
	    {
	      int it;
	      for (it = total_members_dir; it > i; it--)
		{
		  dir_array[it] = dir_array[(it - 1)];
		}
	      dir_array[++i] = tmp + temp_name;
	      break;
	    }
	}
    }
  else
    dir_array[total_members_dir] = tmp + temp_name;
  refresh_lists = false;
  refresh_list ();
  gtk_object_destroy (GTK_OBJECT (new_dir_popup));
}

//*********************************

void
on_dir_master_list_select_row         (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	rowtemp=row;
	columntemp=column;
}


//***********************************

void
on_new_dir_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_object_destroy (GTK_OBJECT (new_dir_popup));
}


//***********************************

void
on_cancel_data_button_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (filesel);
}

//***********************************

gboolean
on_dir_master_list_event (GtkWidget * widget,
			  GdkEvent * event, gpointer user_data)
{
// Adds the root directory if a directory hasn't been added yet
  if (total_members_dir == -1)
    {
      //             gchar *dir_entry[2]={"/", ""};
      //            gtk_clist_append(GTK_CLIST(GTK_CLIST(get_widget(main_win,"dir_master_list"))),dir_entry);
      //             total_members_dir++;
    }
  return FALSE;
}

//***********************************

void
on_data_master_list_select_row (GtkCList * clist,
				gint row,
				gint column,
				GdkEvent * event, gpointer user_data)
{
  r1 = row;
}

//***********************************

gboolean
on_dir_master_list_dc_row (GtkWidget * widget, GdkEventButton * event,
			   gpointer data)
{
  if (event->type == GDK_2BUTTON_PRESS)
    {
      r = rowtemp;
      col = columntemp;
      // refresh the file listing
      refresh_list ();
    }
  return TRUE;
}


//***********************************


void
on_cd_image_load_button_clicked (GtkButton * button, gpointer user_data)
{
  mode = ECD_IMAGE_LOAD;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
on_save_image_button_clicked (GtkButton * button, gpointer user_data)
{
  mode = ECD_IMAGE_SAVE;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}



//***********************************

//***********************************

void
on_add_directory_data_clicked (GtkButton * button, gpointer user_data)
{
  mode = EDIRECTORY;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
progress_show ()
{
  progress_win = create_progress_window ();
  gtk_widget_show (progress_win);
}

//***********************************

void
bad_data_show ()
{
  bad_data = create_bad_data ();
  gtk_widget_show (bad_data);
}

void
on_ok_button_finished_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (progress_win);
}

//***********************************   

void
on_bad_data_button_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (bad_data);
}

//***********************************

void
on_size_button_clicked (GtkButton * button, gpointer user_data)
{
  struct stat filesize;
  string size_total;
  int i;
  float total_size;
  for (i = 0; i <= total_members_file; i++)
    {
      if (file_array[i] != "")
	{
	  string temp =
	    file_array[i].substr (file_array[i].find ("=") + 1,
				  file_array[i].length ());
	  stat (temp.c_str (), &filesize);
	  total_size = total_size + float (filesize.st_size) / 1048000.0;
	}
    }
  total_size = total_size + .5;
  convert.timeconverter (int (total_size), "data", size_total);
  gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "size_entry")),
		      (gchar *) size_total.c_str ());
}

//***********************************

void
on_auto_detect_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *log_window = create_log_window ();
  string scsi_info;
  gtk_widget_show (log_window);
  master_data.scanBus (scsi_info);
  gtk_text_insert (GTK_TEXT (get_widget (log_window, "log_text")), NULL,
		   NULL, NULL, scsi_info.c_str (), -1);
}

//***********************************

void
burn_conf_show ()
{
  burn_conf = create_burn_confirm ();
  gtk_widget_show (burn_conf);
}

//***********************************

void
on_burn_yes_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (burn_conf);
  mode_selection();
}

//***********************************

void
on_hell_no_burn_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (burn_conf);
}

//***********************************

void
on_stdout_stop_clicked (GtkButton * button, gpointer user_data)
{
  //kills off the external process
  kill_process (9);
}

//***********************************

void
on_iso_image_burn_clicked (GtkButton * button, gpointer user_data)
{
  char filen[300];
  string filename_;

  strcpy (filen,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "iso_entry"))));
  filename_ = filen;

  if (filename_ == "")
    {
      bad_data_show ();
      return;
    }
  copy_options_show ();
}

//***********************************

void
on_iso_filesel_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_ISO;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//***********************************

void
on_copy_multi_ok_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_AUDIOCOPYSAMEDEV;
  burn_conf_show ();
  gtk_widget_destroy (multicopy);
}

//***********************************

void
on_copy_multi_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (multicopy);
  string command =
    "rm " + setupData1.tempdiraudio + "/track*.cdda.wav; rm " +
    setupData1.tempdiraudio + "/audio*.wav";
  system (command.c_str ());
}

//***********************************

void
on_on_the_fly_button_toggled (GtkToggleButton * togglebutton,
			      gpointer user_data)
{
  gboolean otf;
  otf = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (togglebutton));

  if (otf == TRUE)
    onthefly = true;
  else
    onthefly = false;
}

//***********************************

void
copy_options_show ()
{
  copy_options = create_copy_cd_window ();
  gtk_widget_show (copy_options);
}

//***********************************   

void
on_copy_burn_button_clicked (GtkButton * button, gpointer user_data)
{
  burn_conf_show ();
}

//***********************************

void
on_copy_abort_button_clicked (GtkButton * button, gpointer user_data)
{
  if (mode == EBURN_CDRDAOCOPY)
    gtk_widget_destroy (copy_cdrdao);
  else
    gtk_widget_destroy (copy_options);
}

//***********************************

void
on_dao_button_toggled (GtkToggleButton * togglebutton, gpointer user_data)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (togglebutton)) == TRUE)
    dao = true;
  else
    dao = false;
}

//***********************************

void
copy_cdrdao_show ()
{
  copy_cdrdao = create_copy_cd_cdrdao ();
  gtk_widget_show (copy_cdrdao);
}


void
on_create_bin_image_clicked (GtkButton * button, gpointer user_data)
{
  char filen[300];
  string filename_;

  strcpy (filen,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "bin_filename_entry"))));
  filename_ = filen;

  if (filename_ == "")
    {
      bad_data_show ();
      return;
    }
  copycd.createBIN (filename_, setupData1);
}


void
on_burn_bin_image_clicked (GtkButton * button, gpointer user_data)
{
  char filen[300];
  string filename_;

  strcpy (filen,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "bin_entry"))));
  filename_ = filen;

  if (filename_ == "")
    {
      bad_data_show ();
      return;
    }
  burn_bin_win = create_bin_burn_opts ();
  gtk_widget_show (burn_bin_win);
}


void
on_create_iso_image_clicked (GtkButton * button, gpointer user_data)
{
  char filen[300];
  string filename_;

  strcpy (filen,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "iso_filename_entry"))));
  filename_ = filen;

  if (filename_ == "")
    {
      bad_data_show ();
      return;
    }
  copycd.createISO (filename_, setupData1);
}


void
on_select_bin_filename_clicked (GtkButton * button, gpointer user_data)
{
  mode = ECREATE_BIN;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//*************************************

void
on_select_iso_filename_clicked (GtkButton * button, gpointer user_data)
{
  mode = ECREATE_ISO;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}


void
on_select_bin_burn_image_clicked (GtkButton * button, gpointer user_data)
{
  mode = EBURN_BIN;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}


void
on_button78_clicked (GtkButton * button, gpointer user_data)
{
  char file[300];
  mp3info mp3_;
  memset (&mp3_, 0, sizeof (mp3info));
  strcpy (file,
	  gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "mp3_id3_entry"))));
  if (!(mp3_.file = fopen (file, "rb+")))
    {
      cout << "Bad Filename " << file << endl;
      return;
    }

  mp3_.filename = file;
  get_mp3_info (&mp3_, SCAN_QUICK, 0);
  //cout << mp3_.id3.title << endl << mp3_.id3.artist << endl << mp3_.id3.album << endl << mp3_.id3.year << endl << mp3_.id3.comment << endl << mp3_.id3.track << endl << mp3_.id3.genre << endl;
}


void
on_sel_dir_button_clicked (GtkButton * button, gpointer user_data)
{
  mode = EID3_TAG;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}


void
on_refresh_mp3list_button_clicked (GtkButton * button, gpointer user_data)
{
  GtkCList *mp3_listing;
  ifstream inFile;
  string filename_, command, dirtempname = "/tmp/" + convert.randName ();

  char *tmp =
    gtk_entry_get_text (GTK_ENTRY (get_widget (main_win, "mp3list_entry")));
  mp3_listing = GTK_CLIST (get_widget (main_win, "mp3_clist"));
  gtk_clist_clear (mp3_listing);
  string temp = tmp;
  command = "ls -1 \"" + temp + "\" > " + dirtempname;
  system (command.c_str ());
  inFile.open (dirtempname.c_str ());
  if (!inFile)
    {
      cout << "Unable to open file, try again" << dirtempname << endl;
      return;
    }
  getline (inFile, filename_);
  while (inFile)
    {
      if (int (filename_.find (".mp3")) != -1
	  || int (filename_.find (".Mp3")) != -1
	  || int (filename_.find (".mP3")) != -1
	  || int (filename_.find (".MP3")) != -1 
          || int (filename_.find(".ogg")) != -1 
          || int (filename_.find(".OGG")) != -1
          || int (filename_.find(".Ogg"))!= -1 )
	{
	  filename_ = temp + filename_;
	  gchar *Track[2] = { (gchar *) filename_.c_str (), "" };
	  gtk_clist_append (GTK_CLIST (mp3_listing), Track);
	}
      getline (inFile, filename_);
    }
  inFile.close ();
  unlink (dirtempname.c_str ());
}


void
on_genre_list_button_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *genrewin = create_id3_genre_window ();
  gtk_widget_show (genrewin);
}


gboolean
on_mp3_clist_button_press_event (GtkWidget * widget,
				 GdkEventButton * event, gpointer user_data)
{
  if (event->type == GDK_2BUTTON_PRESS)
    {
      r = rowtemp;
      col = 1;
      // refresh the file listing
      gchar *temp[2];
      gtk_clist_get_text (GTK_CLIST (get_widget (main_win, "mp3_clist")), r,
			  0, &temp[0]);

      gchar *temp_ = temp[0];
      string fname = temp_;
      if (fname.find(".ogg") != -1 || fname.find(".OGG")  != -1 || fname.find(".Ogg")  != -1)
      {
         id3.readOggTag(main_win, fname);
      }
      else
         id3.readTag(main_win, temp_);
    }
  return TRUE;
}

void
on_mp3_clist_select_row (GtkCList * clist,
			 gint row,
			 gint column, GdkEvent * event, gpointer user_data)
{
  rowtemp = row;
}


void
on_save_tag_button_clicked (GtkButton * button, gpointer user_data)
{
   char* field = gtk_entry_get_text (GTK_ENTRY(get_widget(main_win, "mp3_filename_entry")));  
   string file_name = field;
   if (file_name.find(".ogg") || file_name.find(".OGG") || file_name.find(".Ogg"))
      id3.writeOggTag(main_win, file_name);
   else
      id3.writeTag (main_win,(char *)gtk_entry_get_text (GTK_ENTRY(get_widget(main_win, "mp3_filename_entry"))));
}

void
on_viewlog_clicked (GtkButton * button, gpointer user_data)
{
  /*struct stat filesize;
     stat("/tmp/simplecdrx_output", &filesize);
     const int max=int(filesize.st_size);
     char file[max];
     memset(file, 0 , max); */

  string file, log;
  ifstream logFile;
  logFile.open (setupData1.logfilename.c_str ());
  //logFile.read(file, max);

  while (getline (logFile, file))
    log += file + "\n";
  logFile.close ();
  GtkWidget *log_window = create_log_window ();
  gtk_widget_show (log_window);
  gtk_text_insert (GTK_TEXT (get_widget (log_window, "log_text")), NULL, NULL,
		   NULL, log.c_str (), -1);
}


void
on_burn_bin_clicked (GtkButton * button, gpointer user_data)
{
  mode=EBURN_BIN;
	burn_conf_show ();
}

void
on_progress_detail_clicked (GtkButton * button, gpointer user_data)
{
  assert (stdout_window != NULL);
  GtkWidget *text = get_widget (stdout_window, "scrolledwindow18");
  GtkWidget *text1 = get_widget (stdout_window, "stdout_text");
  if (detailVisible == true)
    {
      gtk_widget_hide (text);
      gtk_widget_hide (text1);
      detailVisible = false;
    }
  else
    {
      gtk_widget_show (text);
      gtk_widget_show (text1);
      detailVisible = true;
    }
}

//***********************************

//Exit function
gboolean
on_SimpleCDR_X_destroy_event (GtkWidget * widget,
			      GdkEvent * event, gpointer user_data)
{
  gtk_main_quit ();
  unlink (setupData1.logfilename.c_str ());
  return TRUE;
}



void
on_data_master_list_drag_data_received (GtkWidget * widget,
					GdkDragContext * drag_context,
					gint x,
					gint y,
					GtkSelectionData * data,
					guint info,
					guint time, gpointer user_data)
{
//excerpted from gcombust 0.1.45
  if (0 == info)
    {
      /* Gnome (gmc) doesn't implement xdnd correctly, it doesn't utf-8
       * encode the uris. KDE (konqueror) is a little less buggy, so it
       * UTF8 encodes the strings. None of the implementations care to
       * set the non-optional hostname.
       *
       * Here we try to guess the source based on the GdkDragAction type
       * (fortunately, for some unlogical reason they are different for
       * gmc/konqueror), so that the uri strings can be decoded
       * correctly.
       *
       * FIXME: The hostname isn't removed as it should be. It doesn't
       * seem to be wildy implemented (rox-filer implements it). If
       * you're reading this, feel free to fix it. I've spent enough time
       * fixing DnD, and I don't even use it.
       *
       * Oh, xdnd is well specsed at
       * http://www.newplanetsoftware.com/xdnd/, but what would life be
       * if all programmers chose to follow specs (or, indeed, chose to
       * break the specs in the same friggin way?)?
       */

      GList *list, *names;

      switch (drag_context->action)
	{
	case GDK_ACTION_COPY:
	  list = names =
	    gnome_uri_list_extract_filenames ((gchar *) data->data, 0);
	  break;
	case GDK_ACTION_MOVE:
	  list = names =
	    gnome_uri_list_extract_filenames ((gchar *) data->data, 1);
	  break;
	default:
	  /* Does GdkDragContext really need this many slightly different and completely
	   * undocumented GdkDragActions?!? */
	  g_warning
	    ("%s %i: Unrecognized GdkDragAction (please report to author): %i %i %i",
	     __FILE__, __LINE__, drag_context->actions,
	     drag_context->suggested_action, drag_context->action);
	  return;
	}

      //cursor_wait(NULL);
      //mainwindow_disable_tabs();
      while (names)
	{
	  //selected_file(0, (gchar *)names->data);
	  //cout << (gchar *) names->data << endl;
	  add_file (string ((gchar *) names->data));
	  names = names->next;
	  while (gtk_events_pending ())
	    gtk_main_iteration_do (0);
	}
      //mainwindow_enable_tabs();
      gnome_uri_list_free_strings (list);
      //cursor_reset(NULL);
    }
  else
    {
      g_message ("%s %i: unknown type dropped, should not happen!",
		 __FILE__, __LINE__);
    }
}


void
on_data_master_list_drag_drop (GtkWidget * widget,
			       GdkDragContext * drag_context,
			       GtkSelectionData * data,
			       guint info, guint time, gpointer user_data)
{

}

void
on_audio_list_drag_data_received (GtkWidget * widget,
				  GdkDragContext * drag_context,
				  gint x,
				  gint y,
				  GtkSelectionData * data,
				  guint info, guint time, gpointer user_data)
{
 
  /*if (0 == info)
    {
      /* see ranting comment in filepicker.c:dropped_data *
      GList *list, *names;

      switch (drag_context->action)
	{
	case GDK_ACTION_COPY:
	  list = names =
	    gnome_uri_list_extract_filenames ((gchar *) data->data, 0);
	  break;
	case GDK_ACTION_MOVE:
	  list = names =
	    gnome_uri_list_extract_filenames ((gchar *) data->data, 1);
	  break;
	default:
	  g_warning
	    ("%s %i: Unrecognized GdkDragAction (please report to author): %i %i %i",
	     __FILE__, __LINE__, drag_context->actions,
	     drag_context->suggested_action, drag_context->action);
	  return;
	}

      //cursor_wait(NULL);
      //mainwindow_disable_tabs();
      while (names)
	{
	  cd_track_add (string ((gchar *) names->data));
	  names = names->next;
	  while (gtk_events_pending ())
	    gtk_main_iteration_do (0);
	}
      //mainwindow_enable_tabs();
      gnome_uri_list_free_strings (list);
      //cursor_reset(NULL);
    }
  else
    {
      g_message ("%s %i: unknown type dropped, should not happen!",
		 __FILE__, __LINE__);
    }*/
}


void
on_simplecdrtabs_switch_page (GtkNotebook * notebook,
			      GtkNotebookPage * page,
			      gint page_num, gpointer user_data)
{
  static int prev_num;
  if (page_num == 1)
    {
      gtk_drag_dest_set (get_widget (main_win, "audio_list"),
			 GTK_DEST_DEFAULT_ALL, drop_types, int (n_drop_types),
			 GDK_ACTION_COPY);
//      gtk_clist_set_reorderable (GTK_CLIST(get_widget(main_win,"audio_list")), TRUE);
    }
  if (prev_num == 1)
    {
      gtk_drag_dest_unset (get_widget (main_win, "audio_list"));
    }


  if (prev_num == 2)
    {
      gtk_drag_dest_unset (get_widget (main_win, "data_master_list"));
      gtk_drag_dest_unset (get_widget (main_win, "dir_master_list"));
    }

  if (page_num == 2)
    {
      gtk_drag_dest_set (get_widget (main_win, "data_master_list"),
			 GTK_DEST_DEFAULT_ALL, drop_types, int (n_drop_types),
			 GDK_ACTION_COPY);
      gtk_drag_dest_set (get_widget (main_win, "dir_master_list"),
			 GTK_DEST_DEFAULT_ALL, drop_types, int (n_drop_types),
			 GDK_ACTION_COPY);
    }
  prev_num = page_num;
}


void
on_dir_master_list_drag_data_received (GtkWidget * widget,
				       GdkDragContext * drag_context,
				       gint x,
				       gint y,
				       GtkSelectionData * data,
				       guint info,
				       guint time, gpointer user_data)
{
//excerpted from gcombust 0.1.45
  if (0 == info)
    {
      GList *list, *names;

      switch (drag_context->action)
	{
	case GDK_ACTION_COPY:
	  list = names =
	    gnome_uri_list_extract_filenames ((gchar *) data->data, 0);
	  break;
	case GDK_ACTION_MOVE:
	  list = names =
	    gnome_uri_list_extract_filenames ((gchar *) data->data, 1);
	  break;
	default:
	  /* Does GdkDragContext really need this many slightly different and completely
	   * undocumented GdkDragActions?!? */
	  g_warning
	    ("%s %i: Unrecognized GdkDragAction (please report to author): %i %i %i",
	     __FILE__, __LINE__, drag_context->actions,
	     drag_context->suggested_action, drag_context->action);
	  return;
	}

      //cursor_wait(NULL);
      //mainwindow_disable_tabs();
      while (names)
	{
	  //selected_file(0, (gchar *)names->data);

	  string fname = (gchar *) names->data;
	  mode = EDIRECTORY;
	  //adding directories from DnD causes crashes for some reason
	  //add_directory(fname);
	  names = names->next;
	  while (gtk_events_pending ())
	    gtk_main_iteration_do (0);
	}
      //mainwindow_enable_tabs();
      gnome_uri_list_free_strings (list);
      //cursor_reset(NULL);
    }
  else
    {
      g_message ("%s %i: unknown type dropped, should not happen!",
		 __FILE__, __LINE__);
    }
}

//===============================
//the log viewer is now available 
//via the menu 
//==============================

void
on_view_log1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  string file, log;
  ifstream logFile;

  logFile.open (setupData1.logfilename.c_str ());

  while (getline (logFile, file))
    log += file + "\n";

  logFile.close ();
  GtkWidget *log_window = create_log_window ();
  gtk_widget_show (log_window);
  gtk_text_insert (GTK_TEXT (get_widget (log_window, "log_text")), NULL, NULL,
		   NULL, log.c_str (), -1);
}


//============================
//quit : so long and thanks for the fish
//============================

void
on_quit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_main_quit ();
  unlink (setupData1.logfilename.c_str ());
}

//============================
//menu: burn->Audio cd
//============================

void
on_audio1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  mode = EBURN_AUDIOCOPY;
  copy_options_show ();
}

//============================
//menu: burn->data->cdrecord
//============================

void
on_cdrecord1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  printf("[DEBUG] on_cdrecord1_activate\n");
  mode = EBURN_MKISOFSCOPY;
  copy_options_show ();
}

//=============================
//menu: burn->data->cdrdao
//=============================

void
on_cdrdao1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  printf("[DEBUG] on_cdrdao1_activate\n");
  mode = EBURN_CDRDAOCOPY;
  copy_cdrdao_show ();
}

//==============================
//menu: Burn->BinImage->Create
//==============================

void
on_create1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  printf("[DEBUG] on_create1_activate\n");
  mode = ECREATE_BIN;
  imagewin = create_create_image_window ();
  gtk_widget_show (imagewin);
}


void
on_burn4_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  printf("[DEBUG] on_burn4_activate\n");
  mode = EBURN_BIN;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}


void
on_create2_activate (GtkMenuItem * menuitem, gpointer user_data)
{  
  printf("[DEBUG] on_create2_activate\n");
  mode = ECREATE_ISO;
  imagewin = create_create_image_window ();
  gtk_widget_show (imagewin);
}


void
on_burn3_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  printf("[DEBUG] on_burn3_activate\n");
  mode = EBURN_ISO;
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}

//================================
//click on website button on about
//dialog
//===============================

/*void
on_About_website_clicked (GtkButton * button, gpointer user_data)
{
  if (!fork())
  {
     printf("[DEBUG] exec moz return %d \n", execl(MOZILLA , "mozilla", "http://ogre.rocky-road.net/cdr.shtml", NULL));
  }
  else
	  wait(NULL);
}
*/

//================================
//menu: help->about
//================================

void
on_about1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget* about = create_Aboutdlg();
  gtk_window_set_modal (GTK_WINDOW(about), TRUE);
  gtk_widget_show (about);
}

gboolean
on_SimpleCDR_X_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_main_quit ();
  unlink (setupData1.logfilename.c_str ());
  return FALSE;
}


void
on_cancel_image_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_widget_destroy(imagewin);
}


void
on_image_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  string filename = gtk_entry_get_text(GTK_ENTRY (get_widget (imagewin, "create_image_entry")));
  gtk_widget_destroy(imagewin);
stdout_window = create_stdout_window();
 gtk_widget_show(stdout_window);
	switch(mode)
  {
	case ECREATE_ISO:
	printf("[DEBUG] ECREATE_ISO\n");
	gtk_object_destroy (GTK_OBJECT (filesel));
	if (filename == "")
	{
	  bad_data_show ();
	  break;
	}
	copycd.createISO(filename, setupData1);
	progress_show ();
	break;
  case ECREATE_BIN:
	printf("[DEBUG] ECREATE_BIN\n");
	gtk_object_destroy(GTK_OBJECT (filesel));
	if (filename == "")
    	{
	  bad_data_show ();
	  break;
    	}
	copycd.createBIN (filename, setupData1);
	progress_show ();
	break;
  default:
		
	break;
	}
gtk_widget_destroy (stdout_window);
}


void
on_browse_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  filesel = create_filesel ();
  gtk_widget_show (filesel);
}


void
on_button108_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   mode = ETOC_SEL;
	filesel = create_filesel ();
   gtk_widget_show (filesel);
}


void
on_blank_fast_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	blank = FAST;
	blankwin = create_blank_window();
	gtk_widget_show(blankwin);
}


void
on_blank_slow_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	blank = ALL;
	blankwin = create_blank_window();
	gtk_widget_show(blankwin);
}


void
on_blank_yes_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(blankwin);
	stdout_window = create_stdout_window();
 gtk_widget_show(stdout_window);
	master_data.blankCDRW (blank, setupData1);
	gtk_widget_destroy(stdout_window);
   progress_show ();
}


void
on_blank_no_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(blankwin);
}


void
on_create_image_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  mode = ECREATE_IMG;
  filesel = create_filesel ();
  gtk_widget_show (filesel);

}


void
on_mkiso_close_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_widget_destroy(mkisoimagewin);
}

void
on_mkiso_ok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
mode_selection();
}

void
on_rip_info_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	static GtkWidget *track_table, *play_button, *play_pixmap, *track_label, *scr_window, *stopButton;
	num_tracks = play.totalTracks(setupData1);
	char buf[5];
	track_table= gtk_table_new (num_tracks, 7, FALSE);
	if(scr_window != NULL)
	{
	    gtk_widget_destroy(scr_window);
		scr_window = NULL;
	}
	for(i=0; i < num_tracks; i++)
	{
		/* CD play button */
				play_button = gtk_button_new_with_label("Play");
//				play_pixmap = gtk_pixmap_new( play_button_enabled_pixmap,
//				                         play_button_enabled_mask );
				//gtk_widget_set_usize( play_button, 18, 18 );
//				gtk_container_add( GTK_CONTAINER( play_button ), pixmap );

				gtk_signal_connect( GTK_OBJECT( play_button ), "clicked",
				                    GTK_SIGNAL_FUNC( sf_cd_play_button_clicked ),
				                    ( gpointer ) i );
				gtk_table_attach( GTK_TABLE( track_table ), play_button, 0, 1, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
				stopButton = gtk_button_new_with_label("Stop");
//				play_pixmap = gtk_pixmap_new( play_button_enabled_pixmap,
//				                         play_button_enabled_mask );
				//gtk_widget_set_usize( play_button, 18, 18 );
//				gtk_container_add( GTK_CONTAINER( play_button ), pixmap );

				gtk_signal_connect( GTK_OBJECT( stopButton ), "clicked",
				                    GTK_SIGNAL_FUNC( on_stop_button_clicked ),
				                    ( gpointer ) i );
				gtk_table_attach( GTK_TABLE( track_table ), stopButton, 1, 2, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
				/* Track number */
				sprintf( buf, "%d", i + 1 );
				track_label = gtk_label_new( buf );
				gtk_widget_set_usize( track_label, 20, 0 );
				gtk_table_attach( GTK_TABLE( track_table ), track_label, 2, 3, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
				/* Length */
				//readable_length = length_to_readable( main_data->track[ i ].length );
				//track_label = gtk_label_new( readable_length );
				gtk_table_attach( GTK_TABLE( track_table ), track_label, 3, 4, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );

				/* MP3 check buttons */
				track_selected_button[ i ] = gtk_toggle_button_new();
				gtk_widget_set_usize( track_selected_button[ i ], 18, 18 );
/*				track_selected_button_pixmap[ i ] = gtk_pixmap_new( button_unchecked_pixmap,
                                   button_unchecked_mask );
*///				gtk_container_add( GTK_CONTAINER( track_selected_button[ i ] ), track_selected_button_pixmap[ i ] );
				gtk_table_attach( GTK_TABLE( track_table ), track_selected_button[ i ], 4, 5, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
										
            /* artist entry */
				artist_entry[ i ] = gtk_entry_new_with_max_length( 50 );
				gtk_widget_set_usize( filename_entry[ i ], 325, 0 );
				string temp_aname="Custom Artist";	
				gtk_entry_set_text( GTK_ENTRY( artist_entry[ i ] ), temp_aname.c_str() );
				gtk_table_attach( GTK_TABLE( track_table ),artist_entry[ i ], 5, 6, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
/*
				/* file name entry */
				filename_entry[ i ] = gtk_entry_new_with_max_length( MAX_FILE_NAME_LENGTH );
				gtk_widget_set_usize( filename_entry[ i ], 325, 0 );
				string temp_fname="Track"+convert.trackNum(i+1);
				gtk_entry_set_text( GTK_ENTRY( filename_entry[ i ] ), temp_fname.c_str() );
				//gtk_entry_set_text( GTK_ENTRY( filename_entry[ i ] ), saved_filename_entry[ i ] );
				gtk_table_attach( GTK_TABLE( track_table ), filename_entry[ i ], 6, 7, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
/*
				gtk_signal_connect( GTK_OBJECT( track_selected_button[ i ] ), "clicked",
				                    GTK_SIGNAL_FUNC( sf_track_selected_button_toggled ),
				                    ( gpointer ) i );
				gtk_signal_connect( GTK_OBJECT( filename_entry[ i ] ), "changed",
				                    GTK_SIGNAL_FUNC( sf_filename_entry_changed ),
				                    ( gpointer ) i );
	*/
    }
	//gtk_widget_show_all(track_table);
	scr_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_container_border_width( GTK_CONTAINER( scr_window ), 5 );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scr_window ),
	                        GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	gtk_box_pack_end (GTK_BOX (get_widget (main_win, "vbox12")), scr_window, TRUE, TRUE, 0);
	
	gtk_container_border_width( GTK_CONTAINER( GTK_BOX (get_widget (main_win, "vbox12")) ), 0 );
	gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scr_window ), track_table );
    gtk_widget_show_all (scr_window);
}

	void sf_cd_play_button_clicked( GtkWidget *widget, gpointer callback_data )
	{
		play.cdplay((int) callback_data + 1, setupData1);
	}

void
on_rip_cddb_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_stop_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	play.cdstop(setupData1);
}


void
on_rip_tracks_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	string bitrate;
	char *bitrate_;
	stdout_window = create_stdout_window();
	gtk_widget_show(stdout_window);

	bitrate_= gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_bitrate_entry")));
    bitrate = bitrate_;
	for(i=0; i < num_tracks; i++)
	{
		gboolean toggle;
		toggle=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(track_selected_button[i]));
		if(toggle == TRUE)
		{
			char *dir = gtk_entry_get_text(GTK_ENTRY(get_widget(main_win, "rip_default_directory"))); 
			char *fname = gtk_entry_get_text(GTK_ENTRY(filename_entry[i]));
			char *artist = gtk_entry_get_text(GTK_ENTRY(artist_entry[i]));
			string file_name = dir;			
			string ftemp = fname;
			string atemp = artist;
			file_name += "/";
			string oggname=file_name + "oggtemp";
			gboolean insertTrackNum = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget(main_win, "insertTrackNums")));
                        if (insertTrackNum == TRUE)
                           file_name += convert.trackNum(i+1) + " - ";
                        file_name += artist;
			file_name +=" - ";
			while(ftemp.find("/") != -1)
			{
				ftemp = ftemp.substr(0, ftemp.find("/"))  + "-" +  ftemp.substr(ftemp.find("/")+1, ftemp.length() - ftemp.find("/") );
			}
			file_name += ftemp;
			ripenc.track(i+1, file_name, bitrate, setupData1);
			string id3Tagname = artist;
			id3Tagname += " - ";
			id3Tagname += fname;
			const char *fname2=id3Tagname.c_str();
			if(setupData1.encoder != "oggenc")
			{
			   id3.writeRippedTag(main_win, fname2, fname);
			}
			else
			{
			   char *album=gtk_entry_get_text(GTK_ENTRY(get_widget(main_win, "rip_album" )));
			   string albtemp = album;
				
			   string command="vorbiscomment -a \""+file_name+".ogg\" -t \"TITLE="+ftemp+"\" -t \"ARTIST="+atemp+"\" -t \"ALBUM="+albtemp+"\"";
			   system(command.c_str());
				//unlink(oggname.c_str());
				//Tag *tag;
				//tag->title=gtk_entry_get_text(GTK_ENTRY( filename_entry[ i ] ));
				//tag->artist=gtk_entry_get_text(GTK_ENTRY(artist_entry[ i ]));
				
				//set_vorbis_tag(tag, fname2);
			}
		}
	}
	gtk_widget_destroy (stdout_window);
}


gboolean
on_audio_list_event                    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_clist_set_reorderable (GTK_CLIST(get_widget(main_win,"audio_list")), TRUE);
  return FALSE;
}


void
on_cddb_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	_main_data main_data;
	int i, ok;
		
//	if (num_tracks == -1)
	//	return;

	ok = cddb_main(setupData1, &main_data);
	if (ok == 0)
	{
		gtk_entry_set_text(GTK_ENTRY(get_widget(main_win, "rip_artist" )), main_data.disc_artist);
		gtk_entry_set_text(GTK_ENTRY(get_widget(main_win, "rip_album" )), main_data.disc_title);
		for(i=0; i < num_tracks; i++)
		{
			gtk_entry_set_text(GTK_ENTRY( filename_entry[ i ] ), main_data.track[ i ].title);
			gtk_entry_set_text(GTK_ENTRY(artist_entry[i]), main_data.disc_artist);

		}
	}
}

void
on_selall_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	for(i = 0; i < num_tracks; i++)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(track_selected_button[i]), TRUE);
	}
}



void
on_rip_scan_cd_clicked (GtkButton * button, gpointer user_data)
{
	int i;
	static GtkWidget *track_table, *play_button, *play_pixmap, *track_label, *rip_window, *stopButton;
	num_tracks = play.totalTracks(setupData1);
	char buf[5];
	track_table= gtk_table_new (num_tracks, 6, FALSE);
	if(rip_window != NULL)
	{
	    gtk_widget_destroy(rip_window);
		rip_window = NULL;
	}
	for(i=0; i < num_tracks; i++)
	{
		/* CD play button */
				play_button = gtk_button_new_with_label("Play");
//				play_pixmap = gtk_pixmap_new( play_button_enabled_pixmap,
//				                         play_button_enabled_mask );
				//gtk_widget_set_usize( play_button, 18, 18 );
//				gtk_container_add( GTK_CONTAINER( play_button ), pixmap );

				gtk_signal_connect( GTK_OBJECT( play_button ), "clicked",
				                    GTK_SIGNAL_FUNC( sf_cd_play_button_clicked ),
				                    ( gpointer ) i );
				gtk_table_attach( GTK_TABLE( track_table ), play_button, 0, 1, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
				stopButton = gtk_button_new_with_label("Stop");
//				play_pixmap = gtk_pixmap_new( play_button_enabled_pixmap,
//				                         play_button_enabled_mask );
				//gtk_widget_set_usize( play_button, 18, 18 );
//				gtk_container_add( GTK_CONTAINER( play_button ), pixmap );

				gtk_signal_connect( GTK_OBJECT( stopButton ), "clicked",
				                    GTK_SIGNAL_FUNC( on_stop_button_clicked ),
				                    ( gpointer ) i );
				gtk_table_attach( GTK_TABLE( track_table ), stopButton, 1, 2, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
				/* Track number */
				sprintf( buf, "%d", i + 1 );
				track_label = gtk_label_new( buf );
				gtk_widget_set_usize( track_label, 20, 0 );
				gtk_table_attach( GTK_TABLE( track_table ), track_label, 2, 3, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
				/* Length */
				//readable_length = length_to_readable( main_data->track[ i ].length );
				//track_label = gtk_label_new( readable_length );
				gtk_table_attach( GTK_TABLE( track_table ), track_label, 3, 4, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );

				/* MP3 check buttons */
				track_selected_button[ i ] = gtk_toggle_button_new();
				gtk_widget_set_usize( track_selected_button[ i ], 18, 18 );
/*				track_selected_button_pixmap[ i ] = gtk_pixmap_new( button_unchecked_pixmap,
                                   button_unchecked_mask );
*///				gtk_container_add( GTK_CONTAINER( track_selected_button[ i ] ), track_selected_button_pixmap[ i ] );
				gtk_table_attach( GTK_TABLE( track_table ), track_selected_button[ i ], 4, 5, i, i + 1,
				                  GTK_EXPAND, GTK_EXPAND, 0, 0 );
    }
	//gtk_widget_show_all(track_table);
	rip_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_container_border_width( GTK_CONTAINER( rip_window ), 5 );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( rip_window ),
	                        GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	gtk_box_pack_end (GTK_BOX (get_widget (main_win, "vbox13")), rip_window, TRUE, TRUE, 0);
	
	gtk_container_border_width( GTK_CONTAINER( GTK_BOX (get_widget (main_win, "vbox13")) ), 0 );
	gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( rip_window ), track_table );
    gtk_widget_show_all (rip_window);
}


void
on_rip_and_add_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	string bitrate;
	char *bitrate_;
	stdout_window = create_stdout_window();
	gtk_widget_show(stdout_window);

	bitrate_= gtk_entry_get_text (GTK_ENTRY
			      (get_widget (main_win, "rip_bitrate_entry")));
    bitrate = bitrate_;
	for(i=0; i < num_tracks; i++)
	{
		gboolean toggle;
		toggle=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(track_selected_button[i]));
		if(toggle == TRUE)
		{
	
  static int rip_add = 1;
  string time_total, time_ind;
  string list, suffix, track, filename;

      convert.trackSuf (rip_add, suffix);
      filename = convert.randName ();
      filename = setupData1.tempdiraudio + "/" + filename + "_" + suffix + ".wav";
	  convert.trackSuf(i+1, track);
      int cont = master_aud.ripNAdd (filename, suffix, track, setupData1);
      if (cont == 1)
	break;

      gchar *Track[2] = { (gchar *) filename.c_str (), "" };

      song = WAV;
      master_aud.time_est (filename, time_ind, time_total, song, total_time_);
      Track[1] = (gchar *) time_ind.c_str ();


      gtk_label_set_text (GTK_LABEL (get_widget (main_win, "total_time")),
			  (gchar *) time_total.c_str ());
      gtk_clist_append (GTK_CLIST (get_widget (main_win, "audio_list")),
			Track);

      rip_add++;
      tracks++;
		}
	}
	gtk_widget_destroy (stdout_window);
}
