/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */

#include "copycd.h"

using namespace std;

int Copy::copyAudioCD(bool simulate, Setup setupData1, string dirname)
{
   string command, sim="";
   if(simulate==true)
      sim="-dummy";
   if(setupData1.ripper=="cdparanoia")
      command="cd "+dirname+"; cdparanoia -v -d "+setupData1.readerdev+" -B -- ";
   if(setupData1.ripper=="cdda2wav")
      command="cd "+dirname+"; cdda2wav -B -H -D "+setupData1.reader;
  
//if function is cancelled, cdrecord will not be called
   if(exec_cmd(command, setupData1)==1)
      return 0;
   if(setupData1.reader==setupData1.recorder)
   {
      return 1;
   }
   if(setupData1.ripper=="cdparanoia")
   {
	   command="cd "+dirname+"; rm track00*.wav; cdrecord "+setupData1.custom_cdrecord+" "+sim+" -v fs="+setupData1.fifo+"k speed="+setupData1.speed+" dev="+setupData1.recorder+" "+setupData1.custom_cdrecord+" -audio track*.wav";
	   exec_cmd(command, setupData1);
	   command="rm "+dirname+"/track*.cdda.wav";
	}
	if(setupData1.ripper=="cdda2wav")
	{
	   command="cd "+dirname+"; rm audio_00*.wav; cdrecord "+setupData1.custom_cdrecord+" "+sim+" -v fs="+setupData1.fifo+"k speed="+setupData1.speed+" dev="+setupData1.recorder+" "+setupData1.custom_cdrecord+" -audio audio*.wav";
       exec_cmd(command, setupData1);
	   command="rm "+dirname+"/audio*.wav";
	}
    exec_cmd(command, setupData1);
	return 0;
}

//*********************************************

void Copy::copyAudioCDsameDev(bool simulate, Setup setupData1, string dirname)
{
   string command, sim="";
   if(simulate==true)
      sim="-dummy";
   if(setupData1.ripper=="cdparanoia")
      command="cd "+dirname+"; rm track00*.wav; cdrecord "+setupData1.custom_cdrecord+" "+sim+" -v fs="+setupData1.fifo+"k speed="+setupData1.speed+" dev="+setupData1.recorder+" "+setupData1.custom_cdrecord+" -audio track*.wav";
   if(setupData1.ripper=="cdda2wav")
      command="cd "+dirname+"; rm audio_00*.wav; cdrecord "+setupData1.custom_cdrecord+" "+sim+" -v fs="+setupData1.fifo+"k speed="+setupData1.speed+" dev="+setupData1.recorder+" "+setupData1.custom_cdrecord+" -audio audio*.wav";
  
   cout<<"Burning CD..."<<endl;
   exec_cmd(command, setupData1);
   command="rm "+dirname+"/track*.cdda.wav; rm "+setupData1.tempdiraudio+"/audio*.wav";
   system(command.c_str());
}

//*****************

void Copy::copyDataCD1(bool simulate, bool onthefly, Setup setupData1)
{
   string command, sim="", onthefly_="";
   if(simulate==true)
      sim="--simulate";
   if(onthefly==true)
   {
		onthefly_="--on-the-fly";
		command="cd "+setupData1.tempdirdata+"; cdrdao copy --source-device "+setupData1.reader+" --device "+setupData1.recorder+" --speed "+setupData1.speed+" --source-driver "+setupData1.cdrdaoreader+" --driver "+setupData1.cdrdaoburner+" --buffers 64 "+sim+" "+onthefly_+"; rm *.bin";
		exec_cmd(command, setupData1);
	}
   else
	{	
		string dirname=setupData1.tempdirdata+"/"+convert.randName();
		mkdir(dirname.c_str(), 0755);
		command="cd "+dirname+"; cdrdao copy --source-device "+setupData1.reader+" --device "+setupData1.recorder+" --speed "+setupData1.speed+" --source-driver "+setupData1.cdrdaoreader+" --driver "+setupData1.cdrdaoburner+" --buffers 64 "+sim+" "+onthefly_+"; rm *.bin";
		exec_cmd(command, setupData1);
		rmdir(dirname.c_str());
	}
}
 
//*****************

int Copy::copyDataCD2(bool simulate, Setup setupData1)
{
   string command, filename, sim="";
   
	filename=convert.randName()+".iso";
	
	if(simulate==true)
      sim="-dummy";
   cout<<"Creating Image..."<<endl;
   //command="cd "+setupData1.tempdirdata+"; mkdir temp; mount "+setupData1.readerdev+" "+setupData1.tempdirdata+"/temp; mkisofs -allow-lowercase -allow-multidot -f -R -J -jcharset iso8859-1 -relaxed-filenames -o "+filename+".iso "+setupData1.tempdirdata+"/temp/; umount "+setupData1.readerdev+"; rm -r temp";
	command="cd "+setupData1.tempdirdata+"; cat "+setupData1.readerdev+" > "+filename;

//if function is cancelled, cdrecord will not be called
   if(exec_cmd(command, setupData1)==1)
   {   
		return 0;
	}
 /*if(setupData1.reader==setupData1.recorder)
  {
   cout<<"Insert a Blank CDR and press ENTER to continue"<<endl;
   getline(cin, buffer);
  }*/
   //cout<<"Burning CD..."<<endl;
   command="cd "+setupData1.tempdirdata+"; cdrecord "+setupData1.custom_cdrecord+" "+sim+" -v fs="+setupData1.fifo+"k speed="+setupData1.speed+" dev="+setupData1.recorder+" "+setupData1.custom_cdrecord+" -data "+filename+"; rm "+filename;
   exec_cmd(command, setupData1);
   //cout<<"Finished!"<<endl;
	return 0;
}

//*************************

void Copy::writeISO(bool simulate, string filename, Setup setupData1)
{
	string command, sim;
	
	if(simulate==true)
 	  sim="-dummy";
	
	command="cdrecord "+setupData1.custom_cdrecord+" "+sim+" -v dev="+setupData1.recorder+" fs="+setupData1.fifo+"k speed="+setupData1.speed+" "+setupData1.custom_cdrecord+" -data \""+filename+"\"";
	exec_cmd(command, setupData1);
}

void Copy::writeBIN(bool simulate, bool overburn, string filename, string img_type, string mode, string toc_file, Setup setupData1)
{
   string command, sim="", ob="", tocname="/tmp/"+convert.randName()+".toc";
   if (simulate==true)
      sim="--simulate";
   if (overburn==true)
      ob="--overburn";
	
   if (toc_file =="")
	{
		ofstream tocfile;
		tocfile.open(tocname.c_str());
      tocfile<<img_type<<"\n";
		tocfile<<"TRACK "<<mode<<"\n";
		tocfile<<"DATAFILE "<<"\""<<filename<<"\""<<"\n";
		tocfile.close();
		command="cdrdao write --device "+setupData1.recorder+" --speed "+setupData1.speed+" --driver "+setupData1.cdrdaoburner+" --buffers 64 "+sim+" "+ob+" "+tocname;
   }
	else
	{
		string dir = toc_file.substr(0, toc_file.find_last_of("/"));
		command = "cd \""+dir+"\"; cdrdao write --device "+setupData1.recorder+" --speed "+setupData1.speed+" --driver "+setupData1.cdrdaoburner+" --buffers 64 "+sim+" "+ob+" \""+toc_file+"\"";
	}
	exec_cmd(command, setupData1);
   unlink(tocname.c_str());
}

void Copy::createBIN(string filename, Setup setupData1)
{
   cout<<"Creating Image..."<<endl;
   string command="cdrdao read-cd --read-raw --device "+setupData1.reader+" --driver "+setupData1.cdrdaoreader+" --datafile "+filename+" "+filename+".toc";
   exec_cmd(command, setupData1);
}

void Copy::createISO(string filename, Setup setupData1)
{
   cout<<"Creating Image..."<<endl;
   string command="cat "+setupData1.readerdev+" > "+filename;
	//command="cd "+setupData1.tempdirdata+"; mkdir temp; mount "+setupData1.readerdev+" "+setupData1.tempdirdata+"/temp; mkisofs -allow-lowercase -allow-multidot -J -jcharset iso8859-1 -iso-level 3 -v -v -R -relaxed-filenames -o "+filename+" "+setupData1.tempdirdata+"/temp/; umount "+setupData1.readerdev+"; rm -r temp";
   cout<<command<<endl;
   exec_cmd(command, setupData1);
}
