/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */

/* Contains substantial amount of code from io.c and tools.c of XCDRoast by Thomas Niederreiter,
   www.xcdroast.org, a big thanks to Thomas for his assisstance */

#include "progress.h"
#include <sys/types.h>
#include <signal.h>
#include <assert.h>

gint read_done, read_output_ctrl, read_abort_mark;
int progress_callback, progress_callback3;
gint read_out_, read_err_;
static pid_t pid_command;
//static int gi_childpid=0;


gboolean
on_stdout_destroy (GtkWidget * widget,
                   GdkEvent * event, gpointer user_data) 
{
  int* bla = (int*) user_data;
  if (user_data != NULL) gtk_idle_remove( *bla);
  return TRUE;
}


//=====================================================
//callback function on_time 
//this function updates the status of the progress bar
//to make it look like knight-rider car : )
//=====================================================

gint
on_timer (void* data)
{
  int old1=0;
  assert(stdout_window != NULL);
  GtkProgress *progressbar1 = (GtkProgress*) get_widget (stdout_window, "progressmon");
  old1 = (int) gtk_progress_get_value( progressbar1); 
  gtk_progress_set_value( progressbar1, (float) ((old1 + 10 ) % 100));
  usleep(100);
  return TRUE;
}   

//======================================================
//exec command 
//you supply the command it execute it 
//======================================================

int
exec_cmd (string command, Setup setupData1)
{
  gint status;
  ofstream logFile;
  int htime = 0;
  
  //we create the stdout window and register 2 functions
  //1 for the idle event and 1 for the destroy 
  //event to unregister the 1st one else it core's

 // stdout_window = create_stdout_window ();
  /*bad line right below here!*/
	//htime = gtk_idle_add (on_timer, NULL);
  printf("[DEBUG] gtk_idle return tag %d\n", htime); 

	gtk_signal_connect (GTK_OBJECT (stdout_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_stdout_destroy),
                      &htime);

	//gtk_widget_show (stdout_window);

  printf("[DEBUG] exec_cmd #%s#\n", command.c_str());

  /* if another read running, ignore */
  if (read_done == 999)
    {
      return 1;
    }

  /* mark our read-process as running */
  read_done = 999;
  read_output_ctrl = 0;
  read_abort_mark = 0;

  /* start childs and get new fds */

  pid_command = full_dpl_pipe3 (&read_out_, &read_err_, command);

  /* set output to nonblocking - otherwise our callback would block */
  fcntl (read_out_, F_SETFL, O_NONBLOCK);
  fcntl (read_err_, F_SETFL, O_NONBLOCK);

  /* catch output of child */

  progress_callback = gdk_input_add (read_out_, GDK_INPUT_READ,
				     (GdkInputFunction) read_out, NULL);
  progress_callback3 = gdk_input_add (read_err_, GDK_INPUT_READ,
				      (GdkInputFunction) read_err, NULL);
  // if we get nothing out of the pipe 
  // we switch the progress bar in activity mode 

  GtkWidget *progressbar1 = get_widget (stdout_window, "progressmon");
  gtk_progress_set_activity_mode (GTK_PROGRESS (progressbar1), true);
  printf("[DEBUG] Progressbar %d has been switched to activity mode\n", progressbar1);
  /* now wait until track is read */

  while (read_done == 999)
    {
      wait_and_process_events ();
		on_timer(NULL);
    }
  //kills the external program if stop button is pressed on output window
  //doesn't work quite right yet, cpu utilization goes to 50%+
  if (read_done == 9)
    {
      cout<<"read done"<<endl;
		 gtk_input_remove (progress_callback);
      gtk_input_remove (progress_callback3);
      kill (pid_command, SIGINT);
      waitpid (pid_command, &status, WNOHANG);
    }
  close (read_out_);
  close (read_err_);

  gtk_text_insert (GTK_TEXT (get_widget (stdout_window, "stdout_text")), NULL,
		   NULL, NULL, "\n", 1);

  logFile.open (setupData1.logfilename.c_str (), std::ios::app);
  logFile <<
    gtk_editable_get_chars (GTK_EDITABLE
			    (get_widget (stdout_window, "stdout_text")), 0,
			    gtk_text_get_length (GTK_TEXT
						 (get_widget
						  (stdout_window,
						   "stdout_text")))) << "\n";
  logFile.close ();
  //gtk_widget_destroy (stdout_window);

  if (read_done == 9)
    return 1;

  return 0;
}

/* start subprocess and reroute stdin, stderr and stdout */
/* does NOT use the shell as spawner */

pid_t
full_dpl_pipe3 (gint * out, gint * err, string command)
{
  gint fd2[2], fd3[2];
  pid_t pid;

  /* do the pipe-stuff */
  if (pipe (fd2) < 0 || pipe (fd3) < 0)
    {
      g_error ("pipe error\n");
    }

  if ((pid = fork ()) < 0)
    {
      g_error ("fork error\n");
    }
  else if (pid > 0)
    {
      /* parent */
      close (fd2[1]);
      close (fd3[1]);
      //gi_childpid = pid;
      //printf("[DEBUG] child pid is %d\n", gi_childpid); 
      /* return new stdout/stdin/stderr of child */

      if (out != NULL)
	*out = fd2[0];
      else
	close (fd2[0]);

      if (err != NULL)
	*err = fd3[0];
      else
	close (fd3[0]);
    }
  else
    {

      /* needed for correct rights in nonroot mode */
      /* fix_guid(); */

      /* child */
      close (fd2[0]);
      close (fd3[0]);

      /* reroute stdout from child */
      if (fd2[1] != STDOUT_FILENO)
	{
	  if (dup2 (fd2[1], STDOUT_FILENO) != STDOUT_FILENO)
	    {
	      g_error ("dup2 error on stdout\n");
	    }
	  close (fd2[1]);
	}
      /* reroute stderr from child */
      if (fd3[1] != STDERR_FILENO)
	{
	  if (dup2 (fd3[1], STDERR_FILENO) != STDERR_FILENO)
	    {
	      g_error ("dup2 error on stderr\n");
	    }
	  close (fd3[1]);
	}

      /* startup child */
//              execl("/bin/sh", "sh", "-c", command.c_str()); 
      system (command.c_str ());
      _exit (0);

    }
  return (pid);
}


void
read_out (gpointer data, gint source, GdkInputCondition cond)
{
  gint n, status;
  gfloat val;
  gchar line[MAXLINE];

  /* read output of vrfytool  */
  n = read_line (read_out_, line, MAXLINE);

  /* readcd-finished? */
  if (n <= 0)
    {
      gtk_input_remove (progress_callback);
      /* pick up return status of child */
      waitpid (pid_command, &status, WUNTRACED);
      /* tell our caller that we are done here */
      read_done = -1;
      return;
    }

  /* forward all other output to textview-window */
  strcat (line, "\n");

  /* look for a percent value */
  string in = line;
  string search;
  /*if (in.find ('%', 0) != string::npos)
    {
      search = in.substr (0, in.find ('%', 0));
      int i = search.find_first_of ("0123456789");
      search = search.substr (i);
      gfloat pval = atof (search.c_str ());
      printf ("%f\n", pval);

      GtkWidget *progressbar1 = get_widget (stdout_window, "progressmon");
      gtk_progress_set_percentage (GTK_PROGRESS (progressbar1),
				   (gfloat) pval / 100);
    }*/

  gtk_text_insert (GTK_TEXT (get_widget (stdout_window, "stdout_text")),
		   NULL, NULL, NULL, line, strlen (line));
}


/* do just swallow all output we get from stderr... and wait if the
   process terminated */

void
read_err (gpointer data, gint source, GdkInputCondition cond)
{
  gint n;
  gint status;
  gchar line[MAXLINE];
  gfloat val;

  static GtkText *stdout_text;
  stdout_text = GTK_TEXT (get_widget (stdout_window, "stdout_text"));
  gtk_text_set_word_wrap (stdout_text, TRUE);

/* read output of vrfytool */
  n = read_line (read_err_, line, MAXLINE);

/* readcd-finished? */
  if (n <= 0)
    {
      gtk_input_remove (progress_callback3);

      /* pick up return status of child */
      waitpid (pid_command, &status, WUNTRACED);

      read_done = -1;
      return;
    }

/* look for a percent value */
  string in = line;
  string search;

/*  if (in.find ('%', 0) != string::npos)
    {
      search = in.substr (0, in.find ('%', 0));
      int i = search.find_first_of ("0123456789");
      search = search.substr (i);
      gfloat pval = atof (search.c_str ());
      printf ("%f\n", pval);

      GtkWidget *progressbar1 = get_widget (stdout_window, "progressmon");
      gtk_progress_set_percentage (GTK_PROGRESS (progressbar1),
				   (gfloat) pval / 100);
    }*/
  gtk_text_insert (stdout_text, NULL, NULL, NULL, line, strlen (line));
  gtk_text_insert (stdout_text, NULL, NULL, NULL, " \n", -1);
}

gint
read_line (gint fd, gchar * ptr, gint maxlen)
{
  gint n, rc;
  gchar c;
  gchar *str;

  str = ptr;

  for (n = 1; n < maxlen; n++)
    {
      if ((rc = read (fd, &c, 1)) == 1)
	{
	  *ptr++ = c;
	  if (c == '\n')
	    {
	      break;
	    }

	}
      else if (rc == 0)
	{
	  /* EOF */
	  if (n == 1)
	    return (0);		/* EOF, no data read */
	  else
	    break;		/* EOF, some data was read */
	}
      else if (rc == -2)
	{
	  /* timeout while reading string */
	  return (-2);
	}
      else
	{
	  /* nonblocking mode an nothing to read? */
	  if (rc == -1 && errno == EAGAIN)
	    {
	      if (n == 1)
		return (-1);
	      else
		break;
	    }
	  return (-1);		/* error */
	}
    }

  /* terminate the string */
  *ptr = 0;

  /* strip of some trailing chars - yes..we need both levels */
  ptr--;
  if ((*ptr == '\n') || (*ptr == '\r'))
    {
      *ptr = 0;
    }
  ptr--;
  if ((*ptr == '\n') || (*ptr == '\r'))
    {
      *ptr = 0;
    }

  if (strlen (str) == 0)
    {
      /* if we read an empty string, but are NOT on EOF return 1 */
      return 1;
    }
  else
    {
      return (strlen (str));
    }
}

void
wait_and_process_events ()
{

  while (gtk_events_pending ())
    gtk_main_iteration ();
  usleep (100);
}

void
kill_process (int num)
{
/*  printf("[DEBUG] kill_process pid=%d\n", gi_childpid);
  if (gi_childpid != 0)
  {*/
    read_done = num;
    //printf("[DEBUG] kill return %d\n", kill (gi_childpid, SIGTERM));  
//  }
}
