/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */

#include "rip.h"

using namespace std;

void RipEncode::ripAll(string directory, string prefix, Setup setupData1)
{
   string command, suffix;
   int totaltracks, track, cont;
   cdrom(totaltracks, setupData1);

//takes spaces out of input if there are any
   while (directory.substr(directory.length()-1, directory.length())==" ")
      directory=directory.substr(0, directory.length()-1);
   while (directory.substr(0, 1)==" ")
   	directory=directory.substr(1, directory.length()-1);

   while (prefix.substr(prefix.length()-1, prefix.length())==" ")
      prefix=prefix.substr(0, prefix.length()-1);
   while (prefix.substr(0, 1)==" ")
   	prefix=prefix.substr(1, prefix.length()-1);


   if (setupData1.ripper=="cdparanoia")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdparanoia -v -d "+setupData1.readerdev+" "+suffix+" "+directory+"/"+prefix+"_"+suffix+".wav";
         cont=exec_cmd(command, setupData1);
         if (cont==1)
            return;
      }


   if (setupData1.ripper=="cdda2wav")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdda2wav -t "+suffix+" -H -D "+setupData1.reader+" "+directory+"/"+prefix+"_"+suffix+".wav";
         cont=exec_cmd(command, setupData1);
         if (cont==1)
            return;
      }
}

//*****************

void RipEncode::trackList(RipType ripping, string list, string directory, string prefix, string bitrate, Setup setupData1)
{
   string track;

//takes spaces out of input if there are any

   while (directory.substr(directory.length()-1, directory.length())==" ")
      directory=directory.substr(0, directory.length()-1);
   while (directory.substr(0, 1)==" ")
   	directory=directory.substr(1, directory.length()-1);

   while (prefix.substr(prefix.length()-1, prefix.length())==" ")
      prefix=prefix.substr(0, prefix.length()-1);
   while (prefix.substr(0, 1)==" ")
   	prefix=prefix.substr(1, prefix.length()-1);

   while (list.substr(list.length()-1, list.length())==" ")
      list=list.substr(0, list.length()-1);
   while (list.substr(0, 1)==" ")
   	list=list.substr(1, list.length()-1);


   while (list!="end")
   {
      convert.selTracks(list, track);
      if (track=="error")
      {
         cout<<"Error in input, please try again"<<endl;
         return;
      }
      if (ripping==ENCODE)
      {
         int cont=encSel(track, directory, prefix, bitrate, setupData1);
         if (cont==1)
            return;
      }

      if (ripping==RIPONLY)
      {
         int cont=rip(track, directory, prefix, setupData1);
         if (cont==1)
            return;
      }
   } //End of While loop
} //End of Function

//*****************************

int RipEncode::rip(string track, string directory, string prefix, Setup setupData1)
{
   string command;
   int cont;
   if (setupData1.ripper=="cdparanoia")    
      command="cdparanoia -v -d "+setupData1.readerdev+" "+track+" "+directory+"/"+prefix+"_"+track+".wav";
   if (setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+track+" -H -D "+setupData1.reader+" "+directory+"/"+prefix+"_"+track+".wav";
   cont=exec_cmd(command, setupData1);
   return cont;
} 

//******************************

void RipEncode::encInd(string filename, string bitrate, Setup setupData1)
{
   string command;

//takes spaces out of input if there are any
   while (filename.substr(filename.length()-1, filename.length())==" ")
      filename=filename.substr(0, filename.length()-1);
   while (filename.substr(0, 1)==" ")
	   filename=filename.substr(1, filename.length()-1);


   if (setupData1.encoder=="blade")
      command="bladeenc -"+bitrate+" "+filename;
  

   if (setupData1.encoder=="lame")
   {
      // lameEncInd(filename, setupData1);
      command="lame -h -b "+bitrate+" "+filename; 
   }

   if (setupData1.encoder=="oggenc")
      command="oggenc -b "+bitrate+" "+filename;

   exec_cmd(command, setupData1);
}

//***********************

void RipEncode::encAll(string directory, string prefix, string bitrate, Setup setupData1)
{
   string command, suffix;
   int totaltracks, track, cont;
   cdrom(totaltracks, setupData1);

//takes spaces out of input if there are any
   while (directory.substr(directory.length()-1, directory.length())==" ")
      directory=directory.substr(0, directory.length()-1);
   while (directory.substr(0, 1)==" ")
	   directory=directory.substr(1, directory.length()-1);

   while (prefix.substr(prefix.length()-1, prefix.length())==" ")
      prefix=prefix.substr(0, prefix.length()-1);
   while (prefix.substr(0, 1)==" ")
   	prefix=prefix.substr(1, prefix.length()-1);


//blade encode
   if (setupData1.encoder=="blade" && setupData1.ripper=="cdparanoia")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdparanoia -v -d "+setupData1.readerdev+" "+suffix+" - | bladeenc -"+bitrate+" STDIN "+directory+"/"+prefix+"_"+suffix+".mp3";
         cont=exec_cmd(command, setupData1);
         if(cont==1)
            return;
      }

   if (setupData1.encoder=="blade" && setupData1.ripper=="cdda2wav")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdda2wav -t "+suffix+" -H -D "+setupData1.reader+" - | bladeenc -"+bitrate+" STDIN "+directory+"/"+prefix+"_"+suffix+".mp3";
         cont=exec_cmd(command, setupData1);
         if(cont==1)
            return;
      }

//oggencode
   if (setupData1.encoder=="oggenc" && setupData1.ripper=="cdda2wav")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdda2wav -t "+suffix+" -H -D "+setupData1.reader+" - | oggenc -b "+bitrate+" -o "+directory+"/"+prefix+"_"+suffix+".ogg - ";
         cont=exec_cmd(command, setupData1);
      }

   if (setupData1.encoder=="oggenc" && setupData1.ripper=="cdparanoia")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdparanoia -v -d "+setupData1.readerdev+" "+suffix+" - | oggenc -b "+bitrate+" -o "+directory+"/"+prefix+"_"+suffix+".ogg - ";
         cont=exec_cmd(command, setupData1);
         if(cont==1)
            return;
      }


//lame
   if (setupData1.encoder=="lame" && setupData1.ripper=="cdparanoia")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdparanoia -v -d "+setupData1.readerdev+" "+suffix+" - | lame -h -b "+bitrate+" - "+directory+"/"+prefix+"_"+suffix+".mp3";
         cont=exec_cmd(command, setupData1);
         if(cont==1)
            return;
      }

   if (setupData1.encoder=="lame" && setupData1.ripper=="cdda2wav")
      for (track=1; track<=totaltracks; track++)
      {
         convert.trackSuf(track, suffix);
         command="cdda2wav -t "+suffix+" -H -D "+setupData1.reader+" - | lame -h -b "+bitrate+" - "+directory+"/"+prefix+"_"+suffix+".mp3";
         cont=exec_cmd(command, setupData1);
         if(cont==1)
            return;
      }

}

//*****************

int RipEncode::encSel(string track, string directory, string prefix, string bitrate, Setup setupData1)
{
   string command;

   if (setupData1.encoder=="blade" && setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+track+" - | bladeenc -"+bitrate+" STDIN "+directory+"/"+prefix+"_"+track+".mp3";

   if (setupData1.encoder=="blade" && setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+track+" -H -D "+setupData1.reader+" - | bladeenc -"+bitrate+" STDIN "+directory+"/"+prefix+"_"+track+".mp3";

   if (setupData1.encoder=="lame" && setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+track+" - | lame -h -b "+bitrate+" - "+directory+"/"+prefix+"_"+track+".mp3";

   if (setupData1.encoder=="lame" && setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+track+" -H -D "+setupData1.reader+" - | lame -h -b "+bitrate+" - "+directory+"/"+prefix+"_"+track+".mp3";

   if (setupData1.encoder=="oggenc" && setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+track+" - | oggenc -b "+bitrate+" -o "+directory+"/"+prefix+"_"+track+".ogg - ";

   if (setupData1.encoder=="oggenc" && setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+track+" -H -D "+setupData1.reader+" - | oggenc -b "+bitrate+" -o "+directory+"/"+prefix+"_"+track+".ogg - ";

   int cont=exec_cmd(command, setupData1);
   return cont; 
}

//************************************

void RipEncode::cdrom(int& totaltracks, Setup setupData1)
{
   struct cdrom_tochdr track_list;
   int cd = open(setupData1.readerdev.c_str(), O_RDONLY | O_NONBLOCK);
   
   ioctl(cd, CDROMREADTOCHDR, &track_list);
       
   totaltracks=track_list.cdth_trk1;
   close(cd);
}

void RipEncode::track(int track, string file_name, string bitrate, Setup setupData1)
{
	   string command, strTrack;
	convert.trackSuf(track, strTrack);

   if (setupData1.encoder=="blade" && setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+strTrack+" - | bladeenc -"+bitrate+" STDIN \""+file_name+"\".mp3";

   if (setupData1.encoder=="blade" && setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+strTrack+" -H -D "+setupData1.reader+" - | bladeenc -"+bitrate+" STDIN \""+file_name+"\".mp3";

   if (setupData1.encoder=="lame" && setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+strTrack+" - | lame -h -b "+bitrate+" - \""+file_name+"\".mp3";

   if (setupData1.encoder=="lame" && setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+strTrack+" -H -D "+setupData1.reader+" - | lame -h -b "+bitrate+" - \""+file_name+"\".mp3";

   if (setupData1.encoder=="oggenc" && setupData1.ripper=="cdparanoia")
      command="cdparanoia -v -d "+setupData1.readerdev+" "+strTrack+" - | oggenc -b "+bitrate+" -o \""+file_name+"\".ogg - ";

   if (setupData1.encoder=="oggenc" && setupData1.ripper=="cdda2wav")
      command="cdda2wav -t "+strTrack+" -H -D "+setupData1.reader+" - | oggenc -b "+bitrate+" -o \""+file_name+"\".ogg - ";

   int cont=exec_cmd(command, setupData1);
}