#ifndef FWHM_H_
#define FWHM_H_
#include "siril.h"
#include "star_finder.h"
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_linalg.h>
#include <gsl/gsl_cblas.h>

struct fwhm_struct {
	double B,		/* average sky background value */
	       A,		/* amplitude */
	       x0, y0,		/* coordinates of the peak */
	       Sx, Sy,		/* Size of the fitted function on the x and y axis in PSF coordinates */
	       FWHMX, FWHMY,	/* FWHM in x and y axis */
	       An,		/* angle of the axis x,y with respect to the image's */
	       Mag,		/* magnitude of the star : this parameter is not fitted
				   but calculated with the vector G and the parameter B */
	       xpos, ypos,	/* position of the star in the image, not set by Minimization */
	       rmse,		/* RMSE of the minimization */
	       /* uncertainties */
	       Berr,
	       Aerr,
	       xerr, yerr,
	       Sxerr, Syerr,
	       Anerr;
	int layer;
	char* units;
};

struct PSF_data {
	size_t n;
	double * y;
	double * sigma;
	size_t NbRows;
	size_t NbCols;
	double rmse;
};

double get_fwhm(fits *, int, double *);
Param_GAUSS *Get_Minimisation(fits *, int , rectangle *);
Param_GAUSS *Global_minimisation(gsl_matrix*, double, int, gboolean);
gsl_vector* MaxInz(gsl_matrix*, double);
int Gaussian_f (const gsl_vector * , void *, gsl_vector *);
int Gaussian_df (const gsl_vector *, void *, gsl_matrix *);
int Gaussian_fdf (const gsl_vector *, void *, gsl_vector *, gsl_matrix *);
int Gaussian_f_An (const gsl_vector * , void *, gsl_vector *);
int Gaussian_df_An (const gsl_vector *, void *, gsl_matrix *);
int Gaussian_fdf_An (const gsl_vector *, void *, gsl_vector *, gsl_matrix *);
Param_GAUSS *minimiz_noAn(gsl_matrix* z, double background, int);
Param_GAUSS *minimiz_An(gsl_matrix* z, Param_GAUSS *);
void DisplayResult(Param_GAUSS *, rectangle *);
double Get_Magnitude(gsl_matrix*, double);
void update_units(fits*, Param_GAUSS**);

#endif
