#ifndef STACKING_H_
#define STACKING_H_

enum {
	AVERAGE_STACKING,
	MEDIAN_STACKING
};	// it would be better to do like the registration of registration methods


/* the dynamic image selection, based on various possible criteria */
typedef int (*stack_filter)(sequence *seq, int nb_img, double param);

/* the stacking method */
struct stacking_args;
typedef int (*stack_method)(struct stacking_args *args);

struct stacking_args {
	stack_method method;
	sequence *seq;
	stack_filter filtering_criterion;
	double filtering_parameter;
	int nb_images_to_stack; // calculated from the above, for display purposes
	char description[100];
	const char *output_filename;
	gboolean output_overwrite;
	struct timeval t_start;
	int retval;
};

/* TYPE OF SIGMA CLIPPING */
typedef enum {
	NONE,
	PERCENTILE,
	NORMAL,
	MEDIAN,
	WINSORIZED,
	LINEARFIT,
} rejection;


int stack_summing(struct stacking_args *args);
int stack_median(struct stacking_args *args);
int stack_mean_with_rejection(struct stacking_args *args);
int addmax_stacking(struct stacking_args *args);
int compute_normalisation(sequence *seq, struct stacking_args *args,
		int nb_frames, double *offset, double *mul, double *scale, int mode);

void start_stacking();
void update_stack_interface();

#endif
