/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.collections.SubArrayList4;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList4<E>
implements Iterable<E>,
Collection<E>,
List<E> {
    protected transient int modCount;

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<E> iterator = collection.iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next());
        }
        return true;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size()) {
            return false;
        }
        Iterator<E> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            Object e2 = iterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public int hashCode() {
        int n = 1;
        for (E e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayList4Iterator(-1);
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            if (!this.equals(object, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            if (!this.equals(object, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    private boolean equals(Object object, E e) {
        return object == null ? e == null : object.equals(e);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.checkIndex(n, 0, this.size());
        return new ArrayList4IndexIterator(n);
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    protected void removeRange(int n, int n2) {
        if (n < 0 || n >= this.size() || n2 > this.size() || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        ListIterator<E> listIterator = this.listIterator(n);
        for (int i = n; i < n2; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract int size();

    @Override
    public List<E> subList(int n, int n2) {
        return new SubArrayList4(this, n, n2);
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        Iterator<E> iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2++] = iterator.next();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator<E> iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2++] = iterator.next();
        }
        return objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (e != this) {
                stringBuilder.append(e);
            } else {
                stringBuilder.append("(this Collection)");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    void checkIndex(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArrayList4IndexIterator
    extends ArrayList4Iterator
    implements ListIterator<E> {
        public ArrayList4IndexIterator(int n) {
            super(n - 1);
        }

        @Override
        public void add(E e) {
            this.checkCanOperate();
            this.checkConcurrentModification();
            try {
                AbstractList4.this.add(this.currentIndex, e);
                ++this.currentIndex;
                this.syncModCount();
                this.setCanOperateFlag(false);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex != -1;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex + 1;
        }

        @Override
        public E previous() {
            this.checkConcurrentModification();
            try {
                Object e = AbstractList4.this.get(this.currentIndex);
                --this.currentIndex;
                this.setCanOperateFlag(true);
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkConcurrentModification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.currentIndex;
        }

        @Override
        public void set(E e) {
            this.checkCanOperate();
            this.checkConcurrentModification();
            try {
                AbstractList4.this.set(this.currentIndex, e);
                this.setCanOperateFlag(false);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArrayList4Iterator
    implements Iterator<E> {
        protected int currentIndex;
        private int _iteratorModCount;
        protected boolean canOperate;

        public ArrayList4Iterator(int n) {
            this.currentIndex = n;
            this.syncModCount();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex + 1 < AbstractList4.this.size();
        }

        @Override
        public E next() {
            this.checkConcurrentModification();
            try {
                Object e = AbstractList4.this.get(this.currentIndex + 1);
                ++this.currentIndex;
                this.setCanOperateFlag(true);
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkConcurrentModification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            this.checkCanOperate();
            this.checkConcurrentModification();
            AbstractList4.this.remove(this.currentIndex);
            --this.currentIndex;
            this.syncModCount();
            this.setCanOperateFlag(false);
        }

        protected void syncModCount() {
            this._iteratorModCount = AbstractList4.this.modCount;
        }

        protected void checkCanOperate() {
            if (!this.canOperate) {
                throw new IllegalStateException();
            }
        }

        protected void setCanOperateFlag(boolean bl) {
            this.canOperate = bl;
        }

        protected void checkConcurrentModification() {
            if (this._iteratorModCount != AbstractList4.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

