/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragContextImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.slots.Slot;

final class FirstPassCommand
implements PassCommand {
    private static final int ID_BATCH_SIZE = 4096;
    private TreeInt _ids;

    FirstPassCommand() {
    }

    void process(DefragContextImpl defragContextImpl, int n, boolean bl) {
        if (this.batchFull()) {
            this.flush(defragContextImpl);
        }
        this._ids = TreeInt.add(this._ids, bl ? -n : n);
    }

    private boolean batchFull() {
        return this._ids != null && this._ids.size() == 4096;
    }

    public void processClass(DefragContextImpl defragContextImpl, ClassMetadata classMetadata, int n, int n2) {
        this.process(defragContextImpl, n, true);
        for (int i = 0; i < classMetadata.i_fields.length; ++i) {
            FieldMetadata fieldMetadata = classMetadata.i_fields[i];
            if (fieldMetadata.isVirtual() || !fieldMetadata.hasIndex()) continue;
            this.processBTree(defragContextImpl, fieldMetadata.getIndex(defragContextImpl.systemTrans()));
        }
    }

    public void processObjectSlot(DefragContextImpl defragContextImpl, ClassMetadata classMetadata, int n) {
        this.process(defragContextImpl, n, false);
    }

    public void processClassCollection(DefragContextImpl defragContextImpl) throws CorruptionException {
        this.process(defragContextImpl, defragContextImpl.sourceClassCollectionID(), false);
    }

    public void processBTree(final DefragContextImpl defragContextImpl, BTree bTree) {
        this.process(defragContextImpl, bTree.getID(), false);
        defragContextImpl.traverseAllIndexSlots(bTree, new Visitor4(){

            public void visit(Object object) {
                int n = (Integer)object;
                FirstPassCommand.this.process(defragContextImpl, n, false);
            }
        });
    }

    public void flush(DefragContextImpl defragContextImpl) {
        if (this._ids == null) {
            return;
        }
        int n = defragContextImpl.blockSize();
        int n2 = Math.max(8, n);
        boolean bl = 8 % n > 0;
        int n3 = 8 / n;
        if (bl) {
            ++n3;
        }
        int n4 = this._ids.size() * n2;
        Slot slot = defragContextImpl.allocateTargetSlot(n4);
        int n5 = slot.address();
        TreeKeyIterator treeKeyIterator = new TreeKeyIterator(this._ids);
        while (treeKeyIterator.moveNext()) {
            int n6 = (Integer)treeKeyIterator.current();
            boolean bl2 = false;
            if (n6 < 0) {
                n6 = -n6;
                bl2 = true;
            }
            defragContextImpl.mapIDs(n6, n5, bl2);
            n5 += n3;
        }
        this._ids = null;
    }
}

