/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TreeReader;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.FreeSlotNode;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public class RamFreespaceManager
extends AbstractFreespaceManager {
    private final TreeIntObject _finder = new TreeIntObject(0);
    private Tree _freeByAddress;
    private Tree _freeBySize;

    public RamFreespaceManager(LocalObjectContainer localObjectContainer) {
        super(localObjectContainer);
    }

    private void addFreeSlotNodes(int n, int n2) {
        FreeSlotNode freeSlotNode = new FreeSlotNode(n);
        freeSlotNode.createPeer(n2);
        this._freeByAddress = Tree.add(this._freeByAddress, freeSlotNode);
        this._freeBySize = Tree.add(this._freeBySize, freeSlotNode._peer);
    }

    public Slot allocateTransactionLogSlot(int n) {
        FreeSlotNode freeSlotNode = (FreeSlotNode)Tree.last(this._freeBySize);
        if (freeSlotNode == null || freeSlotNode._key < n) {
            return null;
        }
        int n2 = n + 100;
        if (freeSlotNode._key > n2) {
            return this.getSlot(n2);
        }
        this.removeFromBothTrees(freeSlotNode);
        return new Slot(freeSlotNode._peer._key, freeSlotNode._key);
    }

    public void freeTransactionLogSlot(Slot slot) {
        this.free(slot);
    }

    public void beginCommit() {
    }

    public void commit() {
    }

    public void endCommit() {
    }

    public void free(Slot slot) {
        int n = slot.address();
        int n2 = slot.length();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this._finder._key = n;
        FreeSlotNode freeSlotNode = (FreeSlotNode)Tree.findSmaller(this._freeByAddress, this._finder);
        if (freeSlotNode != null && freeSlotNode._key + freeSlotNode._peer._key == n) {
            FreeSlotNode freeSlotNode2 = freeSlotNode._peer;
            this._freeBySize = this._freeBySize.removeNode(freeSlotNode2);
            freeSlotNode2._key += n2;
            FreeSlotNode freeSlotNode3 = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (freeSlotNode3 != null && n + n2 == freeSlotNode3._key) {
                freeSlotNode2._key += freeSlotNode3._peer._key;
                this.removeFromBothTrees(freeSlotNode3._peer);
            }
            freeSlotNode2.removeChildren();
            this._freeBySize = Tree.add(this._freeBySize, freeSlotNode2);
        } else {
            freeSlotNode = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (freeSlotNode != null && n + n2 == freeSlotNode._key) {
                FreeSlotNode freeSlotNode4 = freeSlotNode._peer;
                this.removeFromBothTrees(freeSlotNode4);
                freeSlotNode4._key += n2;
                freeSlotNode._key = n;
                freeSlotNode.removeChildren();
                freeSlotNode4.removeChildren();
                this._freeByAddress = Tree.add(this._freeByAddress, freeSlotNode);
                this._freeBySize = Tree.add(this._freeBySize, freeSlotNode4);
            } else {
                if (this.canDiscard(n2)) {
                    return;
                }
                this.addFreeSlotNodes(n, n2);
            }
        }
        this._file.overwriteDeletedBlockedSlot(slot);
    }

    public void freeSelf() {
    }

    private void freeReader(StatefulBuffer statefulBuffer) {
        this._file.free(statefulBuffer.getAddress(), statefulBuffer.length());
    }

    public Slot getSlot(int n) {
        this._finder._key = n;
        this._finder._object = null;
        this._freeBySize = FreeSlotNode.removeGreaterOrEqual((FreeSlotNode)this._freeBySize, this._finder);
        if (this._finder._object == null) {
            return null;
        }
        FreeSlotNode freeSlotNode = (FreeSlotNode)this._finder._object;
        int n2 = freeSlotNode._key;
        int n3 = freeSlotNode._peer._key;
        this._freeByAddress = this._freeByAddress.removeNode(freeSlotNode._peer);
        int n4 = n2 - n;
        if (this.canDiscard(n4)) {
            n = n2;
        } else {
            this.addFreeSlotNodes(n3 + n, n4);
        }
        return new Slot(n3, n);
    }

    int marshalledLength() {
        return TreeInt.marshalledLength((TreeInt)this._freeBySize);
    }

    public int onNew(LocalObjectContainer localObjectContainer) {
        return 0;
    }

    public void read(int n) {
        this.readById(n);
    }

    private void read(StatefulBuffer statefulBuffer) {
        FreeSlotNode.sizeLimit = this.blockedDiscardLimit();
        this._freeBySize = new TreeReader(statefulBuffer, new FreeSlotNode(0), true).read();
        final Tree.ByRef byRef = new Tree.ByRef();
        if (this._freeBySize != null) {
            this._freeBySize.traverse(new Visitor4(){

                public void visit(Object object) {
                    FreeSlotNode freeSlotNode = ((FreeSlotNode)object)._peer;
                    byRef.value = Tree.add(byRef.value, freeSlotNode);
                }
            });
        }
        this._freeByAddress = byRef.value;
    }

    void read(Slot slot) {
        if (slot.address() == 0) {
            return;
        }
        StatefulBuffer statefulBuffer = this._file.readWriterByAddress(this.transaction(), slot.address(), slot.length());
        if (statefulBuffer == null) {
            return;
        }
        this.read(statefulBuffer);
        this.freeReader(statefulBuffer);
    }

    private void readById(int n) {
        if (n <= 0) {
            return;
        }
        if (this.discardLimit() == Integer.MAX_VALUE) {
            return;
        }
        StatefulBuffer statefulBuffer = this._file.readWriterByID(this.transaction(), n);
        if (statefulBuffer == null) {
            return;
        }
        this.read(statefulBuffer);
        this._file.free(n, 8);
        this.freeReader(statefulBuffer);
    }

    private void removeFromBothTrees(FreeSlotNode freeSlotNode) {
        this._freeBySize = this._freeBySize.removeNode(freeSlotNode);
        this._freeByAddress = this._freeByAddress.removeNode(freeSlotNode._peer);
    }

    public int slotCount() {
        return Tree.size(this._freeByAddress);
    }

    public void start(int n) {
    }

    public byte systemType() {
        return 2;
    }

    public String toString() {
        final StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RAM FreespaceManager\n");
        stringBuffer.append("Address Index\n");
        this._freeByAddress.traverse(new Visitor4(){

            public void visit(Object object) {
                stringBuffer.append(object);
                stringBuffer.append("\n");
            }
        });
        stringBuffer.append("Length Index\n");
        this._freeBySize.traverse(new Visitor4(){

            public void visit(Object object) {
                stringBuffer.append(object);
                stringBuffer.append("\n");
            }
        });
        return stringBuffer.toString();
    }

    public void traverse(final Visitor4 visitor4) {
        if (this._freeByAddress == null) {
            return;
        }
        this._freeByAddress.traverse(new Visitor4(){

            public void visit(Object object) {
                FreeSlotNode freeSlotNode = (FreeSlotNode)object;
                int n = freeSlotNode._key;
                int n2 = freeSlotNode._peer._key;
                visitor4.visit(new Slot(n, n2));
            }
        });
    }

    public int write() {
        Pointer4 pointer4 = this._file.newSlot(this.marshalledLength());
        this.write(pointer4);
        return pointer4._id;
    }

    void write(Pointer4 pointer4) {
        StatefulBuffer statefulBuffer = new StatefulBuffer((Transaction)this.transaction(), pointer4);
        TreeInt.write(statefulBuffer, (TreeInt)this._freeBySize);
        statefulBuffer.writeEncrypt();
        this.transaction().flushFile();
        this.transaction().writePointer(pointer4);
    }
}

