/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.Platform4;
import com.db4o.internal.marshall.MarshallingConstants0;
import com.db4o.internal.marshall.PrimitiveMarshaller;
import java.util.Date;

public class PrimitiveMarshaller0
extends PrimitiveMarshaller {
    public boolean useNormalClassRead() {
        return true;
    }

    public Date readDate(Buffer buffer) {
        long l = buffer.readLong();
        if (l == Long.MAX_VALUE) {
            return MarshallingConstants0.NULL_DATE;
        }
        return new Date(l);
    }

    public Object readInteger(Buffer buffer) {
        int n = buffer.readInt();
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        return new Integer(n);
    }

    public Object readFloat(Buffer buffer) {
        Float f = PrimitiveMarshaller0.unmarshallFloat(buffer);
        if (f.isNaN()) {
            return null;
        }
        return f;
    }

    public Object readDouble(Buffer buffer) {
        Double d = PrimitiveMarshaller0.unmarshalDouble(buffer);
        if (d.isNaN()) {
            return null;
        }
        return d;
    }

    public Object readLong(Buffer buffer) {
        long l = buffer.readLong();
        if (l == Long.MAX_VALUE) {
            return null;
        }
        return new Long(l);
    }

    public Object readShort(Buffer buffer) {
        short s = PrimitiveMarshaller0.unmarshallShort(buffer);
        if (s == Short.MAX_VALUE) {
            return null;
        }
        return new Short(s);
    }

    public static Double unmarshalDouble(Buffer buffer) {
        return new Double(Platform4.longToDouble(buffer.readLong()));
    }

    public static Float unmarshallFloat(Buffer buffer) {
        return new Float(Float.intBitsToFloat(buffer.readInt()));
    }

    public static short unmarshallShort(Buffer buffer) {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            n = (n << 8) + (buffer._buffer[buffer._offset++] & 0xFF);
        }
        return (short)n;
    }
}

