/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeCompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferFactoryWrapper;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public class ClassFile
extends Openable
implements IClassFile,
SuffixConstants {
    protected String name;
    protected BinaryType binaryType = null;
    private boolean checkAutomaticSourceMapping;

    protected ClassFile(PackageFragment parent, String name) {
        super(parent);
        this.name = new String(name.substring(0, name.length() - 6));
        this.checkAutomaticSourceMapping = false;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        IStatus status = this.validateClassFile();
        if (!status.isOK()) {
            throw this.newJavaModelException(status);
        }
        if (underlyingResource != null && !underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        IBinaryType typeInfo = this.getBinaryTypeInfo((IFile)underlyingResource);
        if (typeInfo == null) {
            info.setChildren(new IJavaElement[0]);
            return false;
        }
        BinaryType type = new BinaryType(this, ClassFile.simpleName(typeInfo.getName()));
        info.addChild(type);
        newElements.put(type, typeInfo);
        return true;
    }

    public void codeComplete(int offset, ICompletionRequestor requestor) throws JavaModelException {
        this.codeComplete(offset, requestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(int offset, ICompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        this.codeComplete(offset, new CompletionRequestorWrapper(requestor), owner);
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaModelException {
        this.codeComplete(offset, requestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        String source = this.getSource();
        if (source != null) {
            BinaryType type = (BinaryType)this.getType();
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, type.sourceFileName((IBinaryType)type.getElementInfo()), this.getJavaProject());
            this.codeComplete(cu, cu, offset, requestor, owner);
        }
    }

    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            BinaryType type = (BinaryType)this.getType();
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, null, type.sourceFileName((IBinaryType)type.getElementInfo()));
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaElement[0];
    }

    protected Object createElementInfo() {
        return new ClassFileInfo(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassFile)) {
            return false;
        }
        return super.equals(o);
    }

    public boolean exists() {
        return super.exists() && this.validateClassFile().isOK();
    }

    protected IJavaElement findElement(IJavaElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)((Object)elt)).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement match = this.findElement(children[i], position, mapper);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return elt;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBinaryType getBinaryTypeInfo(IFile file) throws JavaModelException {
        JavaElement le = (JavaElement)this.getParent();
        if (le instanceof JarPackageFragment) {
            try {
                ClassFileReader info;
                block13: {
                    JarPackageFragmentRoot root = (JarPackageFragmentRoot)le.getParent();
                    info = null;
                    ZipFile zip = null;
                    try {
                        zip = root.getJar();
                        PackageFragment pkg = (PackageFragment)le;
                        String entryName = Util.concatWith(pkg.names, this.getElementName(), '/');
                        ZipEntry ze = zip.getEntry(entryName);
                        if (ze != null) {
                            byte[] contents = org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                            String fileName = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
                            info = new ClassFileReader(contents, fileName.toCharArray(), true);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        throw throwable;
                    }
                    {
                        Object var11_17 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        if (info != null) break block13;
                    }
                    throw this.newNotPresentException();
                }
                return info;
            }
            catch (ClassFormatException cfe) {
                if (JavaCore.getPlugin().isDebugging()) {
                    cfe.printStackTrace(System.err);
                }
                return null;
            }
            catch (IOException ioe) {
                throw new JavaModelException(ioe, 985);
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        byte[] contents = Util.getResourceContentsAsByteArray(file);
        try {
            return new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), true);
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.validateClassFile().isOK()) {
            return super.getBuffer();
        }
        return this.openBuffer(null, null);
    }

    public IClassFile getClassFile() {
        return this;
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IType type = this.getType();
        return this.findElement(type, position, mapper);
    }

    public IJavaElement getElementAtConsideringSibling(int position) throws JavaModelException {
        IPackageFragment fragment = (IPackageFragment)this.getParent();
        PackageFragmentRoot root = (PackageFragmentRoot)fragment.getAncestor(3);
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        String prefix = null;
        int index = this.name.indexOf(36);
        prefix = index > -1 ? this.name.substring(0, index) : this.name;
        IType type = null;
        int start = -1;
        int end = Integer.MAX_VALUE;
        IJavaElement[] children = fragment.getChildren();
        int i = 0;
        while (i < children.length) {
            String childName = children[i].getElementName();
            String childPrefix = null;
            int childIndex = childName.indexOf(36);
            childPrefix = childIndex > -1 ? childName.substring(0, childIndex) : childName.substring(0, childName.indexOf(46));
            if (prefix.equals(childPrefix)) {
                IClassFile classFile = (IClassFile)children[i];
                classFile.getBuffer();
                SourceRange range = mapper.getSourceRange(classFile.getType());
                if (range != SourceMapper.fgUnknownRange) {
                    int newStart = range.offset;
                    int newEnd = newStart + range.length - 1;
                    if (newStart > start && newEnd < end && newStart <= position && newEnd >= position) {
                        type = classFile.getType();
                        start = newStart;
                        end = newEnd;
                    }
                }
            }
            ++i;
        }
        if (type != null) {
            return this.findElement(type, position, mapper);
        }
        return null;
    }

    public String getElementName() {
        return String.valueOf(this.name) + ".class";
    }

    public int getElementType() {
        return 6;
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                BinaryType type = new BinaryType(this, typeName);
                return type.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '(';
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    public String getTopLevelTypeName() {
        String topLevelTypeName = this.getElementName();
        int firstDollar = topLevelTypeName.indexOf(36);
        topLevelTypeName = firstDollar != -1 ? topLevelTypeName.substring(0, firstDollar) : topLevelTypeName.substring(0, topLevelTypeName.length() - SUFFIX_CLASS.length);
        return topLevelTypeName;
    }

    public IType getType() {
        if (this.binaryType == null) {
            this.binaryType = new BinaryType(this, this.getTypeName());
        }
        return this.binaryType;
    }

    public String getTypeName() {
        int lastDollar = this.name.lastIndexOf(36);
        return lastDollar > -1 ? Util.localTypeName(this.name, lastDollar, this.name.length()) : this.name;
    }

    public ICompilationUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        char[] contents = null;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            contents = mapper.findSource(this.getType());
        }
        if (contents == null) {
            return null;
        }
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy();
        workingCopy.buffer = buffer = owner == null ? this.getBuffer() : owner.createBuffer(workingCopy);
        if (buffer != null && buffer.getCharacters() == null) {
            buffer.setContents(contents);
        }
        return workingCopy;
    }

    public IJavaElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws JavaModelException {
        return this.getWorkingCopy(BufferFactoryWrapper.create(factory), monitor);
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean isClass() throws JavaModelException {
        return this.getType().isClass();
    }

    public boolean isInterface() throws JavaModelException {
        return this.getType().isInterface();
    }

    public boolean isReadOnly() {
        return true;
    }

    private IStatus validateClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        return JavaConventions.validateClassFileName(this.getElementName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        PackageFragmentRoot root;
        block14: {
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null) {
                return this.mapSource(mapper);
            }
            if (this.checkAutomaticSourceMapping) return null;
            root = this.getPackageFragmentRoot();
            if (!root.isArchive()) break block14;
            String elementName = this.getElementName();
            String sourceFileWithoutExtension = elementName.substring(0, elementName.lastIndexOf(46));
            JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
            ZipFile jar = null;
            try {
                try {
                    jar = jarPackageFragmentRoot.getJar();
                    String[] pkgName = ((PackageFragment)this.getParent()).names;
                    char[][] javaLikeExtensions = Util.getJavaLikeExtensions();
                    int i = 0;
                    int length = javaLikeExtensions.length;
                    while (i < length) {
                        StringBuffer entryName = new StringBuffer();
                        int j = 0;
                        int pkgNameLength = pkgName.length;
                        while (true) {
                            if (j >= pkgNameLength) {
                                entryName.append(sourceFileWithoutExtension);
                                entryName.append(javaLikeExtensions[i]);
                                ZipEntry zipEntry = jar.getEntry(entryName.toString());
                                if (zipEntry == null) break;
                                this.checkAutomaticSourceMapping = true;
                                root.attachSource(root.getPath(), null, null);
                                SourceMapper sourceMapper = this.getSourceMapper();
                                if (sourceMapper == null) break;
                                IBuffer iBuffer = this.mapSource(sourceMapper);
                                Object var16_33 = null;
                                JavaModelManager.getJavaModelManager().closeZipFile(jar);
                                return iBuffer;
                            }
                            entryName.append(pkgName[j]);
                            entryName.append('/');
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    if (!(e instanceof JavaModelException)) throw new JavaModelException(e);
                    throw (JavaModelException)e;
                }
            }
            catch (Throwable throwable) {
                Object var16_34 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
                throw throwable;
            }
            {
                Object var16_35 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
                return null;
            }
        }
        String qualifiedName = this.getType().getFullyQualifiedName();
        NameLookup lookup = ((JavaProject)this.getJavaProject()).newNameLookup(DefaultWorkingCopyOwner.PRIMARY);
        ICompilationUnit cu = lookup.findCompilationUnit(qualifiedName);
        if (cu != null) {
            return cu.getBuffer();
        }
        IContainer pkgFolder = (IContainer)this.getParent().getResource();
        IResource[] files = null;
        try {
            files = pkgFolder.members();
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        IResource sourceFile = null;
        String classFileName = this.getElementName();
        String simpleName = classFileName.substring(0, classFileName.lastIndexOf(46));
        int i = 0;
        int length = files.length;
        while (i < length) {
            IResource resource = files[i];
            if (resource.getType() == 1 && Util.equalsIgnoreJavaLikeExtension(resource.getName(), simpleName)) {
                sourceFile = resource;
                break;
            }
            ++i;
        }
        if (sourceFile == null) return null;
        this.checkAutomaticSourceMapping = true;
        root.attachSource(root.getPath(), null, null);
        SourceMapper sourceMapper = this.getSourceMapper();
        if (sourceMapper == null) return null;
        return this.mapSource(sourceMapper);
    }

    private IBuffer mapSource(SourceMapper mapper) {
        char[] contents = mapper.findSource(this.getType());
        if (contents != null) {
            IBuffer buffer = this.getBufferManager().createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            mapper.mapSource(this.getType(), contents);
            return buffer;
        }
        return null;
    }

    static String simpleName(char[] className) {
        if (className == null) {
            return null;
        }
        String simpleName = new String(ClassFile.unqualifiedName(className));
        int lastDollar = simpleName.lastIndexOf(36);
        if (lastDollar != -1) {
            return Util.localTypeName(simpleName, lastDollar, simpleName.length());
        }
        return simpleName;
    }

    public static char[] translatedName(char[] name) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length;
        char[] newName = new char[nameLength];
        int i = 0;
        while (i < nameLength) {
            newName[i] = name[i] == '/' ? 46 : name[i];
            ++i;
        }
        return newName;
    }

    static char[][] translatedNames(char[][] names) {
        if (names == null) {
            return null;
        }
        int length = names.length;
        char[][] newNames = new char[length][];
        int i = 0;
        while (i < length) {
            newNames[i] = ClassFile.translatedName(names[i]);
            ++i;
        }
        return newNames;
    }

    static char[] unqualifiedName(char[] className) {
        if (className == null) {
            return null;
        }
        int count = 0;
        int i = className.length - 1;
        while (i > -1) {
            if (className[i] == '/') {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                return name;
            }
            ++count;
            --i;
        }
        return className;
    }

    public void codeComplete(int offset, final ICodeCompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            this.codeComplete(offset, (ICompletionRequestor)null);
            return;
        }
        this.codeComplete(offset, new ICompletionRequestor(){

            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptError(IProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] fieldName, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptField(declaringTypePackageName, declaringTypeName, fieldName, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptKeyword(keywordName, completionStart, completionEnd);
            }

            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptLabel(labelName, completionStart, completionEnd);
            }

            public void acceptLocalVariable(char[] localVarName, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptModifier(modifierName, completionStart, completionEnd);
            }

            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptPackage(packageName, completionName, completionStart, completionEnd);
            }

            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd);
            }

            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] varName, char[] completionName, int completionStart, int completionEnd, int relevance) {
            }
        });
    }
}

