/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.spring;

import com.opensymphony.xwork2.spring.SpringObjectFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringProxyableObjectFactory
extends SpringObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SpringProxyableObjectFactory.class);
    private List<String> skipBeanNames = new ArrayList<String>();

    @Override
    public Object buildBean(String beanName, Map<String, Object> extraContext) throws Exception {
        block12: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Building bean for name " + beanName, new String[0]);
            }
            if (!this.skipBeanNames.contains(beanName)) {
                ApplicationContext anAppContext = this.getApplicationContext(extraContext);
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Trying the application context... appContext = " + anAppContext + ",\n bean name = " + beanName, new String[0]);
                    }
                    return anAppContext.getBean(beanName);
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Did not find bean definition for bean named " + beanName + ", creating a new one...", new String[0]);
                    }
                    if (!(this.autoWiringFactory instanceof BeanDefinitionRegistry)) break block12;
                    try {
                        Class<?> clazz = Class.forName(beanName);
                        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.autoWiringFactory;
                        RootBeanDefinition def = new RootBeanDefinition(clazz, this.autowireStrategy);
                        def.setSingleton(false);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering a new bean definition for class " + beanName, new String[0]);
                        }
                        registry.registerBeanDefinition(beanName, (BeanDefinition)def);
                        try {
                            return anAppContext.getBean(beanName);
                        }
                        catch (NoSuchBeanDefinitionException e2) {
                            LOG.warn("Could not register new bean definition for bean " + beanName, new String[0]);
                            this.skipBeanNames.add(beanName);
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        this.skipBeanNames.add(beanName);
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning autowired instance created by default ObjectFactory", new String[0]);
        }
        return this.autoWireBean(super.buildBean(beanName, extraContext), this.autoWiringFactory);
    }

    protected ApplicationContext getApplicationContext(Map<String, Object> context) {
        return this.appContext;
    }
}

