/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.apicheck.ApiCheck;
import com.google.doclava.apicheck.ApiInfo;
import com.google.doclava.apicheck.ApiParseException;
import java.net.MalformedURLException;
import java.net.URL;

public final class FederatedSite {
    public static final String XML_API_PATH = "/current.xml";
    private final String name;
    private final URL baseUrl;
    private final ApiInfo apiInfo;

    public FederatedSite(String name, URL baseUrl) throws ApiParseException {
        this.name = name;
        this.baseUrl = baseUrl;
        try {
            URL xmlUrl = new URL(baseUrl + XML_API_PATH);
            this.apiInfo = new ApiCheck().parseApi(xmlUrl);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public FederatedSite(String name, URL baseUrl, String xml) throws ApiParseException {
        this.name = name;
        this.baseUrl = baseUrl;
        this.apiInfo = new ApiCheck().parseApi(xml);
    }

    public String linkFor(String htmlPage) {
        String urlStr = this.baseUrl.toString();
        if (urlStr.endsWith("/") || urlStr.endsWith("?")) {
            return this.baseUrl + htmlPage;
        }
        return urlStr + "/" + htmlPage;
    }

    public String name() {
        return this.name;
    }

    public ApiInfo apiInfo() {
        return this.apiInfo;
    }

    public URL baseUrl() {
        return this.baseUrl;
    }
}

