/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ClassInfo;
import com.google.doclava.Doclava;
import com.google.doclava.FederatedSite;
import com.google.doclava.SinceTagger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    public static final Set<String> PRIMITIVE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short", "void")));
    private boolean mIsPrimitive;
    private boolean mIsTypeVariable;
    private boolean mIsWildcard;
    private String mDimension;
    private String mSimpleTypeName;
    private String mQualifiedTypeName;
    private ClassInfo mClass;
    private TypeInfo[] mTypeArguments;
    private TypeInfo[] mSuperBounds;
    private TypeInfo[] mExtendsBounds;
    private String mFullName;

    public TypeInfo(boolean isPrimitive, String dimension, String simpleTypeName, String qualifiedTypeName, ClassInfo cl) {
        this.mIsPrimitive = isPrimitive;
        this.mDimension = dimension;
        this.mSimpleTypeName = simpleTypeName;
        this.mQualifiedTypeName = qualifiedTypeName;
        this.mClass = cl;
    }

    public TypeInfo(String typeString) {
        int pos;
        int paramStartPos;
        if (typeString.endsWith("...")) {
            typeString = typeString.substring(0, typeString.length() - 3);
        }
        if ((paramStartPos = typeString.indexOf(60)) > -1) {
            ArrayList<TypeInfo> generics = new ArrayList<TypeInfo>();
            int paramEndPos = typeString.lastIndexOf(62);
            int entryStartPos = paramStartPos + 1;
            int bracketNesting = 0;
            for (int i = entryStartPos; i < paramEndPos; ++i) {
                char c = typeString.charAt(i);
                if (c == ',' && bracketNesting == 0) {
                    String entry = typeString.substring(entryStartPos, i).trim();
                    TypeInfo info = new TypeInfo(entry);
                    generics.add(info);
                    entryStartPos = i + 1;
                    continue;
                }
                if (c == '<') {
                    ++bracketNesting;
                    continue;
                }
                if (c != '>') continue;
                --bracketNesting;
            }
            TypeInfo info = new TypeInfo(typeString.substring(entryStartPos, paramEndPos).trim());
            generics.add(info);
            this.mTypeArguments = new TypeInfo[generics.size()];
            generics.toArray(this.mTypeArguments);
            typeString = paramEndPos < typeString.length() - 1 ? typeString.substring(0, paramStartPos) + typeString.substring(paramEndPos + 1) : typeString.substring(0, paramStartPos);
        }
        if ((pos = typeString.indexOf(91)) > -1) {
            this.mDimension = typeString.substring(pos);
            typeString = typeString.substring(0, pos);
        } else {
            this.mDimension = "";
        }
        if (PRIMITIVE_TYPES.contains(typeString)) {
            this.mIsPrimitive = true;
            this.mSimpleTypeName = typeString;
            this.mQualifiedTypeName = typeString;
        } else {
            this.mQualifiedTypeName = typeString;
            pos = typeString.lastIndexOf(46);
            this.mSimpleTypeName = pos > -1 ? typeString.substring(pos + 1) : typeString;
        }
    }

    public ClassInfo asClassInfo() {
        return this.mClass;
    }

    public boolean isPrimitive() {
        return this.mIsPrimitive;
    }

    public String dimension() {
        return this.mDimension;
    }

    public String simpleTypeName() {
        return this.mSimpleTypeName;
    }

    public String qualifiedTypeName() {
        return this.mQualifiedTypeName;
    }

    public String fullName() {
        if (this.mFullName != null) {
            return this.mFullName;
        }
        return this.fullName(new HashSet<String>());
    }

    public static String typeArgumentsName(TypeInfo[] args, HashSet<String> typeVars) {
        String result = "<";
        for (int i = 0; i < args.length; ++i) {
            result = result + args[i].fullName(typeVars);
            if (i == args.length - 1) continue;
            result = result + ", ";
        }
        result = result + ">";
        return result;
    }

    public String fullName(HashSet<String> typeVars) {
        this.mFullName = this.fullNameNoDimension(typeVars) + this.mDimension;
        return this.mFullName;
    }

    public String fullNameNoDimension(HashSet<String> typeVars) {
        String fullName;
        block5: {
            block6: {
                block4: {
                    fullName = null;
                    if (this.mIsTypeVariable) {
                        if (typeVars.contains(this.mQualifiedTypeName)) {
                            return this.mQualifiedTypeName;
                        }
                        typeVars.add(this.mQualifiedTypeName);
                    }
                    fullName = this.mQualifiedTypeName;
                    if (this.mTypeArguments == null || this.mTypeArguments.length <= 0) break block4;
                    fullName = fullName + TypeInfo.typeArgumentsName(this.mTypeArguments, typeVars);
                    break block5;
                }
                if (this.mSuperBounds == null || this.mSuperBounds.length <= 0) break block6;
                fullName = fullName + " super " + this.mSuperBounds[0].fullName(typeVars);
                for (int i = 1; i < this.mSuperBounds.length; ++i) {
                    fullName = fullName + " & " + this.mSuperBounds[i].fullName(typeVars);
                }
                break block5;
            }
            if (this.mExtendsBounds == null || this.mExtendsBounds.length <= 0) break block5;
            fullName = fullName + " extends " + this.mExtendsBounds[0].fullName(typeVars);
            for (int i = 1; i < this.mExtendsBounds.length; ++i) {
                fullName = fullName + " & " + this.mExtendsBounds[i].fullName(typeVars);
            }
        }
        return fullName;
    }

    public TypeInfo[] typeArguments() {
        return this.mTypeArguments;
    }

    public void makeHDF(Data data, String base) {
        this.makeHDFRecursive(data, base, false, false, new HashSet<String>());
    }

    public void makeQualifiedHDF(Data data, String base) {
        this.makeHDFRecursive(data, base, true, false, new HashSet<String>());
    }

    public void makeHDF(Data data, String base, boolean isLastVararg, HashSet<String> typeVariables) {
        this.makeHDFRecursive(data, base, false, isLastVararg, typeVariables);
    }

    public void makeQualifiedHDF(Data data, String base, HashSet<String> typeVariables) {
        this.makeHDFRecursive(data, base, true, false, typeVariables);
    }

    private void makeHDFRecursive(Data data, String base, boolean qualified, boolean isLastVararg, HashSet<String> typeVars) {
        String label = qualified ? this.qualifiedTypeName() : this.simpleTypeName();
        label = label + (isLastVararg ? "..." : this.dimension());
        data.setValue(base + ".label", label);
        if (!(this.mIsTypeVariable || this.mIsWildcard || this.isPrimitive() || this.mClass == null)) {
            if (this.mClass.isDefinedLocally()) {
                data.setValue(base + ".link", this.mClass.htmlPage());
                data.setValue(base + ".since.key", SinceTagger.keyForName(this.mClass.getSince()));
                data.setValue(base + ".since.name", this.mClass.getSince());
            } else {
                Doclava.federationTagger.tagAll(new ClassInfo[]{this.mClass});
                if (!this.mClass.getFederatedReferences().isEmpty()) {
                    FederatedSite site = this.mClass.getFederatedReferences().iterator().next();
                    data.setValue(base + ".link", site.linkFor(this.mClass.relativePath()));
                    data.setValue(base + ".federated", site.name());
                }
            }
        }
        if (this.mIsTypeVariable) {
            if (typeVars.contains(this.qualifiedTypeName())) {
                return;
            }
            typeVars.add(this.qualifiedTypeName());
        }
        if (this.mTypeArguments != null) {
            TypeInfo.makeHDF(data, base + ".typeArguments", this.mTypeArguments, qualified, typeVars);
        }
        if (this.mSuperBounds != null) {
            TypeInfo.makeHDF(data, base + ".superBounds", this.mSuperBounds, qualified, typeVars);
        }
        if (this.mExtendsBounds != null) {
            TypeInfo.makeHDF(data, base + ".extendsBounds", this.mExtendsBounds, qualified, typeVars);
        }
    }

    public static void makeHDF(Data data, String base, TypeInfo[] types, boolean qualified, HashSet<String> typeVariables) {
        int N = types.length;
        for (int i = 0; i < N; ++i) {
            types[i].makeHDFRecursive(data, base + "." + i, qualified, false, typeVariables);
        }
    }

    public static void makeHDF(Data data, String base, TypeInfo[] types, boolean qualified) {
        TypeInfo.makeHDF(data, base, types, qualified, new HashSet<String>());
    }

    void setTypeArguments(TypeInfo[] args) {
        this.mTypeArguments = args;
    }

    void setBounds(TypeInfo[] superBounds, TypeInfo[] extendsBounds) {
        this.mSuperBounds = superBounds;
        this.mExtendsBounds = extendsBounds;
    }

    void setIsTypeVariable(boolean b) {
        this.mIsTypeVariable = b;
    }

    void setIsWildcard(boolean b) {
        this.mIsWildcard = b;
    }

    static HashSet<String> typeVariables(TypeInfo[] params) {
        return TypeInfo.typeVariables(params, new HashSet<String>());
    }

    static HashSet<String> typeVariables(TypeInfo[] params, HashSet<String> result) {
        for (TypeInfo t : params) {
            if (!t.mIsTypeVariable) continue;
            result.add(t.mQualifiedTypeName);
        }
        return result;
    }

    public boolean isTypeVariable() {
        return this.mIsTypeVariable;
    }

    public String defaultValue() {
        if (this.mIsPrimitive) {
            if ("boolean".equals(this.mSimpleTypeName)) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + "Primitive?: " + this.mIsPrimitive + " TypeVariable?: " + this.mIsTypeVariable + " Wildcard?: " + this.mIsWildcard + " Dimension: " + this.mDimension + " QualifedTypeName: " + this.mQualifiedTypeName;
        if (this.mTypeArguments != null) {
            returnString = returnString + "\nTypeArguments: ";
            for (TypeInfo tA : this.mTypeArguments) {
                returnString = returnString + tA.qualifiedTypeName() + "(" + tA + ") ";
            }
        }
        if (this.mSuperBounds != null) {
            returnString = returnString + "\nSuperBounds: ";
            for (TypeInfo tA : this.mSuperBounds) {
                returnString = returnString + tA.qualifiedTypeName() + "(" + tA + ") ";
            }
        }
        if (this.mExtendsBounds != null) {
            returnString = returnString + "\nExtendsBounds: ";
            for (TypeInfo tA : this.mExtendsBounds) {
                returnString = returnString + tA.qualifiedTypeName() + "(" + tA + ") ";
            }
        }
        return returnString;
    }
}

