/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.packaging.JarVisitor;

public class InputStreamZippedJarVisitor
extends JarVisitor {
    private static Log log = LogFactory.getLog(InputStreamZippedJarVisitor.class);

    public InputStreamZippedJarVisitor(URL url, JarVisitor.Filter[] filters) {
        super(url, filters);
    }

    public InputStreamZippedJarVisitor(String fileName, JarVisitor.Filter[] filters) {
        super(fileName, filters);
    }

    protected void doProcessElements() throws IOException {
        JarEntry entry;
        JarInputStream jis;
        try {
            jis = new JarInputStream(this.jarUrl.openStream());
        }
        catch (IOException ze) {
            log.warn((Object)("Unable to find file (ignored): " + this.jarUrl), (Throwable)ze);
            return;
        }
        while ((entry = jis.getNextJarEntry()) != null) {
            int size;
            if (entry.isDirectory()) continue;
            byte[] tmpByte = new byte[4096];
            byte[] entryBytes = new byte[]{};
            while ((size = jis.read(tmpByte)) != -1) {
                byte[] current = new byte[entryBytes.length + size];
                System.arraycopy(entryBytes, 0, current, 0, entryBytes.length);
                System.arraycopy(tmpByte, 0, current, entryBytes.length, size);
                entryBytes = current;
            }
            this.addElement(entry.getName(), new ByteArrayInputStream(entryBytes), new ByteArrayInputStream(entryBytes));
        }
        jis.close();
    }
}

