=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: color defaults
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Hex_triplets
  class Color 
    def shadow
      '"4"'
    end
    def black
      '#000000'
    end
    def white
      '#ffffff'
    end
    def blue_dark
      '#000099'
    end
    def blue
      'blue'
    end
    def blue_base
      '#b9d4dd'
    end
    def blue_base_light
      '#eff6ff'
    end
    def blue_ink
      '#003399'
    end
    def blue_pale
      '#0044cc'
    end
    def blue_light
      '#c0d9d9'
    end
    def blue_tinge
      #'#d7dddd'
      #'#f2f5f7'
      '#e3ecef'
    end
    def blue_sky
      '#c0d9d9'
    end
    def blue_grey
      '#8faebf'
    end
    def blue_murky
      '#437389'
    end
    def brown
      '#423a27'
    end
    def beige
      '#f1e8de'
    end
    def subtleglow
      '#dddccc'
    end
    def glow
      '#fff0c3'
    end
    def custard
      '#fff3b6'
    end
    def rose
      '#ffdec9'
    end
    def turquoise
      '#1c869b'
    end
    def grey_pale
      '#eeeeee'
    end
    def grey_light
      '#dddddd'
    end
    def grey_medium
      '#cccccc'
    end
    def grey
      '#999999'
    end
    def yellow_light
      '#fff3b6'
    end
    def yellow
      '#ffde14'
    end
    def yellow_dark
      '#ffcc00'
    end
    def green_pale
      '#b7d398'  #  #e2efd5 #b7d398 #b1c999
    end
    def green_light
      '#aed19e'
    end
    def green
      '#0a8400'
    end
    def green_dark
      '#086800'
    end
    def ruby
      '#a00000'
    end
    def maroon
      '#800000'
    end
    def paper
      %{"#{self.white}"}
    end
    def band1
      '"#ffffff"'      
      #'"#777777"'
    end
    def band2
      '"#ffffff"'      
      #'"#cccccc"'
    end
    def nav_inner_glow
      %{"#{self.white}"}
      #%{"#{self.yellow_dark}"}
    end
    def nav_umbra
      %{"#{self.white}"}
      #%{"#{self.blue_murky}"} #subtleglow
    end
    def nav_penumbra
      %{"#{self.white}"}
      #%{"#{self.blue_grey}"}  #rose
    end
    def inner_glow
      %{"#{self.white}"}
      #%{"#{self.yellow_dark}"}
    end
    def umbra
      %{"#{self.white}"}
      #%{"#{self.subtleglow}"}
    end
    def penumbra
      %{"#{self.white}"}
      #%{"#{self.glow}"}
    end
    def seg_inner_glow
      %{"#{self.white}"}
      #%{"#{self.yellow_dark}"}
    end
    def seg_umbra
      %{"#{self.white}"}
      #%{"#{self.blue_base}"}
    end
    def seg_penumbra
      %{"#{self.white}"}
      #%{"#{self.glow}"}
    end
    def body
      %{\n<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">\n}
      #%{\n<body bgcolor="#ffffff" text="#000000" link="#003090" vlink"#0044cc" lang="en">\n}
    end
    def font
      "#{self.black}"
    end
    def surround
      %{"#{self.white}"}
    end
    def band
      %{"#{self.white}"}
    end
    def frame
      %{"#{self.white}"}
    end
    def title_band
      %{"#e0d7cd"}
    end
    def book_cover
      %{"#{self.white}"}
    end
    def table_white
      %{"#{self.white}"}
    end
    def table1
      'ffffcc'
    end
    def table2
      'c0d0f0'
    end
    def lev5
      %{"#{self.grey_medium}"}
    end
    def lev6
      %{"#{self.grey_pale}"}
    end
  end
end
__END__

