=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: html generation, processing
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_HTML
  require 'pstore'
  require "#{SiSU_lib}/defaults"
  require "#{SiSU_lib}/html_format_css"
  include SiSU_HTML_Format_type
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  require "#{SiSU_lib}/html_tune"
  include SiSU_Tune
  require "#{SiSU_lib}/metaverse"
  require "#{SiSU_lib}/conf_env"
  require "#{SiSU_lib}/common_xml"
  class Source
    def initialize(fns,cf)
      @fns,@cf=fns,cf
    end
    def read
      songsheet
    end
    def songsheet #_new
      begin
        @md=SiSU_Param::Parameters.new(@fns,@cf).get
        @fnb=@md.fnb
        @dir=SiSU_Env::Info_dir.new(@fns)
        loc=SiSU_Env::Info_dir.new(@fns).tell_output_location
        tool=if @cf =~/z/:   "#{@dir.web_browser} #{loc}/#@fnb/#{@md.fn[:index]}"
        elsif @cf =~/[MVv]/: "#{@dir.web_browser} #{loc}/#@fnb/#{@md.fn[:index]}"
        else                 ''
        end
        tell=SiSU_Screen::Ansi.new(@cf,'HTML',tool)
        tell.greenHiBlue unless @cf =~/q/
        tell=SiSU_Screen::Ansi.new(@cf,@fns,"#{@dir.tell_output_path}/#@fnb/#{@md.fn[:index]}")
        tell.flow if @cf =~/[MV]/
        SiSU_Env::Info_skin.new(@md).select
        SiSU_Viz::Url.new
        data=nil
        unless @md.markup =~/url_png/
          my_make=SiSU_Env::Create_file.new(@cf,@fns,@md) #Beware
          my_make.mkdir_dirs #Beware
          @tuned_file_array=SiSU_HTML::Source::Html_environment.new(@fns,@md).tuned_file_instructions
          data=@tuned_file_array
        else
          data=IO.readlines(@fns,'') #wasteful, not really necessary?
          SiSU_HTML_nav_tune::Tune.new(data,@md).songsheet
          @tuned_file_array=data #watch may not be what you want
        end
        scr_endnotes=SiSU_HTML::Source::Endnotes.new(data,@md).scroll unless @md.markup =~/url_png/
        toc=SiSU_HTML::Source::Toc.new(data,@md).songsheet
        doc_ver=SiSU_HTML::Source::Links_guide.new(data,@md).doc_versions
        links_guide=SiSU_HTML::Source::Links_guide.new(data,@md).toc
        data=@tuned_file_array
        scr_toc=SiSU_HTML::Source::Scroll_head_and_segtoc.new(data,@md,toc,links_guide,doc_ver).in_common
        SiSU_HTML::Source::Seg.new(data,@md).songsheet if @fns !~/([stu]|rs|lm|ph)1/
        data=@tuned_file_array
        scr=SiSU_HTML::Source::Scroll.new(data,@md).songsheet
        scroll=SiSU_HTML::Source::Scroll_output.new(scr_toc,scr[:body],scr_endnotes,scr[:metadata],scr[:owner_details],scr[:tails],@md).publish
        SiSU_HTML::Source::Output.new(scroll,@md).scroll
      rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
        unless @cf =~/[MV]/ #check maintenance flag
          texfiles = Dir["#{@dir.tune}/#{@fns}*"]
          texfiles.each do |f| 
            if FileTest.file?(f)
              #puts "removing #{f}"
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Create_file.new(@cf,@fns).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad=Hash.new,Hash.new,Hash.new,Hash.new,Hash.new,Hash.new
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_name_php,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new
        @@filename_seg,@@seg_url,@@filename_segphp,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@header1=@@header2=@@header3=@@header4=0
      end
    end
    private
    class Html_environment
      def initialize(fns,md=nil)
        @dir,@css,@home,@symlnk,@md,@fns=SiSU_Env::Info_dir.new(fns),SiSU_Style::CSS.new,SiSU_Viz::Home.new,SiSU_Env::Create_system_link.new,md,fns
        @cf=@md.cf
        $program=case @cf
        when /h/i: 'css'
        when /o/: 'tbl'
        when /n/: 'nav'
        when /z/: 'php'
        end
      end
      def suffix_linkname #not used at present
        sfx=if @cf =~/h/: '.html'
        else              ''
        end
      end
      def link_images
        @symlnk.images 
      end
      def directories
        my_make=SiSU_Env::Create_file.new(@cf,@fns)
        @path=Hash.new
        @path[:root]=my_make.html_root
        title=File.basename(@fns,'.rb')
        my_make.mkdir_html
      end  
      def tuned_file_instructions 
        @dir=SiSU_Env::Info_dir.new(@fns)
        @tell=SiSU_Screen::Ansi.new(@md.cf)
        if @md
          @md.sfx=''
          @md.file_type='php' if @cf =~/z/
          @md.sfx='' if @cf =~/z/ # @md.sfx='.php' if @cf =~/z/ # if .php extension is required
          if @cf =~/h/ or @md.fns =~/\~[a-z]{2,3}\.s?/ #multilingual document protection is a bit arbitrary, (needed by existing server configuration), add configuration overide...
            if @cf =~/H/ and @md.fns =~/\~[a-z]{2,3}\.s?/
              tell=SiSU_Screen::Ansi.new(@md.cf,'multilingual document, creating internal url links with filetype suffix',"\n\t\t(overriding -H request, using -h mode instead)")
              tell.warn unless @md.cf =~/q/
            end
            @md.sfx='.html'
            @md.pdf='.pdf'
          end
        end
        @cf=@cf.gsub(/H/,'h')
        @md.file_type='html' if @cf =~/[hon]/
        directories
        newfilename=%{#{@dir.data_o}/#{@md.fnb}/#{@md.fn[:index]}} if @md.file_type =~/html/
        my_make_sourceFile=SiSU_Env::Create_file.new(@cf,@fns)
        @fnm=my_make_sourceFile.marshal_meta
        @tuneVerseMarshal=my_make_sourceFile.marshal_tune
        if @md.markup !~/url_png/ and @cf =~/[hozn]/
          if FileTest.file?(@tuneVerseMarshal) and @cf !~/[mM]/
            File.open(@tuneVerseMarshal) { |f| @tuned_file_array=Marshal.load(f)}
            tell=SiSU_Screen::Ansi.new(@md.cf)
            tell.metaVerseSkipped if @cf =~/v/
          else
            metaverse_array=SiSU_Metaverse::Source.new(@fns,@cf).get # metaverse file drawn here
            SiSU_Tune::MyTune.new(metaverse_array,@fns,@md.cf).songsheet
            File.open(@tuneVerseMarshal){|f| @tuned_file_array=Marshal.load(f)}
          end
        else
          SiSU_HTML_nav_tune::Tune.new(@file_array,@md).songsheet #no doc passed originally... 2004w35
        end
        require "#{SiSU_lib}/param"
        @tuned_file_array
      end
    end
    class Split_text_object
      include SiSU_Viz
      include SiSU_HTML_Format_type
      attr_reader :format,:text,:ocn,:scroll_lev_para_ocn,:seg_lev_para_ocn
      def initialize(md,para)
        @md,@para=md,para
        @format,@ocn='null','null'
      end
      def lev_segname_para_ocn                                                   #needs work 2003w29
        if @para =~/^\d~.+?<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/
          if @para[/([1-6])~(\S+)\s+(\S.+?)<~(\d+);(?:[ohmu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @format,segname,@text,@ocn=$1,$2,$3,$4
            @format="#@format~#{segname}" # 
          elsif @para[/([1-6]~)\s+(\S.+?)<~(\d+);(?:[ohmu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @format,@text,@ocn=$1,$2,$3 #,$4
          end
        else
          if @para[/^(?:_1\*|<:i[12]>\s*_\*)\s+(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @format,@text,@ocn='_1*',$1,$2,$3
          elsif @para[/^(_\*)\s+(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @format,@text,@ocn=$1,$2,$3
          elsif  @para[/<:(i[12])>\s*(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @format,@text,@ocn=$1,$2,$3
          elsif @para[/<:(code|alt|poem|group)>(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @format,@text,@ocn=$1,$2,$3
          elsif @para[/(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im]
            @text,@ocn=$1,$2 #,$3
          end
          if @para !~/<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>|^$/ #added 2002w06
            @text=@para[/(.+?)/im,1]
          end
          if @para[/^(\d)~(?:\S+)?\s+(.+)/im]
            @format,@text=$1,$2
          end
        end
        @seg_lev_para_ocn=if @para[/.+<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/]
          SiSU_HTML_Format_type::Format_seg.new(@md,@format,@text,@ocn)
        end
        @scroll_lev_para_ocn=if @para[/.+<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/]
          SiSU_HTML_Format_type::Format_scroll.new(@md,@format,@text,@ocn)
        end
        self
      end
    end
    class Links_guide
      @links_guide_toc=Array.new
      def initialize(data,md)
        @data,@md=data,md
      end
      def doc_versions
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        @doc_versions_toc=format_head_toc.document_versions_toc
      end
      def toc
        @links_guide_toc=Array.new
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        guide_type='horzontal' #values: horizontal or vertical
        @links_guide_toc << format_head_toc.links_guide_open(guide_type)
        if defined? @md.lnk and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=if l[:url] !~/^\.(\.)?\//: 'external'
              else                              '_top'
              end
              s_lnk_url,s_lnk_lnk=l[:url],l[:say]
              lev_para_ocn=SiSU_HTML_Format_type::Format_toc.new(@md,s_lnk_url,s_lnk_lnk,target)
              @links_guide_toc << lev_para_ocn.links_guide if s_lnk_lnk
            end
          end
        end
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        @links_guide_toc << format_head_toc.links_guide_close #(guide_type)
        @links_guide_toc
      end
    end
    class Endnotes
      include SiSU_Param
      include SiSU_HTML_Format_type
      def initialize(data,md)
        @data,@md=data,md
      end
      def scroll #v2003w31
        @scr_endnotes=Array.new
        format_head_scroll=SiSU_HTML_Format_type::Head_scroll.new(@md)
        @scr_endnotes << format_head_scroll.title_endnote
        @data.each do |para|
          pg=para.dup
          if pg =~/~\{\d+ <a name="_\d+"/
            endnote_array=pg.scan(/~\{\d+(.+?)\}\~/m) #changed 2005
            endnote_array.each do |note| 
              format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,note) 
              @scr_endnotes << format_scroll.endnote_body
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc <Links_guide
      @@toc=Hash.new
      @@toc[:seg],@@toc[:scr]=Array.new,Array.new
      @@seg_url=''
      @@firstseg=nil
      def initialize(data='',md=nil)
        @data,@md=data,md
        @fns=md.fns
        @url=SiSU_Viz::Url.new
        @png=SiSU_Viz::Png.new
        @table=SiSU_Viz::Table.new
        @font=SiSU_Viz::Font.new
        @pat_heading=/(?:[1-6]~(?:\S+)?)?(.*)<~(\d+);(?:[hm]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/
        @pat_strip_heading_name=/<a name="h?\d.*?">(.+?)<\/a>/i
        @tell=SiSU_Screen::Ansi.new(@md.cf)
      end
      def songsheet #extracts toc for scroll & seg
        tell=SiSU_Screen::Ansi.new(@md.cf,"Toc")
        tell.txt_grey unless @md.cf =~/q/
        toc=nil
        @@firstseg=nil
        @data.each do |para|
          if para =~/^\s*([1-6]~|4~!)/ #simplify, remove [!{]? but beware of many knockon effects  
            para_toc=para.dup
            para_toc.gsub!(/&nbsp;<a name="-\d+" href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;<\/a>\s+~\{.+?\}~/m,'') #remove endnotes from toc
            toc=case para_toc
            when /^\s*1~(\S+)?/: Toc.new(para_toc,@md).level_1
            when /^\s*2~(\S+)?/: Toc.new(para_toc,@md).level_2
            when /^\s*3~(\S+)?/: Toc.new(para_toc,@md).level_3
            when /^\s*4~(\S+)?/: Toc.new(para_toc,@md).level_4 
            when /^\s*5~(\S+)?/: Toc.new(para_toc,@md).level_5
            when /^\s*6~(\S+)?/: Toc.new(para_toc,@md).level_6
            when /^\s*4~!/:       Toc.new(para_toc).level_crosslink
            else
            end
            if @@firstseg.nil? and para=~/4~\S+?/
              @@firstseg=/4~(\S+)?/.match(para)[1]
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg] if toc[:seg]
                @@toc[:scr] << toc[:scr] if toc[:scr]
              rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
              end
            end
          end
        end
        @md.firstseg=@@firstseg
        @@toc
      end
    protected
      def rss #sort all wrong, disabled but kept
        @@toc[:seg] <<<<WOK
<center>
<table><tr><td>
<p><font color="#222222" #{@font.face} size="2">
(relatively static) RSS feeds for DOCUMENTS:<br />
<a href="../rssfeed/documents.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/documents.xml<br />
<a href="../rssfeed/tradelaw.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/tradelaw.xml<br />
<a href="../rssfeed/environmental.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/environmental.xml<br />
<center><a href="mailto:info@address.com" target="_top">info@address.com</a></center>
</font></p>
</td></tr></table>
WOK
      end
      def level_doc_owner_details
        if @md.stmp =~/\w\w/
          format_head_scroll=SiSU_HTML_Format_type::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_owner_details
        end
      end
      def level_endnotes
        if @md.flag_endnotes
          format_head_scroll=SiSU_HTML_Format_type::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_endnote
        end
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        @@toc[:scr] << format_head_toc.metadata
        @@toc[:seg] << format_head_toc.seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@d0c)
        @@toc[:scr] << format_head_toc.wordmap
        @@toc[:seg] << format_head_toc.wordmap
      end
      def level_1
        para=@data
        unless para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(@pat_strip_heading_name,"\\1")
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/ #% keep eye on link
        title=unless para =~/Document Information/: linkname
        else
          link="metadata"
          %{<b><a href="#{@md.fnl[:pre]}#{link}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}">#{linkname}</a></b>}
        end
        toc=Hash.new
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:seg]=format_toc.lev1
        title=if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
          linkname
        else #if para =~/Document Information/
          @@toc[:scr] <<  '<br />'
          link='docinfo'
          %{<b><a href="##{link}">#{linkname}</a></b>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev1
        toc
      end
      def level_2
        para=@data
        unless para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(@pat_strip_heading_name,"\\1")
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,linkname)
        toc=Hash.new
        toc[:seg]=format_toc.lev2
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
          title=linkname
        else title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev2
        toc
      end
      def level_3
        para=@data
        para.gsub!(@pat_strip_heading_name,"\\1")
        para.gsub(/(.*?)<a name="(\d+)"><\/a>(.*)/i,"\\1") #2002w42 altered gsub! - problematic? - suspect
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,linkname)
        toc=Hash.new
        toc[:seg]=format_toc.lev3
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
          title=linkname
        else title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev3
        toc
      end
      def level_4
        para=@data
        unless para =~/~metadata/
          unless para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
            para.gsub!(@pat_strip_heading_name,"\\1")
            para[@pat_heading]
            linkname,link=$1,$2 if $&
            p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link
          end
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
          if para =~/^4~/
            seg_link=para.gsub(/^\s*4~(\S+)\s+(.+?)$/i,
              %{  <a href="#{@md.fnl[:pre]}\\1#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}" target="_top">
    \\2
  </a> })
            @@seg_url=para[/^\s*4~(\S+).+?$/i,1]
          elsif para =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
            seg_link=para.gsub(/^\s*(#{@md.lv4}\s+)\s*(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/i,
              %{<a href="#{@md.fnl[:pre]}\\2#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}" } +
              %{target="_top">\\1 \\2 \\3</a> })
          end
          p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,seg_link)
          toc=Hash.new
          toc[:seg]=format_toc.lev4
          if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
            para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
            title=linkname
          else title=%{#{p_num.goto}#{linkname}</a>} if p_num
          end
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
          toc[:scr]=format_toc.lev4
          toc
        end
      end
      def level_5
        para=@data
        if para !~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(@pat_strip_heading_name,"\\1")
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        toc=Hash.new
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}##{link}">
    #{linkname}
  </a>}
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,lnk_n_txt)
          toc[:seg]=format_toc.lev5
          title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev5
        toc
      end
      def level_6
        para=@data
        if para !~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:\w{32}>/
          para.gsub!(@pat_strip_heading_name,"\\1")
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        toc=Hash.new
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}##{link}">
    #{linkname}
  </a>}
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,lnk_n_txt)
          toc[:seg]=format_toc.lev6
          title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev6
        toc
      end
      def level_crosslink
        para=@data
        if para !~/4~!/ #simplify, remove [!{]? but beware of many knockon effects
          para.gsub!(/4~!\s+(\S+)\s+(.+)/i,
            %{<table><tr><td width =\"80\"></td>
  <td><a href="http://\\1" target="external">
    #{@png.crosslink_ext}
      &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        else
          para.gsub!(/4~!\s+(\S+)\s+(.+)/i,
            %{<table><tr><td width ="80">
  </td><td>
    <a href="\\1" target="_top">
      #{@png.crosslink}
        &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        end
      end
    end
    class Scroll_head_and_segtoc < Toc
      def initialize(data,md='',toc='',links_guide_toc='',doc_versions_toc='')
        @data,@md,@toc,@links_guide_toc,@doc_versions_toc=data,md,toc,links_guide_toc,doc_versions_toc
        @txt=SiSU_Viz::Txt.new
        @url=SiSU_Viz::Url.new
        @table=SiSU_Viz::Table.new
      end
      def in_common
        toc_shared=Array.new
        @segtoc=Array.new
        tell=SiSU_Screen::Ansi.new(@md.cf,'Scroll & Segtoc')
        tell.txt_grey unless @md.cf =~/q/
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        dochead=format_head_toc.head
        dochead.gsub!(/toc\.(html|php)/,"doc.\\1") #kludge
        toc_shared << dochead
        @segtoc << format_head_toc.head
        toc_shared << format_head_toc.toc_head_escript if SiSU_HTML_Format_type::Head_toc.method_defined? :toc_head_escript #debug PHP
        @segtoc << format_head_toc.toc_head_escript if SiSU_HTML_Format_type::Head_toc.method_defined? :toc_head_escript #debug PHP
        toc_shared << format_head_toc.scroll_head_navigation_band
        if @md.dc_rights
          rights=format_head_toc.rights 
          rights=SiSU_Tune::Clean_html.new(rights).clean
        end
        if @md.prefix_b
          prefix_b=format_head_toc.prefix_b
          prefix_b=SiSU_Tune::Clean_html.new(prefix_b).clean
        end
        @seg_toc_band=format_head_toc.seg_head_navigation_band('pdf') #bug, vary depending on type of doc !! examine
        @segtoc << @seg_toc_band
        toc_shared << format_head_toc.scroll_head_title_banner_open
        @segtoc << format_head_toc.seg_head_title_banner_open
        tmp_head=nil
        doc_title_endnote=@md.title.gsub(/(\*+)/,%{<sup><a href="#endnotes">\\1</a></sup>})
        tmp_head="#{doc_title_endnote}\n"
          format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
        toc_shared << format_txt_obj.center_bold
        @segtoc << format_txt_obj.center_bold
        if not @md.subtitle.nil? and not @md.subtitle.empty?
          tmp_head="#{@md.subtitle}\n"
          format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        if @md.dc_creator
          creator_endnote=@md.dc_creator.gsub(/(\*+)/,%{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          creator_endnote=%{<sup>&copy;</sup> #{creator_endnote}} if creator_endnote =~/\S/
          tmp_head="#{creator_endnote}"
          format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        tmp_head=format_head_toc.copyat
        format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
        toc_shared << format_txt_obj.toc_head_copy_at 
        @segtoc << format_txt_obj.toc_head_copy_at
        tmp_head=nil
        tmp_head="#{@table.close*4}\n"
        toc_shared << tmp_head.dup
        @segtoc << tmp_head.dup
        tmp_head=nil
        if @md.prefix_a
          tmp_head ||= %{<p />#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          @segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @doc_versions_toc
        toc_shared << @links_guide_toc
        #toc_shared << Links_guide.new.toc
        toc_shared << rights if @md.dc_rights
        toc_shared << prefix_b if @md.prefix_b
        #Table of Contents added/apended here
        toc_shared << @toc[:scr]
        @segtoc << @doc_versions_toc
        @segtoc << @links_guide_toc
        @segtoc << @toc[:seg]
        @segtoc << rights if @md.dc_rights
        @segtoc << prefix_b if @md.prefix_b
        #Segtoc tail added here
        ###DEBUGNOW
        @segtoc << "</p>\n" #bugfix sort later
        @segtoc << @seg_toc_band
        @segtoc << format_head_toc.seg_navigation_tail
        #puts @segtoc
        Output.new(@segtoc.to_s,@md).segtoc
        @segtoc=Array.new
        #% bug necessary figure out why (see ensure) ->
        @toc[:scr]=Array.new
        @toc[:seg]=Array.new
        toc_shared
      end
    end
    class Table
      @@tablehead=0
      @@tablefoot=Array.new #watch
      def initialize(one)
        @one,@parablock,@margin,@paragraph,@table=one,one,SiSU_Viz::Margin.new,SiSU_Viz::Paragraph.new,SiSU_Viz::Table.new
      end
      def table_head(inf)
        %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
  <tr>
    <td valign="top" align="justify">
      <p class="norm" id="o#{inf}"><a name="#{inf}"></a></p>
    </td>
    <td>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">}
      end
      def table_end(tablefoot='')
        %{</table>#{@margin.num}#{@margin.num}&nbsp;#{@table.close}
#{tablefoot}}
      end
      def table_row(inf,h=false)
        bold=if h: '<b>'
        else       ''
        end
        %{
<tr>
  <td width="#{inf}%" valign="top">#{@paragraph.table}#{bold}}
      end
      def table_cell(inf,h=false)
        if h: %{</b></font></td><td width="#{inf}%" valign="top">#{@paragraph.table}<b>}
        else  %{</font></td><td width="#{inf}%" valign="top">#{@paragraph.table}}
        end
      end
      def table_row_close(h=false)
        bold_close=if h: '</b>'
        else             ''
        end
        "#{bold_close}</font></td></tr>"
      end
      def table
        m=@parablock[/<!f(.+?)!>/,1]
        @@tablefoot << m if m 
        @parablock.gsub!(/<!f.+?!>/,'')
        @@tablehead=1 if @parablock =~/<!Th¡/i
        if @parablock =~/<!Th?¡.+?!~(\d+);\w\d+;\w\d+>/: @parablock=table_head($1)
        end
        if @parablock =~/<!TZ!>/
          tablefoot=Array.new
          @@tablefoot.each {|x| tablefoot << ''}
          @@tablefoot=Array.new
          if @parablock =~/<!TZ!>/: @parablock=table_end
          end
        end
        if @@tablehead == 1
          if @parablock =~/¡¡/
            if @parablock =~/<!¡¡(\d+?)¡/
              @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1,true))
            end
            if @parablock =~/¡¡(\d+?)¡/ 
              @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1,true))
            end
            if @parablock =~/!>/
              @parablock.gsub!(/!>/,table_row_close(true))
            end
            @@tablehead=0
          end
          @parablock
        else
          if @parablock =~/<!¡¡(\d+?)¡/
            @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1))
          end
          if @parablock =~/¡¡(\d+?)¡/
            @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1))
          end
          if @parablock =~/!>/
            @parablock.gsub!(/!>/,table_row_close)
          end
          @parablock
        end
        @parablock
      end
      def table_split
        @new_content=Array.new
        @one.split(/\n/).each do |parablock|
          table=Table.new("#{parablock}\n")
          @new_content << table.table
        end
        @new_content.join
      end
    end
    class Scroll < Scroll_head_and_segtoc 
      def initialize(data='',md='')
        @data,@md=data,md
        @margin=SiSU_Viz::Margin.new
      end
      def songsheet
        begin
          scr=Scroll.new(@data,@md).markup
          scr[:tails]=Scroll.new('',@md).tails
          scr
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
        ensure
        end
      end
    protected
      def markup
        data=@data
        @rcdc=false
        @scr=Hash.new
        @scr[:body]=Array.new
        @scr[:metadata]=Array.new
        @scr[:owner_details]=Array.new
        data.each do |para|
          if para =~/Document Information/
            para.gsub!(/(Document Information)/, "\\1<a name=\"docinfo\"></a>")
          end
          if para =~/MetaData/
            para.gsub!(/(MetaData)/, "\\1<a name=\"metadata\"></a>")
          end
          @rcdc=true if @rcdc==false and (para =~/~metadata/ or para =~/1~\s+Document Information/)
          if para !~/(^0~|<ENDNOTES>|<EOF>)/ 
            para.gsub!(/~\{.+?\}~\s+/m,' ') #2003w31
            if para =~/.+?<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/
              paranum=para[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/,1]
              @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
            end
            @sto=Split_text_object.new(@md,para).lev_segname_para_ocn
            unless @rcdc
              m=/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
              if para =~m
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,@sto.text) if @sto.format =~/i[12]|_1?\*|<!i[12]!>\s*_\*|null/
                case @sto.format
                when /^1~(?:\S+)?/: para=@sto.scroll_lev_para_ocn.heading_body1
                when /^2~(?:\S+)?/: para=@sto.scroll_lev_para_ocn.heading_body2
                when /^3~(?:\S+)?/: para=@sto.scroll_lev_para_ocn.heading_body3
                when /^4~\S+/:      para=@sto.scroll_lev_para_ocn.heading_body4 # work on see Split_text_object4
                when /^5~(?:\S+)?/: para=@sto.scroll_lev_para_ocn.heading_body5
                when /^6~(?:\S+)?/: para=@sto.scroll_lev_para_ocn.heading_body6
                when /^_\*$/:       para=@sto.scroll_lev_para_ocn.bullet
                when /^_1\*$/
                  format_txt_obj.gsub_body
                  para=@sto.scroll_lev_para_ocn.bullet_indent1
                when /^_2\*$/
                  format_txt_obj.gsub_body
                  para=@sto.scroll_lev_para_ocn.bullet_indent2
                when /^i1$/i
                  format_txt_obj.gsub_body
                  para=@sto.scroll_lev_para_ocn.indent1
                when /^i2$/i
                  format_txt_obj.gsub_body
                  para=@sto.scroll_lev_para_ocn.indent2
                when /^center$/i:             para=@sto.scroll_lev_para_ocn.center
                when /^(?:b|bold)$/i:         para=@sto.scroll_lev_para_ocn.bold
                when /^(?:poem|group|alt)$/i: para=@sto.scroll_lev_para_ocn.para
                when /^code$/i:               para=@sto.scroll_lev_para_ocn.code
                when /null/ # see whether u can improve
                  if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                    format_txt_obj.gsub_body
                    para=@sto.scroll_lev_para_ocn.para
                    if para =~/<!Th?.+/i # tables come as single block
                      table=Table.new(para)
                      para=table.table_split
                    end
                  end
                end
              elsif para =~/Endnotes?/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="notes">Note</a>')
                para=format_txt_obj.bold_para
              elsif para =~/Owner Details/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="owner.details">Owner Details</a>')
                @scr[:owner_details]=format_txt_obj.bold_para
                para=''
              elsif para =~/(.*)<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>(.*)/i #watch
                one,two=$1,$2
                format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
                para=format_seg.no_paranum
              end
              para=para.gsub(/ [2-6]~\S+ /,'') #and @md.cf =~/[VM]/ #arbitrary, watch problematic as too general
              para='' if (para =~/<a name="n\d+">/ and para =~/^(?:\^~\d+\s|<!e[:_]\d+!>)/) # hmmm re-adjusted 200507, for alt endnote which should again be matched ^~ ... not in response to problem though
              if para =~/<:center>/i #rules changed now a <p class="center" problems may arise 2005w11 !
                one,two=/(.*)<:center>(.*)/i.match(para).captures
                format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two)
                para=format_scroll.center #changes probably cause problem 2005w11 !
              end
            else # this is crazy rethink and redo later with some form of inject
              m=/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
              if para =~m
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,@sto.text) if @sto.format =~/i[12]|null/
                meta=case @sto.format
                when /^1~/:    @sto.scroll_lev_para_ocn.heading_body1
                when /^2~/:    @sto.scroll_lev_para_ocn.heading_body2
                when /^3~/:    @sto.scroll_lev_para_ocn.heading_body3
                when /^4~\S+/: @sto.scroll_lev_para_ocn.heading_body4 # work on see Split_text_object
                when /^5~/:    @sto.scroll_lev_para_ocn.heading_body5
                when /^6~/:    @sto.scroll_lev_para_ocn.heading_body6
                when /^i1$/i
                  format_txt_obj.gsub_body
                  @sto.scroll_lev_para_ocn.indent1
                when /^i2$/i
                  format_txt_obj.gsub_body
                  @sto.scroll_lev_para_ocn.indent2
                when /^center$/i:   @sto.scroll_lev_para_ocn.center
                when /^(b|bold)$/i: @sto.scroll_lev_para_ocn.bold
                when /null/ # see whether u can improve
                  if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                    format_txt_obj.gsub_body
                    @sto.scroll_lev_para_ocn.para
                    if para =~/<!Th?.+/i # tables come as single block
                      table=Table.new(para)
                      para=table.table_split
                    end
                  end
                end
              elsif para =~/(Endnotes?)/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="notes">Note</a>')
                meta=format_txt_obj.bold_para
              elsif para =~/MetaData/ and para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/ #debug 2003w46 add rc info
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="metadata">MetaData</a>')
                meta=format_txt_obj.bold_para
              elsif para =~/Owner Details/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="owner.details">Owner Details</a>')
                @scr[:owner_details]=format_txt_obj.bold_para
                meta=''
              elsif para =~/(¡|<!Th?)/mi
                table=Table.new(para)
                para=table.table
              elsif para =~/(.*)<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>(.*)/i #ok - bug in equiv for seg 2004w46
                one,two=$1,$2
                format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two) #watch #fix
                meta=format_scroll.no_paranum
              end
              meta='' if (para =~/<a name="n\d+">/ and para =~/^(\^~\d+ |<!e[:_]\d+!>)/) # -endnote
              if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                case para
                when /<:i1>/
                  gsub(/<:i1>/,'')
                  format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,para)
                  meta=format_scroll.indent_one_no_paranum
                when /<:i2>/
                  gsub(/<:i2>/,'')
                  format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,para)
                  meta=format_scroll.indent_one_no_paranum
                end
              end
              if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
              end
              if para =~/<:center>/i
                one,two=/(.*)<:center>(.*)/i.match(para).captures
                format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two)
                meta=format_scroll.center
              end
            end
            para.gsub!(/<!.+!>/i,' ') ## Clean Prepared Text
            para.gsub!(/^<:\S?>/i,'') ## Clean Prepared Text
            para.gsub!(/<:\S?>/i,' ') ## Clean Prepared Text
            unless meta: @scr[:body] << para
            else         @scr[:metadata] << meta
            end
          end
        end
        @scr
      end
      def tails
        scr_tail=Array.new
        format_head_scroll=SiSU_HTML_Format_type::Head_toc.new(@md)
        scr_tail  << format_head_scroll.scroll_tail
        scr_tail
      end
    end
    class Scroll_output
      def initialize(scr_toc,scr_body,scr_endnotes,scr_metadata,scr_owner_details,scr_tails,doc)
        @scr_toc,@scr_body,@scr_endnotes,@scr_metadata,@scr_owner_details,@scr_tails,@md=scr_toc,scr_body,scr_endnotes,scr_metadata,scr_owner_details,scr_tails,doc
      end
      def publish
        scroll=Array.new
        scroll << @scr_toc
        scroll << @scr_body
        scroll << @scr_endnotes
        scroll << @scr_metadata
        scroll << @scr_owner_details
        scroll << @scr_tails
        scroll.to_s
      end
    end
    class Seg
      @@seg,@@seg_subtoc,@@seg_endnotes,@@seg_ad=Hash.new,Hash.new,Hash.new,Hash.new
      @@seg_name,@@seg_name_html,@@seg_name_php,@@segtocband=Array.new,Array.new,Array.new,Array.new
      @@filename_seg=@@filename_segphp=@@seg_url=@@fn=@@to_lev4=@@get_hash_to=@@get_hash_fn=''
      @@loop_count=@@seg_total=@@tracker=0
      @@is4=@@is3=@@is2=@@is1=0
      @@header1=@@header2=@@header3=@@header4=0
      @@seg[:table_top_control],@@seg[:tocband],@@seg[:title],@@seg[:headers],@@seg[:main],@@seg[:tail],@@seg[:credits],@@seg_subtoc_array,@@seg_endnotes_array,@@heading_endnotes_array,@@seg[:endnote_all]=Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new
      @@seg[:header_endnotes]=''
      @@tablehead,@@number_of_cols=0,0
      @@flag_group=false
      attr_reader :seg_name_html,:seg_name_html_tracker
      def initialize(data='',md='')
        @data,@md=data,md
        @url=SiSU_Viz::Url.new
        @banner=SiSU_Viz::Banner.new
        @margin=SiSU_Viz::Margin.new
        @seg_name_html=@@seg_name_html || nil
        @seg_name_html_tracker=@@tracker || nil
      end
      def songsheet
        begin
          Seg.new(@data,@md).get_subtoc_endnotes
          Seg.new(@data,@md).articles
          Seg.new.cleanup # (((( added ))))
          #### (((( END )))) ####
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
        ensure
          @@seg_name=Array.new
        end
      end
    protected
      def articles
        data=@data
        track,tracking,newfile=0,0,0
        @@is4=@@is3=@@is2=@@is1=0
        printed_endnote_seg='n'
        @h_sfx='.php' if @md.file_type =~/php/
        @h_sfx=@md.sfx if @md.file_type =~/html/
        @h_sfx='.html' if @md.file_type =~/html/ #used in creating file, not to be omitted.
        data.each do |para|
          if para =~/^\s*4~/i
            @@seg_name << para[/^4~(\S+)/i,1]
            seg_name=para[/^4~(\S+)/i,1]
            @@seg_ad[seg_name]=para[/.+?<:\d\s+(.+)\s*?>/i,1] #watch
          end
        end
        @@seg_name_html=@@seg_name
        @@seg_total=@@seg_name.length
        testforartnum=@@seg_name_html
        tell=SiSU_Screen::Ansi.new(@md.cf,@@seg_name.length)
        tell.segmented unless @md.cf =~/q/
        flagend='y'
        data.each do |para|
          if para =~/^4~.+/ #watch
            if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
              @@header4=para.to_s[/^4~(?:\S+\s+)?(.+?)<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i, 1]
            else @@header4=para.to_s[/^4~(?:\S+\s+)?(.+)/i,1]
            end
            @@is4=newfile=1
          end
          if para =~/^3~.+/
            @@header3=para.to_s[/^3~(?:~\S+\s+)?(.+)/i,1]
            @@is4,@@is3=0,1
          end
          if para =~/^2~.+/
            @@header2=para.to_s[/^2~(?:~\S+\s+)?(.+)/i,1]
            @@is4,@@is3,@@is2=0,0,1
          end
          if para =~/^1~.+/
            @@header1=para.to_s[/^1~(?:~\S+\s+)?(.+)/i,1]
            @@is4,@@is3,@@is2,@@is1=0,0,0,1
          end
          if (@@is1 && !@@is2 && !@@is3 && !@@is4)
            unless para =~/^1~/: head1=$_ #;
            end
          end
          if @@is4 == 1 or para =~/<ENDNOTES>|<EOF>/
            if newfile == 1 or para =~/<ENDNOTES>|<EOF>/
              newfile=0
              if para =~/^4~\S+/ or para =~/<ENDNOTES>|<EOF>/ # @@level4
                if tracking != 0
                  #complicated in 2003w46 (apparently by insertion of endnotes where they exist before metadata)
                  #great simplifications made 2004w35 but must watch
                    File.mkpath(@md.dir_out) unless FileTest.directory?(@md.dir_out) #bug - added specifically for nav! not needed by regular seg, check !!!
                    Seg.new('',@md).tail
                    segfilename="#{@md.dir_out}/#{@md.fnl[:pre]}#{@@seg_name_html[tracking-1]}#{@md.fnl[:mid]}#@h_sfx#{@md.fnl[:post]}"
                    @@filename_seg=File.new(segfilename,'w') if @@seg_name_html[tracking-1]
                    unless (@@seg_name_html[tracking-1] =~/endnotes/)
                      Seg.new.output
                    else Seg.new.output('endnotes')
                    end
                  Seg.new.reinitialise
                  Seg.new(para,@md).header_art
                  Seg.new(para,@md).head
                  if @@seg_name_html[tracking] =~/metadata/
                    #### this is for metadata
                    segfilename="#{@md.dir_out}/#{@md.fnl[:pre]}#{@@seg_name_html[tracking]}#{@md.fnl[:mid]}#@h_sfx#{@md.fnl[:post]}"
                    @@filename_seg=File.new(segfilename,'w')
                    Seg.new.reinitialise
                    flagend="x"
                                                                                 #%(((( EOF )))) -->
                    @@filename_seg.close
                  end
                end
                if  tracking == 0
                  Seg.new(para,@md).header_art
                  Seg.new(para,@md).head
                end
              end
              tracking=tracking + 1
            end
            m=para[/.+?<a name="(\d+)">.*/i]; @@get_hash_to=$1 if m              # changed 2002w42, again w44 ! & again 2003w16
            m=para[/^4~(\S+)/i]; @@get_hash_fn=$1 if m
            if testforartnum[tracking-1] !~/endnote/
              Seg.new(para,@md).markup
              Seg.new(para,@md).txt
            else
              Seg.new(para,@md).markup
              Seg.new(para,@md).txt
              if printed_endnote_seg == 'n'
                Seg.new(para,@md).endnote
                printed_endnote_seg='y'
              end
            end
          end
        end
      end
      def header_art
        @data.each do |para|
          format_head_seg=SiSU_HTML_Format_type::Head_seg.new(@md)
          if para =~/[0-6]~/ #2004w27/5
            if @@tracker < @@seg_total-1: @@seg[:table_top_control] << format_head_seg.dot_control_pre_next
            else                          @@seg[:table_top_control] << format_head_seg.dot_control_pre
            end
          end
          @@seg[:title]=format_head_seg.head
        end
      end
      def head
        data=@data
        clean=/<(?:!.*?!|:.*?|~\d+;(?:[ohum]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32})>/
        format_head_seg=SiSU_HTML_Format_type::Head_seg.new(@md)
        unless @md.flag_pdf
          if @@tracker < @@seg_total-1
            if @@tracker == 0: @@segtocband << format_head_seg.toc_next3
            else               @@segtocband << format_head_seg.toc_pre_next3
            end
          elsif @@tracker == @@seg_total
            @@segtocband << format_head_seg.toc_pre3
          end
        else  # identical code without .pdf
          if @@tracker < @@seg_total-1
            if @@tracker == 0: @@segtocband << format_head_seg.toc_next2
            else               @@segtocband << format_head_seg.toc_pre_next2
            end
          else @@segtocband << format_head_seg.toc_pre2
          end
        end
        @p_num ||= ''
        if @@is1 == 1
          @dc_creator=%{<b><sup>&copy;</sup>&nbsp;#{@md.dc_creator}</b>\n} if @md.dc_creator.to_s =~/\S/
          @@seg[:tocband] << format_head_seg.navigation_band(@@segtocband,@@seg[:table_top_control])
          @@seg[:headers] << format_head_seg.seg_head_escript if SiSU_HTML_Format_type::Head_seg.method_defined? :seg_head_escript #debug PHP move up in text #bug
          @@seg[:headers] << format_head_seg.title_banner(@md.title,@md.subtitle,@dc_creator).gsub(clean,'')
          paranum=if @@header1[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/]: $1
          else ''
          end
          @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
          format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,@@header1,@p_num.ocn_display)
          @@seg[:headers] << format_seg.title_header1.gsub(clean,'')
          @@header1.gsub!(/&nbsp;<a name="-\d+" href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;<\/a>/,'')
        end
        if @@is2 == 1
          header2=@@header2
          paranum=if header2[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/]: $1
          else ''
          end
          @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
          format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,header2,@p_num.ocn_display)
          @@seg[:headers] << format_seg.title_header2.gsub(clean,'')
          @@header2.gsub!(/&nbsp;<a name="-\d+" href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;<\/a>/,'')
        end
        if @@is3 == 1
          header3=@@header3
          paranum=if header3[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/]: $1
          else ''
          end
          @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
          format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,header3,@p_num.ocn_display)
          @@seg[:headers] << format_seg.title_header3.gsub(clean,'')
          @@header3.gsub!(/&nbsp;<a name="-\d+" href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;<\/a>/,'')
        end
        if @@is4 == 1
          header4=@@header4
          paranum=if header4[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/]: $1
          else ''
          end
          @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
          format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,header4,@p_num.ocn_display)
          @@seg[:headers] << format_seg.title_header4.gsub(clean,'')
        end
        @@seg[:headers] << %{#{@@seg[:table_top_control]}}
        @@seg[:header_endnotes]=format_head_seg.title_endnote(@md.title,@md.subtitle,@dc_creator,@@seg[:table_top_control])
        @@tracker=@@tracker+1
      end
      def markup
        @debug=Array.new
        data=@data.dup #bugwatch tied
        @group_collect=Array.new
        data.each do |para|
          format_head_seg=SiSU_HTML_Format_type::Head_seg.new(@md)
          if para !~/^0~/
            m=para[/.+?<~(\d+);(?:[ohm]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/]
            if m
              paranum=m[1].to_s
              @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
            end
            if para =~/<:(?:code|alt|poem|group)>/i or @@flag_group==true
              if para =~/<:(?:code|alt|poem|group)>/i 
                @group_collect << @margin.txt_0 + para
                @@flag_group=true
              elsif @@flag_group==true
                unless para =~/<:(?:code|alt|poem|group)-end>/i                  # neither ideal nor necessary sort later
                  @group_collect << para 
                else @group_collect << para.gsub(/<:(?:code|alt|poem|group)-end>/i,'')
                end
              end
              if para =~/<:(?:code|alt|poem|group)-end>/i
                para = @group_collect.join
                @@flag_group=false
                @group_collect=Array.new
              end
            end
            if para !~/^[0-9]~/
              if para =~/(.*)<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>(.*)/i 
                #one,two=para[/(.*)<~0;\w\d+;\w\d+>(.*)/]
                one,two=$1,$2
                format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
                para=format_seg.no_paranum
              end
            end
            if para[/<~(\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32})>/]
              @sto=Split_text_object.new(@md,para).lev_segname_para_ocn
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,@sto.text) if @sto.format =~/i[12]|_1?\*|<:i[12]>\s*_\*|null/
              para=case @sto.format # work area 2003w29 ||@|def lev_segname_para_ocn|
              when /^4~\S+/:       @sto.seg_lev_para_ocn.header4 # work on see Split_text_object
              when /^5~(?:~\S+)?/: @sto.seg_lev_para_ocn.header5
              when /^6~(?:~\S+)?/: @sto.seg_lev_para_ocn.header6
              when /^_\*$/:        @sto.seg_lev_para_ocn.bullet
              when /^_1\*$/
                format_txt_obj.gsub_body
                @sto.seg_lev_para_ocn.bullet_indent1
              when /^i1$/i
                format_txt_obj.gsub_body
                @sto.seg_lev_para_ocn.indent1
              when /^i2$/i
                format_txt_obj.gsub_body
                @sto.seg_lev_para_ocn.indent2
              when /^(?:poem|group|alt)$/
                @sto.seg_lev_para_ocn.para
              when /^code$/i
                @sto.seg_lev_para_ocn.code
              when /null/
                if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/ and para !~/^<!TZ!>/
                  format_txt_obj.gsub_body
                  @sto.seg_lev_para_ocn.para
                elsif para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/ and para =~/^<!TZ!>/
                  format_txt_obj.gsub_body
                  @sto.seg_lev_para_ocn.table_end
                else para
                end
              else para
              end
            elsif para =~/¡|<!T[hZ]?/i
              table=Table.new(para)
              para=table.table
            end
            if @md.flag_separate_endnotes
              para.gsub!(/"\s+href="#_(\d+)">/i, %{" href=\"endnotes#{@md.sfx}#_\\1">})       #endnote- twice #removed file type
            end
            if para !~/#{@margin.txt_w1}|#{@margin.txt_w2}/i
              if para[/(.*)<~0;(?:u|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>(.*)/i] #% watch u & m?
                #is error
                one,two=$1,$2
                format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
                para=format_seg.seg_no_paranum                                   #% undefined
              end
              para.gsub!(/\s*(-\{{2}~\d+|<:e[:_]\d+>).*/i,'')                   #potentially dagerous - removes all paragraphs with <!e_!> #?? workpoint
              if para =~/<a name="_\d+" href="#-\d+">&nbsp;<sup>/                #endnote- note-
                format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,para)
                para=format_seg.no_paranum
              end
            end
            if para =~/4~\S+|4~!/ 
              para.gsub!(/4~\S+|<:[-_\w\d]?(-.+?-)?>|4~!.+/,'')              #sort seg headers
              @@seg[:main] << para 
              @@seg[:main] << @@seg_subtoc[@@get_hash_fn]                       #% insertion of sub-toc
            else
              para.gsub!(/<:[-_\w\d]?(-.+?-)?>|4~!.+/,'')
              @@seg[:main] << para unless @@flag_group==true
            end
          end
        end
      end
      def txt
      end
      def endnote
      end
      def tail
        format_head_seg=SiSU_HTML_Format_type::Head_seg.new(@md)
        if @md.flag_auto_endnotes
          @@seg[:tail] << format_head_seg.endnote_mark
          @@seg[:tail] << @@seg_endnotes[@@get_hash_fn] #endnotes deposited at end of individual segments||@|EXTRACTION OF ENDNOTES|
        end
        @@seg[:tail] << %{<table summary="whitespace"><tr><td>&nbsp;</td></tr></table>}
        @@seg[:credits] << format_head_seg.credit
      end
      def output(type='')
        if @@seg[:title] =~/\S/ #kludge (for exception file better.ways, how ironic) get a real ruby test, e.g. test that not array or... 
          @@filename_seg << @@seg[:title] 
          @@filename_seg << @@seg[:table_top_control]
          @@filename_seg << @@seg[:tocband]
          if type !~/endnote/
            @@filename_seg << @@seg[:headers]
            @@filename_seg << @@seg[:main]
          else
            @@filename_seg << @@seg[:header_endnotes]
            @@filename_seg << @@seg[:endnote_all]
          end
          @@filename_seg << @@seg[:tail]
          @@filename_seg << @@seg[:tocband]
          @@filename_seg << @@seg[:credits]
          @@filename_seg.close
        end
      end
      def reinitialise
        @@seg[:title],@@seg[:table_top_control],@@segtocband,@@seg[:tocband],@@seg[:headers],@@seg[:main],@@seg[:tail],@@seg[:credits]=Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new,Array.new
      end
      def cleanup
        reinitialise
        @@seg_total,@@tracker=0,0
        @@seg_endnotes,@@seg_subtoc=Hash.new,Hash.new
        @@seg_endnotes_array,@@seg_subtoc_array,@@heading_endnotes_array=Array.new,Array.new,Array.new
        @@seg[:endnote_all]=Array.new
      end
      def get_subtoc_endnotes #get endnotes & sub-table of contents subtoc
        @data.each do |para|
          para.gsub!(/<a name=\"h\d.*?\">(.+?)<\/a>/mi,"\\1")
          if @md.flag_auto_endnotes
            if para =~/^[123]~/                                         #% EXTRACTION OF ENDNOTES 
              @@heading_endnotes_array <<@@seg_endnotes_array
            elsif para =~/^4~/ and not @@fn.empty?
              @@seg_endnotes[@@fn] = Array.new
              @@seg_endnotes[@@fn] << @@heading_endnotes_array << @@seg_endnotes_array 
              @@heading_endnotes_array,@@seg_endnotes_array=Array.new,Array.new
            end
          end
          if para =~/^4~/                                              #% EXTRACTION OF SUB-TOCs 
            @@seg_subtoc[@@fn]=@@seg_subtoc_array
            @@seg_subtoc_array=Array.new
          end
          if para =~/^4~/                                              #% SEGMENT NAME, after EXTRACTION OF ENDNOTES & SUB-TOCs 
            m=para[/^4~(\S+).+?<~(\d+);(?:[oh]|4:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/i]
            if m:  @@fn,@@to_lev4=$1,$2 if m # changed 2004w07          #endnotes and sub-tocs
            else
              m=para[/^4~(\S+)/i]
              @@fn,@@to_lev4=$1,'nonum' if m # changed 2005w13
            end
          end
          if para =~/^[56]~/
            para.gsub!(/&nbsp;<\/a>/i,'&nbsp;')
            case para # series changed 2002w42
            when /^5~\S*\s+(.+)?<~(\d+);(?:h|[56]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/i
              one,two=$1,$2
              format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
              para=format_seg.subtoc_lev5
            when /^6~\S*\s+(.+)?<~(\d+);(?:h|[56]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/i
              one,two=$1,$2
              format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
              para=format_seg.subtoc_lev6
            end
            @@seg_subtoc_array << para
          end
          if @md.flag_auto_endnotes
            if para =~/~\{\d+ <a name="_\d+"/ # endnote-
              endnote_array=para.scan(/~\{.+?\}\~/m)
              endnote_array.each do |note| 
                note_match=note.dup
                note_match_seg=note.dup
                e_n=note_match_seg[/~\{\d+\s+(.+?)\}~/m,1]
                try=e_n.split(/<br \/>/)
                try.each do |e|
                  format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,e)
                  if e =~/<:i[12]>/
                    note_match=format_seg.endnote_body_seg_tail_indent
                  else note_match=format_seg.endnote_body_seg_tail
                  end
                  @@seg_endnotes_array << note_match
                end
                try.join('<br \/>')
                                                                                 #% creation of separate end segment/page of all endnotes referenced back to reference segment
                m=/~\{\d+\s+(.+?href=")(#-\d+".+)\}~/mi
                one=note_match_seg[m,1] #note~ [a name]
                two=note_match_seg[m,2] #note-
                format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
                note_match_all_seg=format_seg.endnote_seg_body(@@fn) #BUG WATCH 200408
                @@seg[:endnote_all] << note_match_all_seg
              end
              para.gsub!(/~\{.+?\}~\s*/m,' ')
            end
          end
        end
      end
    end
    class Output
      include SiSU_Param
      def initialize(data='',md='')
        @data,@md=data,md
        @my_make=SiSU_Env::Create_file.new(@md.cf,@md.fns,@md)
      end
      def scroll
        begin
          @sisu=Array.new
          @data.each do |para|
            para.strip!
            para.gsub!(/<:.+?>/,'')
            unless para =~/^\s*$/
              para="#{para}\n" 
              @sisu << para
            end
          end
          @filename_html_scroll=@my_make.file_html_scroll(@md)
          new_file_data=@sisu.to_s
          #@sisu=new_file_data.scan(/\S+/)
          @sisu=new_file_data.split(/\n\n/)
          @sisu.each {|para| @filename_html_scroll.puts para, "\n"}
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
        end
      end
      def segtoc
        begin
          @sisu=Array.new
          @data.each do |para|
            para.strip!
            para.gsub!(/<(!.+?!|~\d+;(?:[ohm]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32})>/,'')
            unless para =~/^\s*$/
              para="#{para}\n"
              @sisu << para
            end
          end
          new_file_data=@sisu.to_s
          @filename_html_segtoc=@my_make.file_html_segtoc(@md)
          @filename_html_index=@my_make.file_html_index(@md)
          @sisu=new_file_data.split(/\n\n/)
          #@sisu.compact!
          @sisu.each {|para| @filename_html_segtoc.puts para,"\n" }
          @sisu.each {|para| @filename_html_index.puts para,"\n" }
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
        end
      end
      def seg
        begin
          @sisu=Array.new
          @data.each do |para|
            para.strip!
            unless para =~/^\s*$/: @sisu << para
            end
          end
          new_file_data=@sisu.to_s
          @sisu=new_file_data.split(/\n\n/)
          @sisu.each {|para| @newfile.puts para, "\n"}
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
        end
      end
    end
  end
end
__END__
