=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: document summary processing, available outputs and metadata
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Manifest
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Param
  include SiSU_Viz
  class Source
    def initialize(fns,cf)
      @fns,@cf=fns,cf
      @md=SiSU_Param::Parameters.new(@fns,@cf).get
      @fnb=@md.fnb
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@fns,@cf).get
        @dir=SiSU_Env::Info_dir.new(@fns)
        path=SiSU_Env::Info_dir.new(@fns)
        xbrowser=@dir.web_browser
        browser=@dir.console_web_browser
        webserv_url=path.tell_output_location
        url_html="#{webserv_url}/#{@md.fnb}/#{@md.fn[:manifest]}"
        tell=SiSU_Screen::Ansi.new(@cf,'Manifest',"#{xbrowser} #{url_html}")
        tell.greenHiBlue unless @cf =~/q/
        tell=SiSU_Screen::Ansi.new(@cf,"#{browser} #{url_html}")
        tell.grey_tab if @cf =~/v/i
        Output_Info.new(@md,@fns).check_output
      rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
      end
    end
    private
    class Output_Info <Source
      def initialize(md,fns)
        @manifest=Hash.new
        @manifest[:txt],@manifest[:html]=Array.new,Array.new
        @md,@fns=md,fns
        @dir=SiSU_Env::Info_dir.new(fns)
        @fnb=@md.fnb
        out=@dir.data_o
        @base_url="#{@dir.output_links_path[:url_root]}/#@fnb"
        @base_path="#{out}/#@fnb"
      end
      def output
        SiSU_Env::SiSU_file.new(@md).mkdir
        manifest=SiSU_Env::SiSU_file.new(@md,@md.fn[:manifest]).mkfile
        @manifest[:html].each do |x|
          manifest << x
        end
      end
      def summarize(id,file)
        #p "#@base_url/#{file}"
        size=(File.size("#{@base_path}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/im.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="bold"><a href="#{file}">#{file}</a></p></th><td><p class="norm">#{id}</p><p class="tiny"><a href="#@base_url/#{file}">#@base_url/#{file}</a></p></td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def summarize_source(id,file)
        sys=SiSU_Env::System_call.new
        dgst=sys.md5("#{@base_path}/#{file}")
        tell=SiSU_Screen::Ansi.new(@md.cf,"#{dgst[1]} #{file}")
        tell.warn if @md.cf =~/[vVM]/
        size=(File.size("#{@base_path}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/im.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="tiny">#{id}:</p> <p class="norm"><a href="#{file}">#{file}</a></p><p class="tiny"><a href="#@base_url/#{file}">#@base_url/#{file}</a></p></th><td class="right"><p class="tiny">#{dgst[1]}</p></td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def languages(id,file)
        #SiSU_Env::Env_call
        flv=@dir.published_manifests?(@base_path)
        @manifest[:html] << %{<tr><th class="left"><p class="bold"><p class="bold">\n}
        flv.each do |l|
          @manifest[:txt] << "#{l[:m]} #{l[:l]}\n"
          @manifest[:html] << %{<a href="#{l[:m]}">#{l[:l]}</a>&nbsp;&nbsp;&nbsp; }
        end
        @manifest[:html] << %{</p></th></tr>\n}
      end
      def published_languages(id,file)
        #SiSU_Env::Env_call
        flv=@dir.published_manifests?(@base_path)
        flv.each do |l|
          @manifest[:txt] << "#{l[:m]} #{l[:l]}\n"
          @manifest[:html] << %{<tr><th class="left"><p class="bold"><a href="#{l[:m]}">#{l[:l]}</a></p></th><td><p class="norm">#{l[:l]}</p><p class="tiny"><a href="#@base_url/#{l[:m]}">#@base_url/#{l[:m]}</a></p></td><td class="right"><p class="right">&nbsp;</p></td></tr>\n}
        end
      end
      def metadata(id,info)
        @manifest[:html] << %{<tr><th class="left"><p class="bold">#{id}:</p></th><td><p class="left">#{info}</p></td></tr>\n}
      end
      def links(url,lnk,target)
        static=if url =~/^\.\//: url.gsub(/^\.(\.)?/,@base_url)
        elsif url =~/^\.\.\//:   url.gsub(/^\.(\.)?/,@dir.output_links_path[:url_root])
        else                     url                            
        end
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="#{url}">#{lnk}</a></p><p class="tiny"><a href="#{static}">#{static}</a></p></th></tr>\n}
      end
      def output_tests
        if FileTest.file?("#@base_path/#{@md.fn[:toc]}")==true
          id,file='HTML table of contents (linked to segmented text)',@md.fn[:toc]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          id,file='HTML document (scroll)',@md.fn[:doc]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:xhtml]}")==true
          id,file='XHTML',@md.fn[:xhtml]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:sax]}")==true
          id,file='XML (SAX)',@md.fn[:sax]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:dom]}")==true
          id,file='XML (DOM)',@md.fn[:dom]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:odf]}")==true
          id,file='ODF (Open Document Format)',@md.fn[:odf]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p]}")==true
          id,file='PDF (portrait)',@md.fn[:pdf_p]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l]}")==true
          id,file='PDF (landscape)',@md.fn[:pdf_l]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:plain]}")==true
        if    @md.cf =~/a/: id,file='plaintext Unix (UTF-8) (footnotes)',@md.fn[:plain]
        elsif @md.cf =~/e/: id,file='plaintext Unix (UTF-8) (endnotes)',@md.fn[:plain]
        elsif @md.cf =~/A/: id,file='plaintext dos (UTF-8) (footnotes)',@md.fn[:plain]
        elsif @md.cf =~/E/: id,file='plaintext dos (UTF-8) (endnotes)',@md.fn[:plain]
        else                id,file='plaintext (UTF-8)',@md.fn[:plain]
        end
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:wmap]}")==true
          id,file='Wordmap (rudimentary index in html)',@md.fn[:wmap]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#@fns.tex")==true
          id,file='LaTeX (portrait)','#@fns.tex'
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#@fns.tex")==true
          id,file='LaTeX (landscape)','#@fns.landscape.tex'
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:digest]}")==true
          id,file='Digest/DCC - Document Content Certificate (md5)',@md.fn[:digest]
          summarize(id,file)
        end
      end
      def published_versions
        if FileTest.file?("#@base_path/sisu_manifest.html")==true
          id,file='Markup (SiSU source)',@fns
          languages(id,file)
        end
      end
      def language_versions
        if FileTest.file?("#@base_path/sisu_manifest.html")==true
          id,file='Markup (SiSU source)',@fns
          published_languages(id,file)
        end
      end
      def source_tests
        if @fns =~/\._sst$/                                                  #% decide whether to extract and include requested/required documents
          req=@fns.gsub(/(.+)?\._sst$/,"\\1.ssm") #watch strange
          #req=@fns.gsub(/(.+)?\.t([0-3])$/,"\\1.r\\2")
          if FileTest.file?("#@base_path/#{req}")==true
            id,file='Markup Composite File (SiSU source)',req
            summarize_source(id,file)
          end
        end
        #p "#@base_path/#@fns"
        if FileTest.file?("#@base_path/#@fns")==true
          id,file='Markup (SiSU source)',@fns
          summarize_source(id,file)
        end
        if FileTest.file?("#@base_path/sisudoc.tgz")==true
          id,file='SiSU doc (tar gzip)','sisudoc.tgz'
          summarize_source(id,file)
        end
        #if FileTest.file?("#@base_path/#@fns.meta")==true
        #  id,file='Markup (SiSU source)','#@fns.meta'
        #  summarize(id,file)
        #end
        #if FileTest.file?("#@base_path/#@fns.tgz")==true
        #  id,file='SiSUdoc (tar gzip)','#@fns.tgz'
        #  summarize(id,file)
        #end
      end
      def metadata_tests
        if @md.dc_title
          id,info='DC Title',@md.dc_title
          metadata(id,info)
        end
        if @md.title
          id,info='Title',@md.title
          metadata(id,info)
        end
        if @md.subtitle
          id,info='Subtitle',@md.subtitle
          metadata(id,info)
        end
        if @md.dc_creator
          id,info='DC Creator',@md.dc_creator
          metadata(id,info)
        end
        if @md.dc_contributor
          id,info='DC Contributor',@md.dc_contributor
          metadata(id,info)
        end
        if @md.translator
          id,info='Translator',@md.translator
          metadata(id,info)
        end
        if @md.illustrator
          id,info='Illustrator',@md.illustrator
          metadata(id,info)
        end
        if @md.dc_publisher
          id,info='DC Publisher',@md.dc_publisher
          metadata(id,info)
        end
        if @md.prepared_by
          id,info='Prepared by',@md.prepared_by
          metadata(id,info)
        end
        if @md.digitized_by
          id,info='Digitized by',@md.digitized_by
          metadata(id,info)
        end
        if @md.dc_subject
          id,info='DC Subject',@md.dc_subject
          metadata(id,info)
        end
        if @md.dc_description
          id,info='DC Description',@md.dc_description
          metadata(id,info)
        end
        if @md.abstract
          id,info='Abstract',@md.abstract
          metadata(id,info)
        end
        if @md.dc_type
          id,info='DC Type',@md.dc_type
          metadata(id,info)
        end
        #if @md.owner
        #  id,info='Owner',@md.owner
        #  metadata(id,info)
        #end
        #if @md.copyright
        #  id,info='Copyright',@md.copyright
        #  metadata(id,info)
        #end
        if @md.dc_rights
          id,info='DC Rights',@md.dc_rights
          metadata(id,info)
        end
        if @md.dc_date
          id,info='DC Date',@md.dc_date
          metadata(id,info)
        end
        if @md.dc_date_created
          id,info='DC Date created',@md.dc_date_created
          metadata(id,info)
        end
        if @md.dc_date_issued
          id,info='DC Date issued',@md.dc_date_issued
          metadata(id,info)
        end
        if @md.dc_date_available
          id,info='DC Date available',@md.dc_date_available
          metadata(id,info)
        end
        if @md.dc_date_modified
          id,info='DC Date modified',@md.dc_date_modified
          metadata(id,info)
        end
        if @md.dc_date_valid
          id,info='DC Date valid',@md.dc_date_valid
          metadata(id,info)
        end
        if @md.dc_language[:name]
          id,info='DC Language',@md.dc_language[:name]
          metadata(id,info)
        end
        if @md.original_language[:name]
          id,info='Original Language',@md.original_language[:name]
          metadata(id,info)
        end
        if @md.dc_format
          id,info='DC Format',@md.dc_format
          metadata(id,info)
        end
        if @md.dc_identifier
          id,info='DC Identifier',@md.dc_identifier
          metadata(id,info)
        end
        if @md.dc_source
          id,info='DC Source',@md.dc_source
          metadata(id,info)
        end
        if @md.dc_relation
          id,info='DC Relation',@md.dc_relation
          metadata(id,info)
        end
        if @md.dc_coverage
          id,info='DC Coverage',@md.dc_coverage
          metadata(id,info)
        end
        if @md.keywords
          id,info='Keywords',@md.keywords
          metadata(id,info)
        end
        if @md.comments
          id,info='Comments',@md.comments
          metadata(id,info)
        end
        if @md.cls_loc
          id,info='Classify Library Of Congress',@md.cls_loc
          metadata(id,info)
        end
        if @md.cls_dewey
          id,info='Classify Dewey',@md.cls_dewey
          metadata(id,info)
        end
        if @md.cls_pg
          id,info='Classify Project Gutenberg',@md.cls_pg
          metadata(id,info)
        end
        if @md.cls_isbn
          id,info='Classify ISBN',@md.cls_isbn
          metadata(id,info)
        end
        if @md.prefix_a
          id,info='Prefix (a)',@md.prefix_a
          metadata(id,info)
        end
        if @md.prefix_b
          id,info='Prefix (b)',@md.prefix_b
          metadata(id,info)
        end
        if @md.fns
          id,info='Sourcefile',@md.fns
          metadata(id,info)
        end
        if @md.en[:mismatch] > 0
          id,info='WARNING document error in endnote markup, number mismatch',"endnotes: #{@md.en[:note]} != endnote reference marks: #{@md.en[:mark]} (difference = #{@md.en[:mismatch]})"
          metadata(id,info)
        end
        if @md.wc_words
          id,info='Word Count approximate',@md.wc_words
          metadata(id,info)
        end
        if @md.dgst
          id,info='Sourcefile Digest (md5)',@md.dgst[1]
          metadata(id,info)
        end
        if @md.rc_vnumber
          id,info='Document (RCS/CVS) number',@md.rc_vnumber
          metadata(id,info)
        end
        if @md.rc_date
          id,info='Document (RCS/CVS) date',"#{@md.rc_date} at #{@md.rc_time}"
          metadata(id,info)
        end
        if @md.generated
          id,info='Document (metaverse) last generated',@md.generated
          metadata(id,info)
        end
        if @md.sisuversion
          #p @md.sisuversion
          id,info='Generated by',"#{@md.sisuversion[:project]} #{@md.sisuversion[:version]} #{@md.sisuversion[:date_stamp]} (#{@md.sisuversion[:date]})"
          metadata(id,info)
        end
        if @md.rubyversion
          id,info='Ruby version',@md.rubyversion
          metadata(id,info)
        end
      end
      def links_tests
        if defined? @md.lnk and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=if l[:url] !~/^\.(\.)?\//: 'external'
              else                              '_top'
              end
              url,lnk=l[:url],l[:say]
              unless url.nil? or url.empty?: links(url,lnk,target)
              end
            end
          end
        end
      end
      def check_output
        begin
          id,file='',''
          url=SiSU_Viz::Url.new
          @manifest[:html] <<<<WOK
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">          
<head>
<title>
SiSU manifest: #{@md.title}
</title>
<meta name="sourcefile" content="#@fns" />
<link rel="generator" href="http://www.jus.uio.no/sisu" />
<link rel="shortcut icon" href="../_sisu/image/rb7.ico" />
<link rel="stylesheet" href="../#{@dir.style}/html.css" type="text/css" />
</head>
<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">
<table summary="band" border="0" cellpadding="3" cellspacing="0">
<tr><td align="left" bgcolor="#ffffff"><a href="http://www.jus.uio.no/sisu/" target="_top"><img border="0" src="#{url.path_image}/sisu.png" alt="SiSU --&gt;" /></a></td><td><p class="tiny"><a href="#@base_url/#{file}"><img border="0" height="12" width="12" src="#{url.path_image}/bullet_red.png"  alt="TOC linked" />&nbsp;#@base_url/#{file}</a></p></td></tr>
</table>
<h1 class="small">#{@md.dc_title}</h1>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          published_versions
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="output">SiSU manifest of generated output</a></h2>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">filename</p></th><th class="left"><p class="bold">description</p></th><th class="right"><p class="right"><b>file size</b></p><p class="tiny_right">(kB)</p></th></tr>

WOK
          output_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          source_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="metadata">SiSU manifest of document metadata</a></h2>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">metadata</p></th><th class="left"><p class="bold">description</p></th></tr>
WOK
          metadata_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<table summary="normal text css" width="90%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr><th class="left"><p class="bold"><a name="links">metadata suggested links:</a></p></th></tr>
WOK
          links_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="languages">Document Language Versions, manifests</a></h2>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">filename</p></th><th class="left"><p class="bold">description</p></th><th class="right"><p class="right">&nbsp;</p></th></tr>

WOK
          language_versions
          @manifest[:html] <<<<WOK
</table>
</body>
</html>
WOK
          output
        rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
        ensure
        end
      end
    end
  end
end
__END__
