=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: semantics
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module Semantic
  require "#{SiSU_lib}/param"
  class YamlInfoCreate
    def initialize(file='')
      @file=file
      @sisu=Array.new
      @@doc[:title],@@doc[:subtitle],@@doc[:creator],@@doc[:subject],@@doc[:keywords],@@doc[:description],@@doc[:publisher],@@doc[:contributor],@@doc[:date],@@doc[:date_created],@@doc[:date_issued],@@doc[:date_available],@@doc[:date_valid],@@doc[:date_modified],@@doc[:type],@@doc[:format],@@doc[:identifier],@@doc[:source],@@doc[:language],@@doc[:coverage],@@doc[:relation],@@doc[:rights]=nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil,nil
    end
    def songsheet
      param
      yamlinfo
    end
    def param
      file_array=IO.readlines(@file,'')
      SiSU_Param(file_array.collect,@file,"a") #problem not updated watch
    end
    def printscreen
      puts "#{@@cX.fuschia}filename:#{@@cX.off}       " + @file
      puts "#{@@cX.fuschia}title:#{@@cX.off}          " + @@doc[:title]
      puts "#{@@cX.fuschia}subtitle:#{@@cX.off}       " + @@doc[:subtitle] if @@doc[:subtitle]
      puts "#{@@cX.fuschia}creator:#{@@cX.off}        " + @@doc[:creator] if @@doc[:creator]
      puts "#{@@cX.fuschia}subject:#{@@cX.off}        " + @@doc[:subject] if @@doc[:subject]
      puts "#{@@cX.fuschia}description:#{@@cX.off}    " + @@doc[:description] if @@doc[:description]
      puts "#{@@cX.fuschia}publisher:#{@@cX.off}      " + @@doc[:publisher] if @@doc[:publisher]
      puts "#{@@cX.fuschia}contributor:#{@@cX.off}    " + @@doc[:contributor] if @@doc[:contributor]
      puts "#{@@cX.fuschia}date:#{@@cX.off}           " + @@doc[:date] if @@doc[:date]
      puts "#{@@cX.fuschia}date created:#{@@cX.off}   " + @@doc[:date_created] if @@doc[:date_created]
      puts "#{@@cX.fuschia}date issued:#{@@cX.off}    " + @@doc[:date_issued] if @@doc[:date_issued]
      puts "#{@@cX.fuschia}date available:#{@@cX.off} " + @@doc[:date_available] if @@doc[:date_available]
      puts "#{@@cX.fuschia}date valid:#{@@cX.off}     " + @@doc[:date_valid] if @@doc[:date_valid]
      puts "#{@@cX.fuschia}date modified:#{@@cX.off}  " + @@doc[:date_modified] if @@doc[:date_modified]
      puts "#{@@cX.fuschia}type:#{@@cX.off}           " + @@doc[:type] if @@doc[:type]
      puts "#{@@cX.fuschia}format:#{@@cX.off}         " + @@doc[:format] if @@doc[:format]
      puts "#{@@cX.fuschia}identifier:#{@@cX.off}     " + @@doc[:identifier] if @@doc[:identifier]
      puts "#{@@cX.fuschia}source:#{@@cX.off}         " + @@doc[:source] if @@doc[:source]
      puts "#{@@cX.fuschia}language:#{@@cX.off}       " + @@doc[:language] if @@doc[:language]
      puts "#{@@cX.fuschia}coverage:#{@@cX.off}       " + @@doc[:coverage] if @@doc[:coverage]
      puts "#{@@cX.fuschia}relation:#{@@cX.off}       " + @@doc[:relation] if @@doc[:relation]
      puts "#{@@cX.fuschia}rights:#{@@cX.off}         " + @@doc[:rights] if @@doc[:rights]
      #puts "#{@@cX.fuschia}copyright:#{@@cX.off}      " + @@doc[:copyright] if @@doc[:copyright]
      puts "#{@@cX.fuschia}keywords:#{@@cX.off}       " + @@doc[:keywords] if @@doc[:keywords]
      puts '-----------------------'
    end
    def yamlinfo
      uri=case @file
      when /.+?\.[_-]?sst$/: @file.gsub(/(.+?)\.[_-]?sst$/,"http://localhost/reserved/\\1/")
      end
      p uri
      @sisu << '-'
      @sisu << "  filename:       " + uri
      @sisu << "  title:          " + @@doc[:title].gsub(/:/, ' - ') if @@doc[:title]
      @sisu << "  subtitle:       " + @@doc[:subtitle] if @@doc[:subtitle]
      @sisu << "  creator:        " + @@doc[:creator] if @@doc[:creator]
      @sisu << "  subject:        " + @@doc[:subject] if @@doc[:subject]
      @sisu << "  keywords:       " + @@doc[:keywords] if @@doc[:keywords]
      @sisu << "  description:    " + @@doc[:description] if @@doc[:description]
      @sisu << "  publisher:      " + @@doc[:publisher] if @@doc[:publisher]
      @sisu << "  contributor:    " + @@doc[:contributor] if @@doc[:contributor]
      @sisu << "  date:           " + @@doc[:date] if @@doc[:date]
      @sisu << "  date_created:   " + @@doc[:date_created] if @@doc[:date_created]
      @sisu << "  date_issued:    " + @@doc[:date_issued] if @@doc[:date_issued]
      @sisu << "  date_available: " + @@doc[:dateavailable] if @@doc[:date_available]
      @sisu << "  date_valid:     " + @@doc[:date_valid] if @@doc[:date_valid]
      @sisu << "  date_modified:  " + @@doc[:date_modified] if @@doc[:date_modified]
      @sisu << "  type:           " + @@doc[:type] if @@doc[:type]
      @sisu << "  format:         " + @@doc[:format] if @@doc[:format]
      @sisu << "  identifier:     " + @@doc[:identifier] if @@doc[:identifier]
      @sisu << "  source:         " + @@doc[:source] if @@doc[:source]
      @sisu << "  language:       " + @@doc[:language] if @@doc[:language]
      @sisu << "  coverage:       " + @@doc[:coverage] if @@doc[:coverage]
      @sisu << "  relation:       " + @@doc[:relation] if @@doc[:relation]
      @sisu << "  rights:         " + @@doc[:rights] if @@doc[:rights]
      #@sisu << "  copyright:      " + @@doc[:copyright] if @@doc[:copyright]
      @sisu.each {|para| @@filename_semantic.puts para}
    end
  end
  class Yaml_info_read
    def initialize #(file='')
      @pwd=Dir.pwd
      @sisu=Array.new
    end
    def loadfile
      if FileTest.file?("#@pwd/semantic.yaml") 
        @yaml||=YAML::load(File::open("#@pwd/semantic.yaml"))
      end
    end
    def printscreen
      @yaml.each do |y| 
        puts y['title'] if y['title']
        puts y['subtitle'] if y['subtitle']
        puts y['creator'] if y['creator']
        puts y['subject'] if y['subject']
        puts y['description'] if y['description']
        puts y['publisher'] if y['publisher']
        puts y['contributor'] if y['contributor']
        puts y['date'] if y['date']
        puts y['date_created'] if y['date_created']
        puts y['date_issued'] if y['date_issued']
        puts y['date_available'] if y['date_available']
        puts y['date_valid'] if y['date_valid']
        puts y['date_modified'] if y['date_modified']
        puts y['type'] if y['type']
        puts y['format'] if y['format']
        puts y['identifier'] if y['identifier']
        puts y['source'] if y['source']
        puts y['language'] if y['language']
        puts y['coverage'] if y['coverage']
        puts y['relation'] if y['relation']
        puts y['rights'] if y['rights']
        puts y['copyright'] if y['copyright']
        puts y['keywords'] if y['keywords']
        puts '-----'
      end
    end
  end
  class RSS < Yaml_info_read
    def songsheet
      loadfile
      rss_nav
      debris
    end
    def rss(match=//, feedtitle='')
      @sisu=Array.new
      @sisu <<  %{<rss version="2.0">\n-\n  <channel><title>#{feedtitle}</title>
<link>http://www.jus.uio.no/lm/</link>
<description>Semantic Information Structuring Unit</description>
<language>en-us</language>
-
}
      @yaml.each do |y| 
        if y['title'] and ((y['subject'] and "#{y['subject']}"[match]) or (y['keywords'] and "#{y['keywords']}"[match]))
          #p y['keywords']
          p y['subject']
          @sisu <<  %{-
  <item>
  <title>#{y['title']}</title>
  -
    <guid>
  #{y['filename']}
  </guid>
  -
  }
          @sisu << %{<description>}
          @sisu << %{<h1 id="#{y['title'].gsub(/\s+/, '-')}">#{y['title']}</h1>} 
          @sisu << %{#{y['title']} } if y['title']
          @sisu << %{#{y['subtitle']} } if y['subtitle']
          @sisu << %{#{y['creator'] }} if y['creator']
          #@sisu << %{#{y['subject']}} if y['subject']
          @sisu << %{#{y['description'] }} if y['description']
          #@sisu << %{#{y['publisher']}} if y['publisher']
          #@sisu << %{#{y['contributor']}} if y['contributor']
          @sisu << %{#{y['date']} } if y['date']
          #@sisu << %{#{y['date_created']}} if y['date_created']
          #@sisu << %{#{y['date_issued']}} if y['date_issued']
          #@sisu << %{#{y['date_available']}} if y['date_available']
          #@sisu << %{#{y['date_valid']}} if y['date_valid']
          #@sisu << %{#{y['date_modified']}} if y['date_modified']
          #@sisu << %{#{y['type']}} if y['type']
          #@sisu << %{#{y['format']}} if y['format']
          #@sisu << %{#{y['identifier']}} if y['identifier']
          #@sisu << %{#{y['source']}} if y['source']
          #@sisu << %{#{y['language']}} if y['language']
          #@sisu << %{#{y['coverage']}} if y['coverage']
          #@sisu << %{#{y['relation']}} if y['relation']
          #@sisu << %{#{y['rights']}} if y['rights']
          #@sisu << %{#{y['copyright']}} if y['copyright']
          #@sisu << %{#{y['keyword']}} if y['keyword']
          @sisu << %{</description>}
          @sisu << %{</item>}
        end
      end
      @sisu <<  %{</channel>\n</rss>}
      #@sisu.each {|para| @@rss.puts para} #KEEP does all
      if "united nations"[match]
        @sisu.each {|para| @@rss_un.puts para}
        @sisu=Array.new
      end
      if "unidroit"[match]
        @sisu.each {|para| @@rss_unidroit.puts para}
        @sisu=Array.new
      end
      if "hcpil"[match]
        @sisu.each {|para| @@rss_hcpil.puts para}
        @sisu=Array.new
      end
      if "contract"[match]
        @sisu.each {|para| @@rss_contracts.puts para}
        @sisu=Array.new
      end
      if "navigate"[match]
        @sisu.each {|para| @@rss_nav.puts para}
        @sisu=Array.new
      end
    end
    def rss_un
      match=/united\s+nations|uncitral/i
      rss(match, 'Lex Mercatoria Pages on the United Nations')
    end
    def rss_unidroit
      match=/unidroit/i
      rss(match, 'Lex Mercatoria pages on UNIDROIT')
    end
    def rss_hcpil
      match=/hague\s+conference|hcpil/i
      rss(match, 'Lex Mercatoria pages on the Hague Conference on Private International Law')
    end
    def rss_contracts
      match=/contracts?/i
      rss(match, 'Lex Mercatoria Contract Law pages')
    end
    def rss_nav
      match=/navigate(\s|$)/i
      rss(match, 'Lex Mercatoria Navigation pages')
    end
    def dummy
      @sisu <<  %{<doc>}
      @yaml.each do |y| 
        @sisu <<  %{<content>}
        @sisu <<  %{#{y['title']}} if y['title']
        @sisu <<  %{#{y['subtitle']}} if y['subtitle']
        @sisu <<  %{#{y['creator']}} if y['creator']
        @sisu <<  %{#{y['subject']}} if y['subject']
        @sisu <<  %{#{y['description']}} if y['description']
        @sisu <<  %{#{y['publisher']}} if y['publisher']
        @sisu <<  %{#{y['contributor']}} if y['contributor']
        @sisu <<  %{#{y['date']}} if y['date']
        @sisu <<  %{#{y['date_created']}} if y['date_created']
        @sisu <<  %{#{y['date_issued']}} if y['date_issued']
        @sisu <<  %{#{y['date_available']}} if y['date_available']
        @sisu <<  %{#{y['date_valid']}} if y['date_valid']
        @sisu <<  %{#{y['date_modified']}} if y['date_modified']
        @sisu <<  %{#{y['type']}} if y['type']
        @sisu <<  %{#{y['format']}} if y['format']
        @sisu <<  %{#{y['identifier']}} if y['identifier']
        @sisu <<  %{#{y['source']}} if y['source']
        @sisu <<  %{#{y['language']}} if y['language']
        @sisu <<  %{#{y['coverage']}} if y['coverage']
        @sisu <<  %{#{y['relation']}} if y['relation']
        @sisu <<  %{#{y['rights']}} if y['rights']
        @sisu <<  %{#{y['copyright']}} if y['copyright']
        @sisu <<  %{#{y['keyword']}} if y['keyword']
        @sisu <<  %{</content>}
      end
      @sisu <<  %{</doc>}
      @sisu.each {|para| @@rss.puts para}
    end
    def debris
      outputdir=SiSU_Env::Info_dir.new.feed
      x=Dir.new(outputdir).entries
      x.each do |y|
        #unless FileTest.file?("#{outputdir}/#{y}") and File.size?("#{outputdir}/#{y}") == 0
        if File.size("#{outputdir}/#{y}") == 0
          #File.unlink("#{outputdir}/#{y}")
          p "#{outputdir}/#{y}"
          p File.size("#{outputdir}/#{y}")
        end
      end
    end
  end
  class RDF < Yaml_info_read
    def songsheet
      loadfile
      #printscreen
      rdf
      rdf_un
      rdf_unidroit
      rdf_hcpil
      rdf_contracts
      rdf_nav
      debris
    end
    def rdf
    end
    def rdf_un
    end
    def rdf_unidroit
    end
    def rdf_hcpil
    end
    def rdf_contracts
    end
    def rdf_nav
    end
    def debris
    end
  end
end
                                                                                 #% start
require "#{SiSU_lib}/param"
require "#{SiSU_lib}/defaults"
require "#{SiSU_lib}/sysenv"
include SiSU_Param
include SiSU_Env
include SiSU_Viz
outputdir=SiSU_Env::Info_dir.new.feed
pwd=Dir.pwd
@argv=Array.new
argv=$*
p argv
my_make=SiSU_Env::Create_file.new('','')
if argv.to_s =~/yaml/
  my_make.file_semantic
  files=Dir["*.sst,*._sst,*-sst"]
  end
  files.each {|f| @argv << f[/(.+?)\.[_-]?sst$/,1] if f =~/.+?\.[_-]?sst$/}
  #########
  files.each do |filename|
    Semantic::YamlInfoCreate.new(filename).songsheet
  end
elsif argv.to_s =~/rss/
  #rss=%{#{outputdir}/semantic.xml}
  #@@rss=File.new(rss, "w+")
  rss_nav=%{#{outputdir}/navigate.xml}
  @@rss_nav=File.new(rss_nav, "w+")
  #
  #rss_un=%{#{outputdir}/un.xml}
  #@@rss_un=File.new(rss_un, "w+")
  #rss_unidroit=%{#{outputdir}/unidroit.xml}
  #@@rss_unidroit=File.new(rss_unidroit, "w+")
  #rss_hcpil=%{#{outputdir}/hcpil.xml}
  #@@rss_hcpil=File.new(rss_hcpil, "w+")
  #rss_contracts=%{#{outputdir}/contracts.xml}
  #@@rss_contracts=File.new(rss_contracts, "w+")
  ##my_make.file_rss
  Semantic::RSS.new.songsheet
elsif argv.to_s =~/rdf/
  #rdf=%{#{outputdir}/semantic.rdf}
  #@@rdf=File.new(rdf, "w+")
  #rdf_un=%{#{outputdir}/un.rdf}
  #@@rdf_un=File.new(rdf_un, "w+")
  #rdf_unidroit=%{#{outputdir}/unidroit.rdf}
  #@@rdf_unidroit=File.new(rdf_unidroit, "w+")
  #rdf_hcpil=%{#{outputdir}/hcpil.rdf}
  #@@rdf_hcpil=File.new(rdf_hcpil, "w+")
  #rdf_contracts=%{#{outputdir}/contracts.rdf}
  #@@rdf_contracts=File.new(rdf_contracts, "w+")
  #rdf_nav=%{#{outputdir}/navigate.rdf}
  #@@rdf_nav=File.new(rdf_nav, "w+")
  ##my_make.file_rdf
  #Semantic::RDF.new.songsheet
end
__END__

