=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: Vocabulary, wordlist (first usd by wordmap)
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module Wordlists
  class Lists
    def initialize
    end
    def scanlist
      /(?:<i>(?:[\w0-9"]+[\s]*){2,7}<\/i>|<b>(?:[\w0-9"]+[\s]*){2,7}<\/b>|http:\/\/\S+)|code\{.+?\}code|<\S+?>|\w+/mi
      #/(?:<i>(?:[\w0-9"]+[\s]*){2,7}<\/i>|<b>(?:[\w0-9"]+[\s]*){2,7}<\/b>|http:\/\/\S+|\w+)/i
    end
    def lesser
      /^(?:
      a|about|all|also|although|am|an[dy]?|approach(?:es|ed)?|are|around|a[st]|availab(?:ility|le)|
      b|back|be|been|both|but|by|
      c|can|close|come|could|
      d|damaged?|did|do|does|doing|done|down|
      e|each|early|easy|eight|end|even|every(?:thing)?|exist(?:ed|ence|ing|s)?|
      f|fair|fall|familiar|feature[ds]?|fees?|few|first(?:ly)?|five|fix(?:ed)?|for|form|forecast(?:ed|s|ing)?|four|frequent(?:ed|ly)?|from|frustration|fully?|fundamental|
      g|generally|get|give|go|got|gone|
      h|had|half|has|have|height?|held|her|here|him|his|hmm+|hold|how(?:ever)?|html|https?|ftp|
      i|if|in|include|inclusion|info|initial|initially|inquire|insofar|instead|interest(?:ed|ing|ingly|s)|in(?:to)?|introduc(?:e|tion)|is|it|like(?:ly|wise)?|
      k|kee[np]|kept|key|kn[eo]w|
      l|large(?:ly)?|later?|lead|least|le[dt]|less|like(?:ly)?|list(?:ed|s)?|little|long(?:er)?|looks?|lots?|low(?:er)?|
      m|made|main|major|mak(?:es?|ing)|many|may|maybe|mean|ment|mid|might|minor|miss|more|most(?:ly)?|move[ds]?|movement|moving|much|
      n|needs?|new|next|nine|no[nrtw]?|
      o|off?|often|old|on|one|or|once|one|only|open|other(s|wise)?|our|out|outline|output|over|overview|own|
      p|particularly|partly|pass|past|pay|pdf|perhaps|please|post|potential|practical(?:ly)?|pre|prefer|presum(?:e|ably|s)|problem(atic|s)?|pull|push|put|
      q|quite|
      r|ran|range|rather|read|real|reasonable|receive|recent|recogni[sz]e|reduce|refer|reference|relative|regard(?:ing|less|s)?|really|release|relevant|remarks?|remove|repeat|result|return|run|
      s|say|search|second(?:ly)?|see(?:[kn]|ing|ingly|ms?)?|sen[dt]|separate|self|set|seven|several|she|similar(?:ly)?|simpl(?:e|y)|since|situations?|situated|six|small|so|some(?:thing)?|start(?:ed)?|stop(?:ped)?|such|sure|
      t|take[ns]?|ten|test|thanks?|that|the|their|then|there|these|they|third(?:ly)?|this|those|though|three|to|today|towards?|tried|try|two|
      u|under(?:lying|stand|standing)?|unfortunately|up(?:on)|use[dsr]?|
      w|want|was|well|ways?|what|when|where|which|while|whilst|who(?:se)?|wide(?:ly)?|will|with(?:in|out)|why|wide|width|when|where|which|why|would|
      z)$/i
    end
    def special
      #/<i>(?:[\w0-9"]+[\s]*){2,7}?<\/i>|http:\/\/\S+|(?:
      /<i>(?:[\w0-9"]+[\s]*){2,7}<\/i>|<b>(?:[\w0-9"]+[\s]*){2,7}<\/b>|https?:\/\/\S+|ftp:\/\/\S+|(?:
      a|
      b|
      c|
      d|
      e|
      f|
      g|
      h|
      i|
      j|
      l|
      m|
      n|
      o|
      p|
      r|
      s|
      t|
      u|
      w|
      h|
      u|
      zz|\w+)/i
    end
    def greater
      /^(?:kajfsajflajskdfjz)$/i
    end
  end
end
__END__
