=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: composite documents, assemble/build documents from other documents or parts of marked up text

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Assemble
  require SiSU_lib + '/sysenv'
  class Remote_image
    def initialize
      @env=SiSU_Env::Info_dir.new
    end
    def image(dir)
      images=Array.new
      images[0]=dir
      images
    end
    def download_images(images_array) #first element in array is source url
      path="#{@env.processing}/external_document/image"
      File.mkpath(path) unless FileTest.directory?(path)
      download_from=images_array.shift
      images_array.each do |i| 
        image="#{path}/#{i}"
        #unless FileTest.exists?(image)
          imagefile=File.new(image,'w+')
          open("#{download_from}/#{i}") do |g|
            imagefile << g.read
          end
          imagefile.close
        #end
      end
    end
    def download_doc_skin(doc_skin) #first element in array is source url
      path="#{@env.processing}/external_document/skin/doc"
      File.mkpath(path) unless FileTest.directory?(path)
      download_from=doc_skin.shift
      doc_skin.each do |i| 
        skin="#{path}/#{i}.rb"
        unless FileTest.exists?(skin)
          skinfile=File.new(skin,'w+')
          open("#{download_from}/#{i}.rb") do |g|
            skinfile << g.read
          end
          skinfile.close
        end
      end
    end
  end
  class Composite
    @@imager=Hash.new
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_dir.new
    end
    def read
      begin
        @fns_array=IO.readlines(@opt.fns,'')
        assembled=insertions?
        write(assembled)
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def write(assembled)
      m=/(.+)?(\.ssm$)/im
      assembled_file=File.new("#{@opt.fnb}._sst",'w+')
      assembled.each{|a| assembled_file << a }
      assembled_file.close
    end
    def download_images(download_from,images_array)
      path="#{@env.processing}/external_document/image"
      File.mkpath(path) unless FileTest.directory?(path)
      images_array.each do |i| 
        image="#{path}/#{i}"
        unless FileTest.exists?(image)
          imagefile=File.new(image,'w+')
          open("#{download_from}/#{i}") do |g|
            imagefile << g.read
          end
          imagefile.close
        end
      end
    end
    def download_doc_skin(doc_skin) #first element in array is source url
      path="#{@env.processing}/external_document/skin/doc"
      File.mkpath(path) unless FileTest.directory?(path)
      download_from=doc_skin.shift
      doc_skin.each do |i| 
        skin="#{path}/#{i}.rb"
        unless FileTest.exists?(skin)
          skinfile=File.new(skin,'w+')
          open("#{download_from}/#{i}.rb") do |g|
            skinfile << g.read
          end
          skinfile.close
        end
      end
    end
    def insertion(fni,insert_array)
      file=Hash.new
      file[:prepared]=Array.new
      file[:images]=Array.new
      rgx_image=/([a-zA-Z0-9._-]+?\.(?:png|jpg))/
      #file[:prepared] << "#% Date " << "\n"
      file[:prepared] << "\n% |#{fni}|@|^|>>ok\n" 
      insert_array.each do |i| 
        i.gsub!(/^([12]|:?[AB])~\? /,"% [conditional heading:] \\1~ ")            #off conditional heading (consider syntax)
        if i =~/^0~|^@\S+?:/
          i.gsub!(/\n/m,"\n%  ")
          i.gsub!(/\n%\s+$/m,'')
          i.gsub!(/^0~|^@\S+?:/m,"\n% [imported header:] ")                          #off imported headers
        end
        #i.gsub!(/(\{)\s*(\S+?\.(?:png|jpg))\s+/, %{\\1\\2 :L })                  #off imported headers
        file[:prepared] << i 
        file[:images] << i.scan(rgx_image).uniq if i =~rgx_image #flag
      end
      file[:prepared] << "\n% end import\n"
      file[:images].uniq! if file[:images].length > 0
      file[:images].flatten! if file[:images].length > 0
      file
    end
    def insertions?
      data=@fns_array
      tuned_file=Array.new
      imagedir=Array.new
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Composite Document',@opt.fns)
      tell.grey_title_hi unless @opt.cmd =~/q/
      data.each do |para|
        if para =~/^r\{(.+?)\}/ \
        or para =~/^(?:<<\s*)\{(.+?)\}(?:req(?:quire)?\b|\s*\})?/ \
        or para =~/^(?:<<\s*)\|(\S+?)\|@\|.+?\|(?:req(?:quire)?\b|\s*\})?/ \
        or para =~/^(?:<<\s*)<(?:URL|url):(\S+?)>(?:req(?:require)\b|\s*\})?/ \
        or para =~/^\{(.+?)\}(?:req(?:require)?)\b/ \
        or para =~/^\|(\S+?)\|@\|.+?\|(?:req(?:require)?)\b/ \
        or para =~/^<(?:URL|url):(\S+?)>(?:req(?:require))\b/
          loadfile=$1.strip
          tell=SiSU_Screen::Ansi.new(@opt.cmd,'loading:',loadfile)
          tell.txt_grey if @opt.cmd =~/[MVv]/
          tuned_file << if loadfile =~ /http:\/\/\S+?\.ss[ti]$/ # and NetTest
            imagedir = /(http:\/\/\S+?)\/[^\/]+?\.ss[ti]$/i.match(loadfile).captures.join + '/_sisu/image' #watch
            require 'uri'
            image_uri=URI.parse(imagedir)
            require 'open-uri'
            require 'pp'
            insert=open(loadfile)
            insert_array=insert.dup
            insert.close
            file=insertion(loadfile,insert_array)
            #% ...
            @@imager[image_uri] ||=Array.new
            @@imager[image_uri] << file[:images]
            file[:prepared]
          elsif loadfile =~ /\.ss[ti]$/ and FileTest.file?(loadfile)
            insert_array=IO.readlines(loadfile,'')
            file=insertion(loadfile,insert_array)
            file[:prepared]
          else
            cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
            puts "\t  #{cX.fuschia}ERROR#{cX.off} #{cX.brown}#{@opt.fns}#{cX.off} #{cX.fuschia}requires invalid or non-existent file:#{cX.off} #{cX.brown}#{loadfile}#{cX.off}"
            para
          end
        else tuned_file << para
        end
        tuned_file.compact!
      end
      if @@imager.length >0
        @@imager.each do |d,i| 
          i.flatten!
          i.uniq!
          download_images(d,i)
        end
      end
      tuned_file
    end
  end
end
__END__

