=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: configuration

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Present
  require SiSU_lib + '/sysenv'
  require SiSU_lib + '/color_hex_triplets'
  include SiSU_Hex_triplets
  class RelaxNG
    def fn_dtd_sax
      'sisu_sax.dtd'
    end
    def fn_dtd_dom
      'sisu_dom.dtd'
    end
    def fn_dtd_xhtml
      'sisu_xhtml.dtd'
    end
    def rnc_sax
      @relaxng =<<RELAXNG
# %% sax model
# Author: Ralph@Amissah.com
# $Id$

# %% definitions

#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.

# %% structure
element document {
  #document head:
  element head {
    #dublin core:
    element dc {
      attribute class { text }
    }+
  },
  #document body:
  element body {
    #object, a unit of text, usually a paragraph with any associated endnotes
    element object {
      attribute number { text },
      element ocn { text },
      #body content/text, whether ordinary paragraph or heading:
      element text { 
        #attributes indicates whether ordinary text (norm) or heading, (levels h[1-6]):
        attribute class { text },
        text
      },
      #endnotes, zero or many:
      element endnote {
        attribute notenumber { text },
        #endnotes number:
        element number { text },
        #endnotes content/text:
        element note { text }
      }*
    }+
  }
}
RELAXNG
    end
    def rnc_dom
      @relaxng =<<RELAXNG
# %% dom model
# %% definitions
#dublin core:
element-dc =
  ( attribute title { text }
  #attribute subtitle { text }?
  & attribute creator { text }?
  & attribute subject { text }?
  & attribute description { text }?
  & attribute publisher { text }?
  & attribute contributor { text }?
  & attribute date { text }?
  & attribute datecreated { text }?
  & attribute dateissued { text }?
  & attribute dateavailable { text }?
  & attribute datevalid { text }?
  & attribute datemodified { text }?
  & attribute type { text }?
  & attribute format { text }?
  & attribute identifier { text }?
  & attribute source { text }?
  & attribute relation { text }?
  & attribute coverage { text }?
  & attribute rights { text }?
  & attribute keywords { text }? )
#element-paragraph = 
#  text
#  element b
#  element i
#  element u
#endnotes, zero or many, embedded in text:
element-endnote =
  element endnote {
    element number { text },
    element note { text }
  }*
#body text/contents
element-text =
  element mytext {
    text
    & element-endnote
  }
#object citation number, unique sequential number for objects:
element-ocn =
  element ocn { text }
#object container:
element-object =
  element object {
    element-ocn,
    #note nametag is only used in element-heading, object is used in both heading and content ->
    element nametag { text }?,
    element-text
  }+
#heading object container
element-heading =
  element heading {
    element-object
  }
#content/paragraph/main text object container
element-content =
  element content {
    element-object*
  },
#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.
# %% structure
element document {
  #document head:
  element head {
    attribute id { text },
    element-dc,
    attribute copyright { text }?
    #element title {
    #  attribute xml:lang { text },
    #  text
    #}
  },
  #document body:
  element body { 
    element heading1 {
      element-heading,
      element heading2 {
        element-heading,
        element heading3 {
          element-heading,
          element contents1 {
            element-heading,
            element-content*,
            element contents2 {
              element-heading,
              element-content*,
              element contents3 {
                element-heading,
                element-content*
              }*
            }*
          }+
        }+
      }+
    }+
  }
}
RELAXNG
    end
    def rnc_xhtml
      @relaxng =<<RELAXNG
# %% sax model
# Author: Ralph@Amissah.com
# $Id$
# %% definitions
#dublin core:
element-dc =
  ( attribute title { text }
  #attribute subtitle { text }?
  & attribute creator { text }?
  & attribute subject { text }?
  & attribute description { text }?
  & attribute publisher { text }?
  & attribute contributor { text }?
  & attribute date { text }?
  & attribute datecreated { text }?
  & attribute dateissued { text }?
  & attribute dateavailable { text }?
  & attribute datevalid { text }?
  & attribute datemodified { text }?
  & attribute type { text }?
  & attribute format { text }?
  & attribute identifier { text }?
  & attribute source { text }?
  & attribute relation { text }?
  & attribute coverage { text }?
  & attribute rights { text }?
  & attribute keywords { text }? ),
#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.
# %% structure
element document {
  #document head:
  element head {
    attribute id { text },
    element-dc,
    attribute copyright { text }?
    #element title {
    #  attribute xml:lang { text },
    #  text
    #}
  },
  #document body:
  element body {
    #object, unit
    element object {
      #may or may not be a heading, if heading provide heading level [1-6]:
      element heading { text }?,
      #object citation number, unique sequential number for objects:
      element ocn { text },
      #body content/text, whether heading or ordinary paragraph:
      element text { text },
      #endnotes, zero or many:
      element endnote {
        #endnotes number:
        element en_n { text },
        #endnotes content/text:
        element note { text }
      }*
    }+
  }
}
RELAXNG
    end
  end
end
__END__

