=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: document digests (md5|sha256) and structure processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Digest_view
  require SiSU_lib + '/metaverse'
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  include SiSU_Param
  include SiSU_Viz
  pwd=Dir.pwd
  class Source
    @@dg=nil
    def initialize(opt)
      @@description,@@digests,@@metaverse_structure1,@@metaverse_structure2,@@sc_info=Array.new,Array.new,Array.new,Array.new,Array.new
      @opt=opt
      @fnb=@opt.fnb
      @@endnotes_para=Array.new
      @@dg ||=SiSU_Env::Info_dir.new.digest
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::Info_dir.new(@opt.fns)
        path=SiSU_Env::Info_dir.new(@opt.fns).tell_output_path
        tool=if @opt.cmd =~/[MVv]/: "#{@env.text_editor} #{path}/#{@md.fnb}/#{@md.fn[:digest]}"
        else ''
        end
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"Document #{@@dg} Digests",tool)
        tell.green_hi_blue unless @opt.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.tell_output_path}/#{@md.fnb}/#{@md.fn[:digest]}")
        tell.flow if @opt.cmd =~/[MV]/
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        @metaverse_array=SiSU_Metaverse::Source.new(@opt).get # metaverse file drawn here
        SiSU_Digest_view::Source::Scroll.new(@metaverse_array,@md).songsheet
        SiSU_Env::Info_skin.new(@md).select
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      require SiSU_lib + '/common_text'
      include SiSU_text_utils
      @@dg,@@dl=nil,nil
      @@description,@@digests,@@metaverse_structure1,@@metaverse_structure2,@@sc_info=Array.new,Array.new,Array.new,Array.new,Array.new
      def initialize(data='',md='')
        @data,@md=data,md
        SiSU_Env::SiSU_file.new(@md).mkdir
        @filename_digest=SiSU_Env::SiSU_file.new(@md,@md.fn[:digest]).mkfile
        @@dg ||=SiSU_Env::Info_dir.new.digest
        @@dl ||=SiSU_Env::Info_dir.new.digest_length
      end
      def songsheet
      #source parser, based on metaverse creation
      #metaverse parser ...
        Scroll.new(@data,@md).message_digest
        Scroll.new(@data,@md).metaverse_structure
        Scroll.new(@data,@md).supplementary
        Scroll.new(@data,@md).output
      end
      def description(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@description << f << e
      end
      def digests(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@digests << f << e
      end
      def metaverse_structure1(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@metaverse_structure1 << f << e
      end
      def metaverse_structure2(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@metaverse_structure2 << f << e
      end
      def rcinfo(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@sc_info << f << e
      end
      def output
        @filename_digest << @@description
        @filename_digest << @@digests
        @filename_digest << @@metaverse_structure1
        @filename_digest << @@metaverse_structure2
        @filename_digest << @@sc_info
      end
      def message_digest
      #there will be a docbook mapping header, fairly complex variations
        data=@data
        dir=SiSU_Env::Info_dir.new(@md.fns)
        sys=SiSU_Env::System_call.new
        l=Hash.new(0)
        @p=Array.new
        @g,@v,@r='','',''
        data.each do |para|
          x=nil
          y=Array.new
          para_endnotes=Array.new
          if para =~/<~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)><([0-9a-f]{#{@@dl}}):([0-9a-f]{#{@@dl}})>/
            ocn,h1,h2,d_clean,d_all=$1,$2,$3,$4,$5
            @ocn=ocn unless ocn.to_i == 0
            if para=~/~\{[\d*+]+.+?<[0-9a-f]{#{@@dl}}>\}~/
              para_endnotes << para.scan(/~\{([\d*+]+).+?<([0-9a-f]{#{@@dl}})>\}~/)
            end
            ima=Array.new
            if para =~/\{(\S+\.(png|jpg))\s.+?\}(?:(?:https?|ftp):\/\/\S+|image)/
              images=para.scan(/\{(\S+\.(?:png|jpg))\s.+?\}(?:(?:https?|ftp):\/\/\S+|image)/).flatten
            else image=nil
            end
            x=case para
            when /^0~title/
              "\n" + '  '*0 +'0' + '  '*9
            when /^0~subtitle/
              "\n" + '  '*1 +'0' + '  '*8
            when /^1~/
              "\n" + '  '*2 +'1' + '  '*7 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^2~/
              "\n" + '  '*3 +'2' + '  '*6 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^3~/
              "\n" + '  '*4 +'3' + '  '*5 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^4~/
              "\n" + '  '*5 +'4' + '  '*4 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^5~/
              "\n" + '  '*6 +'5' + '  '*3 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^6~/
              "\n" + '  '*7 +'6' + '  '*2 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            else
              if para =~/Sourcefile Digest \(.*?\):\s/
                @n,@s=/#{$1}\((\S+?)\)=\s+<u>([0-9a-f]{#{@@dl}})<\/u>/.match(para)[1,2]
              end
              x=unless ocn =~ /^0$/
                if images and images.length > 0 # then get path of image & produce digest
                  @image_name,@image_dgst,@img=Array.new,Array.new,Array.new
                  images.each do |i|
                    image_source=if FileTest.file?("#{dir.image_source_local_tex}/#{i}")
                      dir.image_source_local_tex
                    elsif FileTest.file?("#{dir.image_source_remote_tex}/#{i}")
                      dir.image_source_remote_tex
                    elsif FileTest.file?("#{dir.image_source_tex}/#{i}")
                      dir.image_source_tex
                    else
                      tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:", %{"#{i}" missing}, "search locations: #{dir.image_source_local_tex}, #{dir.image_source_remote_tex} and #{dir.image_source_tex}")
                      tell.error2 unless @md.cmd =~/q/
                      nil
                    end
                    @img << /\S+\.(png|jpg)/.match(i)[1]
                    not_found_msg='image not found'
                    if image_source
                      para_image = image_source + '/' + i 
                      @image_name << i
                      @image_dgst << if @dg =~/^sha(?:2|256)$/: sys.sha256(para_image)
                      else                                      sys.md5(para_image)
                      end
                    else image_dgst[1]=not_found_msg + ' '*(32-not_found_msg.length)
                    end
                  end
                  line= "\n" + '  '*9 + ' - ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all + "\n"
                  line_image=Array.new
                  c=0 
                  @image_name.each do |ok|
                    line_image << %{                     #{@img[c]}       #{@image_dgst[c][1]}                                  #{@image_name[c]}}
                    c +=1
                  end
                  line=line + line_image.join("\n")
                else "\n" + '  '*9 + ' - ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
                end
              else
                prefix=case para
                when /DC Title: /:                   @t=/DC Title: (.+?)<~\d;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/.match(para)[1].gsub(/<\/?u>/,'').strip
                                                     'dc title          '
                when /DC Creator: /:                 @c=/DC Creator: (.+?)<~\d;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/.match(para)[1].gsub(/<\/?u>/,'').strip
                                                     'dc creator        '
                when /DC Subject: /:                 'dc subject        '
                when /DC Description: /:             'dc description    '
                when /DC Publisher: /:               'dc publisher      '
                when /DC Type: /:                    'dc type           '
                when /DC Rights: /:                  'dc rights         '
                when /DC Date: /:                    'dc date           '
                when /DC Date\.created: /:           'dc date.created   '
                when /DC Date\.issued: /:            'dc date.issued    '
                when /DC Date\.available: /:         'dc date.available '
                when /DC Date\.modified: /:          'dc date.modified  '
                when /DC Date\.valid: /:             'dc date.valid     '
                when /DC Language: /:                'dc language       '
                when /source filename: /:            'sourcefile        '
                when /Sourcefile Digest \(.+?\): /
                  dgst_extra="\n" + ' '*21 +'source' +' '*4 + @md.dgst[1] + ' '*34 + @md.fns
                                                     'sourcefile digest '
                when /RCS version number: /:         'rcs version number'
                when /RCS time: /:                   'rcs time          '
                when /RCS date: /:                   'rcs date          '
                when /CVS version number: /:         'cvs version number'
                when /CVS time: /:                   'cvs time          '
                when /CVS date: /:                   'cvs date          '
                when /Skin_Digest: /
                  dgst_extra="\n" + ' '*21 + 'skin' +' '*6 + @md.dgst_skin[1] + ' '*34 + /(skin_\S+?\.rb)/.match(@md.dgst_skin[0])[1]
                                                     "skin digest       "
                when /Generated by: /:      @v=/Generated by: (.+?)<~\d;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/.match(para)[1].gsub(/<\/?u>/,'').strip
                                                     'sisu version      '
                when /Document \(metaverse\) last generated: /: @g=/Document \(metaverse\) last generated: (.+?)<~\d;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/.match(para)[1].gsub(/<\/?u>/,'').strip
                                                     'doc last generated'
                when /Ruby version: /:               @r=/Ruby version: (.+?)<~\d;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/.match(para)[1].gsub(/<\/?u>/,'').strip
                                                     'ruby version      '
                else
                  '  '*9
                end
                dgst_extra ||=''
                "\n" + prefix +' - ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all + dgst_extra + "\n"
              end
            end
            para_endnotes[0].each { |e| y << "\n" + ' '*(28-e[0].length) + "[#{e[0].to_s}] #{e[1].to_s}" } if para_endnotes[0]
            if y: digests(x,y)
            else  digests(x)
            end
          end
        end
        dir=SiSU_Env::Info_dir.new(@fns)
        manifest="#{dir.output_links_path[:url_root]}/#{@md.fnb}/sisu_manifest.html"
        a=%{level (if any),      ocn:      digest clean (no markup/notes),  digest all (includes markup & endnotes)\n                       [endnote number] endnote digest clean\n}
        description("#@t\n")
        description("#@c\n")
        description("#{@md.fns}\n")
        description("----------------------------------------------\n")
        description("SiSU Document Content Certificate (Digest/DCC)\n")
        description("----------------------------------------------\n")
        description("                               #{@@dg} digests\n")
        description("------------\n")
        description("Sourcefile digest:             #@s\n")
        description("  source filename:             #@n\n")
        description("available outputs:             #{manifest}\n")
        description("  time generated:                #@g\n")
        description("  SiSU version used:             #@v\n")
        description("  Ruby version used:             #@r\n")
        description("------------\n")
        description("Document Digest Tree (from metaverse):\n")
        description(a)
        #digests("------------\n")
        #digests("#@v\n")
        #digests("#@g\n")
        #digests("#@r\n")
      end
      def metaverse_structure
      #there will be a docubook mapping header, fairly complex variations
        data=@data
        l=Hash.new(0)
        metaverse_structure1("------------\n")
        metaverse_structure1("document structure (heading levels)\n")
        ocn,endnotes=nil,nil
        data.each do |para|
          x=case para
          when /^0~/: l[0] +=1 
            if para =~/^0~title/: '  '*0 +'0~ == headers' + "\n" + '  '*0 +'1-6 headings:'
            end
          #when /^0~subtitle/: l[0] +=1
          #  '  '*1 +'0'
          when /^1~/: l[1] +=1
            '  '*0 +'1'
          when /^2~/: l[2] +=1
            '  '*1 +'2'
          when /^3~/: l[3] +=1
            '  '*2 +'3'
          when /^4~/: l[4] +=1
            '  '*3 +'4'
          when /^5~/: l[5] +=1
            '  '*4 +'5'
          when /^6~/: l[6] +=1
            '  '*5 +'6'
          else nil
          end
          if para =~/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/
            ocn=$1 unless $1.to_i == 0
          end
          if para =~/~\{([\d*+]+).+?<[0-9a-f]{#{@@dl}}>\}~/
            endnotes=$1 unless $1.to_i == 0
          end
          metaverse_structure1("#{x}\n") if x
        end
        metaverse_structure2("------------\n")
        metaverse_structure2("document structure *\n")
        [0,1,2,3,4,5,6].each {|y| metaverse_structure2("#{y}~            = #{l[y]}\n") }
        metaverse_structure2("objects (ocn) = #{ocn}\n")
        metaverse_structure2("endnotes      = #{endnotes}\n")
        metaverse_structure2("* number of headers (0~) and of each heading level (1~ to 6~)\n")
      end
      def supplementary
        if defined? @md.sc_number and @md.sc_number
          rcinfo("------------\n")
          rcinfo("source control information\n")
          rcinfo("  (the following information while not important for document content certification\n   may help the publisher in locating the version referred to)\n")
          rcinfo("  rcs version number:            #{@md.sc_number}\n")
          if defined? @md.sc_date and @md.sc_date
            rcinfo("  rcs date:                      #{@md.sc_date}\n")
          end
          if defined? @md.sc_time and @md.sc_time
            rcinfo("  rcs time:                      #{@md.sc_time}\n")
          end
        end
        rcinfo("------------\n")
        rcinfo("Note: the time generated related fields (text and digests) will vary between otherwise identical document outputs\n")
      end
    end
  end
end
__END__

