=begin
 * Name: modify.rb
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: Conversion script from kdissert .kdi to sisu markup .ssm (master document)
 * Copyright (C) 2004, 2006 Ralph Amissah
 * Packaged with: SiSU - Simple information Structuring Universe -
     Structured information, Serialized Units
 * SiSU Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_sst_from_xml
  require SiSU_lib + '/sysenv'
  class Convert
    require 'rexml/document'
    include REXML
    def initialize(opt)
      @opt=opt
      @sisu,@sisu_base=[],[]
    end
    def tell(filename,type)
      SiSU_Screen::Ansi.new(@opt.cmd,"XML #{type} to SiSU sst","#{filename} --> #{filename}.sst").green_hi_blue
    end
    def read
      xml_to_sisu
    end
    def markup_head(text)
      text.strip!
      text.gsub!(/(?:\s*\n|\s\s+)/,' ')
      text.gsub!(/<header class=['"]\S+?['"]>(.+?)<\/header>/,'\1')
      text.gsub!(/<(\w+)>(.+?)<\/\w+>/,'@\1: \2')
      text.gsub!(/<header class=['"]\S+?['"]><(\w+)>(.+?)<\/\w+><\/header>/,'@\1: \2')
      text.gsub!(/\s +/,' ')
      text.strip!
      text + "\n\n"
    end
    def markup(text)
      text.strip!
      text.gsub!(/(?:\s*\n|\s\s+)/,' ')
      text.gsub!(/<text class='h1'>(.+?)<\/text>/,':A~ \1')
      text.gsub!(/<text class='h2'>(.+?)<\/text>/,':B~ \1')
      text.gsub!(/<text class='h3'>(.+?)<\/text>/,':C~ \1')
      text.gsub!(/<text class='h4'>(.+?)<\/text>/,'1~ \1')
      text.gsub!(/<text class='h5'>(.+?)<\/text>/,'2~ \1')
      text.gsub!(/<text class='h6'>(.+?)<\/text>/,'3~ \1')
      text.gsub!(/<text class='norm'>(.+?)<\/text>/,'\1')
      text.gsub!(/<endnote symbol='norm'>(.+?)<\/endnote>/,'~{ \1 }~')
      text.gsub!(/<br ?\/>/,'<br>')
      text.gsub!(/\s +/,' ')
      text.strip!
      #text.gsub!(/<header>(.+?)<\/header/,"@#{x.name}: \\1\n\n")
      text + "\n\n"
    end
    def sax #(file) 
      out_file=File.new(@output_file_name,'w')
      head=@doc.root.get_elements('//head/header')
      body=@doc.root.get_elements('//object/text')
      head.each do |x|
        if x.name == 'header'
          head=markup_head(x.to_s)
          out_file.puts head
        end
      end
      body.each do |x|
        if x.name == 'text'
          body=markup(x.to_s)
          out_file.puts body
        end
      end
    end
    def node #(file)
      sax #(file)
    end
    def dom #(file) 
      raise "#{__FILE}::#{__LINE__} xml dom representation to sst not yet implemented (experimental simple xml representations sax and node to sst are in place)."
    end
    def xml_to_sisu
      unless @opt.files.empty?
        @opt.files.each do |xml|
          @sisu_base=[]
          if xml =~/\.sx[sdn]\.xml$/
            begin
              @doc_str=IO.readlines(xml,'').join("\n")
              @output=File.new("#{xml}.sst",'w')
              @doc=REXML::Document.new(@doc_str)
              @output_file_name="#{Dir.pwd}/#{xml}.sst"
              @el=[]
            rescue REXML::ParseException
            end
          end
          if xml =~/\.sxs\.xml$/
            unless @opt.cmd =~/q/; tell(xml,'sax')
            end
            sax
          elsif xml =~/\.sxd\.xml$/
            unless @opt.cmd =~/q/; tell(xml,'dom')
            end
            dom
          elsif xml =~/\.sxn\.xml$/
            unless @opt.cmd =~/q/; tell(xml,'node')
            end
            node
          else puts "filename not recognised: << #{xml} >>"
          end
          @output << @sisu_base
        end
      else puts '.xml file for conversion to sisu expected'
      end
      puts @opt.files.inspect
    end
  end
end
__END__
