#!/usr/bin/env ruby
=begin
 * Name: modify.rb
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: A conversion script for canned substitutions,
     a fairly generic simple tool that can be used to store other canned conversions,
     used here for altering SiSU markup
 * Copyright (C) 2004, 2006 Ralph Amissah
 * Packaged with: SiSU information Structuring Universe -
     Structured information, Serialized Units
 * SiSU Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: configure rc in ~/.sisu/sisurc.yaml
=end
module SiSU_Modify
  class Convert_markup
    def initialize(cf,files)
      @cf,@files=cf,files
      @description="This is a script that contains canned text conversions for reuse"
    end
    def current_match_and_replace #Disable, edit manually
      #convert_pre_37_to_38_experimental
    end
    def message(text)
      response=''
      while response !~/yes/
        print %{
    #{text}
    to continue type "yes" [to exit type "no" or "quit"]: }
        response=File.new('/dev/tty').gets.strip
        exit if response =~/^(?:quit|no)$/
      end
    end
    def help
    print <<WOK

#@description

modify.rb --default [filename/wildcard]
  performs the current default conversion that is set
  [handle with care, (may be disabled)]

modify.rb --to38 [filename/wildcard]
  converts pre 0.37 sisu markup to 0.38 experimental

modify.rb --to37 [filename/wildcard]
  converts pre 0.37 sisu markup to 0.38 experimental

note converting twice in a single direction will result
in markup inconsistency

An alternative script has been introduced,
try 'sisu --convert'

modify.rb --default
  performs the current default conversion that is set
  on the files matched in default the settings
  [handle with care, (may be disabled)]

WOK
      exit
    end
    #%% substitutions to be made
    def convert_pre_37_to_38_experimental
      message('convert sisu markup from 0.37 to 0.38 experimental (rad)')
      [
        [/^0~(\S+?)([+-])\s+/,    "@\\1:\\2 "],
        [/^0~(\S+)\s+/,           "@\\1: "],
        [/^@toc:\s+/,             "@structure: "],
        [/^1~/,                   ':A~'],
        [/^2~/,                   ':B~'],
        [/^3~/,                   ':C~'],
        [/^4~/,                   '1~'],
        [/^5~/,                   '2~'],
        [/^6~/,                   '3~']
      ]
    end
    def convert_38_experimental_to_37
      message('convert sisu markup from 0.38 experimental (rad) to 0.37')
      [
        [/^@(\S+?):([+-])\s+/,    "0~\\1\\2 "],
        [/^@(\S+?):\s+/,          "0~\\1 "],
        [/^0~structure\s+/,       "0~toc "],
        [/^1~/,                   '4~'],
        [/^2~/,                   '5~'],
        [/^3~/,                   '6~'],
        [/^:?A~/,                 '1~'],
        [/^:?B~/,                 '2~'],
        [/^:?C~/,                 '3~']
      ]
    end
    def markup_version?(i)
      file=File.open(i,'r')
      cont=file.readlines
      file.close
      markup_version=nil
      cont.each do |y|
        if y =~/^:?A~/
          markup_version='0.38'
          break
        end
        if y =~/^1~/
          markup_version='0.37'
          break
        end
        #if y =~/^1{~/
        #  markup_version='0.16'
        #  break
        #end
        markup_version='0.37'
      end
      markup_version
    end
    def conversion
      #%% do it                                   -------------------------->
      if @files and @files.length > 0
        p @files
        mr=nil
        #%% changes to make m match, r replace      -------------------------->
        if @cf =~/--help/: help
        else
          message("WARNING, proceed at your own risk,\npermanent changes requested for the above named files\n  best that you check (manually) what this file is set to do\n  conversions set are at the top of the file")
          mr=case @cf
          when /--convert|default/:     current_match_and_replace
          when /--(?:(?:37)?to38|rad)/: convert_pre_37_to_38_experimental
          when /--(?:(?:38)?to37)/:     convert_38_experimental_to_37
          else help
          end
        end
        match_and_replace=mr
        #start_processing =/not used in this example/i
        end_processing =/END\s+OF\s+FILE/
        @files.each do |i|
          @new,@matched,@flag_start,@flag_end,@empty1,@empty2=true,false,false,false,false,false
          o="#{i}.bk" #o is for old
          file=File.open(i,'r')
          cont=file.readlines
          file.close
          cont.each do |y|
          #p y
          #p y if y =~/^[1-6]~/
            match_and_replace.each do |m,r|
              if y =~m
                if @new
                  @new=false
                  File.unlink(o) if File.exists?(o)
                  #system("lv #{i} > #{o}")
                  File.rename(i,o)
                  File.unlink(i) if File.exists?(i)
        	    @file=File.new(i,'w')
                  @matched=true
                  break
                end
              end
            end
          end
          if @matched
            puts "match in #{i}"
            @flag_start=true
            cont.each do |y|
              if y =~end_processing: @flag_end=true
              end
              if @flag_start and not @flag_end
                match_and_replace.each do |m,r|
                  if y =~m
                    p m.to_s + ' -> ' + r
                    puts "in:  #{y}"
                    y.gsub!(m,r) if m and r
                    puts "out: #{y}"
                  end
                end
              end
              #if y =~start_processing: @flag_start=true
              #end
              #if y =~m1
              #end
              if y=~/^\s*$/: @empty1=true
              else           @empty1=false
              end
              @file.puts y unless (@empty1==true and @empty2==true)
              if y=~/^\s*$/: @empty2=true
              else           @empty2=false
              end
              #@file << y + "\n"
            end
            @file.close
          else puts "NO match in #{f}"
          end
        end
      else puts "this routine makes permanent changes to the contents of the files matched, as instructed within [no matches]"
      end
    end
  end
end
#%% files to match for this conversion set  ------------------------->
f=$*
p $*
cf=f[0].to_s
f.shift
match_and_replace=Array.new
#unless cf and cf =~/--/
#  puts <<WOK
#
##@description
#
#usage:
#  modify.rb --convert [filename/wildcard]
#for help
#  modify.rb --help
#WOK
#  exit
#end
unless f.length > 0: f=Dir.glob("[a-z]*.ss?")  #restricted to sisu type files, it need not be
end
#f=Dir.glob("{bin,conf,data,lib}/**/*.rb")     #sisu development
#f=Dir.glob("[^_]/**/*")                       #all files subdirectories beneath pwd except those starting with _
SiSU_Modify::Convert_markup.new(cf,f).conversion
__END__
