=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: share sisu source markup file, copy it to output directory!

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Markup
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  pwd=Dir.pwd
  class Source
    require 'fileutils'
    include FileUtils
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      stub=@opt.fnb.gsub(/~[a-z]+$/,'')
      @output_path="#{@env.path.output}/#{stub}"
    end
    def read
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Share Document Source!',@opt.fns)
      tell.green_hi_blue unless @opt.cmd =~/q/
      tell=SiSU_Screen::Ansi.new(@opt.cmd,"Copy sisu markup file to output directory","#{@opt.fns} -> #@output_path")
      tell.warn unless @opt.cmd =~/q/
      File.mkpath(@env.path.output) unless FileTest.directory?(@env.path.output)
      File.mkpath(@output_path) unless FileTest.directory?(@output_path)
      if FileTest.directory?(@output_path)
        unless @opt.fns =~/\.ssm$/; cp(@opt.fns,@output_path)
        else
          req=@opt.fns.gsub(/(.+)?\.ssm$/,'\1.composite.sst')
          file=@opt.fns.gsub(/(.+)?\.ssm$/,'\1._sst')
          if FileTest.file?(file);  cp(file,"#@output_path/#{req}")
          else print "did not find #{file} to copy"
          end
        end
      else
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"Output directory does not exist","#{@opt.fns} -> #@output_path")
        tell.warn unless @opt.cmd =~/q/
        exit
      end
    end
  end
end
__END__
