=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: base formatting template for html generation

=end
module SiSU_HTML_Format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(md,paranum)
      @md=md
      @paranum=paranum[/(\d+)/m,1]
      @paranum ||=''
      vz=SiSU_Env::Get_init.instance.skin
      @skin_no_ocn=if defined? vz.ocn_display_off \
      and vz.ocn_display_off == true
        true
      else false
      end
    end
    def ocn_display
      if @md.markup.inspect =~/no_ocn/ \
      or @md.mod.inspect =~/--no-ocn/ \
      or @skin_no_ocn
        ocn_class='ocn_off'
        @paranum.gsub(/^(\d+|)$/,
        %{  <p class="#{ocn_class}">
    &nbsp;
  </p>})
      else
        ocn_class='ocn'
        @paranum.gsub(/^(\d+|)$/,
        %{  <p class="#{ocn_class}">
    &nbsp;&nbsp;\\1
  </p>})
      end
    end
    def name
      %{<a name="#@paranum" />}
    end
    def id #w3c? "tidy" complains about numbers as identifiers ! annoying
      %{id="o#@paranum"}
    end
    def goto
      %{<a href="##@paranum">}
    end
  end
  class Paragraph_id_ocn #used by table version #work area 2003w48
    attr_accessor :paranum,:font,:p_num
    def initialize(md,paranum)
      @paranum,@vz,@p_num=paranum,SiSU_Env::Get_init.instance.skin,SiSU_HTML_Format::Paragraph_number.new(md,paranum) #font
    end
    def txt
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@vz.font_size_txt} #{@vz.font_color} #{@vz.font_face}>}
    end
    def txt_00
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@vz.font_size_txt_00} #{@vz.font_color} #{@vz.font_face}>}
    end
    def font_citation
      %{<font #{@vz.font_size_txt} #{@vz.font_face}>}
    end
    def endnote
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@vz.font_size_endnote} #{@vz.font_color} #{@vz.font_face}>}
    end
    def table
      %{  <p #{@p_num.id} align="left">#{@p_num.name}
  <font #{@vz.font_small} #{@vz.font_color} #{@vz.font_face}>}
    end
    def tiny
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@vz.font_tiny} #{@vz.font_color} #{@vz.font_face}>}
    end
    def small
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@vz.font_small} #{@vz.font_color} #{@vz.font_face}>} # keep but not used?
    end
    def font_tiny
      %{<font #{@vz.font_tiny} #{@vz.font_face}>}
    end
    def font_small
      %{<font #{@vz.font_small} #{@vz.font_face}>}
    end
    def header_
      %{  <p #{@p_num.id} align="center">#{@p_num.name}
  <font #@vz.font color="#@color" #{@vz.font_face}>}
    end
  end
  class Head_information
    include SiSU_Viz
    include SiSU_HTML_Format
    include SiSU_Env
    attr_reader :md,:sfx,:pdf,:rdf,:vz
    def initialize(md='')
      @md=md
      @sfx,@pdf=@md.sfx,@md.pdf
      @rdf=SiSU_XML_tags::RDF.new(md)
      # DublinCore 1 - title
      @vz=SiSU_Env::Get_init.instance.skin
      @css=SiSU_Env::CSS_stylesheet.new(md)
      @seg_name_html=(SiSU_HTML::Source::Seg.new.seg_name_html || [])
      @seg_name_html_tracker=(SiSU_HTML::Source::Seg.new.seg_name_html_tracker || [])
      case @md.file_type
      when /php/; @index='index' # @index="index.php"
      else        @index='index'
      end
      @metalink='#metadata'
      @tocband_scroll,@tocband_segtoc=nil,nil
    end
    def doc_type
      %{<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">\n}
    end
    def toc_head_escript #embedded script in this case PHP
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    def seg_head_escript #embedded script in this case PHP
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    def table_close
      %{  </font>
#{@vz.table_close}}
    end
    def buttons_home
      %{<!- home and index buttons -!>
  #{@vz.banner_home_and_index_buttons}
<!- home and index buttons -!>}
    end
    def copyat
      %{#{@vz.paragraph_font_tiny}copy @
  <a href="#{@vz.url_home}" #{@vz.js_home}>
    #{@vz.txt_home}
  </a></h1>}
    end
  end
  class Widget < Head_information
    def initialize(md)
      super(md)
      @md=md
      @cf_defaults=SiSU_Env::Info_processing_flag.new
    end
    def home
      %{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="../index.html" target="_top">
  #{@vz.png_homepage}</a>
</td>
}
    end
    def scroll(text)
      if @md.fns =~ /\.(?:-|ssm\.)?sst$/
        scroll=%{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:doc]}" target="_top" #{@vz.js_doc}>
    #{text}
  </a>
</td>
}
      end
    end
    def seg(text)
      %{<td align="center" bgcolor="#99CC66">
  <a href="#{@md.fn[:toc]}" target="_top" #{@vz.js_doc}>
    #{text}
  </a>
</td>
}
    end
    def search
      env=SiSU_Env::Info_env.new(@md.fns,@md)
      env.widget.search_form('sisusearch',nil,nil,true)
    end
    def manifest
      %{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:manifest]}" target="_top" #{@vz.js_manifest}>
    #{@vz.nav_txt_manifest}
  </a>
</td>}
    end
    def pdf
      pdf=if @md.programs[:pdf] \
      and @cf_defaults.cf_0 =~/p/
        %{
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@vz.js_portrait}>
    #{@vz.nav_txt_pdf_portrait}
  </a>
</td>
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@vz.js_landscape}>
    #{@vz.nav_txt_pdf_landscape}
  </a>
</td>
}
      else ''
      end
    end
    def odf
      odf=if @cf_defaults.cf_0 =~/o/
        %{
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:odf]}" target="_top" #{@vz.js_odf}>
    #{@vz.nav_txt_odf}
  </a>
</td>}
      else ''
      end
    end
    def concordance(text)
      if @md.concord_make \
      and @md.wc_words < 300000 #max word count for display of concordance here as would now be a large file
  %{<td align="center" bgcolor=#{@vz.color_band2}>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@vz.js_concordance}>
      #{text}
    </a>
  </td>}
      else ''
      end
    end
  end
  class Head_toc < Head_information
    def initialize(md)
      super(md)
      @md=md
      @tocband_scroll,@tocband_segtoc=make_scroll,make_seg
    end
    def scroll_head_navigation_band
      pdf=if @md.programs[:pdf]
        <<WOK
<td align="center" width="60%">
  #{make_seg_scroll_pdf}
</td>
WOK
      else ''
      end
      %{<table summary="table of contents scroll navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{@vz.banner_band}
</td>#{pdf}
<td width="20%">
  &nbsp;
#{@vz.table_close}
<p />}
    end
    def concordance_navigation_band(type='')
      if type=~/pdf/
        @tocband_concordance=make_concordance
      end
      %{<table summary="concordance navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
 #{@vz.banner_band}
</td>
<td width="60%" align="center">
  #@tocband_concordance
</td>
<td width="20%" align="right">
  &nbsp;<a href="index.html" target="_top" alt="-&gt;">
      #{@vz.png_nav_toc}
    </a>&nbsp;
#{@vz.table_close}
<p />}
    end
    def seg_head_navigation_band(type='')
      if type=~/pdf/
        @tocband_segtoc=make_scroll_seg_pdf
      end
      firstseg=%{<a href="#{@md.fnl[:pre]}#{@md.firstseg}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" alt="-&gt;">
      #{@vz.png_nav_nxt}
    </a>} if @md.firstseg =~/\S+/
      %{<table summary="table of contents segment navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
 #{@vz.banner_band}
</td>
<td width="60%" align="center">
  #@tocband_segtoc
</td>
<td width="20%" align="right">
  &nbsp;#{firstseg}&nbsp;
#{@vz.table_close}
<p />}
    end
    def manifest_link(text)
  %{<font size=2>
    <a href="#{@md.fn[:manifest]}" target="_top" #{@vz.js_manifest}>#{text}</a>
  </font>}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@vz.js_concordance}>
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def make_seg_scroll_pdf
      wgt=Widget.new(@md)
      scroll=%{<td align="center" bgcolor=#{@vz.color_band2}>
  #{@vz.nav_txt_doc_link}
</td>
}
      %{<table summary="toc segment and scroll with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{scroll}
  #{wgt.seg(@vz.nav_txt_toc_link)}#{wgt.pdf}#{wgt.odf}
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def make_scroll_seg_pdf
      manifest=scroll=seg=''
      wgt=Widget.new(@md)
      seg=%{<td align="center" bgcolor=#{@vz.color_band2}>
  #{@vz.nav_txt_toc_link}
</td>
}
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{seg}
  #{wgt.scroll(@vz.nav_txt_doc_link)}#{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def make_concordance
      manifest=scroll=seg=''
      wgt=Widget.new(@md)
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{wgt.seg(@vz.nav_txt_toc_link)}#{wgt.scroll(@vz.nav_txt_doc_link)}#{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@md.html_title}
  </title>
  <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
  #{@rdf.rdftoc}
  #{@rdf.metatag_html}
  #{@vz.font_css_table_file}
</head>
#{@vz.color_body}
  <a name="top" id="top"></a>
  <a name="up" id="up"></a>
  <a name="start" id="start"></a>
  #{@vz.js_top}}
    end
    def links_guide_vertical_open #???
      url=(defined? @vz.url_hp) && @vz.url_hp =~/^http:\/\/\S+$/ ? @vz.url_hp : @vz.url_home
      %{<div id="vertical_links">
  <ul id="vertical">
  <li class="refbold">
    <a href="#{url}" #{@vz.js_home}>
      #{@vz.txt_hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.fn[:manifest]}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_horizontal_open #???
      url=(defined? @vz.url_hp) && @vz.url_hp =~/^http:\/\/\S+$/ ? @vz.url_hp : @vz.url_home
      %{<div id="horizontal_links">
  <ul id="horizontal">
  <li class="refbold">
    <a href="#{url}" #{@vz.js_home}>
      #{@vz.txt_hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.fn[:manifest]}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_open(type='horizontal')
      if type=='vertical'; links_guide_vertical_open
      else                 links_guide_horizontal_open
      end
    end
    def links_guide_close #(type='horizontal')
      insert=''
      insert=@vz.banner_home_guide if @md.sfx_src =~/lm?/
      #insert=@vz.banner_home_guide if @md.sfx_src =~/s?/
      insert=if @md.sfx_src =~/s?/
        link='http://www.jus.uio.no/sisu'                      #get from defaults
        url='www.jus.uio.no/sisu'
        name='SiSU electronic documents'                            #get from defaults
        #name='SiSU electronic documents/books'                      #get from defaults
        insert= %{  <li class="refbold">
    <a href="#{link}" alt="#{name}" target="_top">
      #{name}
    </a>
  </li>
  <li class="ref">
    <a href="#{link}" alt="#{name}" target="_top">
      #{url}
    </a>
  </li>
  </ul>
</div>}
      end
      %{ #{insert}
<!- quick ref -!>}
    end
    def prefix_a
    end
    def rights
      rights=@md.dc_rights.gsub(/^\s*Copyright\s+\(C\)/,'Copyright <sup>&copy;</sup>&nbsp;')
      %{<p class="small_left">Rights: #{rights}</p>
<p />}
    end
    def prefix_b
      %{<p class="small_left">Prefix: #{@md.prefix_b}<p />}
    end
    def scroll_head_title_banner_open
      %{<center>
#{@md.icon}
</center>
#{@vz.banner_instrument_cover_band_scr}}
    end
    def seg_head_title_banner_open
      %{<center>
  #{@md.icon}
</center>
#{@vz.banner_instrument_cover_band_seg}}
    end
    def make_scroll
      concord=concordance_link(@vz.nav_txt_concordance)
      %{<table summary="toc scroll" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white" border="0">
  #{@vz.nav_txt_doc_link}
</td>
<td align="center" bgcolor="white">
   #{concord}
#{@vz.table_close}}
    end
    def make_seg
      concord=concordance_link(@vz.nav_txt_concordance)
      %{<table summary="toc segment" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white">
  #{@vz.nav_txt_toc_link}
</td>
<td align="center" bgcolor="white">
  <font size=2>
   #{concord}
#{@vz.table_close}}
    end
    def manifest #check structure
      manifest=manifest_link(@vz.nav_txt_manifest)
      %{#{@vz.margin_txt_3}
  #{@vz.paragraph_font_small}
   #{manifest}
    </font>
#{@vz.table_close}}
    end
    def concordance #check structure
      concord=concordance_link(@vz.nav_txt_concordance)
      %{#{@vz.margin_txt_3}
  #{@vz.paragraph_font_small}
   #{concord}
    </font>
#{@vz.table_close}}
    end
    def metadata
      %{#{@vz.margin_txt_3}
#{@vz.paragraph_font_small}
  <a href="#@metalink" #{@vz.js_metalink}>
    <i>MetaData</i>
    <font size="1" color="#777777">
      &nbsp;&nbsp;&nbsp;
    </font>
  </a>
  </font>
#{@vz.table_close}}
    end
    def seg_metadata
      @metalink=%{./#{@md.fn[:metadata]}}
      metadata
    end
    def seg_tail
      %{<p>&nbsp;<p>
<table summary="toc segment tail" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{@vz.banner_band}
</td>
<td width="60%">
  <center>
    #{@tocband_segtoc}
  </center>
</td></tr>
</table>
<p>&nbsp;</p>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>}
    end
    def scroll_tail
      nav=scroll_head_navigation_band
      %{#{nav}
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>}
    end
    def seg_navigation_tail #this is a bug area, look up and "tidy"
      #nav=scroll_head_navigation_band
      %{<p>&nbsp;</p>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>}
    end
  end
  def html_close
    %{</body>
</html>}
  end
  class Head_scroll < Head_toc
    def initialize(md)
      super(md)
    end
    def toc_owner_details
      %{#{@vz.margin_txt_3}
#{@vz.paragraph_font_small}
  <a href="#owner.details">
    Owner Details
    <font size="1" color="#777777">
      &nbsp;&nbsp;&nbsp;
    </font>
  </a>
  </font>
#{@vz.table_close}}
    end
    def table
      %{<table summary="scroll table" width=#{@vz.table_width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width=#{@@indent['level_1']} align="right">
</th>
<td valign="top">
#{@vz.paragraph_txt}}
    end
    def table1
      %{<table summary="scroll table1" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} #{@vz.color_color_table1} align="justify">
<tr><td valign="top">
#{@vz.paragraph_txt}}
    end
    def table2
      %{<table summary="scroll table2" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} #{@vz.color_color_table2} align="justify">
<tr><td valign="top">
#{@vz.paragraph_txt}}
    end
    def toc_endnote
      %{#{@vz.margin_txt_3}
#{@vz.paragraph_font_small}
  <a href="#endnotes">
    Endnotes
  </a>
#{@vz.table_close}}
    end
    def title_endnote
      %{#{@vz.margin_txt_0}
  #{@vz.paragraph_txt}
  <a name="endnotes" id="endnotes"></a>
#{@vz.margin_num}
  &nbsp;
#{@vz.table_close}}
    end
    def tail
      %{<br />
#{@vz.margin_txt_0}
<table summary="scroll tail" bgcolor="#777777">
<tr><td width="20%">
#{@vz.banner_band}
</td>
<td width="60%">
<center>#@tocband_scroll</center>
</td></tr>
</table>
<br />
#{@vz.paragraph_txt}
  <center>
    #{@vz.credits_splash}
    #{@vz.credits_sisu}
  </center>
#{@vz.margin_num}
#{@vz.table_close}
<a name="bottom id="finish"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits" id="credits"></a>
<font color="white" size="0">
  #{@md.title*10}
</font>
</body>
</html>}
    end
  end
  class Head_seg < Head_information
    def initialize(md)
      super(md)
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@seg_name_html[@seg_name_html_tracker]} -
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdfseg}
#{@rdf.metatag_html}
#{@vz.font_css_table_file}
</head>
#{@vz.color_body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@vz.js_top}}
    end
    def title_banner(title,subtitle,creator)
    end
    def dot_control_pre_next
      %{<table summary="segment hidden control pre and next" width="100%" border="0" cellpadding="0" bgcolor=#{@vz.color_grey_pale} align="center">
<tr><td align="left">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_dot_nxt}
  </a>
#{@vz.table_close}}
    end
    def dot_control_pre
      %{<table summary="segment hidden control pre" width="100%" border="0" cellpadding="0" bgcolor=#{@vz.color_grey_pale} align="center">
<tr><td align="left">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-2]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{@md.fn[:toc]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_dot_nxt}
  </a>
#{@vz.table_close}}
    end
    def toc_nav(f_pre=false,f_nxt=false,use=1)
      pre=nxt=''
      toc=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_toc}
  </a>
</td>}
      pre=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-use]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_pre}
  </a>
</td>} if f_pre==true
      nxt=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_nxt}
  </a>
</td>} if f_nxt==true
      %{<table summary="segment navigation pre/next" border="0" cellpadding="3" cellspacing="0">
<tr>
#{pre}
#{toc}
#{nxt}
<td>
#{@vz.table_close}}
    end
    def toc_next2
      pre,nxt=false,true
      toc_nav(false,true).dup
    end
    def toc_pre_next2
      toc_nav(true,true).dup
    end
    def toc_pre2
      toc_nav(true,false,2).dup
    end
    def manifest_link(text)
  %{<font size=2>
    <a href="#{@md.fn[:manifest]}" target="_top" #{@vz.js_manifest}>
      #{text}
    </a>
  </font>}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@vz.js_concordance}>
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def doc_types #used in seg_nav_band ###
      scroll=seg=''
      wgt=Widget.new(@md)
      #dir=SiSU_Env::Info_env.new(@md.fns)
      %{
<table summary="segment navigation available documents types: toc,doc,pdf,concordance" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{wgt.seg(@vz.nav_txt_toc_link)}
  #{wgt.scroll(@vz.nav_txt_doc_link)}
  #{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def toc_pre_next3 #used with seg_doc_types in seg_nav_band #with pdf & other doc types #knxjs
      %{<table summary="segment navigation pre/next" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_previous}
  </a>
</td>
<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_toc}
  </a>
</td>
<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_next}
  </a>
#{@vz.table_close}}
    end
    def toc_next3 #used with seg_doc_types in seg_nav_band #with pdf & other doc types #knxjs
      %{<table summary="segment navigation next" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_toc}
  </a>
</td>
<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_next}
  </a>
#{@vz.table_close}}
    end
    def toc_pre3 #used with seg_doc_types in seg_nav_band #with pdf and other doc types #knxjs
    # note endnotes is now two back, with insertion between end of text and metadata, but what happens where no endnote?
      %{<table summary="segment navigation pre" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-2]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_previous}
  </a></td>
<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_toc}
  </a>
#{@vz.table_close}}
    end
    def toc_endnote
    end
    def title_endnote(title,subtitle,creator,table_top_control)
      %{#{@vz.banner_instrument_cover_band_seg}
  <h1 class="banner">
    #{title}
  </h1>
  <h1 class="subbanner">
   #{subtitle}
  </h1>
  <h1 class="subbanner">
    #{creator}
  </h1>
  <h4 class="banner">
    Endnotes
  </h4>
#{@vz.table_close}
<h1>Endnotes</h1>}
    end
    def navigation_table
      %{<table summary="navigation segment table" width=#{@vz.table_width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width="#{@@indent['leve_1']}" align="right">
</td>
<td valign="top">
  <font size=2>}
    end
    def navigation_table1
      %{<table summary="navigation segment table1" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} bgcolor=#{@vz.color_table1} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def navigation_table2
      %{<table summary="navigation segment table2" width=#{@vz.table_width_2} border="0" cellpadding=#{@vz.table_cellpad_box} bgcolor=#{@vz.color_table2} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def header_advert_local_1
      dir=SiSU_Env::Info_env.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="http://#{@md.ad_url}#@sfx" target="_top">
    <img border="0" src="#{dir.url.images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@vz.table_close}
</center>}
    end
    def header_advert_local_2
      dir=SiSU_Env::Info_env.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="#{@md.ad_url}#@sfx" target="_top">
    <img border="0" src="#{dir.url.images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@vz.table_close}
</center>}
    end
    def header_advert_external
      dir=SiSU_Env::Info_env.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="#{@md.ad_url}#@sfx" target="external">
    <img border="0" src="#{dir.url.images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@vz.table_close}
</center>}
    end
    def credit
      %{<br/>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits" id="credits"></a>}
    end
    def navigation_band(segtocband,seg_table_top_control)
      %{<table summary="segment navigation band" bgcolor=#{@vz.color_band1} width="100%"><tr>
<td width="20%" align="left">
#{@vz.banner_band}
</td>
<td width="60%" align="center">
  #{doc_types}
</td>
<td width="20%" align="right">
  #{segtocband}
</td></tr>
</table>
#{seg_table_top_control}}
    end
    def endnote_mark
%{<p class="center" id="endnotes">
<a href="#top"><hr></a></p>} #revisit
    end
  end
  class Format_text_object
    @vz=SiSU_Env::Get_init.instance.skin
    @@dp=nil
    attr_accessor :md,:one,:two,:three,:parablock,:table,:link,:linkname,:format,:paranum,:p_num,:para_id,:headname,:margin,:paragraph,:table,:banner,:url,:icon,:font,:one_stripped
    def initialize(md='',*txt)
      @md,@one,@two,@three=md,txt[0],txt[1],txt[2]
      rgx=/^[1-6-]~/
      @one_stripped=@one.gsub(rgx,'') if @one =~rgx
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      rgx=/~[{\[][\d*+]+\s+(.+?)<#@dp>[}\]]~/ #problem introduced
      @one_stripped=@one.gsub(rgx,'\1') if @one =~rgx #problem introduced
      @link,@linkname=txt[0],txt[1]
      @format,parablock=txt[0],txt[1]
      @parablock=parablock
      ##performance hit does not justify action:
      #@parablock=if parablock=~/\S+/ and parablock !~/<!Th?¡ /m
      #  wrap=SiSU_text_utils::Wrap.new(parablock,70,4)
      #  wrap.line_wrap
      #else parablock
      #end
      if txt[2]=~/\d+/
        @paranum=txt[2][/(\d+)/m,1] # unless paranum =~/#/
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,@paranum)
        @para_id=Paragraph_id_ocn.new(@md,@paranum) #used by table version
      end
      @headname=''
      if @format =~ /\d~(\S+)/
        headname=$1 #format[/\d~(\S+)/m,1]
        @headname=if headname =~/^[a-zA-Z]/; %{<a name="#{headname}" id="#{headname}"></a>} #consider: h_#{headname}
        else %{<a name="h#{headname}" id="h#{headname}"></a>}
        end
      end
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def para_form(tag,attrib)                                                        # regular paragraphs shaped here
      ul=ulc=''
      ul,ulc="<ul>\n  ","\n  </ul>" if @tag =~/li/
      %{#{@vz.margin_css}
  #{ul}<#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name}
    #@parablock
  </#{tag}>#{ulc}
#{@vz.margin_num_css}
  #{@p_num.ocn_display}
#{@vz.table_close}
}
    end
    def para
      para_form('p','norm')
    end
    def code
      para_form('p','code')
    end
    def center
      para_form('p','center')
    end
    def bold
      para_form('p','bold')
    end
    def bullet
      para_form('li','bullet')
    end
    def format(tag,atrib)
      para_form(tag,atrib)
    end
    def dl
      "<dl><b>#@one</b> #@two</dl>"
    end
    def table_end                                                                #<!TZ!>
      %{</table>
  #{@vz.margin_num_css.strip}
    #{@p_num.ocn_display}
  #{@vz.table_close}}
    end
    def no_paranum
      %{#{@vz.margin_css}
#{@vz.paragraph_txt}
  #@one #@two
#{@vz.margin_num}
#{@vz.table_close}}
    end
    def gsub_body
      case @one
      when /^(?:<:i[1-9]>\s*)?\((i+|iv|v|vi+|ix|x|xi+)\)/
        @one.gsub!(/^\((i+|iv|v|vi+|ix|x|xi+)\)/,'<b>(\1)</b>')
        @one.gsub!(/^(<:i[1-9]>)\s*\((i+|iv|v|vi+|ix|x|xi+)\)/,'\1<b>(\2)</b>')
      when /^(?:<:i[1-9]>\s*)?\(?(\d|[a-z])+\)/
        @one.gsub!(/^\((\d+|[a-z])+\)/,'<b>(\1)</b>')
        @one.gsub!(/^(<:i[1-9]>)\s*\((\d+|[a-z])+\)/,'\1<b>(\2)</b>')
      when /^\s*\d{1,3}\.\s/
        @one.gsub!(/^\s*(\d+\.)/,'<b>\1</b>')
      when /^\s*[A-Z]\.\s/
        @one.gsub!(/^\s*([A-Z]\.)/,'<b>\1</b>')
      end
    end
    def bold_para
      %{#{@vz.margin_txt_0}
  <p class="bold">
    #@one
  </p>
#{@vz.margin_num_css}
  &nbsp;&nbsp;&nbsp;
#{@vz.table_close}}
    end
    def bold_header
      @one.gsub!(/[1-9]~(\S+)/,'<a name="\1"></a>')
      @one.gsub!(/[1-9]~/,'')
      @one.gsub!(/<~0;[um]\d+;[um]\d+><#@dp:#@dp>\s*$/i,'') #watch & do differently
      %{<p class="bold">
    #@one
  </p>
#{@vz.margin_num_css}
  &nbsp;&nbsp;&nbsp;
#{@vz.table_close}}
    end
    def toc_head_copy_at
      %{<p class="center">#@one</p>\n}
    end
    def center
      %{<p class="center">#@one</p>\n}
    end
    def bold
      %{<p class="bold">#@one</p>\n}
    end
    def center_bold
      %{<p class="centerbold">#@one</p>\n}
    end
  end
  class XML
  end
end
__END__
