# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   #___#

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_substitute_and_insert
  class SI
    def initialize(md,data)
      @md,@data=md,data
      @skin=SiSU_Env::Info_skin.new(@md)
    end
    def substitutions_and_insertions?
      data=@data
      data_expand=[]
      if data[0] =~ /^#!\s*(?:\/usr\/bin\/env sisu|\/usr\/bin\/sisu)/ # remove bang from top #! (however file is stripped, so will be removed provided no content precedes it)
        data[0].gsub!(/^#!\s*\/usr\/bin\/sisu/,'')
        data[0].gsub!(/^#!\s*\/usr\/bin\/env sisu/,'')
      end
      if data[0] =~ /^(SiSU\s+[\d.]*|sisu-[\d.]+)$/ # SiSU identifier
        data[0].gsub!(/^(SiSU\s*[\d.]*)$/,'% \1')
        data[0].gsub!(/^(sisu-[\d.]+)$/,'% \1')
      end
      data.each do |para|
        if para =~/<:insert\d+!?>/ \
        and para !~/^%\s+/
          @skin.select
          ins=SiSU_Viz::Inserts.new
          case para
          when /^\s*<:insert1>\s*$/
            para=[]
            ins.insert1.split(/\n\n/).each{|x| para << x }
          when /^\s*<:insert2>\s*$/
            para=[]
            ins.insert2.split(/\n\n/).each{|x| para << x }
          when /^\s*<:insert3>\s*$/
            para=[]
            ins.insert3.split(/\n\n/).each{|x| para << x << "\n"}
            para=ins.insert3
          when /^\s*<:insert4>\s*$/
            para=[]
            ins.insert4.split(/\n\n/).each{|x| para << x << "\n"}
            para=ins.insert4
          when /^\s*<:insert5>\s*$/
            para=[]
            ins.insert5.split(/\n\n/).each{|x| para << x << "\n"}
          when /^\s*<:insert6>\s*$/
            para=[]
            ins.insert6.split(/\n\n/).each{|x| para << x << "\n"}
          when /^\s*<:insert7>\s*$/
            para=[]
            ins.insert7.split(/\n\n/).each{|x| para << x << "\n"}
          end
          para.each{|x| data_expand << x }
        else data_expand << para
        end
        data_expand.flatten!
        data_expand.compact!
      end
      data_expand.each do |para|
        para=if @md.markup_version.to_f >= 0.38
          SiSU_document_structure::Structure.new(@md,para).structure_markup_normalize
        else
          SiSU_document_structure::Structure.new(@md,para).structure_marks
        end
        #para.gsub!(/<url:(\S+?)>/,'\1') #consider, would permit use of text hyperlinks if desired, dal_syntax more appropriate?
        para.gsub!(/^((?:[1-9]|:?[A-C])~\S*)\s*$/,'\1~ [Note: heading marker::required title missing]~#')                                    #conditional header for incorporated document 2004w12
        if para =~/^@\S+?:/
          para.gsub!(/^@(\S+?):\s+/,"#{Mx[:meta_o]}\\1#{Mx[:meta_c]}")
          para.gsub!(/^@(\S+?):([+-])\s+/,"#{Mx[:meta_o]}\\1\\2#{Mx[:meta_c]}")
        end
      end
    end
  end
end
__END__

