# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: common file for xml generation

=end
module SiSU_text_parts
  require "#{SiSU_lib}/shared_structure"
  class Split_text_object < SiSU_Structure::Split_text_object
    require "#{SiSU_lib}/param"
    require "#{SiSU_lib}/xml_format"
    include SiSU_Viz
    include SiSU_XML_format
    @@alt_id_count=0
    @@dp=nil
    def lev_segname_para
      if @para =~/^#{Mx[:lv_o]}(?:\d:|<:.+?>).+/
        if /^#{Mx[:lv_o]}([1-6]):(\S+?)#{Mx[:lv_c]}\s*(\S.+)/m.match(@para)
          @format,segname,@text=$1,$2,$3
        elsif /^#{Mx[:lv_o]}([1-6]):#{Mx[:lv_c]}\s*(\S.+)/m.match(@para)
          @format,@text=$1,$2
        elsif /<:(.+?)>\s*(\S.+?)/m.match(@para)
          @format,@text=$1,$2
        elsif /^#{Mx[:lv_o]}([1-6]):(\S+?)#{Mx[:lv_c]}\s*(\S.+?)/m.match(@para)
          @@alt_id_count+=1
          @format,segname,@text=$1,$2,$3
          #@format="#@format:#{segname}" #
        elsif /^#{Mx[:lv_o]}([1-6]):#{Mx[:lv_c]}\s*(\S.+?)/m.match(@para)
          @@alt_id_count+=1
          @format,@text=$1,$2
        end
      else
        if /(.+?)/m.match(@para)
          @text=$1
        end
        if @para !~/#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$|^$/ #added 2002w06
          @text=/(.+?)/m.match(@para)[1]
        end
        if /^(\d)~\S*\s+(.+)/m.match(@para)
          @format,@text=$1,$2
        end
      end
      @format="#@format:#{segname}" #
#follow this search beneath for heading_body1-6
      @lev_para_ocn=if @para =~/.+#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        SiSU_XML_format::Format_scroll.new(@md,@format,@text,@ocn)
      else
        SiSU_XML_format::Format_scroll.new(@md,@format,@text,"#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}")
      end
      self
    end
  end
end
module SiSU_XML_munge
  class Trans
    require "#{SiSU_lib}/defaults"
    def initialize(md)
      @md=md
      @sys=SiSU_Env::System_call.new
      @dir=SiSU_Env::Info_env.new(@md.fns)
      @dp=SiSU_Env::Info_env.new.digest.pattern
      @url_brace=SiSU_Viz::Skin.new.url_decoration
      if @md.sem_tag
        #@ab ||=SiSU_Viz::Skin.new.semantic_tags.default
        @ab ||=semantic_tags.default
      end
    end
    def semantic_tags
      def default
        {
          :pub =>     'publication',
          :conv =>    'convention',
          :vol =>     'volume',
          :pg =>      'page',
          :cty =>     'city',
          :org =>     'organization',
          :uni =>     'university',
          :dept =>    'department',
          :fac =>     'faculty',
          :inst =>    'institute',
          :co =>      'company',
          :com =>     'company',
          :conv =>    'convention',
          :dt =>      'date',
          :y =>       'year',
          :m =>       'month',
          :d =>       'day',
          :ti =>      'title',
          :au =>      'author',
          :ed =>      'editor', #editor?
          :v =>       'version', #edition
          :n =>       'name',
          :fn =>      'firstname',
          :mn =>      'middlename',
          :ln =>      'lastname',
          :in =>      'initials',
          :qt =>      'quote',
          :ct =>      'cite',
          :ref =>     'reference',
          :ab =>      'abreviation',
          :def =>     'define',
          :desc =>    'description',
          :trans =>   'translate',
        }
      end
      self
    end
    def char_enc #character encode
      def utf8(para='')
        if @sys.locale =~/utf-?8/i # instead ucs for utf8 #require 'iconv' ? Iñtërnâtiônàlizætiøn
          #¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûü
          #¢£¥§©ª«®°±²³µ¶¹º»¼½¾×÷
          ##para.gsub!(//, '&#;')
          ##para.gsub!(//, '&;')
          para.gsub!(/</u, '&#60;') # '&lt;'   # &#060;
          para.gsub!(/>/u, '&#62;') # '&gt;'   # &#062;
          para.gsub!(/¢/u, '&#162;') # '&cent;'   # &#162;
          para.gsub!(/£/u, '&#163;') # '&pound;'  # &#163;
          para.gsub!(/¥/u, '&#165;') # '&yen;'    # &#165;
          para.gsub!(/§/u, '&#167;') # '&sect;'   # &#167;
          para.gsub!(/©/u, '&#169;') # '&copy;'   # &#169;
          para.gsub!(/ª/u, '&#170;') # '&ordf;'   # &#170;
          para.gsub!(/«/u, '&#171;') # '&laquo;'  # &#171;
          para.gsub!(/®/u, '&#174;') # '&reg;'    # &#174;
          para.gsub!(/°/u, '&#176;') # '&deg;'    # &#176;
          para.gsub!(/±/u, '&#177;') # '&plusmn;' # &#177;
          para.gsub!(/²/u, '&#178;') # '&sup2;'   # &#178;
          para.gsub!(/³/u, '&#179;') # '&sup3;'   # &#179;
          para.gsub!(/µ/u, '&#181;') # '&micro;'  # &#181;
          para.gsub!(/¶/u, '&#182;') # '&para;'   # &#182;
          para.gsub!(/¹/u, '&#185;') # '&sup1;'   # &#185;
          para.gsub!(/º/u, '&#186;') # '&ordm;'   # &#186;
          para.gsub!(/»/u, '&#187;') # '&raquo;'  # &#187;
          para.gsub!(/¼/u, '&#188;') # '&frac14;' # &#188;
          para.gsub!(/½/u, '&#189;') # '&frac12;' # &#189;
          para.gsub!(/¾/u, '&#190;') # '&frac34;' # &#190;
          para.gsub!(/×/u, '&#215;') # '&times;'  # &#215;
          para.gsub!(/÷/u, '&#247;') # '&divide;' # &#247;
          para.gsub!(/¿/u, '&#191;') # '&iquest;' # &#191;
          para.gsub!(/À/u, '&#192;') # '&Agrave;' # &#192;
          para.gsub!(/Á/u, '&#193;') # '&Aacute;' # &#193;
          para.gsub!(/Â/u, '&#194;') # '&Acirc;'  # &#194;
          para.gsub!(/Ã/u, '&#195;') # '&Atilde;' # &#195;
          para.gsub!(/Ä/u, '&#196;') # '&Auml;'   # &#196;
          para.gsub!(/Å/u, '&#197;') # '&Aring;'  # &#197;
          para.gsub!(/Æ/u, '&#198;') # '&AElig;'  # &#198;
          para.gsub!(/Ç/u, '&#199;') # '&Ccedil;' # &#199;
          para.gsub!(/È/u, '&#200;') # '&Egrave;' # &#200;
          para.gsub!(/É/u, '&#201;') # '&Eacute;' # &#201;
          para.gsub!(/Ê/u, '&#202;') # '&Ecirc;'  # &#202;
          para.gsub!(/Ë/u, '&#203;') # '&Euml;'   # &#203;
          para.gsub!(/Ì/u, '&#204;') # '&Igrave;' # &#204;
          para.gsub!(/Í/u, '&#205;') # '&Iacute;' # &#205;
          para.gsub!(/Î/u, '&#206;') # '&Icirc;'  # &#206;
          para.gsub!(/Ï/u, '&#207;') # '&Iuml;'   # &#207;
          para.gsub!(/Ð/u, '&#208;') # '&ETH;'    # &#208;
          para.gsub!(/Ñ/u, '&#209;') # '&Ntilde;' # &#209;
          para.gsub!(/Ò/u, '&#210;') # '&Ograve;' # &#210;
          para.gsub!(/Ó/u, '&#211;') # '&Oacute;' # &#211;
          para.gsub!(/Ô/u, '&#212;') # '&Ocirc;'  # &#212;
          para.gsub!(/Õ/u, '&#213;') # '&Otilde;' # &#213;
          para.gsub!(/Ö/u, '&#214;') # '&Ouml;'   # &#214;
          para.gsub!(/Ø/u, '&#216;') # '&Oslash;' # &#216;
          para.gsub!(/Ù/u, '&#217;') # '&Ugrave;' # &#217;
          para.gsub!(/Ú/u, '&#218;') # '&Uacute;' # &#218;
          para.gsub!(/Û/u, '&#219;') # '&Ucirc;'  # &#219;
          para.gsub!(/Ü/u, '&#220;') # '&Uuml;'   # &#220;
          para.gsub!(/Ý/u, '&#221;') # '&Yacute;' # &#221;
          para.gsub!(/Þ/u, '&#222;') # '&THORN;'  # &#222;
          para.gsub!(/ß/u, '&#223;') # '&szlig;'  # &#223;
          para.gsub!(/à/u, '&#224;') # '&agrave;' # &#224;
          para.gsub!(/á/u, '&#225;') # '&aacute;' # &#225;
          para.gsub!(/â/u, '&#226;') # '&acirc;'  # &#226;
          para.gsub!(/ã/u, '&#227;') # '&atilde;' # &#227;
          para.gsub!(/ä/u, '&#228;') # '&auml;'   # &#228;
          para.gsub!(/å/u, '&#229;') # '&aring;'  # &#229;
          para.gsub!(/æ/u, '&#230;') # '&aelig;'  # &#230;
          para.gsub!(/ç/u, '&#231;') # '&ccedil;' # &#231;
          para.gsub!(/è/u, '&#232;') # '&egrave;' # &#232;
          para.gsub!(/é/u, '&#233;') # '&acute;'  # &#233;
          para.gsub!(/ê/u, '&#234;') # '&circ;'   # &#234;
          para.gsub!(/ë/u, '&#235;') # '&euml;'   # &#235;
          para.gsub!(/ì/u, '&#236;') # '&igrave;' # &#236;
          para.gsub!(/í/u, '&#237;') # '&acute;'  # &#237;
          para.gsub!(/î/u, '&#238;') # '&icirc;'  # &#238;
          para.gsub!(/ï/u, '&#239;') # '&iuml;'   # &#239;
          para.gsub!(/ð/u, '&#240;') # '&eth;'    # &#240;
          para.gsub!(/ñ/u, '&#241;') # '&ntilde;' # &#241;
          para.gsub!(/ò/u, '&#242;') # '&ograve;' # &#242;
          para.gsub!(/ó/u, '&#243;') # '&oacute;' # &#243;
          para.gsub!(/ô/u, '&#244;') # '&ocirc;'  # &#244;
          para.gsub!(/õ/u, '&#245;') # '&otilde;' # &#245;
          para.gsub!(/ö/u, '&#246;') # '&ouml;'   # &#246;
          para.gsub!(/ø/u, '&#248;') # '&oslash;' # &#248;
          para.gsub!(/ù/u, '&#250;') # '&ugrave;' # &#250;
          para.gsub!(/ú/u, '&#251;') # '&uacute;' # &#251;
          para.gsub!(/û/u, '&#252;') # '&ucirc;'  # &#252;
          para.gsub!(/ü/u, '&#253;') # '&uuml;'   # &#253;
          para.gsub!(/þ/u, '&#254;') # '&thorn;'  # &#254;
          para.gsub!(/ÿ/u, '&#255;') # '&yuml;'   # &#255;
          para.gsub!(/‘/u, '&#8216;') # '&lsquo;' # &#8216;
          para.gsub!(/’/u, '&#8217;') # '&rsquo;' # &#8217;
          para.gsub!(/“/u, '&#8220;') # &ldquo;   # &#8220;
          para.gsub!(/”/u, '&#8221;') # &rdquo;   # &#8221;
          para.gsub!(/–/u, '&#8211;') # &ndash;   # &#8211;
          para.gsub!(/—/u, '&#8212;') # &mdash;   # &#8212;
          para.gsub!(/∝/u, '&#8733;') # &prop;    # &#8733;
          para.gsub!(/∞/u, '&#8734;') # &infin;   # &#8734;
          para.gsub!(/™/u, '&#8482;') # &trade;   # &#8482;
          para.gsub!(/✠/u, '&#10016;') # &cross;  # &#10016;
          para.gsub!(/ /u, ' ')       # space identify
          para.gsub!(/ /u, ' ')       # space identify
        end
      end
      def html(para='')
        if @sys.locale =~/utf-?8/i # instead ucs for utf8 #require 'iconv' ? Iñtërnâtiônàlizætiøn
          para.gsub!(/ /u, ' ')           # space identify
          para.gsub!(/ /u, ' ')           # space identify
        else
          para.gsub!(/¢/u, '&cent;')      # &#162;
          para.gsub!(/£/u, '&pound;')     # &#163;
          para.gsub!(/¥/u, '&yen;')       # &#165;
          para.gsub!(/§/u, '&sect;')      # &#167;
          para.gsub!(/©/u, '&copy;')      # &#169;
          para.gsub!(/ª/u, '&ordf;')      # &#170;
          para.gsub!(/«/u, '&laquo;')     # &#171;
          para.gsub!(/®/u, '&reg;')       # &#174;
          para.gsub!(/°/u, '&deg;')       # &#176;
          para.gsub!(/±/u, '&plusmn;')    # &#177;
          para.gsub!(/²/u, '&sup2;')      # &#178;
          para.gsub!(/³/u, '&sup3;')      # &#179;
          para.gsub!(/µ/u, '&micro;')     # &#181;
          para.gsub!(/¶/u, '&para;')      # &#182;
          para.gsub!(/¹/u, '&sup1;')      # &#185;
          para.gsub!(/º/u, '&ordm;')      # &#186;
          para.gsub!(/»/u, '&raquo;')     # &#187;
          para.gsub!(/¼/u, '&frac14;')    # &#188;
          para.gsub!(/½/u, '&frac12;')    # &#189;
          para.gsub!(/¾/u, '&frac34;')    # &#190;
          para.gsub!(/×/u, '&times;')     # &#215;
          para.gsub!(/÷/u, '&divide;')    # &#247;
          para.gsub!(/¿/u, '&iquest;')    # &#191;
          para.gsub!(/À/u, '&Agrave;')    # &#192;
          para.gsub!(/Á/u, '&Aacute;')    # &#193;
          para.gsub!(/Â/u, '&Acirc;')     # &#194;
          para.gsub!(/Ã/u, '&Atilde;')    # &#195;
          para.gsub!(/Ä/u, '&Auml;')      # &#196;
          para.gsub!(/Å/u, '&Aring;')     # &#197;
          para.gsub!(/Æ/u, '&AElig;')     # &#198;
          para.gsub!(/Ç/u, '&Ccedil;')    # &#199;
          para.gsub!(/È/u, '&Egrave;')    # &#200;
          para.gsub!(/É/u, '&Eacute;')    # &#201;
          para.gsub!(/Ê/u, '&Ecirc;')     # &#202;
          para.gsub!(/Ë/u, '&Euml;')      # &#203;
          para.gsub!(/Ì/u, '&Igrave;')    # &#204;
          para.gsub!(/Í/u, '&Iacute;')    # &#205;
          para.gsub!(/Î/u, '&Icirc;')     # &#206;
          para.gsub!(/Ï/u, '&Iuml;')      # &#207;
          para.gsub!(/Ð/u, '&ETH;')       # &#208;
          para.gsub!(/Ñ/u, '&Ntilde;')    # &#209;
          para.gsub!(/Ò/u, '&Ograve;')    # &#210;
          para.gsub!(/Ó/u, '&Oacute;')    # &#211;
          para.gsub!(/Ô/u, '&Ocirc;')     # &#212;
          para.gsub!(/Õ/u, '&Otilde;')    # &#213;
          para.gsub!(/Ö/u, '&Ouml;')      # &#214;
          para.gsub!(/Ø/u, '&Oslash;')    # &#216;
          para.gsub!(/Ù/u, '&Ugrave;')    # &#217;
          para.gsub!(/Ú/u, '&Uacute;')    # &#218;
          para.gsub!(/Û/u, '&Ucirc;')     # &#219;
          para.gsub!(/Ü/u, '&Uuml;')      # &#220;
          para.gsub!(/Ý/u, '&Yacute;')    # &#221;
          para.gsub!(/Þ/u, '&THORN;')     # &#222;
          para.gsub!(/ß/u, '&szlig;')     # &#223;
          para.gsub!(/à/u, '&agrave;')    # &#224;
          para.gsub!(/á/u, '&aacute;')    # &#225;
          para.gsub!(/â/u, '&acirc;')     # &#226;
          para.gsub!(/ã/u, '&atilde;')    # &#227;
          para.gsub!(/ä/u, '&auml;')      # &#228;
          para.gsub!(/å/u, '&aring;')     # &#229;
          para.gsub!(/æ/u, '&aelig;')     # &#230;
          para.gsub!(/ç/u, '&ccedil;')    # &#231;
          para.gsub!(/è/u, '&egrave;')    # &#232;
          para.gsub!(/é/u, '&acute;')     # &#233;
          para.gsub!(/ê/u, '&circ;')      # &#234;
          para.gsub!(/ë/u, '&euml;')      # &#235;
          para.gsub!(/ì/u, '&igrave;')    # &#236;
          para.gsub!(/í/u, '&acute;')     # &#237;
          para.gsub!(/î/u, '&icirc;')     # &#238;
          para.gsub!(/ï/u, '&iuml;')      # &#239;
          para.gsub!(/ð/u, '&eth;')       # &#240;
          para.gsub!(/ñ/u, '&ntilde;')    # &#241;
          para.gsub!(/ò/u, '&ograve;')    # &#242;
          para.gsub!(/ó/u, '&oacute;')    # &#243;
          para.gsub!(/ô/u, '&ocirc;')     # &#244;
          para.gsub!(/õ/u, '&otilde;')    # &#245;
          para.gsub!(/ö/u, '&ouml;')      # &#246;
          para.gsub!(/ø/u, '&oslash;')    # &#248;
          para.gsub!(/ù/u, '&ugrave;')    # &#250;
          para.gsub!(/ú/u, '&uacute;')    # &#251;
          para.gsub!(/û/u, '&ucirc;')     # &#252;
          para.gsub!(/ü/u, '&uuml;')      # &#253;
          para.gsub!(/þ/u, '&thorn;')     # &#254;
          para.gsub!(/ÿ/u, '&yuml;')      # &#255;
          para.gsub!(/‘/u, '&#lsquo;')    # &lsquo;  # &#8216;
          para.gsub!(/’/u, '&#rsquo;')    # &rsquo;  # &#8217;
          para.gsub!(/“/u, '&ldquo;')     # &ldquo;   # &#8220;
          para.gsub!(/”/u, '&rdquo;')     # &rdquo;   # &#8221;
          para.gsub!(/–/u, '&ndash;')     # &ndash;  # &#8211;
          para.gsub!(/—/u, '&mdash;')     # &mdash;  # &#8212;
          para.gsub!(/∝/u, '&prop;')      # &prop;   # &#8733;
          para.gsub!(/∞/u, '&infin;')     # &infin;  # &#8734;
          para.gsub!(/™/u, '&trade;')     # &trade;  # &#8482;
          para.gsub!(/✠/u, '&#10016;')    # &#10016;
          #para.gsub!(/✠/u, '&dagger;')    # &dagger; # &#8224; incorrect replacement †
          para.gsub!(/ /u, ' ')           # space identify
          para.gsub!(/ /u, ' ')           # space identify
        end
      end
      self
    end
    def tidywords(wordlist)
      wordlist.each do |x|
        #imperfect solution will not catch all possible cases
        x.gsub!(/&/,'&amp;') unless x =~/&\S+;/
        x.gsub!(/&([A-Z])/,'&amp;\1')
      end
    end
    def markup(para='')
      wordlist=para.scan(/&[#0-9a-z]+;|\S+|\n/) #\n needed for tables, check though added 2005w17
      para=tidywords(wordlist).join(' ').strip
      para.gsub!(/#{Mx[:br_line]}|#{Mx[:br_nl]}/,'<br />')
      para.gsub!(/#{Mx[:mk_o]}:name#\S+?#{Mx[:mk_c]}/,'')
      para.gsub!(/#{Mx[:mk_o]}#([a-zA-Z]+)#{Mx[:mk_c]}/,'&\1;')
      para.gsub!(/#{Mx[:mk_o]}(#[0-9]+)#{Mx[:mk_c]}/,'&\1;')
      para.gsub!(/(^|#{Mx[:gl_c]}|\s+)<\s+/,'\1&lt; '); para.gsub!(/\s+>(\s+|$)/,' &gt;\1')
      #para.gsub!(/#{Mx[:fa_emphasis_o]}(.+?)#{Mx[:fa_emphasis_c]}/,'<em>\1</em>') #reinstate
      para.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'<b>\1</b>')
      para.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'<i>\1</i>')
      para.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'<u>\1</u>')
      para.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'<sup>\1</sup>')
      para.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'<sub>\1</sub>')
      para.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'<ins>\1</ins>')
      para.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'<cite>\1</cite>')
      para.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>')
      para.gsub!(/<:pb>\s*/,'') #Fix
      para.gsub!(/<+[-~]#>+/,'')
      para.gsub!(/#{Mx[:id_o]}0;\w\d+;[um]\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
      if para !~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/
        #embeds a red-bullet image -->
        para.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'<b>\1</b>')
        para.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'<i>\1</i>')
        para.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'<u>\1</u>')
        para.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>')
        para.gsub!(/#{Mx[:br_line]}|#{Mx[:br_nl]}/,'<br />')
        para.gsub!(/#{Mx[:br_page]}\s*/,'')
        para.gsub!(/#{Mx[:br_page_new]}\s*/,'')
        para.gsub!(/#{Mx[:pa_non_object_no_heading]}|#{Mx[:pa_non_object_dummy_heading]}/,''); para.gsub!(/<[-~]#>/,'')
        para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:jpg|png|gif))\s+(\d+)x(\d+)(\s+[^}]+)?#{Mx[:lnk_c]}(https?:\/\/\S+)/,
          %{<image xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:actuate="onLoad" xlink:show="embed" xlink:href="#{@dir.url.images_local}/\\1" width="\\2" height="\\3" />[\\1] \\4})
        para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:jpg|png|gif))(\s+[^}]+)?#{Mx[:lnk_c]}(https?:\/\/\S+)/,
          %{<image xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:actuate="onLoad" xlink:show="embed" xlink:href="#{@dir.url.images_local}/\\1"/>\\1})
        para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:jpg|png|gif))\s+(\d+)x(\d+)(\s+[^}]+)?#{Mx[:lnk_c]}image/,
          %{<image xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:actuate="onLoad" xlink:show="embed" xlink:href="#{@dir.url.images_local}/\\1" width="\\2" height="\\3" />[\\1] \\4})
        para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:jpg|png|gif))(\s+[^}]+)?#{Mx[:lnk_c]}image/,
          %{<image xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:actuate="onLoad" xlink:show="embed" xlink:href="#{@dir.url.images_local}/\\1"/>\\1})
        para.gsub!(/(^|#{Mx[:gl_c]}|\s)#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}(https?:\/\/[^"><]+?)([,.:;"><]?(?=\s|$))/,
          '\1<link xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:href="\3">\2</link>\4') #watch, compare html_tune
        para.gsub!(/(^|#{Mx[:gl_c]}|\s)((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?=\s|$))/,
          %{\\1#{@url_brace.xml_open}<link xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:href="\\2">\\2</link>#{@url_brace.xml_close}\\3})
        para.gsub!(/\b[_\\]((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/,
          '<link xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:href="\1">\1</link>\2') #escaped urls not linked, deal with later
      else
        para.gsub!(/(^|[^}])_</m,'\1&lt;'); para.gsub!(/(^|[^}])_>/m,'\1&gt;') #code-block: angle brackets special characters
        para.gsub!(/(^|[^}])_</m,'\1&lt;'); para.gsub!(/(^|[^}])_>/m,'\1&gt;')
      end
      para.gsub!(/&nbsp;|#{Mx[:nbsp]}/m,'&#160;')
      para
    end
    def markup_light(para='')
      para.gsub!(/\/\{(.+?)\}\//,'<i>\1</i>')
      para.gsub!(/[*!]\{(.+?)\}[*!]/,'<b>\1</b>')
      para.gsub!(/_\{(.+?)\}_/,'<u>\1</u>')
      para.gsub!(/-\{(.+?)\}-/,'<del>\1</del>')
      para.gsub!(/<br(\s*\/)?>/,'<br />')
      para.gsub!(/<:pb>\s*/,'')
      para.gsub!(/<[-~]#>/,'')
      para.gsub!(/(^|#{Mx[:gl_c]}|\s)&\s+/,'\1&amp; ') #sort
      para.gsub!(/&([^;]{1,5})/,'&amp;\1') #sort, rough estimate, revisit #WATCH found in node not sax
      para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\/\/\S+|image)/,
        "<image.path>#{@dir.url.images_local}\/\\1</image.path>")
      para.gsub!(/&nbsp;|#{Mx[:nbsp]}/,'&#160;')
      #para.gsub!(/&nbsp;/,' ') #clean
      wordlist=para.scan(/&[#0-9a-z]+;|\S+|\n/) #\n needed for tables, check though added 2005w17
      para=tidywords(wordlist).join(' ').strip
      para
    end
    def markup_fictionbook(para='')
      para.gsub!(/~\{([\d*+]+).+?\}~/,'[\1]')
      para.gsub!(/\/\{(.+?)\}\//,'<i>\1</i>')
      para.gsub!(/[*!]\{(.+?)\}[*!]/,'<b>\1</b>')
      para.gsub!(/_\{(.+?)\}_/,'<u>\1</u>')
      para.gsub!(/-\{(.+?)\}-/,'<del>\1</del>')
      para.gsub!(/<br(\s*\/)?>/,'<br />')
      para.gsub!(/<:pb>\s*/,'')
      para.gsub!(/<[-~]#>/,'')
      #temporary -->
      para.gsub!(/<:\S+?>/,'')
      #<-- temporary
      para.gsub!(/<[-~]#>/,'')
      para.gsub!(/(^|#{Mx[:gl_c]}|\s)&\s+/,'\1&amp; ') #sort
      para.gsub!(/&([^;]{1,5})/,'&amp;\1') #sort, rough estimate, revisit #WATCH found in node not sax
      para.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\/\/\S+|image)/,
        "<image.path>#{@dir.url.images_local}\/\\1</image.path>")
      para.gsub!(/&nbsp;|#{Mx[:nbsp]}/,'&#160;')
      #para.gsub!(/&nbsp;/,' ') #clean
      wordlist=para.scan(/&[#0-9a-z]+;|\S+|\n/) #\n needed for tables, check though added 2005w17
      para=tidywords(wordlist).join(' ').strip
      para
    end
    def markup_group(para='')
      para.gsub!(/</,'&lt;'); para.gsub!(/>/,'&gt;')
      para.gsub!(/&lt;:?br(?:\s+\/)?&gt;/,'<br />')
      para.gsub!(/&lt;(link xmlns:xlink=".+?")&gt;/,'<\1>')
      para.gsub!(/&lt;(\/link)&gt;/,'<\1>')
      para.gsub!(/&lt;(\/?en)&gt;/,'<\1>')
      para
    end
    def xml_sem_block_paired(matched) # colon depth: many, recurs
      matched.gsub!(/\b(au):\{(.+?)\}:\1\b/m,   %{<sem:#{@ab[:au]} depth="many">\\2</sem:#{@ab[:au]}>}) # sem :
      matched.gsub!(/\b(vol):\{(.+?)\}:\1\b/m, %{<sem:#{@ab[:vol]} depth="many">\\2</sem:#{@ab[:vol]}>}) # sem :
      matched.gsub!(/\b(pub):\{(.+?)\}:\1\b/m, %{<sem:#{@ab[:pub]} depth="many">\\2</sem:#{@ab[:pub]}>}) # sem :
      matched.gsub!(/\b(ref):\{(.+?)\}:\1\b/m, %{<sem:#{@ab[:ref]} depth="many">\\2</sem:#{@ab[:ref]}>}) # sem :
      matched.gsub!(/\b(desc):\{(.+?)\}:\1\b/m,%{<sem:#{@ab[:desc]} depth="many">\\2</sem:#{@ab[:desc]}>}) # sem :
      matched.gsub!(/\b(conv):\{(.+?)\}:\1\b/m,%{<sem:#{@ab[:conv]} depth="many">\\2</sem:#{@ab[:conv]}>}) # sem :
      matched.gsub!(/\b(ct):\{(.+?)\}:\1\b/m,  %{<sem:#{@ab[:ct]} depth="many">\\2</sem:#{@ab[:ct]}>}) # sem :
      matched.gsub!(/\b(cty):\{(.+?)\}:\1\b/m, %{<sem:#{@ab[:cty]} depth="many">\\2</sem:#{@ab[:cty]}>}) # sem :
      matched.gsub!(/\b(org):\{(.+?)\}:\1\b/m, %{<sem:#{@ab[:org]} depth="many">\\2</sem:#{@ab[:org]}>}) # sem :
      matched.gsub!(/\b(dt):\{(.+?)\}:\1\b/m,   %{<sem:#{@ab[:dt]} depth="many">\\2</sem:#{@ab[:dt]}>}) # sem :
      matched.gsub!(/\b(n):\{(.+?)\}:\1\b/m,   %{<sem:#{@ab[:n]} depth="many">\\2</sem:#{@ab[:n]}>}) # sem :
      matched.gsub!(/([a-z]+(?:[_:.][a-z]+)*)(?::\{(.+?)\}:\1)/m,'<sem:\1 depth="many">\2</sem:\1>') # sem :
    end
    def xml_semantic_tags(para)
      if @md.sem_tag
        para.gsub!(/([a-z]+(?:[_:.][a-z]+)*)(?::\{(.+?)\}:\1)/m) {|c| xml_sem_block_paired(c) } # sem :
        para.gsub!(/([a-z]+(?:[_:.][a-z]+)*)(?::\{(.+?)\}:\1)/m) {|c| xml_sem_block_paired(c) } # sem :
        para.gsub!(/([a-z]+(?:[_:.][a-z]+)*)(?::\{(.+?)\}:\1)/m) {|c| xml_sem_block_paired(c) } # sem :
        #colon one / single / flat / shallow
        para.gsub!(/:\{(.+?)\}:au\b/m,             %{<sem:#{@ab[:au]} depth="one">\\1</sem:#{@ab[:au]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:n\b/m,              %{<sem:#{@ab[:n]} depth="one">\\1</sem:#{@ab[:n]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:ti\b/m,             %{<sem:#{@ab[:ti]} depth="one">\\1</sem:#{@ab[:ti]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:ref\b/m,            %{<sem:#{@ab[:ref]} depth="one">\\1</sem:#{@ab[:ref]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:desc\b/m,           %{<sem:#{@ab[:desc]} depth="one">\\1</sem:#{@ab[:desc]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:cty\b/m,            %{<sem:#{@ab[:cty]} depth="one">\\1</sem:#{@ab[:cty]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:org\b/m,            %{<sem:#{@ab[:org]} depth="one">\\1</sem:#{@ab[:org]}>}) # sem :
        para.gsub!(/:\{(.+?)\}:([a-z]+(?:[_:.][a-z]+)*)/m,'<sem:\2 depth="one">\1</sem:\2>') # sem :
        #semicolon zero / none
        para.gsub!(/;\{([^}]+(?![;]))\};ti\b/m,    %{<sem:#{@ab[:ti]} depth="zero">\\1</sem:#{@ab[:ti]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};qt\b/m,    %{<sem:#{@ab[:qt]} depth="zero">\\1</sem:#{@ab[:qt]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};ref\b/m,   %{<sem:#{@ab[:ref]} depth="zero">\\1</sem:#{@ab[:ref]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};ed\b/m,    %{<sem:#{@ab[:ed]} depth="zero">\\1</sem:#{@ab[:ed]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};v\b/m,     %{<sem:#{@ab[:v]} depth="zero">\\1</sem:#{@ab[:v]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};desc\b/m,  %{<sem:#{@ab[:desc]} depth="zero">\\1</sem:#{@ab[:desc]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};def\b/m,   %{<sem:#{@ab[:def]} depth="zero">\\1</sem:#{@ab[:def]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};trans\b/m, %{<sem:#{@ab[:trans]} depth="zero">\\1</sem:#{@ab[:trans]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};y\b/m,     %{<sem:#{@ab[:y]} depth="zero">\\1</sem:#{@ab[:y]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};ab\b/m,    %{<sem:#{@ab[:ab]} depth="zero">\\1</sem:#{@ab[:ab]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};pg\b/m,    %{<sem:#{@ab[:pg]} depth="zero">\\1</sem:#{@ab[:pg]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};fn?\b/m,   %{<sem:#{@ab[:fn]} depth="zero">\\1</sem:#{@ab[:fn]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};mn?\b/m,   %{<sem:#{@ab[:mn]} depth="zero">\\1</sem:#{@ab[:mn]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};ln?\b/m,   %{<sem:#{@ab[:ln]} depth="zero">\\1</sem:#{@ab[:ln]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};in\b/m,    %{<sem:#{@ab[:in]} depth="zero">\\1</sem:#{@ab[:in]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};uni\b/m,   %{<sem:#{@ab[:uni]} depth="zero">\\1</sem:#{@ab[:uni]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};fac\b/m,   %{<sem:#{@ab[:fac]} depth="zero">\\1</sem:#{@ab[:fac]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};inst\b/m,  %{<sem:#{@ab[:inst]} depth="zero">\\1</sem:#{@ab[:inst]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};dept\b/m,  %{<sem:#{@ab[:dpt]} depth="zero">\\1</sem:#{@ab[:dept]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};org\b/m,   %{<sem:#{@ab[:org]} depth="zero">\\1</sem:#{@ab[:org]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};com?\b/m,  %{<sem:#{@ab[:com]} depth="zero">\\1</sem:#{@ab[:com]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};cty\b/m,   %{<sem:#{@ab[:cty]} depth="zero">\\1</sem:#{@ab[:cty]}>}) # sem ;
        para.gsub!(/;\{([^}]+(?![;]))\};([a-z]+(?:[_:.][a-z]+)*)/m,'<sem:\2 depth="zero">\1</sem:\2>') # sem ;
      end
      para
    end
  end
end
module SiSU_XML_tags #Format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class RDF
    def initialize(md='',seg_name=[],tracker=0)
      @full_title=@subtitle=@author=@subject=@description=@publisher=@contributor=@date=@date_created=@date_issued=@date_available=@date_valid=@date_modified=@type=@format=@identifier=@source=@language=@relation=@coverage=@rights=@copyright=@owner=@keywords=''
      #seg_name=%{#{@@seg_name[@@tracker]} - } if @@seg_name[@@tracker]
      @md=md
      @sfx,@pdf=@md.sfx,@md.pdf
      @rdfurl=%{  rdf:about="http://www.jus.uio.no/lm/toc"\n}
      if @md.full_title                                                            # DublinCore 1 - title
        @rdf_title=%{    dc.title="#{seg_name}#{@md.full_title}"\n}
        @full_title=%{  <meta name="dc.title" content="#{@md.full_title}" />\n}
        #@full_title=%{  <meta name="dc.title" content="#{seg_name}#{@md.full_title}" />\n}
      end
      if @md.author                                                          # DublinCore 2 - creator/author (author)
        @rdf_author=%{    dc.author="#{@md.author}"\n}
        content=meta_content_clean(@md.author)
        @author=%{  <meta name="dc.author" content="#{content}" />\n}
      end
      if @md.subject                                                          # DublinCore 3 - subject (us library of congress, eric or udc, or schema???)
        @rdf_subject=%{    dc.subject="#{@md.subject}"\n}
        content=meta_content_clean(@md.subject)
        @subject=%{  <meta name="dc.subject" content="#{content}" />\n}
      end
      if @md.description                                                      # DublinCore 4 - description
        @rdf_description=%{    dc.description="#{@md.description}"\n}
        content=meta_content_clean(@md.description)
        @description=%{  <meta name="dc.description" content="#{content}" />\n}
      end
      if @md.publisher                                                        # DublinCore 5 - publisher (current copy published by)
        @rdf_publisher=%{    dc.publisher="#{@md.publisher}"\n}
        content=meta_content_clean(@md.publisher)
        @publisher=%{  <meta name="dc.publisher" content="#{content}" />\n}
      end
      if @md.contributor                                                      # DublinCore 6 - contributor
        @rdf_contributor=%{    dc.contributor="#{@md.contributor}"\n}
        content=meta_content_clean(@md.contributor)
        @contributor=%{  <meta name="dc.contributor" content="#{content}" />\n}
      end
      if @md.date                                                             # DublinCore 7 - date year-mm-dd
        @rdf_date=%{    dc.date="#{@md.date}"\n}
        @date=%{  <meta name="dc.date" content="#{@md.date}" #{@md.date_scheme} />\n}
      end
      if @md.date_created                                                     # DublinCore 7 - date.created year-mm-dd
        @rdf_date_created=%{    dc.date.created="#{@md.date_created}"\n}
        @date_created=%{  <meta name="dc.date.created" content="#{@md.date_created}" #{@md.date_created_scheme} />\n}
      end
      if @md.date_issued                                                      # DublinCore 7 - date.issued year-mm-dd
        @rdf_date_issued=%{    dc.date.issued="#{@md.date_issued}"\n}
        @date_issued=%{  <meta name="dc.date.issued" content="#{@md.date_issued}" #{@md.date_issued_scheme} />\n}
      end
      if @md.date_available                                                   # DublinCore 7 - date.available year-mm-dd
        @rdf_date_available=%{    dc.date.available="#{@md.date_available}"\n}
        @date_available=%{  <meta name="dc.date.available" content="#{@md.date_available}" #{@md.date_available_scheme} />\n}
      end
      if @md.date_valid                                                       # DublinCore 7 - date.valid year-mm-dd
        @rdf_date_valid=%{    dc.date.valid="#{@md.date_valid}"\n}
        @date_valid=%{  <meta name="dc.date.valid" content="#{@md.date_valid}" #{@md.date_valid_scheme} />\n}
      end
      if @md.date_modified                                                    # DublinCore 7 - date.modified year-mm-dd
        @rdf_date_modified=%{    dc.date.modified="#{@md.date_modified}"\n}
        @date_modified=%{  <meta name="dc.date.modified" content="#{@md.date_modified}" #{@md.date_modified_scheme} />\n}
      end
      if @md.type                                                             # DublinCore 8 - type (genre eg. report, convention etc)
        @rdf_type=%{    dc.type="#{@md.type}"\n}
        content=meta_content_clean(@md.type)
        @type=%{  <meta name="dc.type" content="#{content}" />\n}
      end
      if @md.format                                                           # DublinCore 9 - format (use your mime type)
        @rdf_format=%{    dc.format="#{@md.format}"\n}
        content=meta_content_clean(@md.format)
        @format=%{  <meta name="dc.format" content="#{content}" />\n}
      end
      if @md.identifier                                                       # DublinCore 10 - identifier (your identifier, could use urn which is free)
        @rdf_identifier=%{    dc.identifier="#{@md.identifier}"\n}
        content=meta_content_clean(@md.identifier)
        @identifier=%{  <meta name="dc.identifier" content="#{content}" />\n}
      end
      if @md.source                                                           # DublinCore 11 - source (document source)
        @rdf_source=%{    dc.source="#{@md.source}"\n}
        content=meta_content_clean(@md.source)
        @source=%{  <meta name="dc.source" content="#{content}" />\n}
      end
      if @md.language \
      and @md.language[:name]                                                  # DublinCore 12 - language (English)
        @rdf_language=%{    dc.language="#{@md.language[:name]}"\n}
        @language=%{  <meta name="dc.language" content="#{@md.language[:name]}" />\n}
      end
      if @md.language_original \
      and @md.language_original[:name]
        @rdf_language_original=%{    dc.language="#{@md.language_original[:name]}"\n}
        @language_original=%{  <meta name="dc.language" content="#{@md.language_original[:name]}" />\n}
      end
      if @md.relation                                                         # DublinCore 13 - relation
        @rdf_relation=%{    dc.relation="#{@md.relation}"\n}
        content=meta_content_clean(@md.relation)
        @relation=%{  <meta name="dc.relation" content="#{content}" />\n}
      end
      if @md.coverage                                                         # DublinCore 14 - coverage
        @rdf_coverage=%{    dc.coverage="#{@md.coverage}"\n}
        content=meta_content_clean(@md.coverage)
        @coverage=%{  <meta name="dc.coverage" content="#{content}" />\n}
      end
      if @md.rights                                                           # DublinCore 15 - rights
        @rdf_rights=%{    dc.rights="#{@md.rights}"\n}
        content=meta_content_clean(@md.rights)
        @rights=%{  <meta name="dc.rights" content="#{content}" />\n}
      end
      content=meta_content_clean(@md.keywords)
      @keywords=%{  <meta name="keywords" content="#{content}" />\n} if @md.keywords
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def meta_content_clean(content='')
      unless content.nil?
        content.tr!('"',"'")
      end
      content
    end
    def rdftoc #tocHead #values strung together, because some empty, and resulting output (line breaks) is much better
      #<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
      #         xmlns:dc="http://purl.org/dc/elements/1.1/">
      #  <rdf:Description rdf:about="http://www.jus.uio.no/lm/doc"
      #      dc:creator="Author"
      #      dc:title="Title"
      #      dc:description="Description if any"
      #      dc:date="Publication Date"
      #  />
      #</rdf:RDF>
      #Dublin Core
#### XML only :-( KEEP
#<<WOK
#<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
#     xmlns:dc="http://purl.org/dc/elements/1.1/">
#  <rdf:Description
#    #@rdfurl#@rdf_title#@rdf_subtitle#@rdf_creator#@rdf_subject#@rdf_description#@rdf_publisher#@rdf_contributor#@rdf_date#@rdf_dateCreated#@rdf_dateIssued#@rdf_dateAvailable#@rdf_dateValid#@rdf_dateModified#@rdf_type#@rdf_format#@rdf_identifier#@rdf_source#@rdf_language#@rdf_relation #@rdf_coverage#@rdf_rights
#    />\n
#</rdf:RDF>\n
#WOK
    end
    def rdfseg #segHead
      rdftoc
    end
    def comment_xml(extra='')
      generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
      lastdone="Last Generated on: #{Time.now}"
      rubyv="Ruby version: #{@md.ruby_version}"
      sc=if @md.sc_info
        "Source file: #{@md.sc_filename} version: #{@md.sc_number} of: #{@md.sc_date}"
      else ''
      end
      if extra.empty?
<<WOK
<!-- Document processing information:
     * #{generator}
     * #{rubyv}
     * #{sc}
     * #{lastdone}
     * SiSU http://www.jus.uio.no/sisu
-->
WOK
     else
<<WOK
<!-- Document processing information:
     * #{extra}
     * #{generator}
     * #{rubyv}
     * #{sc}
     * #{lastdone}
     * SiSU http://www.jus.uio.no/sisu
-->
WOK
     end
    end
    def comment_xml_sax
      desc='SiSU XML, SAX type representation'
      comment_xml(desc)
    end
    def comment_xml_node
      desc='SiSU XML, Node type representation'
      comment_xml(desc)
    end
    def comment_xml_dom
      desc='SiSU XML, DOM type representation'
      comment_xml(desc)
    end
    def metatag_html #values strung together, because some empty, and resulting output (line breaks) is much better
#{@vz.js_head}
<<WOK
#@full_title#@subtitle#@author#@subject#@description#@publisher#@contributor#@date#@date_created#@date_issued#@date_available#@date_valid#@date_modified#@type#@format#@identifier#@source#@language#@relation#@coverage#@rights#@copyright#@owner
#{@vz.txt_generator}
#{@vz.png_ico}
WOK
    end
  end
end
module SiSU_Tables
  require "#{SiSU_lib}/xml_tables"
end
__END__
