# coding:utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   constants

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
Mx,Rx={},{}
Mx[:meta_o],Mx[:meta_c]='〔@','〕'
Mx[:lv_o_1],Mx[:lv_o_2],Mx[:lv_o_3],Mx[:lv_o_4],Mx[:lv_o_5],Mx[:lv_o_6],Mx[:lv_o_7],Mx[:lv_o_8],Mx[:lv_o_9]=
  '〔1:','〔2:','〔3:','〔4:','〔5:','〔6:','〔7:','〔8:','〔9:';
Mx[:lv_o],Mx[:lv_c]='〔','〕'
#  '1~','2~','3~','4~','5~','6~','7~','8~','9~'; Mx[:lv_c]=''
Mx[:en_a_o]='【'; Mx[:en_a_c]='】' #Mx[:en_a_o]='~{'; Mx[:en_a_c]='}~'
Mx[:en_b_o]='〖'; Mx[:en_b_c]='〗' #Mx[:en_b_o]='~['; Mx[:en_b_c]=']~'
Mx[:br_line]="#{Mx[:mk_o]}br#{Mx[:mk_c]}"
Mx[:gr_o]='〔';                                         Mx[:gr_c]='〕' #group text mark
Mx[:id_o]='〔';                                         Mx[:id_c]='〕' #object id mark
Mx[:tc_o]='『';                                         Mx[:tc_c]='』' #table column mark
Mx[:tc_p]='┆'                                                          #table row/misc mark
Mx[:pa_o]='〔';                                         Mx[:pa_c]='〕' #affects paragraph mark
Mx[:mk_o]='〔';                                         Mx[:mk_c]='〕' #generic mark
Mx[:gl_o]='〔';                                         Mx[:gl_c]='〕' #glyph
Mx[:fa_o]='〔'; Mx[:fa_o_c]='¤';                        Mx[:fa_c_o]='¤'; Mx[:fa_c]='〕'
Mx[:fa_bold_o]=       "#{Mx[:fa_o]}b#{Mx[:fa_o_c]}";    Mx[:fa_bold_c]=       "#{Mx[:fa_c_o]}b#{Mx[:fa_c]}"
Mx[:fa_italics_o]=    "#{Mx[:fa_o]}i#{Mx[:fa_o_c]}";    Mx[:fa_italics_c]=    "#{Mx[:fa_c_o]}i#{Mx[:fa_c]}"
Mx[:fa_underscore_o]= "#{Mx[:fa_o]}u#{Mx[:fa_o_c]}";    Mx[:fa_underscore_c]= "#{Mx[:fa_c_o]}u#{Mx[:fa_c]}"
Mx[:fa_cite_o]=       "#{Mx[:fa_o]}cite#{Mx[:fa_o_c]}"; Mx[:fa_cite_c]=       "#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}"
Mx[:fa_insert_o]=     "#{Mx[:fa_o]}ins#{Mx[:fa_o_c]}";  Mx[:fa_insert_c]=     "#{Mx[:fa_c_o]}ins#{Mx[:fa_c]}"
Mx[:fa_strike_o]=     "#{Mx[:fa_o]}del#{Mx[:fa_o_c]}";  Mx[:fa_strike_c]=     "#{Mx[:fa_c_o]}del#{Mx[:fa_c]}"
Mx[:fa_superscript_o]="#{Mx[:fa_o]}sup#{Mx[:fa_o_c]}";  Mx[:fa_superscript_c]="#{Mx[:fa_c_o]}sup#{Mx[:fa_c]}"
Mx[:fa_subscript_o]=   "#{Mx[:fa_o]}sub#{Mx[:fa_o_c]}"; Mx[:fa_subscript_c]=  "#{Mx[:fa_c_o]}sub#{Mx[:fa_c]}"
Mx[:fa_hilite_o]=     "#{Mx[:fa_o]}hi#{Mx[:fa_o_c]}";   Mx[:fa_hilite_c]=     "#{Mx[:fa_c_o]}hi#{Mx[:fa_c]}"
Mx[:gl_bullet]=       "#{Mx[:gl_o]}●#{Mx[:gl_c]}"
#non substantive text sort: <-#> <~#>
  Mx[:pa_non_object_dummy_heading]="#{Mx[:pa_o]}-##{Mx[:pa_c]}" #unnumbered paragraph, delete when not required [used in dummy headings, eg. for segmented html] (place marker at end of paragraph)
  Mx[:pa_non_object_no_heading]="#{Mx[:pa_o]}~##{Mx[:pa_c]}" #unnumbered paragraph (place marker at end of paragraph)
Mx[:idx_o]='▢ ';                                         Mx[:idx_c]='▢ ' #
Mx[:nbsp]=            '░' #'▭ '
Mx[:br_line]=         "#{Mx[:mk_o]}br#{Mx[:mk_c]}"
Mx[:br_paragraph]=    "#{Mx[:mk_o]}br#{Mx[:mk_c]}"
Mx[:br_nl]=           "#{Mx[:mk_o]}nl#{Mx[:mk_c]}"
Mx[:br_page]=         "#{Mx[:mk_o]}pb#{Mx[:mk_c]}"
Mx[:br_page_new]=     "#{Mx[:mk_o]}pn#{Mx[:mk_c]}"
Mx[:br_endnotes]=     "#{Mx[:mk_o]}ENDNOTES#{Mx[:mk_c]}"
Mx[:br_eof]=          "#{Mx[:mk_o]}EOF#{Mx[:mk_c]}"
Mx[:lnk_o]='◁'; Mx[:lnk_c]='▷'
 #‹ ›
Mx[:sm_set_o]='《'; Mx[:sm_set_c]='》'
Mx[:sm_subset_o]='《 '; Mx[:sm_subset_c]='》'
#Mx[:sm_set_o]='∈ '; Mx[:sm_set_c]='∋ '
#Mx[:sm_subset_o]='∈ '; Mx[:sm_subset_c]='∋ '
Rx[:mx_fa_clean]=     /#{Mx[:fa_o]}.+?#{Mx[:fa_c]}|#{Mx[:pa_o]}.+?#{Mx[:pa_c]}|#{Mx[:mk_o]}.+?#{Mx[:mk_c]}/
Rx[:lv],Rx[:lv_1],Rx[:lv_2],Rx[:lv_3],Rx[:lv_4],Rx[:lv_5],Rx[:lv_6],Rx[:lv_7],Rx[:lv_8],Rx[:lv_9]=
  /〔([1-9]):(\S*?)〕/,/#{Mx[:lv_o_1]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_2]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_3]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_4]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_5]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_6]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_7]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_8]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_9]}(\S*?)#{Mx[:lv_c]}/
Rx[:meta]=/#{Mx[:meta_o]}(\S+?)#{Mx[:meta_c]}/
unless RUBY_VERSION < '1.9'
  Mx[:meta_o].force_encoding('utf-8');                      Mx[:meta_c].force_encoding('utf-8')
  Mx[:lv_o_1].force_encoding('utf-8'); Mx[:lv_o_2].force_encoding('utf-8'); Mx[:lv_o_3].force_encoding('utf-8'); Mx[:lv_o_4].force_encoding('utf-8'); Mx[:lv_o_5].force_encoding('utf-8'); Mx[:lv_o_6].force_encoding('utf-8'); Mx[:lv_o_7].force_encoding('utf-8'); Mx[:lv_o_8].force_encoding('utf-8'); Mx[:lv_o_9].force_encoding('utf-8')
  Mx[:lv_o].force_encoding('utf-8');                        Mx[:lv_c].force_encoding('utf-8')
  Mx[:gr_o].force_encoding('utf-8');                        Mx[:gr_c].force_encoding('utf-8')
  Mx[:id_o].force_encoding('utf-8');                        Mx[:id_c].force_encoding('utf-8')
  Mx[:tc_p].force_encoding('utf-8')
  Mx[:tc_o].force_encoding('utf-8');                        Mx[:tc_c].force_encoding('utf-8')
  Mx[:pa_o].force_encoding('utf-8');                        Mx[:pa_c].force_encoding('utf-8')
  Mx[:mk_o].force_encoding('utf-8');                        Mx[:mk_c].force_encoding('utf-8')
  Mx[:gl_o].force_encoding('utf-8');                        Mx[:gl_c].force_encoding('utf-8')
  Mx[:fa_o].force_encoding('utf-8');                        Mx[:fa_c].force_encoding('utf-8')
  Mx[:fa_o_c].force_encoding('utf-8');                      Mx[:fa_c_o].force_encoding('utf-8')
  Mx[:fa_bold_o].force_encoding('utf-8');                   Mx[:fa_bold_c].force_encoding('utf-8')
  Mx[:fa_italics_o].force_encoding('utf-8');                Mx[:fa_italics_c].force_encoding('utf-8')
  Mx[:fa_underscore_o].force_encoding('utf-8');             Mx[:fa_underscore_c].force_encoding('utf-8')
  Mx[:fa_cite_o].force_encoding('utf-8');                   Mx[:fa_cite_c].force_encoding('utf-8')
  Mx[:fa_insert_o].force_encoding('utf-8');                 Mx[:fa_insert_c].force_encoding('utf-8')
  Mx[:fa_strike_o].force_encoding('utf-8');                 Mx[:fa_strike_c].force_encoding('utf-8')
  Mx[:fa_superscript_o].force_encoding('utf-8');            Mx[:fa_superscript_c].force_encoding('utf-8')
  Mx[:fa_subscript_o].force_encoding('utf-8');              Mx[:fa_subscript_c].force_encoding('utf-8')
  Mx[:fa_hilite_o].force_encoding('utf-8');                 Mx[:fa_hilite_c].force_encoding('utf-8')
  Mx[:gl_bullet].force_encoding('utf-8')
  Mx[:pa_non_object_dummy_heading].force_encoding('utf-8'); Mx[:pa_non_object_no_heading].force_encoding('utf-8')
  Mx[:br_line].force_encoding('utf-8');                     Mx[:br_nl].force_encoding('utf-8')
  Mx[:br_paragraph].force_encoding('utf-8')
  Mx[:br_page].force_encoding('utf-8');                     Mx[:br_page_new].force_encoding('utf-8')
  Mx[:br_endnotes].force_encoding('utf-8')
  Mx[:br_eof].force_encoding('utf-8')
  Mx[:lnk_o].force_encoding('utf-8');                       Mx[:lnk_c].force_encoding('utf-8')
  Mx[:sm_set_o].force_encoding('utf-8');                    Mx[:sm_set_c].force_encoding('utf-8')
  Mx[:sm_subset_o].force_encoding('utf-8');                 Mx[:sm_subset_c].force_encoding('utf-8')
#
  #Rx[:mx_fa_clean].force_encoding('utf-8')
  #Rx[:lv].force_encoding('utf-8');Rx[:lv_1].force_encoding('utf-8');Rx[:lv_2].force_encoding('utf-8');Rx[:lv_3].force_encoding('utf-8');Rx[:lv_4].force_encoding('utf-8');Rx[:lv_5].force_encoding('utf-8');Rx[:lv_6].force_encoding('utf-8');Rx[:lv_7].force_encoding('utf-8');Rx[:lv_8].force_encoding('utf-8');Rx[:lv_9].force_encoding('utf-8')
  #Rx[:meta].force_encoding('utf-8')
end
__END__
consider:
  〔comment〕
  〔links?????〕
   import document?
check:
  bold line

┆┆⋮┇┊┋
『』
「」
〔〕
【】

·
¤
 #˝ " λ Ω  β   α π  Ѫ Ж  Я Ѳ  ѳ   Ф ㈣
 Ѳ  ѳ   Ф
 ♩ ♭   ✠   ▭  ▬   ▪
【】〖〗《》「」
 ‹ › ∗ 
'〔lv1〕','〔lv2〕','〔lv3〕','〔lv4〕','〔lv5〕','〔lv6〕','〔lv7〕','〔lv8〕','〔lv9〕'
'〔 Ѳ1〕','〔 Ѳ2〕','〔 Ѳ3〕','〔 Ѳ4〕','〔 Ѳ5〕','〔Ѳ6〕','〔Ѳ7〕','〔Ѳ8〕','〔Ѳ9〕'
◁▷ 

◀this is text or an image▶ http://
