# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Syntax for markup, input markup syntaxes, determined here

=end
module SiSU_Syntax
  class Words
    def initialize(line,md,mkp)
      @line,@md,@mkp=line,md,mkp
    end
  end
  class Markup
    def initialize(md='',data='')
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @data_new=[]
      url_and_stub=SiSU_Env::Info_env.new.url
      @output_url="#{url_and_stub.remote}"
      @http_m=%r{\{.+?\}(?:https?|file)://\S+|(?:https?|file):\S+|\.\.\/\S+|\S+?\.png\b|[*]~\S+|^#{Mx[:meta_o]}.+|#{Mx[:gr_o]}(?:code|group|alt|verse)(?:-end)?#{Mx[:gr_c]}|#{Mx[:fa_o]}:br#{Mx[:fa_c]}}
      @manmkp_ital='[i/]\\{.+?\\}[i/]'
      tail_m_ital=%q{(?:\s|[.,;:?!'")]|~\^|~\\\{\s|$)}
      tail_m_bold=%{(?:(?:#{Mx[:fa_italics_c]})?(?:\s|[.,;:?!'")]|~\^|~\\\{\s|$))?}
      bold_line=%{^!_\s.+?(?:#{Mx[:br_line]}|\n|$)}
      ital_line=%{^/_\s.+?(?:#{Mx[:br_line]}|\n|$)}
      @line_scan_ital=if defined? @md.make_italic[:str] \
      and defined? @vz.markup_make_italic[:str]
        /#@http_m|#{bold_line}|#@manmkp_ital#{tail_m_ital}|(?:#{@md.make_italic[:str]}|#{@vz.markup_make_italic[:str]})#{tail_m_ital}|\S+|\n/
      elsif defined? @md.make_italic[:str]
        /#@http_m|#{bold_line}|#@manmkp_ital#{tail_m_ital}|#{@md.make_italic[:str]}#{tail_m_ital}|\S+|\n/
      elsif defined? @vz.markup_make_italic[:str]
        /#@http_m|#{bold_line}|#@manmkp_ital#{tail_m_ital}|#{@vz.markup_make_italic[:str]}#{tail_m_ital}|\S+|\n/
      end
      @manmkp_bold='^!_\s.+?(?:\n|$)|[*!b]\\{.+?\\}[*!b]|[*!][a-zA-Z0-9\-_]+[*!]'
      @line_scan_bold=if (defined? @md.make_bold[:str] \
      and @md.make_bold[:str]) \
      and (defined? @vz.markup_make_bold[:str] \
      and @vz.markup_make_bold[:str])
        /#@http_m|#{bold_line}|(?:#@manmkp_bold|#{@md.make_bold[:str]}|#{@vz.markup_make_bold[:str]})#{tail_m_bold}|\S+|\n/
      elsif defined? @md.make_bold[:str] \
      and @md.make_bold[:str]
        /#@http_m|#{bold_line}|(?:#@manmkp_bold|#{@md.make_bold[:str]})#{tail_m_bold}|\S+|\n/
      elsif defined? @vz.markup_make_bold[:str] \
      and @vz.markup_make_bold[:str]
        /#@http_m|#{bold_line}|(?:#@manmkp_bold|#{@vz.markup_make_bold[:str]})#{tail_m_bold}|\S+|\n/
      end
    end
    def songsheet
      @data.each do |line|
        line=if @md.sem_tag then sem(line) else line end
        line=pre(line)
        line=wordlist_italics(line)
        line=wordlist_bold(line)
        line=bodymarkup(line)
        @data_new << line
      end
      @data_new
    end
    def sem(line)
      line=SiSU_sem::Tags.new(line,@md).rm.all
    end
    def pre(line)
      line=line.dup
      line.gsub!(/^0~(\S+)/,"#{Mx[:lv_o]}@\\1#{Mx[:lv_c]}")
      line.gsub!(/^@(\S+?):/,"#{Mx[:lv_o]}@\\1#{Mx[:lv_c]}")
      if line =~/\{(?:t|table)(?:~h)?\s*c?[\d; ]*\}/; line.gsub!(/(\n)/,';;\1') #markup for alternative tables
      end
      line
    end
    def wordlist_italics(line)
      line=line.dup
      if (defined? @md.make_italic[:str] \
      and @md.make_italic[:str]) \
      or (defined? @vz.markup_make_italic[:str] \
      and @vz.markup_make_italic[:str])
        line= if line !~/^(?:#{Rx[:meta]}|#{Mx[:gr_o]}code)/  #!~/^(?:[0-6]~|!_|%+\s)/
          word=line.scan(@line_scan_ital)
          word.flatten!
          word.compact! #reinstated
          line_array=[]
          word.each do |w|
            unless /#@manmkp_ital|#@http_m/.match(w)
              if defined? @md.make_italic[:regx] \
              and @md.make_italic[:regx]
                w.gsub!(@md.make_italic[:regx],"#{Mx[:fa_italics_o]}\\1#{Mx[:fa_italics_c]}")
              elsif defined? @vz.markup_make_italic \
              and @vz.markup_make_italic
                w.gsub!(@vz.markup_make_italic,"#{Mx[:fa_italics_o]}\\1#{Mx[:fa_italics_c]}")
              end
            end
            line_array << w
          end
          line_array.join(' ')
        else line
        end
      end
      line
    end
    def embolden(given)
      given.gsub!(/^!_\s+((?:\{|#{Mx[:lnk_o]})(?:~^ )?.+?(?:\}|#{Mx[:lnk_o]})http:\/\/\S+.*?)(<br>)/,"#{Mx[:fa_bold_o]} \\1 #{Mx[:fa_bold_c]}\\2")
      given.gsub!(/^!_\s+((?:\{|#{Mx[:lnk_o]})(?:~^ )?.+?(?:\}|#{Mx[:lnk_o]})http:\/\/\S+.*)/,"#{Mx[:fa_bold_o]} \\1 #{Mx[:fa_bold_c]}")
      given.gsub!(/(?:^!_|^#{Mx[:lv_o]}[7-9]:\S*?#{Mx[:lv_c]})\s*(.+?)(<br>)/,"#{Mx[:fa_bold_o]}\\1#{Mx[:fa_bold_c]}\\2")
      given.gsub!(/(?:^!_|^#{Mx[:lv_o]}[7-9]:\S*?#{Mx[:lv_c]})\s*(.+?)\s+((?:[*]~\S+\s*)+)/,"#{Mx[:fa_bold_o]}\\1#{Mx[:fa_bold_c]}\\2")
      given.gsub!(/(?:^!_|^#{Mx[:lv_o]}[7-9]:\S*?#{Mx[:lv_c]})\s*(.+?)\s*([~-]#)$/,"#{Mx[:fa_bold_o]}\\1#{Mx[:fa_bold_c]}\\2")
      given.gsub!(/(?:^!_\s+|^#{Mx[:lv_o]}[7-9]:\S*?#{Mx[:lv_c]}\s*)(.*)?\s*$/,"#{Mx[:fa_bold_o]}\\1#{Mx[:fa_bold_c]}")
    end
    def italicise(given)
      given.gsub!(/^\/_\s*(.+?)(<br>)/,"#{Mx[:fa_italics_o]}\\1#{Mx[:fa_italics_c]}\\2")
      given.gsub!(/^\/_\s*(.+?)\s+((?:[*]~\S+\s*)+)/,"#{Mx[:fa_italics_o]}\\1#{Mx[:fa_italics_c]}\\2")
      given.gsub!(/^\/_\s*(.+?)\s*([~-]#)$/,"#{Mx[:fa_italics_o]}\\1#{Mx[:fa_italics_c]}\\2")
      given.gsub!(/^\/_\s+(.*)?\s*$/,"#{Mx[:fa_italics_o]}\\1#{Mx[:fa_italics_c]}")
    end
    def wordlist_bold(line)
      line=line.dup
      if (defined? @md.make_bold[:str] \
      and @md.make_bold[:str]) \
      or (defined? @vz.markup_make_bold[:str] \
      and @vz.markup_make_bold[:str])
        line=if line !~/^(?:#{Rx[:meta]}|#{Mx[:lv_o]}[1-9]:\S*?#{Mx[:lv_c]}|%+\s|#{Mx[:gr_o]}code)/
          line_array=[]
          word=line.scan(@line_scan_bold)
          word.flatten!
          word.compact!
          word.each do |w|
            unless /#@manmkp_bold|#@http_m/.match(w)
              if defined? @md.make_bold[:regx] \
              and @md.make_bold[:regx]   #document header: 0~bold [bold word list]
                w.gsub!(@md.make_bold[:regx],"#{Mx[:fa_bold_o]}\\1#{Mx[:fa_bold_c]}")
              elsif defined? @vz.markup_make_bold \
              and @vz.markup_make_bold               #defaults and skin adjusted bold word list
                w.gsub!(@vz.markup_make_bold,"#{Mx[:fa_bold_o]}\\1#{Mx[:fa_bold_c]}")
              end
            else
              if w =~ /(?:^!_|^#{Mx[:lv_o]}[7-9]:\S*?#{Mx[:lv_c]})\s+/; embolden(w) #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
              elsif w =~/^\/_\s+/; italicise(w)
              end
            end
            line_array << w
          end
          line_array.join(' ')
        else line
        end
      else
        if line !~/^(?:#{Mx[:lv_o]}[0-9]:\S*?#{Mx[:lv_c]}|%+\s)/ \
        and line =~ /(?:^!_|^#{Mx[:lv_o]}[7-9]:\S*?#{Mx[:lv_c]})\s+/
          embolden(line)
        end
        if line =~ /\/_\s+/
          italicise(line)
        end
      end
      line
    end
    def bodymarkup(line)
      # << http://www.jus.uio.no/sisu/sisu_markup_table/markup >>
      # See: data/sisu/sample/document_samples_sisu_markup/
      # !{emphasis}!        e{emphasis}e       <strong>emphasis</strong>
      # *{bold text}*       b{bold}b           <b>bold text</b>
      # _{underline}_       u{underline}u      <u>underline</u>
      # /{italics}/         i{italics}i        <i>italics</i>
      # "{citation}"        c{citation}c       <cite>citation</cite> #blockquote?
      # ^{superscript}^                        <sup>superscript</sup>
      # ,{subscript},                          <sub>subscript</sub>
      # +{inserted text}+                      <ins>inserted text</ins>
      # -{deleted text}-                       <del>deleted text</del>
      # {url address}:url
      # {image.png}imageurl
      # {image.png}png
      # ~{endnote}~         <!e endnote !>
      # !_                                    #bold/emphasise paragraph
      # _"                                    #blockquote paragraph
      # _1                  <:i1>            #indent paragraph 1 step
      # _2                  <:i2>            #indent paragraph 2 steps
      # _3                  <:i3>            #indent paragraph 3 steps
      # _4                  <:i4>            #indent paragraph 4 steps
      # _*                                    #bullet (list) ●
      # _1*                                   #bullet (list) indented
      # _1*                                   #bullet (list) indented
      # #                                     #numbered (list) level 1
      # _#                                    #numbered (list) level 2
      line=line.dup
      if line !~/^#{Mx[:meta_o]}|#{Mx[:gr_o]}codeline#{Mx[:gr_c]}|#{Mx[:gr_o]}code-end#{Mx[:gr_c]}/
        #special characters: ~ { } < > - _ / also used : ^ ! #
        line_array=[]
        line.gsub!(/^%{1,4} .+/mi,'') #remove comments
        word=line.scan(/\S+|\n/) unless line =~/^(?:#{Mx[:meta_o]}|%+\s)/ #visit
        if word
          word.each do |w| # _ - / # | : ! ^ ~
            unless w =~/^#{Mx[:lv_o]}[0-9]:\S*?#{Mx[:lv_c]}|~\{|\}~|~\[|\]~|^\^~|~\^|\*~\S+|~#|\{t?~|\{table|http:\/\/\S+/
              w.gsub!(/\\?~/,"#{Mx[:gl_o]}#126#{Mx[:gl_c]}")                                              #escaped special character
              #w.gsub!(/~/,"#{Mx[:gl_o]}#126#{Mx[:gl_c]}")
            end
            w.gsub!(/^\<$/,"#{Mx[:gl_o]}#lt#{Mx[:gl_c]}")                                                 #escaped special character
            w.gsub!(/^\>$/,"#{Mx[:gl_o]}#gt#{Mx[:gl_c]}")                                                 #escaped special character
            line_array << w
          end
          line=line_array.join(' ')
          line=line.strip
        end
        line.gsub!(/~\{(.+?)\}~/m,Mx[:en_a_o] + '\1' + Mx[:en_a_c])
        line.gsub!(/~\[([^*+].+?)\]~/m,Mx[:en_b_o] + '* \1' + Mx[:en_b_c]) #default if markup does not specify
        line.gsub!(/~\[(.+?)\]~/m,Mx[:en_b_o] + '\1' + Mx[:en_b_c])
        if @md.subtitle and not @md.subtitle.empty?
          if line =~/(?:by\s+)?(?:@creator|@author)/
            line.gsub!(/^(#{Mx[:lv_o]}1:\??#{Mx[:lv_c]})\s*@title\s+(?:(by\s+)?(?:@creator|@author))\s*$/,"\\1#{@md.title} - #{@md.subtitle},<br />\\2#{@md.author}")
          else
            line.gsub!(/^(#{Mx[:lv_o]}1:\??#{Mx[:lv_c]})\s*@title\s*$/,"\\1 #{@md.title} - #{@md.subtitle}")
          end
        else
          if line =~/(?:by\s+)?(?:@creator|@author)/
            line.gsub!(/^(#{Mx[:lv_o]}1:\??#{Mx[:lv_c]})\s*@title\s+(?:(by\s+)?(?:@creator|@author))\s*$/,"\\1#{@md.title},<br />\\2#{@md.author}")
          else
            line.gsub!(/^(#{Mx[:lv_o]}1:\??#{Mx[:lv_c]})\s*@title\s*$/,"\\1 #{@md.title}")
          end
        end
        line.gsub!(/^(1~\??) @title\s*$/,"\\1 #{@md.title} - #{@md.subtitle}")                    #
        line.gsub!(/^(#{Mx[:lv_o]}[23]:\??#{Mx[:lv_c]}) (?:(by\s+)?(?:@creator|@author))\s*$/,"\\1 \\2#{@md.author}")                    #
        line.gsub!(/<((?:https?|file):\/\/\S+?)>/,'< \1 >')                    #catch problem markup
        line.gsub!(/\}\.\.\/(\S+)/,"\}#@output_url/\\1")                       #means you are not supporting relative links (only relevant in html), converted to static here
        line.gsub!(/<:=(\S+?)>/,'{ c_\1.png 14x14 }http://www.jus.uio.no/sisu')                                                    #adjustment 2005w30
        line.gsub!(/<!(\S+)!>/,'<:\1>')                                        #escaped special character
        line.gsub!(/&nbsp;/,"#{Mx[:nbsp]}")                                             #escaped special character
        line.gsub!(/\\~/,"#{Mx[:gl_o]}#126#{Mx[:gl_c]}")                                             #escaped special character
        line.gsub!(/\\\{/,"#{Mx[:gl_o]}#123#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\}/,"#{Mx[:gl_o]}#125#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\<</,"#{Mx[:gl_o]}#lt#{Mx[:gl_c]}#{Mx[:gl_o]}#lt#{Mx[:gl_c]}")                 #escaped special character
        line.gsub!(/\\\>>/,"#{Mx[:gl_o]}#gt#{Mx[:gl_c]}#{Mx[:gl_o]}#gt#{Mx[:gl_c]}")                 #escaped special character
        line.gsub!(/\\\</,"#{Mx[:gl_o]}#lt#{Mx[:gl_c]}")                                             #escaped special character
        line.gsub!(/\\\>/,"#{Mx[:gl_o]}#gt#{Mx[:gl_c]}")                                             #escaped special character
        line.gsub!(/\\\_/,"#{Mx[:gl_o]}#095#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\-/,"#{Mx[:gl_o]}#045#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\+/,"#{Mx[:gl_o]}#043#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\//,"#{Mx[:gl_o]}#047#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\#/,"#{Mx[:gl_o]}#035#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\&/,"#{Mx[:gl_o]}#038#{Mx[:gl_c]}")                                            #&amp; #escaped special character
        line.gsub!(/\\\|/,"#{Mx[:gl_o]}#124#{Mx[:gl_c]}")                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\:/,"#{Mx[:gl_o]}#058#{Mx[:gl_c]}")                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\!/,"#{Mx[:gl_o]}#033#{Mx[:gl_c]}")                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\^/,"#{Mx[:gl_o]}#094#{Mx[:gl_c]}")                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\,/,"#{Mx[:gl_o]}#044#{Mx[:gl_c]}")                                            #not really a sisu special character but made available as possibility
        #ADD -->
        line.gsub!(/\\\\/,"#{Mx[:gl_o]}#092#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\*/,"#{Mx[:gl_o]}#042#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/\\\!/,"#{Mx[:gl_o]}#033#{Mx[:gl_c]}")                                            #escaped special character
        line.gsub!(/(?:^| )\*~([a-z0-9._-]+)/i," #{Mx[:mk_o]}:name#\\1#{Mx[:mk_c]}")                 #html name marker <a name="\\1"></a>
        line.gsub!(/^(#{Mx[:lv_o]}[56]:(\S+?)#{Mx[:lv_c]})\s*(.+)/,"\\1 \\3 #{Mx[:mk_o]}:name#\\2#{Mx[:mk_c]}")   #html name marker <a name="\\1"></a>, however at present takes you to correct position within sub-toc, will nneed to clean from sub-toc leaving in main body only
        line.gsub!(/(?:<:?br>|<br \/>)/,"#{Mx[:br_line]}")                     #indent used in endnotes, not implemented, replace when ready with: line.gsub!(/(?:<br>|<br \/>)\s*_([12])\s+/,'<br><:i\1> ')
        if line=~/(^|#{Mx[:gl_c]}| )\{~\^ (.+?)\s*\}((?:https?|file|ftp):\S+)\s*#{Mx[:en_a_o]}(.+?)#{Mx[:en_a_c]}/m
          line.gsub!(/(^|#{Mx[:gl_c]}| )\{~\^ ([^}]+?)\s*\}((?:https?|file|ftp):\S+)\s*#{Mx[:en_a_o]}(.+?)#{Mx[:en_a_c]}/m,
            "\\1#{Mx[:lnk_o]}\\2#{Mx[:lnk_c]}\\3 #{Mx[:en_a_o]}\\3 \\4#{Mx[:en_a_c]}") # watch
        end
        if line=~/(^|#{Mx[:gl_c]}| )\{~\^ (.+?)\s*\}((?:https?|file|ftp):\S+?)([;,.]?(?=\s|$))/m
          line.gsub!(/(^|#{Mx[:gl_c]}| )\{~\^ (.+?)\s*\}((?:https?|file|ftp):\S+?)([;,.]?(?=\s|$))/m,
            "\\1#{Mx[:lnk_o]}\\2#{Mx[:lnk_c]}\\3\\4 #{Mx[:en_a_o]}\\3#{Mx[:en_a_c]} ")
           #text url endnote url shortcut {~^ [text] }http://url is { [text] }http://url #{Mx[:en_a_o]} http://url #{Mx[:en_a_c]} [plus adjustment for commas]
           #means for this class, non-object, un-numbered ~# will not work # shortcut should not be used in conjunction with rebgular matches #reversed order, and addition of no-tilde..
        end
        #line.gsub!(/(^| )\{~\^ (.+?)\s*\}((?:https?|file|ftp):\S+)\s+~\{(.+?)\}~/,'\1{ \2 }\3 ~{ \3 \4 }~') # watch
        line.gsub!(/<:?p([nb])>/,"#{Mx[:fa_o]}p\\1#{Mx[:fa_c]}")               #indent used in endnotes, not implemented, replace when ready with: line.gsub!(/(?:<br>|<br \/>)\s*_([12])\s+/,'<br><:i\1> ')
      # depreciated -->#{Mx[:fa_c]}
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)e\{(.+?)\}e/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")              #emphasis
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)b\{(.+?)\}b/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")              #bold
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)u\{(.+?)\}u/,"\\1#{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]}")  #underscore
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)c\{(.+?)\}c/,"\\1#{Mx[:fa_cite_o]}\\2#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}") #cite /blockquote?
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)i\{(.+?)\}i/,"\\1#{Mx[:fa_italics_o]}\\2#{Mx[:fa_italics_c]}")        #italics
      # depreciated ^
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)!\{(.+?)\}!/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")              #emphasis
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)\*\{(.+?)\}\*/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")            #bold
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[\{]|\>)_\{(.+?)\}_/,"\\1#{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]}")  #underscore
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|#{Mx[:lnk_o]}|[\(\[]|\(|\>)\/\{(.+?)\}\//,"\\1#{Mx[:fa_italics_o]}\\2#{Mx[:fa_italics_c]}")     #italics
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\"\{(.+?)\}\"/,"\\1#{Mx[:fa_cite_o]}\\2#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}")     #cite /blockquote?
        line.gsub!(/(^|[^\\])\^\{(.+?)\}\^/,"\\1#{Mx[:fa_superscript_o]}\\2#{Mx[:fa_superscript_c]}")                                 #superscript
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|\(|\>|\S)9\{(.+?)\}9/,"\\1#{Mx[:fa_superscript_o]}\\2#{Mx[:fa_superscript_c]}")           #superscript
        line.gsub!(/(^|[^\\]),\{(.+?)\},/,"\\1#{Mx[:fa_subscript_o]}\\2#{Mx[:fa_subscript_c]}")                                 #subscript
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)6\{(.+?)\}6/,"\\1#{Mx[:fa_subscript_o]}\\2#{Mx[:fa_subscript_c]}")   #subscript
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\+\{(.+?)\}\+/,"\\1#{Mx[:fa_insert_o]}\\2#{Mx[:fa_insert_c]}")              #inserted text
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)v\{(.+?)\}v/,"\\1#{Mx[:fa_insert_o]}\\2#{Mx[:fa_insert_c]}")                #inserted text
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)-\{(.+?)\}-/,"\\1#{Mx[:fa_strike_o]}\\2#{Mx[:fa_strike_c]}")                #strikethrough - deleted text
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)x\{(.+?)\}x/,"\\1#{Mx[:fa_strike_o]}\\2#{Mx[:fa_strike_c]}")                #deleted text
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\*(\S+?)\*/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")                     #bold single word, watch
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\!(\S+?)\!/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")                     #bold single word, watch
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\/([\(\)a-zA-Z0-9']+?)\/([^a-zA-Z0-9]|[ ,.;:'"~$]|$)/,"\\1#{Mx[:fa_italics_o]}\\2#{Mx[:fa_italics_c]}\\3") #italics single word, watch
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)_(\S+?)_([.,!'")]?(?:\s|$))/,"\\1#{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]}\\3") #underscore single word, watch (made more complicated by url decoration escape tag (_url))
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+)-([^{]\S+?)-( |$)/,"\\1#{Mx[:fa_strike_o]}\\2#{Mx[:fa_strike_c]}\\3")                                        #underscore single word, watch
        line.gsub!(/(^|#{Mx[:gl_c]}|\s+|['"]|#{Mx[:nbsp]}|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>|\d+)\^(\S+?)\^/,"\\1#{Mx[:fa_superscript_o]}\\2#{Mx[:fa_superscript_c]}") #superscript single word, watch digit added
        line.gsub!(/<[:e]\s+(.+?)!?>/,"#{Mx[:en_a_o]}\\1#{Mx[:en_a_c]}")                                                                                     #not tested
        line.gsub!(/^\s*_\*\s*/,"#{Mx[:gl_bullet]}")                               #bullets, shortcut
        line.gsub!(/=\{(.+?)\}/,"#{Mx[:idx_o]}\\1#{Mx[:idx_c]}")                   #
        line.gsub!(/^\s*_([1-9])\*\s*/,"#{Mx[:pa_o]}:i\\1#{Mx[:pa_c]}#{Mx[:gl_bullet]}")                               #bullets, shortcut
        #line.gsub!(/^\s*_([1-9])(\*+)\s*/,"#{Mx[:fa_o]}:i\\1#{Mx[:fa_c]}#{Mx[:fa_o]}\\2#{Mx[:fa_c_o]}")                               #bullets, shortcut
        line.gsub!(/^\s*_([1-9])\s+/,"#{Mx[:pa_o]}:i\\1#{Mx[:pa_c]}")                                                                 #indent
        line.gsub!(/(?:<:?br>|<br \/>)/,"#{Mx[:br_line]}")                        #indent used in endnotes, not implemented, replace when ready with: line.gsub!(/(?:<br>|<br \/>)\s*_([12])\s+/,'<br><:i\1> ')
        ##added
        #line.gsub!(/(?:^!_\s+|^[7-9]~\s+|<:b>)(.*)?([~-]#)$/i,'<b>\1</b> \2')    #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
        #line.gsub!(/(?:^!_\s+|^[7-9]~\s+|<:b>)(.*)?\s*$/i,'<b>\1</b>')           #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
        #line.gsub!(/(?:(?:^| )!_ |^[7-9]~ |<:b>)(.*)\n/mi,'<b>\1</b> ')          #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
        #line.gsub!(/^_" (.*)\n/i,'<blockquote>\1</blockquote> ')                 #blockquotes #introduce KEEP
        line.gsub!(/<:hi>/,"#{Mx[:fa_hilite_o]}") #'<span style="background-color: rgb(255,240,196)">')   # bright yellow rgb(255,255,0) pale yellow rgb(255,255,200)
        line.gsub!(/<:\/hi>/,"#{Mx[:fa_hilite_c]}") #'</span>')
        #line.gsub!(/<:hi>/,
        #line.gsub!(/<:\/hi>/,'</span>')
        line.gsub!(/(#{Mx[:gr_o]}verse#{Mx[:gr_c]}.+)/m,"\\1\n")
        line.gsub!(/[ ]+($)/,'\1')
        line.gsub!(/\{\s*(.+?)\s*\}(https?:\S+)/,"#{Mx[:lnk_o]}\\1#{Mx[:lnk_c]}\\2") #linked (text or image)
        line.gsub!(/\{\s*(.+?)\s*\}(image)/,"#{Mx[:lnk_o]}\\1#{Mx[:lnk_c]}\\2")      #linked image
        #line.gsub!(/(#{Mx[:lnk_c]})\s*((?:https?|file|ftp):\S+?)/m,'\1\2')
        ##semantic
        #line.gsub!(/([a-z](?:[a-z_:.]+?[a-z])?)+(?::\{(.+?)\}:\1)/m,"\\1#{Mx[:sm_set_o]}\\2#{Mx[:sm_set_c]}\\1")
        #line.gsub!(/;\{\s*(.+?)\s*\};([a-z]+(?:[_:.][a-z]+)*)/,"#{Mx[:sm_subset_o]}\\1#{Mx[:sm_subset_c]}\\2")
        if line =~/(#{Mx[:gr_o]}(?:verse|group)#{Mx[:gr_c]})/; line.gsub!(/(#{Mx[:gr_o]}(?:verse|group)#{Mx[:gr_c]})/i,"\\1\n") #cosmetic
        else line.gsub!(/<br \/>/i,"#{Mx[:br_line]}\n")
        end
      elsif line =~/^#{Mx[:gr_o]}code(?:-end)?#{Mx[:gr_c]}|#{Mx[:gr_o]}codeline#{Mx[:gr_c]}/ # /^<:code>/ #should be enough # underscore used as escape for angle brackets
        line.gsub!(/([<>])/,'_\1')
        line.gsub!(/_<:(\S+?)_>/,'<:\1>') #convert <:\S+> back, clumsy
        line.gsub!(/_<(br(?: \/)?)_>/,'<\1>') #convert <br> <br /> back, clumsy
        line.gsub!(/(^|#{Mx[:gl_c]}|\s)&lt;(br(?: \/)?)&gt;([\s,.]|$)/,'\1<\2>\3') #convert <br> <br /> back, clumsy
        line.gsub!(/#{Mx[:gr_o]}codeline#{Mx[:gr_c]}/,"\n#{Mx[:nbsp]}#{Mx[:nbsp]}") #temporary fix, prefer: #line.gsub!(/<:codeline>/,"\n")
        line
      else # 0~
      end
      line
    end
    def tech                                                                       #script markup planned to be more strict for technical documents
      # !{emphasis}!        e{emphasis}e       <strong>emphasis</strong>
      # *{bold text}*       b{bold}b           <b>bold text</b>
      # _{underline}_       u{underline}u      <u>underline</u>
      # /{italics}/         i{italics}i        <i>italics</i>
      # "{citation}"        c{citation}c       <cite>citation</cite>
      # ^{superscript}^                        <sup>superscript</sup>
      # ,{subscript},                          <sub>subscript</sub>
      # +{inserted text}+                      <ins>inserted text</ins>
      # -{deleted text}-                       <del>deleted text</del>
      # {url address}:url
      # {image.png}imageurl
      # {image.png}png
      # ~{endnote}~         <!e endnote !>
      # +1                  <!i1!>
      # +2                  <!i2!>
      puts 'tech'
      @data.each do |line|
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)e\{(.+?)\}e/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")              #emphasis
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)b\{(.+?)\}b/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")              #bold
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)u\{(.+?)\}u/,"\\1#{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]}")  #underscore
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)c\{(.+?)\}c/,"\\1#{Mx[:fa_cite_o]}\\2#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}") #cite
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)i\{(.+?)\}i/,"\\1#{Mx[:fa_italics_o]}\\2#{Mx[:fa_italics_c]}")        #italics
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)!\{(.+?)\}!/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")              #emphasis
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)\*\{(.+?)\}\*/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")            #bold
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\>)_\{(.+?)\}_/,"\\1#{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]}")  #underscore
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|[\(\[]|\(|\>)\/\{(.+?)\}\//,"\\1#{Mx[:fa_italics_o]}\\2#{Mx[:fa_italics_c]}")   #italics
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\"\{(.+?)\}\"/,"\\1#{Mx[:fa_cite_o]}\\2#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\^\{(.+?)\}\^/,"\\1#{Mx[:fa_superscript_o]}\\2#{Mx[:fa_superscript_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)9\{(.+?)\}9/,"\\1#{Mx[:fa_superscript_o]}\\2#{Mx[:fa_superscript_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>),\{(.+?)\},/,"\\1#{Mx[:fa_subscript_o]}\\2#{Mx[:fa_subscript_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)6\{(.+?)\}6/,"\\1#{Mx[:fa_subscript_o]}\\2#{Mx[:fa_subscript_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\+\{(.+?)\}\+/,"\\1#{Mx[:fa_insert_o]}\\2#{Mx[:fa_insert_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)v\{(.+?)\}v/,"\\1#{Mx[:fa_insert_o]}\\2#{Mx[:fa_insert_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)-\{(.+?)\}-/,"\\1#{Mx[:fa_strike_o]}\\2#{Mx[:fa_strike_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)x\{(.+?)\}x/,"\\1#{Mx[:fa_strike_o]}\\2#{Mx[:fa_strike_c]}")
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\*(\S+?)\*/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")               #bold single word, watch
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\!(\S+?)\!/,"\\1#{Mx[:fa_bold_o]}\\2#{Mx[:fa_bold_c]}")               #bold single word, watch
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\/([\(\)a-zA-Z0-9']+?)\/([ ,.;:'"~$]|[^a-zA-Z0-9])/,"\\1#{Mx[:fa_italics_o]}\\2#{Mx[:fa_italics_c]}\\3")     #italics single word, watch
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)_(\S+?)_/,"\\1#{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]}")                 #underscore single word, watch
        line.gsub!(/(^|\s+|['"]|#{Mx[:fa_o_c]}|#{Mx[:fa_c]}|\(|\>)\^(\S+?)\^/,"\\1#{Mx[:fa_superscript_o]}\\2#{Mx[:fa_superscript_c]}")     #check  #superscript single word, watch digit added
        line.gsub!(/^\s*_\([1-9]\)\(\*\+\)\s*/,"#{Mx[:pa_o]}:i\\1#{Mx[:pa_c]}#{Mx[:fa_o]}\\2#{Mx[:fa_c_o]}") # bullets, shortcut
        line.gsub!(/^\s*_\([1-9]\)\s+/,"#{Mx[:pa_o]}:i\\1#{Mx[:pa_c]}")
        line.gsub!(/(?:<:?br>|<br \/>)\s*_[12]\s+/,"#{Mx[:br_line]} ")                          #indent used in endnotes, not implemented, replace when ready with: line.gsub!(/(?:<br>|<br \/>)\s*_([12])\s+/,'<br><:i\1> ')
      end
      @data
    end
  end
end
__END__
NOTE:
downstream code blocks are not currently/yet honoured, e.g. stuff within angle brackets are removed
