# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DB_remove
  class Remove
    def initialize(opt,conn,file)
      @opt,@conn,@file=opt,conn,file
      @md=SiSU_Param::Parameters.new(@opt).get
      @fnb=@md.fnb
      @db=SiSU_Env::Info_db.new
    end
    def remove
      driver_sqlite3 = true if @conn.inspect.match(/^(.{10})/)[1] == @db.sqlite.conn_sqlite3.inspect.match(/^(.{10})/)[1]
      del_id=if driver_sqlite3
        @conn.get_first_value(%{ SELECT tid FROM metadata WHERE filename LIKE '#{@opt.fns}'; }).to_i
      else
        x=@conn.select_one(%{ SELECT tid FROM metadata WHERE filename LIKE '#{@opt.fns}'; })
        del=if x; x.join.to_i else nil
        end
      end
      if del_id
        sql_entry=[
          "DELETE FROM endnotes WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM endnotes_asterisk WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM endnotes_plus WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM documents WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM urls WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM metadata WHERE tid = '#{del_id}';",
        ]
        if driver_sqlite3
          @conn.transaction
          sql_entry.each do |s|
            @conn.execute(s)
          end
          @conn.commit if driver_sqlite3
        else
          s=sql_entry.join(' ')
          @conn.execute(s)
        end
        if @opt.cmd =~/M/
          @file.puts sql_entry if @opt.cmd =~/M/
        end
      else
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"no such file in database #{@db.psql.db}::#{@opt.fns}")
        tell.puts_grey #if @opt.cmd.include? ?v
      end
    end
  end
end
__END__
