# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: postgresql module, dbi import frame

=end
module  SiSU_DBI                                                                 #% database building
  require "#{SiSU_lib}/help"
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Screen
  require "#{SiSU_lib}/param"
  include SiSU_Param
  require "#{SiSU_lib}/db_dbi" # db_dbi.rb
  include SiSU_DB_DBI
  require "#{SiSU_lib}/shared_html_lite"
  include SiSU_Format_Shared
  class SiSU_SQL
    def initialize(opt)
      SiSU_Env::Load.new('dbi',true).prog
      @opt=opt
      @db=SiSU_Env::Info_db.new
      if @opt.cmd =~/d/i \
      or  @opt.mod.inspect =~/--(pg(?:sql)?|(?:sq)?lite)/
        @sql_type=if @opt.cmd=~/D/ \
        or @opt.mod.inspect =~/--pg(?:sql)?/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'pg'
        elsif @opt.cmd =~/d/ \
        and @opt.mod.inspect =~/--(?:db[=-])?pg(?:sql)?/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'pg'
        elsif @opt.cmd=~/d/ \
        or @opt.mod.inspect =~/--(?:sq)?lite/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'sqlite'
        elsif @opt.cmd =~/d/ \
        and @opt.mod.inspect =~/--(?:db[=-])?(?:sq)?lite/
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'sqlite'
        #elsif @opt.cmd =~/d/ and @opt.mod.select =~/--my(?:sql)?/;               'mysql'
        else
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
          'sqlite'
        end
      end
    end
    def maintenance_check(opt,file,line)
      p opt.mod
      p opt.cmd
      p "at #{file} #{line}"
    end
    def read_psql
      begin
        @conn=@db.psql.conn_dbi
      rescue
        if @opt.mod.inspect=~/--(createall|create)/
          puts %{manually create the database: "#{db}" if it does not yet exist}
          #sudo su -p postgres;  createdb #{db}; #[createuser?]
        end
        SiSU_DB_DBI::Case.new(@opt,@conn,@sql_type).cases
        @conn=DBI.connect(dbi,user,db)
      ensure
      end
    end
    def read_sqlite
      begin
        sql_type='sqlite'
        @conn=@db.sqlite.conn_sqlite3
        #@conn=@db.sqlite.conn_dbi     #issue with dbi sqlite api, when fixed revert to using, KEEP
      rescue
      ensure
      end
    end
    def connect
      case @sql_type
      when /pg/;     read_psql
      when /sqlite/; read_sqlite
      end
      tell=SiSU_Screen::Ansi.new(@opt.cmd,"DBI (#@sql_type) #{@opt.mod}")
      tell.dbi_title unless @opt.cmd =~/q/
      begin
        SiSU_DB_DBI::Case.new(@opt,@conn,@sql_type).cases
      rescue
        SiSU_Errors::Info_error.new($!,$@,@cf,@opt.fns).error
      ensure
      end
      begin
        #@conn.disconnect if @sql_type =~/sqlite/ and @opt.mod.inspect !~/^--(?:re)?create/
        #@conn.disconnect if @sql_type =~/sqlite/
      rescue
        connect
      end
    end
  end
end
__END__
