# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: update previous output (with similar output file type formats)

=end
module SiSU_Update_control_flag
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Param
  class Check
    def initialize(opt)
      @opt=opt
      @md=SiSU_Param::Parameters.new(@opt).get
    end
    def read
      begin
        @env=SiSU_Env::Info_env.new(@md.fns)
        out=@env.path.output
        base_path="#{out}/#{@md.fnb}"
        tell=SiSU_Screen::Ansi.new(@md.cmd,'Checking previous output',base_path)
        tell.green_hi_blue unless @md.cmd =~/q/
        Set_CF.new(@md).set_flags
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
    private
    class Set_CF
      def initialize(md)
        @md=md
        @env=SiSU_Env::Info_env.new(@md.fns)
        out=@env.path.output
        @base_path="#{out}/#{@md.fnb}"
      end
      def set_flags #-mNhwpoabxXyv
        flag='-v'
        if FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          flag=flag + 'a'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:toc]}")==true \
        or FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          flag=flag + 'h'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:xhtml]}")==true
          flag=flag + 'b'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:sax]}")==true
          flag=flag + 'x'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:dom]}")==true
          flag=flag + 'X'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:odf]}")==true
          flag=flag + 'o'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p]}")==true \
        or FileTest.file?("#@base_path/#{@md.fn[:pdf_l]}")==true
          flag=flag + 'p'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:concordance]}")==true
          flag=flag + 'w'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:digest]}")==true
          flag=flag + 'N'
        end
        if FileTest.file?("#@base_path/#{@md.fns}")==true
          flag=flag + 's'
        end
        if FileTest.file?("#@base_path/sisupod.tgz")==true
          flag=flag + 'S'
        end
        puts flag
        flag
      end
    end
  end
end
__END__
