# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: xhtml output logic, flow
   ** Notes: tidy -xml scroll.xhtml >> index.tidy
=end
module SiSU_XHTML
  require "#{SiSU_lib}/defaults"
  include SiSU_Viz
  require "#{SiSU_lib}/particulars"
  include SiSU_Particulars
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/shared_xml"
  require "#{SiSU_lib}/xml_format"
  include SiSU_XML_format
  include SiSU_XML_munge
  require "#{SiSU_lib}/rexml"
  include SiSU_Rexml
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
    end
    def read
      begin
        @env,@md,@dal_array=@particulars.env,@particulars.md,@particulars.dal_array
        path=@env.path.output_tell
        loc=@env.url.output_tell
        tool=if @opt.cmd =~/[MV]/; "#{@env.program.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:xhtml]}\n\t#{@env.program.xml_viewer} #{path}/#{@md.fnb}/#{@md.fn[:xhtml]}"
        elsif @opt.cmd =~/v/; "#{@env.program.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:xhtml]}"
        else ''
        end
        SiSU_Screen::Ansi.new(@opt.cmd,'invert','XHTML',tool).colorize unless @opt.cmd =~/q/
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output_tell}/#{@md.fnb}/#{@md.fn[:xhtml]}").flow if @opt.cmd =~/[MV]/
        SiSU_XHTML::Source::Songsheet.new(@particulars).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        #file closed in songsheet
      end
    end
    private
    class Songsheet
      def initialize(particulars)
        @env,@md,@dal_array,@particulars=particulars.env,particulars.md,particulars.dal_array,particulars
      end
      def songsheet
        begin
          SiSU_XHTML::Source::Scroll.new(@particulars).songsheet
          SiSU_XHTML::Source::Tidy.new(@md,@env).xml if @md.cmd =~/[vVM]/ # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@md.fn[:xhtml]).xml if @md.cmd =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
    class Scroll
      require "#{SiSU_lib}/shared_txt"
      require "#{SiSU_lib}/css"
      include SiSU_text_utils
      @@dp=nil
      @@xml={ :body=>[],:sisu=>[],:open=>[],:close=>[],:head=>[] }
      def initialize(particulars)
        @env,@md,@dal_array=particulars.env,particulars.md,particulars.dal_array
        @vz=SiSU_Env::Get_init.instance.skin
        @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
        @regx=/^(?:(?:#{Mx[:br_page]}\s*|#{Mx[:br_page_new]}\s*)?#{Mx[:lv_o]}\d:(\S*)#{Mx[:lv_c]}\s*)?(.+?)\s*#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        @tab="\t"
        @trans=SiSU_XML_munge::Trans.new(@md)
        @sys=SiSU_Env::System_call.new
      end
      def songsheet
        pre
        @data=markup(@dal_array)
        post
        publish
      end
    protected
      def embedded_endnotes(para='')
        para.gsub!(/#{Mx[:en_a_o]}(\d+)\s+(.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/,
          '<endnote><number>\1</number><note>\2</note></endnote> ')
        para.gsub!(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_b_c]}/,
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
        para.gsub!(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/,
          '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
      end
      def extract_endnotes(para='')
        notes=para.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+\s+.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/)
        notes.flatten.each do |e|
          s=e.to_s
          util=SiSU_text_utils::Wrap.new(s,70)
          wrap=util.line_wrap
          wrap.gsub!(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote notenumber="\\1">
#{@tab*2}\\1. \\2
#{@tab*1}</endnote>
WOK
)
          wrap.gsub!(/^([*+]\d+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote symbol="\\1">
#{@tab*2}\\1 \\2
#{@tab*1}</endnote>
WOK
)
          wrap.gsub!(/^([*+]+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote symbol="\\1.length">
#{@tab*2}\\1 \\2
#{@tab*1}</endnote>
WOK
)
#KEEP alternative presentation of endnotes
#        wrap.gsub!(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
##{@tab*1}<p class="endnote" notenumber="\\1">
##{@tab*2}\\1. \\2
##{@tab*1}</p>
#WOK
#)
          @endnotes << wrap
        end
      end
      def xml_head(meta)
        txt=meta.text
        txt.gsub!(/#{Mx[:br_line]}|#{Mx[:br_nl]}/,' ')
        txt.gsub!(/ & /,' and ')
        el=meta.el.gsub(/\./,'_')
        el_txt=meta.el.gsub(/\./,' ')
        @@xml[:head] <<= if meta.type == 'meta'
          <<WOK
#{@tab}<meta>#{el_txt.capitalize}:</meta>
#{@tab}<#{el} class="#{meta.attrib}">
#{@tab*2}#{txt}
#{@tab}</#{el}>
#{@tab}<br />
WOK
        else ''
        end
      end
      def xml_structure(para='',lv='',ocn='',hname='',type='norm') #extracted endnotes
        lv=lv.to_i
        n=lv - 1
        n3=lv + 2
        lv=nil if lv == 0
        extract_endnotes(para)
        para.gsub!(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/,'<en>\1</en>') #footnote/endnote clean
        para.gsub!(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        if para[@regx]
          paragraph="#{para[@regx,2]}"
          util=SiSU_text_utils::Wrap.new(paragraph,70)
          wrapped=util.line_wrap
        end
        @@xml[:body] << if para[@regx,3]; %{#{@tab*0}<object id="#{para[@regx,3]}">} << "\n"
        else                              "#{@tab*0}<object>" << "\n" if para[@regx]
        end
        #@@xml[:body] << "#{@tab*0}<object>" << "\n" if para[@regx]
        #@@xml[:body] << "#{@tab*1}<heading>#{lv}</heading>" << "\n" if lv
        @@xml[:body] << %{#{@tab*1}<text class="#{type}">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n} unless lv  # main text, contents, body KEEP
        @@xml[:body] << %{#{@tab*1}<text class="h#{lv}">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n}  << "\n" if lv # main text, contents, body KEEP
        #@@xml[:body] << %{#{@tab*1}<text heading="#{lv}">\n} << "\n" if lv
        @@xml[:body] << @endnotes.compact.join if @endnotes.length > 0 # main text, endnotes KEEP
        @@xml[:body] << "#{@tab*1}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
        ##@@xml[:body] << "#{@tab*1}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" if para[@regx]
        @endnotes=[]
      end
      def group_structure(para='',ocn='')
        para.gsub!(/#{Mx[:gr_o]}group(?:-end)?#{Mx[:gr_c]}/,'')
        para=@trans.markup_group(para)
        para.strip!
        para.gsub!(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/,'<en>\1</en>') #footnote/endnote clean
        para.gsub!(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)\s*#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="group">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def poem_structure(para='',ocn='')
        para.gsub!(/#{Mx[:gr_o]}verse(?:-end)?#{Mx[:gr_c]}/,'')
        para=@trans.markup_group(para)
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="verse">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def code_structure(para='',ocn='')
        para.gsub!(/#{Mx[:gr_o]}code(?:-end)?#{Mx[:gr_c]}/,'')
        para=@trans.markup_group(para)
        para.gsub!(/\s\s/,'&#160;&#160;')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="code">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def table_structure(table='',ocn='') #tables
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n" #if para[@regx]
        @@xml[:body] << %{#{@tab*1}#{table}\n#{@tab*1}\n} # unless lv  # main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" #if para[@regx]
        @endnotes=[]
      end
      def markup(data)
        @endnotes=[]
        @rcdc=false
        @level,@cont,@copen,@xml_contents_close=[],[],[],[]
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @xml_contents_close[x]='' }
        data.each do |para|
          @trans.char_enc.utf8(para) if @sys.locale =~/utf-?8/i #% utf8
          para=@trans.markup(para)
          if para =~/^#{Rx[:meta]}\s*.+?$/ # for headers
            d_meta=SiSU_text_utils::Header_scan.new(@md,para).meta
            if d_meta; xml_head(d_meta)
            end
          end
          if @rcdc==false \
          and (para =~/~metadata/ \
          or para =~/#{Mx[:lv_o]}1:meta#{Mx[:lv_c]}\s*Document Information/)
            @rcdc=true
          end
          if para !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            if para =~/.+?#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
              paranum=para[@regx,3]
              @p_num=SiSU_XML_format::Paragraph_number.new(@md,paranum)
            end
            @sto=SiSU_text_parts::Split_text_object.new(@md,para).xml
            ### problem in scroll, it appears tables are getting paragraph numbers
            unless @rcdc
              m=/#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
              if para =~m
                txt_obj={:txt =>@sto.text}
                format_scroll=SiSU_XML_format::Format_scroll.new(@md,txt_obj) if @sto.format =~/i[1-9]|ordinary/
                case @sto.format
                when /^(1):(\S*)/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body1
                when /^(2):(\S*)/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body2
                when /^(3):(\S*)/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body3
                when /^(4):(\S+)/ # work on see SiSU_text_parts::Split_text_object
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body4
                when /^(5):(\S*)/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body5
                when /^(6):(\S*)/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body6
                else
                  matched=/#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/mi.match(para)
                  stamp,ocn=matched[0],matched[1]
                  if para =~ /#{Mx[:gr_o]}verse#{Mx[:gr_c]}/
                    para.gsub!(/#{stamp}/,'')
                    poem_structure(para,ocn)
                  elsif para =~ /#{Mx[:gr_o]}group#{Mx[:gr_c]}/
                    para.gsub!(/#{stamp}/,'')
                    group_structure(para,ocn)
                  elsif para =~ /#{Mx[:gr_o]}code#{Mx[:gr_c]}/
                    para.gsub!(/#{stamp}/,'')
                    code_structure(para,ocn)
                  elsif para =~/#{Mx[:gr_o]}Th?.+/ # tables come as single block #work area 2005w13
                    table=SiSU_Tables::Table_xml.new(para,ocn)
                    para=table.table_split
                    table_structure(para,ocn)
                  elsif para =~ /^\s*(?:#{Mx[:pa_o]}:i([1-9])#{Mx[:pa_c]})?#{Mx[:gl_bullet]}/
                    m=$1
                    para.gsub!(/^(\s*(?:#{Mx[:pa_o]}:i([1-9])#{Mx[:pa_c]})?)#{Mx[:gl_bullet]}/,'\1')
                    xml_structure(para,nil,nil,nil,"indent_bullet#{m}")
                  elsif para =~ /^\s*#{Mx[:pa_o]}:i([1-9])#{Mx[:pa_c]}/
                    xml_structure(para,nil,nil,nil,"indent#{$1}")
                  else xml_structure(para,nil,nil,nil)
                  end
                  #@@xml[:body] << "#{@tab*6}<object>" << "\n" if para[@regx]
                  #@@xml[:body] << "#{@tab*7}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
                  #@@xml[:body] << "#{@tab*7}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # main text, contents, body KEEP
                  #@@xml[:body] << "#{@tab*6}</object>" << "\n" if para[@regx]
                end
              elsif para =~/(#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/ \
              and para !~/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
              elsif para =~/(MetaData)/ \
              and para =~/#{Mx[:id_o]}~\d+;[m]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/ #debug 2003w46 add rc info
                txt_obj={:txt =>'<br /><a name="metadata">MetaData</a>'}
                format_scroll=Format_scroll.new(@md,txt_obj)
                para=format_scroll.bold_para
              elsif para =~/(Owner Details)/ \
              and para !~/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
                txt_obj={:txt =>'<br /><a name="owner.details">Owner Details</a>'}
                format_scroll=Format_scroll.new(@md,txt_obj)
                @@xml[:owner_details]=format_scroll.bold_para
                para=''
              #elsif para =~/(.*)<:#>(.*)/
              #  one,two=$1,$2
              #  format_text=Format_text_object.new(one,two)
              #  para=format_text.seg_no_paranum
              end
              #if para =~/<a name="n\d+">/ \
              #and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/ # -endnote
              #  para=''
              #end
              para=case para
              when /#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]}/
                if para =~/.*<:#>.*$/
                  txt_obj={:txt =>para}
                  format_text=Format_text_object.new(@md,txt_obj)
                  format_text.scr_inden_ocn_e_no_paranum
                end
              else para
              end
              if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/
                # i don't get the condition for no paranum
              end
            else #
            end
            para.gsub!(/#{Mx[:pa_o]}:\S+#{Mx[:pa_c]}/,'') if para
          end
        end
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          @@xml[:body] << "#{@tab*5}</content>\n#{@tab*y}</contents#{v}>\n" if @level[x] == true
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x] == true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{@tab*y}</level #{x}>\n" if @level[x] == true }
      end
      def pre
        rdf=SiSU_XML_tags::RDF.new(@md)
        dir=SiSU_Env::Info_env.new
        @@xml[:head],@@xml[:body]=[],[] #added
        css=SiSU_Env::CSS_select.new(@md).xhtml
        encoding=if @sys.locale =~/utf-?8/i #% utf8
          '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else
          '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
<?xml-stylesheet type="text/css" href="../#{@env.path.style}/#{css}"?>
#{rdf.comment_xml}
<document>
WOK
        @@xml[:head] << %{<head>\n\t<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />\n}
        @@xml[:body] << "<body>\n"
      end
      def post
        @@xml[:head] << "</head>\n"
        @@xml[:body] << "</body>\n"
        @@xml[:close] = "</document>\n"
      end
      def publish
        content=[]
        content << @@xml[:open] << @@xml[:head] << @@xml[:body] << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail] << @@xml[:close]
        content.flatten!.compact!
        Output.new(content,@md).xml
        @@xml={} # check whether should be nil
      end
    end
    class Output
      def initialize(data,md)
        @data,@md=data,md
      end
      def xml
        SiSU_Env::SiSU_file.new(@md).mkdir
        filename_xml=SiSU_Env::SiSU_file.new(@md,@md.fn[:xhtml]).mkfile
        @data.each do |para|
          para.gsub!(/#{Mx[:pa_o]}:\S+#{Mx[:pa_c]}/,'') #; para.gsub!(/<:\S+?>|<!.+?!>/,'')
          para.gsub!(/^\s*\n$/,'')
          filename_xml.puts para unless para.empty?
        end
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,dir)
        @md,@env=md,dir
        @prog=SiSU_Env::Info_program.new
      end
      def xml
        if @prog.tidy !=false
          if @md.cmd =~/[VM]/
            tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','Using XML Tidy','check document structure')
            tell.colorize unless @md.cmd =~/q/
            tell.grey_open unless @md.cmd =~/q/
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy=SiSU_Env::System_call.new("#{@env.path.output}/#{@md.fnb}/#{@md.fn[:xhtml]}",tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.cmd =~/q/
          end
        end
      end
    end
  end
end
__END__
<?xml version="1.0"?>
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<?xml version="1.0" encoding="UTF-16" standalone="no"?>
