# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: LaTeX generation

=end
module SiSU_TeX
  require 'pstore'
  require "#{SiSU_lib}/defaults"                           # defaults.rb
    include SiSU_Viz
  require "#{SiSU_lib}/particulars"                        # particulars.rb
    include SiSU_Particulars
  require "#{SiSU_lib}/texpdf_format"                      # texpdf_format.rb
    include SiSU_TeX_Pdf
  @tex_file=@@tex_footnote_array=@@tex_col_w=[]
  @@tex_backslash ||="\\\\"
  @@tilde='\\\\\\~' #?? debug crazy
  @@tabular="{tabular}"
  @@column_instruct=@@squigle_close=@@tex_line_mode=@@tex_word_mode=@@line_mode=''
  @@tex_debug_counter=@@table_pagebreak_counter=@@tex_footnote_call_counter=@@tex_table_flag=@@tex_counter=@@tex_column=@@tex_columns=@@tex_columns=@@counting=0
  @@tex_pattern_margin_number=/\\\\begin\\\{tiny\\\}\\\\hspace\\\{0mm\\\}\\\\end\\\{tiny\\\}\\\{\\\\marginpar.+?\s+/
  @@n=@@tableheader=@@rights=nil
  @@date ||=SiSU_Env::Info_date.new
  class Source #Songsheet #<SiSU_Param::MyFiles
    require 'pstore'
    require "#{SiSU_lib}/sysenv"                           # sysenv.rb
      include SiSU_Env
    include SiSU_Viz
    require "#{SiSU_lib}/dal"                              # dal.rb
      include SiSU_DAL
    include SiSU_TeX
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
      @md=@particulars.md
      @env=@particulars.env
    end
    def directories
      begin
        @dir_out_root=@env.path.output
        case @opt.fns
        when /\.(?:-|ssm\.)?sst$/
          SiSU_Env::SiSU_file.new(@md).mkdir
          Dir.mkdir(@env.path.tex) unless FileTest.directory?(@env.path.tex)
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=@particulars.md
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'LaTeX/PDF')
        tell.green_title_hi unless @opt.cmd =~/q/
        path=@env.url.output_tell
        if @opt.cmd =~/[MVv]/
          tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.program.pdf_viewer} #{path}/#{@md.fnb}/#{@md.fn[:pdf_l]}")
          tell.flow
          tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.program.pdf_viewer} #{path}/#{@md.fnb}/#{@md.fn[:pdf_p]}")
          tell.flow
        end
        @md=@particulars.md
        SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        $flag=@md.cmd                                                         #introduced to pass 0 for no object citation numbers... to texpdf_format
        @dir_o="#{@env.path.output}/#{@opt.fnb}"
        directories
                                                                             #% needed needs to be reprogrammed !!!
        SiSU_Env::Info_skin.new(@md).select
        dal_array=SiSU_DAL::Source.new(@opt).get # dal file drawn here
        SiSU_TeX::Source::LaTeX_create.new(@particulars).songsheet
        dal_array=''
        pwd=Dir.pwd
        SiSU_TeX::Source::LaTeX_to_pdf.new(@md,@particulars.env).latexrun_selective
        Dir.chdir(pwd)
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles=Dir["#{@env.path.tex}/#{@opt.fns}*"]
          texfiles.each do |f|
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        @tex_file=@@tex_footnote_array=[]
        @@column_instruct=''
        @@squigle_close=@@tex_line_mode=@@tex_word_mode=@@line_mode=''
        @@tex_debug_counter=@@table_pagebreak_counter=@@tex_footnote_call_counter=@@tex_table_flag=@@tex_counter=@@tex_column=@@tex_columns=@@tex_columns=@@counting=0
        @@tex_col_w=[]
        @@n=@@tableheader=@@rights=nil
        @@date=SiSU_Env::Info_date.new
        @@flag={}
        $flag=1 #remove at some stage
        SiSU_Env::Create_file.new(@opt.cmd,@opt.fns).param_instantiate
      end
    end
    private
    class LaTeX_to_pdf #<Songsheet
      require 'fileutils'
      include FileUtils #::Verbose
      @@n_lpdf||=0 #change
      def initialize(md,env)
        @md,@env=md,env
      end
      def latex_do(texfilename,papersize)
        @texfilename=texfilename
        @@n_lpdf=@@n_lpdf+1
        tell=SiSU_Screen::Ansi.new(@md.cmd,"#{papersize} portrait ->")
        tell.dark_grey_title_hi if @md.cmd =~/[MVv]/
        tex_fn_base=@texfilename.gsub(/\.tex$/,'')
        cmd=SiSU_Env::System_call.new("#{tex_fn_base}.tex",'',@md.cmd)
        tell=SiSU_Screen::Ansi.new(@md.cmd)
        tell.grey_open unless @md.cmd =~/q/
        if "#{tex_fn_base}" =~/\w+/ \
        and "#{papersize}" =~/\w+/
          2.times { |i| cmd.latex2pdf(@md,papersize) }
        end
        tell.p_off unless @md.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@md.cmd,"#{papersize} landscape ->")
        tell.dark_grey_title_hi if @md.cmd =~/[MVv]/
        cmd=SiSU_Env::System_call.new("#{tex_fn_base}.landscape.tex",'',@md.cmd)
        tell.grey_open
        if "#{tex_fn_base}" =~/\w+/ \
        and "#{papersize}" =~/\w+/
          2.times { |i| cmd.latex2pdf(@md,papersize) }
        end
        tell.p_off unless @md.cmd =~/q/
        pwd=Dir.pwd
        portrait_pdf="#{pwd}/#{tex_fn_base}.pdf"
        landscape_pdf="#{pwd}/#{tex_fn_base}.landscape.pdf"
        case papersize
        when /a4/;     pdf_p=@md.fn[:pdf_p_a4];     pdf_l=@md.fn[:pdf_l_a4]
        when /a5/;     pdf_p=@md.fn[:pdf_p_a5];     pdf_l=@md.fn[:pdf_l_a5]
        when /b5/;     pdf_p=@md.fn[:pdf_p_b5];     pdf_l=@md.fn[:pdf_l_b5]
        when /letter/; pdf_p=@md.fn[:pdf_p_letter]; pdf_l=@md.fn[:pdf_l_letter]
        when /legal/;  pdf_p=@md.fn[:pdf_p_legal];  pdf_l=@md.fn[:pdf_l_legal]
        else           pdf_p=@md.fn[:pdf_p_a4];     pdf_l=@md.fn[:pdf_l_a4]
        end
        if FileTest.file?(portrait_pdf)
          cp(portrait_pdf,"#@dir_sisu/#{@md.fnb}/#{pdf_p}")
          rm(portrait_pdf)
        else p "here #{__FILE__} #{__LINE__} NOT FOUND: #{portrait_pdf}" if @md.cmd.inspect =~/M/
        end
        if FileTest.file?(landscape_pdf)
          cp(landscape_pdf,"#@dir_sisu/#{@md.fnb}/#{pdf_l}")
          rm(landscape_pdf)
        else p "#{__FILE__}:#{__LINE__} NOT FOUND: #{landscape_pdf}" if @md.cmd.inspect =~/M/
        end
        tell=SiSU_Screen::Ansi.new(@md.cmd,@@n_lpdf,'processed (SiSU LaTeX to pdf - using pdfetex aka. pdftex or pdflatex)')
        tell.generic_number unless @md.cmd =~/q/
      end
      def latexrun_selective
        begin
          pwd=Dir.pwd
          Dir.chdir(pwd) #watch
          @tex_f_no=0
          info={}
          if FileTest.file?(@env.source_file_with_path)
            @md.papersize_array.each do |ps|
              if @md.fns =~/\.(?:-|ssm\.)?sst$/
                @dirout=SiSU_Env::Info_env.new(@md.fns)
                case @md.fns
                when /\.(?:-|ssm\.)?sst$/
                  if FileTest.directory?(@env.path.tex)==true
                    Dir.chdir(@env.path.tex)
                    @dir_sisu=@dirout.path.output
                    texfile=@md.fns.gsub(/$/,".#{ps}.tex")
                    texfile=texfile.gsub(/~/,'-')
                    if File.exist?(texfile) \
                    and File.size(texfile) > 0
                      @tex_f_no+=1
                      latex_do(texfile,ps)
                    else
                      puts "\tzero file size #{@env.path.tex}/#{texfile}"
                    end
                  end
                end
              end
            end
            outputdir="#@dir_sisu/#{@md.fnb}"
            case @md.papersize_array[0] #default pdf
            when /a4/;     pdf_p=@md.fn[:pdf_p_a4];     pdf_l=@md.fn[:pdf_l_a4]
            when /a5/;     pdf_p=@md.fn[:pdf_p_a5];     pdf_l=@md.fn[:pdf_l_a5]
            when /b5/;     pdf_p=@md.fn[:pdf_p_b5];     pdf_l=@md.fn[:pdf_l_b5]
            when /letter/; pdf_p=@md.fn[:pdf_p_letter]; pdf_l=@md.fn[:pdf_l_letter]
            when /legal/;  pdf_p=@md.fn[:pdf_p_legal];  pdf_l=@md.fn[:pdf_l_legal]
            else           pdf_p=@md.fn[:pdf_p_a4];     pdf_l=@md.fn[:pdf_l_a4]
            end
            if FileTest.file?("#{outputdir}/#{pdf_p}")
              system("
                cd #{outputdir}
                rm portrait.pdf
                ln -s #{pdf_p} portrait.pdf
              ")
            end
            if FileTest.file?("#{outputdir}/#{pdf_l}")
              system("
                cd #{outputdir}
                rm landscape.pdf
                ln -s #{pdf_l} landscape.pdf
              ")
            end
          else
            tell=SiSU_Screen::Ansi.new(@md.cmd,"FILE NOT FOUND: << #{@md.fns} >> - requested latex system processing skipped")
            tell.warn
          end
          lst=Dir["*.{aux,log,out}"]
          lst.each {|file| File.unlink(file)} if lst
          #touch("#{@dir_pdf}index.html") #correct @dir_pdf appears to contain slash / and should not
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        end
      end
    end
    class LaTeX_create
      #include SiSU_Param
      @@tex_backslash ||="\\\\"
      @@tilde='\\\\\\~' #?? debug crazy
      @@tex_head={
        'a4'=>{:p => nil, :l => nil},
        'a5'=>{:p => nil, :l => nil},
        'b5'=>{:p => nil, :l => nil},
        'letter'=>{:p => nil, :l => nil},
        'legal'=>{:p => nil, :l => nil},
        'book'=>{:p => nil, :l => nil}
      }
      @@flag_alt,@@flag_group,@@flag_code=false,false,false
      @@dp,@@prefix_b=nil,nil
      def initialize(particulars)
        @particulars=particulars
        @md=@particulars.md
        @env=@particulars.env
        @data=@particulars.dal_array # dal file drawn here
        @st={ :tex=>{} }
        @tex=SiSU_TeX_Pdf::Use_TeX.new(@md)
        @vz=SiSU_Env::Get_init.instance.skin
        @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
        vz=SiSU_Env::Get_init.instance.skin
        @skin_no_ocn=if defined? vz.ocn_display_off \
        and vz.ocn_display_off == true
          true
        else false
        end
      end
      def songsheet
        begin
          data=@data
          @@tex_footnote_array=[]
          @@rights=nil
          tell=SiSU_Screen::Ansi.new(@md.cmd,"pdfTex portrait & landscape")
          tell.txt_grey unless @md.cmd =~/q/
          if @md.rights
            use=@md.rights.dup #dup is necessary, else contents of :rights changed
            sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,use)
            copymark=if @md.author_copymark; '{\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
            else ''
            end
            copymark='Copyright {\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
            copyright=sp_char.special_characters_safe.gsub(/^\s*Copyright \(C\)/, copymark)
            @@rights||="\n #{@@tex_backslash*2}[3]\\ \\linebreak #{copyright}"
          end
          if @md.prefix_b
            sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,@md.prefix_b)
            prefix_b=sp_char.special_characters_safe
            @@prefix_b="\n #{@@tex_backslash*2}[3]\\ \\linebreak \\ #{prefix_b}\n" unless @@prefix_b
          end
          data=pre(data)
          data=footnote(data)
          if @md.flag_tables
            data=tables(data)
          end
          ocn=if @md.markup.inspect =~/no_ocn/ \
          or @md.mod.inspect =~/--no-ocn/ \
          or @skin_no_ocn
            false
          else true
          end
          data=number_paras(data,ocn)
          data=markup(data)
          output(data)
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    protected
      def pre(data)
        @tex_file=[]
        data.each do |para|
          # DEBUG 2003w16 this is a kludge, because i could not get parameters
          # from param, Sort out ... revert to more elegant solution
          # even more of a kludge as had to insert newlines where code is used not satisfactory, think about
          para='' if para =~/#{Mx[:lv_o]}\d+:.*?#{Mx[:lv_c]}.+?#{Mx[:pa_non_object_dummy_heading]}/
          para=if para =~/#{Mx[:br_nl]}|\n/; para.split(/#{Mx[:br_nl]}|\n/)
          else para
          end
          if para.class == String
            @md.flag_tables=true if para =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c/u
            sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,para)
            @tex_file << sp_char.special_characters
          elsif para.class == Array
            para.each do |grp|
              @md.flag_tables=true if grp =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c/u
              sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,grp)
              @tex_file << sp_char.special_characters
            end
          end
        end
        data=@tex_file.delete_if {|x| x =~/^\s*#{Rx[:meta]}/}
        @tex_file
      end
      def footnote(data)
        @tex_file=[]
        data.each do |para|
          # EMBEDDED FOOTNOTES / ENDNOTES should be straightforward but not quite a synch.
          if para =~/#{Mx[:en_a_o]}[\d*+]+\s|#{Mx[:en_b_o]}([*+]\d+)\s/                                                # note escape not necessary in front of ~ has implications for many other matches #debug note
            para.gsub!(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/m,"\\footnote[\\1]{%\n \\2} ") #removed space before \\footnote 2004w21, watch
            para.gsub!(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_b_c]}/m,"\\FootnoteA{\\1}{%\n \\2} ") #work on asterisk footnotes
            para.gsub!(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/m,"\\FootnoteA{\\1}{%\n \\2} ") #work on asterisk footnotes
          end
          @tex_file << para
        end
        @tex_file
      end
      def tables_hash(md,para)
        @block={}
        @para=para
        @md.papersize_array.each do |ps|
          @@tableheader={ ps => { :p => 0, :l => 0 }}
          para,para_p=@para.dup,@para.dup #visit
          txt_obj={:txt =>para,:paper_size =>ps}
          format_l=SiSU_TeX_Pdf::Format_text_object.new(md,txt_obj)
          txt_obj={:txt =>para_p,:paper_size =>ps}
          format_p=SiSU_TeX_Pdf::Format_text_object.new(md,txt_obj)
          @block[ps]={
            :l => format_l.longtable_landscape,
            :p => format_p.longtable_portrait
          }
        end
        @block
      end
      def tables(data)
        @tex_file=[]
        data.each do |para|
          @tex_file << if para =~/#{Mx[:tc_p]}|#{Mx[:gr_o]}T/u
            tables_hash(@md,para) #Hash result
          else para
          end
        end
        @tex_file
      end
      def enclose(para,type='')
        para.strip!
        para=if type =~/code/; para
        elsif para !~/(\\begin\{tabular\}.*|\\end\{tabular\}|&|#{@@tex_backslash*2})\s*$/ #check
          para.gsub!(/(.+)/m,"\n#{@tex.skip_small} \\1 #{@tex.skip_small}\n")
        else para
        end
      end
      def markup_common(para)
        tex_f=nil
        txt_obj={:txt =>para}
        mono=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj)
        if para =~/#{Mx[:gr_o]}(?:code|alt|verse|group)#{Mx[:gr_c]}/ \
        or @@flag_alt
          if para =~/#{Mx[:gr_o]}(?:code|alt|verse|group)#{Mx[:gr_c]}/
            @lineone=case para
            when /#{Mx[:gr_o]}(?:alt|verse|group)#{Mx[:gr_c]}/; para
            when /#{Mx[:gr_o]}code#{Mx[:gr_c]}/; "#{@tex.paraskip_small} \\begin{scriptsize} " + para
            else 'error' #should never occur
            end
          end
          if para =~/<=curly/ #takes care of escaped curly braces, expand
            sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,para)
            para=sp_char.special_characters_curly(para)
          end
          regx=/#{Mx[:gr_o]}((?:code|alt|verse|group)(?:-end)?)#{Mx[:gr_c]}/m
          x=nil
          x=regx.match(para)[1] if para =~regx
          para.gsub!(/\n#{Mx[:gr_o]}(?:code|alt|verse|group)#{Mx[:gr_c]}\n/m,'')
          para=enclose(para,'code') unless para =~/^$/
          if x =~/(?:alt|verse|group)/; @@flag_alt=true
            if x =~/group/; @@flag_group=true
            end
          elsif x =~/code/; @@flag_alt,@@flag_code=true,true
          elsif @@flag_alt
            if para =~ /(?:https?|file|ftp)/m
              txt_obj={:txt =>para,:paper_size =>'a4'}
              para=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj).http
            end
            @group_collect << para #<< "\n\n"
          end
          if x =~/(?:code|alt|verse|group)-end/m
            regx=/(\\+marginpar\{\\+begin\{tiny\}\d+\\+end\{tiny\}\})/
            y=if para =~regx
              regx.match(para)[1]
            else ''
            end
            para.gsub!(regx,'')
            group_collect=[]
            group_collect << '\begin{footnotesize} ' unless @@flag_code
            @group_collect.each do |x|
              x.gsub!(/(<:\S+>|#{Mx[:id_o]}.*?#{Mx[:id_c]}|#{Mx[:tc_o]}.*?#{Mx[:tc_c]}|#{Mx[:gr_o]}.*?#{Mx[:gr_c]}|<!.*?!>|<!>)/,' ') #Mx fix
              x=x.split(/ \\\\ /)
              group_collect << x
            end
            group_collect << ' \end{footnotesize} ' unless @@flag_code
            @group_collect=group_collect.flatten
            @lineone.gsub!(/(<:\S+>|#{Mx[:fa_o]}.*?#{Mx[:fa_c]}|#{Mx[:gr_o]}.*?#{Mx[:gr_c]}|<!.*?!>|<!>)/,' ')
            insert=[]
            insert=if para =~/#{Mx[:gr_o]}code-end#{Mx[:gr_c]}/m
              insert << y + @lineone << @group_collect << ' \end{scriptsize}' << " #{@tex.paraskip_normal}"
            else insert << y + @lineone << @group_collect
            end
            para.gsub!(/(<:\S+>|#{Mx[:fa_o]}.*?#{Mx[:fa_c]}|#{Mx[:gr_o]}.*?#{Mx[:gr_c]}|<!.*?!>|<!>)/,' ')
            @@flag_alt,@@flag_group,@@flag_code=false,false,false
            @group_collect=[]
            tex_f=insert.flatten
          end
          para=tex_f
        else
          case para
          when /^#{Mx[:lv_o_1]}/;                    mono.level1
          when /^#{Mx[:lv_o_2]}/;                    mono.level2
          when /^#{Mx[:lv_o_3]}/;                    mono.level3
          when /^#{Mx[:lv_o_4]}/;                    mono.level4
          when /^#{Mx[:lv_o_5]}/;                    mono.level5
          when /^#{Mx[:lv_o_6]}/;                    mono.level6
          when /^#{Mx[:pa_o]}:i([1-9])#{Mx[:pa_c]}/; mono.indent($1)
          when /<:=/;                                mono.symbol_graphic #watch
          when /^\s*<:image\s+/;                     mono.image
          when /#{Mx[:lnk_c]}image/;                 mono.png
          else
            para.strip!
            para=enclose(para) unless para =~/^$/
          end
          para.gsub!(/\s*(?:#{Mx[:br_line]}|#{Mx[:br_nl]})\s*/,' \\\\\\\\ ')   #% tread with care
          para.gsub!(/(\.#{@@tilde}\S*\s*|<:\S+>|#{Mx[:fa_o]}.*?#{Mx[:fa_c]}|#{Mx[:gr_o]}.*?#{Mx[:gr_c]}|<!.*?!>|<!>)/,' ')   #% tread with care
          #para.gsub!(/(.#{@@tilde}(?:\\~\S+)?\s*|<:\S+>|<!.*?!>|<!>)/,' ')  #KEEP reference, problem escaping open curly braces \{
          if para =~/<=curly/ #takes care of escaped curly braces, expand
            sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,para)
            para=sp_char.special_characters_curly(para)
          end
          para
        end
        if para =~ /(?:https?|file|ftp)/
          para=if para !~/\.(?:png|jpg|gif)/
            txt_obj={:txt =>para,:paper_size =>'a4'}
            SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj).http
          else
            @block={}
            @md.papersize_array.each do |ps|
              txt_obj={:txt =>para,:paper_size =>ps}
              image=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj).http
              @block[ps]={
                :l => image,
                :p => image
              }
            end
            @block
          end
        end
        para
      end
      def markup(data)
        @tex_file=[]
        md={}
        #% document headers watch special characters in title & subtitle: glark "\{\{~(sub)?title.+?[$&%#_\{\}]" *.(lm|er)??
        home=@vz.txt_home.gsub(/#{Mx[:br_line]}|#{Mx[:br_nl]}|#{Mx[:br_paragraph]}|\\\\/,' - ') #no line splitting in heading neither html nor latex
        title=@md.title.gsub(/#{Mx[:br_line]}|#{Mx[:br_nl]}|#{Mx[:br_paragraph]}|\\\\/,' - ') #no line splitting in heading neither html nor latex
        subtitle=@md.subtitle.gsub(/#{Mx[:br_line]}|#{Mx[:br_nl]}|#{Mx[:br_paragraph]}|\\\\/,' - ') if @md.subtitle #no line splitting in heading neither html nor latex
        @md.papersize_array.each do |ps|
          txt_obj={:txt =>"#{home}: - #{title} #{subtitle}",:paper_size =>ps,:orientation =>'portrait'}
          orient_portrait=SiSU_TeX_Pdf::Format_head.new(@md,txt_obj)
          txt_obj={:txt =>"#{home}: - #{title} #{subtitle}",:paper_size =>ps,:orientation =>'landscape'}
          orient_landscape=SiSU_TeX_Pdf::Format_head.new(@md,txt_obj)
          @@tex_head[ps][:p]=orient_portrait.document_head_with_orientation
          @@tex_head[ps][:l]=orient_landscape.document_head_with_orientation
        end
        @tex_file <<<<WOK
#{@tex.header}#{@tex.footer}
\\tolerance=300
\\clubpenalty=300
\\widowpenalty=300
\\makeatother
\\makeatother
\\chardef\\txtbullet="2022
\\chardef\\tilde="7E
% \\sloppy
\\begin{document}
WOK
        sisu_rc_footnote=if @md.sc_info; @tex.doc_sc_info_footnote_full
        else                             @tex.doc_sc_info_footnote_brief
        end
        @copymark='' #check and remove as now is superflous
        x={}
        txt_obj={:title =>@md.title,:subtitle =>@md.subtitle}
        x[:l]=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj).title_landscape
        x[:p]=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj).title_portrait
        @tex_file << x
        x=nil
        if @md.author
          sp_char=SiSU_TeX_Pdf::Special_characters.new(@md,@md.author)
          author=sp_char.special_characters
          @tex_file << if @md.author_home
            <<WOK

\\author{\\href{#{@md.author_home}}{#@copymark \\textnormal{#{author}}}}
WOK
          else "\n\\author{#@copymark \\textnormal{#{author}}}"
          end
        end
        @tex_file << unless @md.fnb =~/^mail\s*$/; "\n\\date{\\begin{footnotesize} copy @ #{@tex.site} \\end{footnotesize} #{sisu_rc_footnote}}"
        else                                       "\\date"
        end
        @tex_file <<<<WOK
\\pagenumbering{roman}\\maketitle
\\pagestyle{fancy}
WOK
        #@tex_file << @tex.newpage #newpage clearpage depending on portrait or landscape
        @tex_file << "\\newpage\n"
        @tex_file << @@rights if @md.rights #if @orientation =~/landscape/
        @tex_file << @@prefix_b if @md.prefix_b
        @tex_file << @tex.sisu_rights
        @tex_file << if @md.sc_info; @tex.doc_sc_info
        else                         @tex.doc_no_sc_info
        end
        @tex_file << @tex.manifest_info
        x={}
        x[:l] =<<WOK
#{@tex.newpage('landscape')}
\\pagestyle{fancy}
\\tableofcontents
#{@tex.newpage('landscape')}
\\pagenumbering{arabic}
#{@tex.paraskip_normal}
#{@tex.newpage('landscape')}
WOK
        x[:p] =<<WOK
#{@tex.newpage('portrait')}
\\pagestyle{fancy}
\\tableofcontents
#{@tex.newpage('portrait')}
\\pagenumbering{arabic}
#{@tex.paraskip_normal}
#{@tex.newpage('portrait')}
WOK
        @tex_file << x
        x=nil
        @group_collect=[]
        data.each do |para|                                                      #% case follows with levels 1-6 indents & graphics
          if para.class == String
            para=markup_common(para)
          elsif para.class == Hash
            if ( para['a4'] or para['a5'] or para['b5'] \
            or para['letter'] or para['legal'])
              @md.papersize_array.each do |ps|
                if para[ps]
                  if (para[ps][:p] and para[ps][:l])
                    para[ps]={
                      :p => markup_common(para[ps][:p]),
                      :l => markup_common(para[ps][:l])
                    }
                  else p "here #{__FILE__} #{__LINE__}" if @md.cmd.inspect =~/M/
                  end
                end
              end
            elsif (para[:p] and para[:l])
              para = {
                :p => markup_common(para[:p]),
                :l => markup_common(para[:l])
              }
            else p "here #{__FILE__} #{__LINE__}" if @md.cmd.inspect =~/M/
            end
          end
          @tex_file << para
        end
        @tex_file << "\n\\newpage\n" # was \\pagebreak\n
        @md.subtitle_tex=@md.subtitle.dup if @md.subtitle
        # kludge ... look again later
        @tex_file << if @md.doc_skin !~/skin_mail/; @tex.doc_tail
        else                                        @tex.mail_tail
        end
        if defined? @md.lnk \
        and @md.lnk
          @md.lnk.each do |l|
            if l[:say]
              url=%<#{l[:url]}>
              url.gsub!(/(?:\\)*([$&~%_#}{^])/,"\\\\\\1")                         #latex special chars
              s_lnk=l[:say]
              s_lnk.gsub!(/\s*(#{Mx[:br_line]}|#{Mx[:br_nl]}|#{Mx[:br_paragraph]})\s*/,' \\\\\\\\ ')
              s_lnk.gsub!(/(?:\\)*([$&~%_#}{^])/,"\\\\\\1")                       #latex special chars
              if url !~/^\.(\.)?\//
                s_lnk_url=%<\\begin{scriptsize}\\url{#{url}}\\end{scriptsize}>  # note this bit of dereferencing magic
              else
                url.gsub!(/\.\.\//,'')
                s_lnk_url="(#{@tex.site}) \\\\\n" + ' ' +
                  "\\begin{scriptsize}" +
                  %<\\url\{#{@vz.url_root_http}/#{url}\}> + # note this bit of dereferencing magic
                  "\\end{scriptsize}"
              end
              @tex_file << " #{s_lnk} \\\\\n #{s_lnk_url} \n" unless  @md.doc_skin =~/skin_mail/
              s_lnk=s_lnk_url=nil
            end
          end
        end
        @tex_file << " #{@tex.sitename} home: \\\\
\\begin{bfseries}#{@tex.site}\\end{bfseries}
"
        #Stamp.stamp #removed 200408 but watch
        #% code for inclusion of addresses of promulgating authority
        @st[:tex][:stmp]||=@md.stmpd
        stamp=@st[:tex][:stmp] if @st[:tex][:stmp]
        if stamp
          use=stamp.gsub(/\n/,"#{@@tex_backslash*2}\n")
          @tex_file << "\n\\newpage\n"
          @tex_file << "\\section*" +
            "{#{@tex.owner_chapter}}\n" +
            "\\addcontentsline{toc}" +
            "{section}{#{@tex.owner_chapter}}\n"
          @tex_file << "#{use}\n"
          @tex_file << @@rights if @@rights
        end
        @tex_file << "\n\\end{document}"
      end
      def number_paras_numbering(para,ocn)
        if para =~/#{Mx[:id_o]}\\~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/ \
        and para !~/\\end\{longtable\}|#{Mx[:br_eof]}/ #catch <!TZ!>
          m=/(.+?)#{Mx[:id_o]}\\~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m
          parablock=para[m,1]
          paranum=if ocn; para[m,2]
          else ''
          end
          paranum = '' if paranum.to_i == 0
          txt_obj={:txt =>parablock,:ocn =>paranum}
          do_duo=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj)
          para=do_duo.para_num if parablock
        elsif para =~/^#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/ #2005 this is added for tables, rationalise
          m=/#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m
          paranum=para[m,1]
          para.gsub!(/#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
          para="\\marginpar{\\begin{tiny}#{paranum}\\end{tiny}}" + para
        elsif para =~/^#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}/ #extra 2005 this is added for tables, rationalise
          m=/#{Mx[:id_o]}~(\d+);[oh]\d+;\w\d+#{Mx[:id_c]}/m
          paranum=para[m,1]
          para.gsub!(/#{Mx[:id_o]}~\d+;(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}/,'')
          para="\\marginpar{\\begin{tiny}#{paranum}\\end{tiny}}" + para
        elsif para =~/\\end\{longtable\}/ #catch <!TZ!>
          para.gsub!(/#{Mx[:id_o]}\\~\d+#{Mx[:id_c]}|#{Mx[:id_o]}\\~(\d+);(?:[ohm]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
          para.gsub!(/#{Mx[:id_o]}\\~\d+#{Mx[:id_c]}|#{Mx[:id_o]}\\~(\d+);(?:[ohm]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}/,'') #extra
        end
        para
      end
      def number_paras(data,ocn)
        tex_file=[]
        data.each do |para|
          para=if para.class == Hash
            if ( para['a4'] or para['a5'] or para['b5'] \
            or para['letter'] or para['legal'])
              @para={}
              @md.papersize_array.each do |ps|
                if para[ps]
                  if (para[ps][:p] and para[ps][:l])
                    @para[ps]={
                        :p => number_paras_numbering(para[ps][:p],ocn),
                        :l => number_paras_numbering(para[ps][:l],ocn)
                    }
                  else p "here #{__FILE__} #{__LINE__}" if @md.cmd.inspect =~/M/
                  end
                end
              end
            elsif (para[:p] and para[:l])
              @para = {
                :p => number_paras_numbering(para[:p],ocn),
                :l => number_paras_numbering(para[:l],ocn)
              }
            else p "here #{__FILE__} #{__LINE__}" if @md.cmd.inspect =~/M/
            end
          else #elsif para.class == String
            @para=number_paras_numbering(para,ocn)
          end
          tex_file << @para
        end
        tex_file
      end
      def output(array)
        array.flatten!
        array.compact!
        @array=array
        fns_l=@md.fns.gsub(/~/,'-') #this is a sorry fix, but necessary as it appears latex programs like not ~
        @md.papersize_array.each do |ps|
          filename_tex_landscape=File.new("#{@env.path.tex}/#{fns_l}.#{ps}.landscape.tex",'w+')
          filename_tex_portrait=File.new("#{@env.path.tex}/#{fns_l}.#{ps}.tex",'w+')
          filename_tex_portrait << @@tex_head[ps][:p]
          filename_tex_landscape << @@tex_head[ps][:l]
          array.each do |para|
            case para
            when String
              para.gsub!(/^\s+/,'')
              if para !~/\A\s*\Z/
                filename_tex_portrait.puts para,"\n"
                filename_tex_landscape.puts para,"\n"
              end
            when Hash
              if para[ps] and (para[ps][:p] and para[ps][:l])
                para[ps][:p].gsub!(/^\s+/,'') if para[ps][:p]
                para[ps][:l].gsub!(/^\s+/,'') if para[ps][:l]
                if para[ps][:p] !~/\A\s*\Z/
                  filename_tex_portrait.puts para[ps][:p],"\n"
                end
                if para[ps][:l] !~/\A\s*\Z/
                  filename_tex_landscape.puts para[ps][:l],"\n"
                end
              elsif (para[:p] and para[:l])
                para[:p].gsub!(/^\s+/,'') if para[:p]
                para[:l].gsub!(/^\s+/,'') if para[:l]
                if para[:p] !~/\A\s*\Z/
                  filename_tex_portrait.puts para[:p],"\n"
                end
                if para[:l] !~/\A\s*\Z/
                  filename_tex_landscape.puts para[:l],"\n"
                end
              else p "here #{__FILE__} #{__LINE__}" if @md.cmd.inspect =~/M/
              end
            end
          end
          array=@array
          filename_tex_portrait.close
          filename_tex_landscape.close
        end
        @@tex_head={
          'a4'=>{:p => nil, :l => nil},
          'a5'=>{:p => nil, :l => nil},
          'b5'=>{:p => nil, :l => nil},
          'letter'=>{:p => nil, :l => nil},
          'legal'=>{:p => nil, :l => nil},
          'book'=>{:p => nil, :l => nil}
        }
        array=[]
      end
    end
  end
end
__END__
