# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: preprocessing, (document abstraction), data abstraction used
   in subsequent processing

=end
module SiSU_DAL
  require "#{SiSU_lib}/defaults"                           # defaults.rb
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
  require "#{SiSU_lib}/param"                              # param.rb
  require "#{SiSU_lib}/dal_syntax"                         # dal_syntax.rb
  require "#{SiSU_lib}/dal_doc_str"                        # dal_doc_str.rb
  require "#{SiSU_lib}/dal_idx"                            # dal_idx.rb
  require "#{SiSU_lib}/dal_numbering"                      # dal_numbering.rb
  require "#{SiSU_lib}/dal_hash_digest"                    # dal_hash_digest.rb
  require "#{SiSU_lib}/dal_endnotes"                       # dal_endnotes.rb
  require "#{SiSU_lib}/dal_images"                         # dal_images.rb
  require "#{SiSU_lib}/dal_metadata"                       # dal_metadata.rb
  require "#{SiSU_lib}/dal_character_check"                # dal_character_check.rb
  require "#{SiSU_lib}/dal_substitutions_and_insertions"   # dal_substitutions_and_insertions.rb
  require "#{SiSU_lib}/dal_expand_insertions"              # dal_expand_insertions.rb
  require "#{SiSU_lib}/i18n"                               # i18n.rb
  require "#{SiSU_lib}/shared_sem"                         # shared_sem.rb
  include SiSU_Env
  include SiSU_Param
  include SiSU_Viz
  include SiSU_Syntax
  class Instantiate < SiSU_Param::Parameters::Instructions
    def initialize
      @@flag_vocab=0
      @@line_mode=''
    end
  end
  class Source <Instantiate
    @@dal_array,@@html_idx_array=[],[]
    @@fns=nil
    def initialize(opt)
      @opt=opt
      @@fns||@opt.fns
      @my_make_fns=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
      @fnm=@my_make_fns.marshal_meta
      @fnm_idx_html=@my_make_fns.marshal_meta_idx_html
      SiSU_Env::Create_system_link.new.images
      @env=SiSU_Env::Info_env.new
    end
    def read                                                                     #creates dal
      begin
        dal=[]
        @@dal_array=[]
        @@fns=@opt.fns
        create_dal
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        Instantiate.new
      end
    end
    def get                                                                      #reads dal, unless does not exist then creates first
      begin
        dal=[]
        unless @@fns==@opt.fns
          @@fns=@opt.fns
          @@dal_array=[]
        end
        dal=if @@dal_array.empty?; read_fnm
        else @@dal_array.dup #check
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        Instantiate.new
      end
    end
    def get_idx_html                                                             #reads dal idx.html, #unless does not exist then creates first
      begin
        dal=[]
        unless @@fns==@opt.fns
          @@fns=@opt.fns
          @@html_idx_array=[]
        end
        dal=if @@html_idx_array.empty?; read_fnm_idx_html
        else @@html_idx_array.dup #check
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        Instantiate.new
      end
    end
  protected
    def create_dal
      dal_array=[]
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Document Abstraction')
      tell.green_title_hi unless @opt.cmd =~/q/
      file_array=@env.read_source_file(@opt.fns)
      file_array.each do |l|
        if l =~/\r\n/; l.gsub!(/\r\n/,"\n")
        end
      end
      meta=file_array.dup
      meta=meta.join.split("\n\n") #check whether can be eliminated, some of these are large objects to have twice
      @md=SiSU_Param::Parameters::Instructions.new(meta,@opt).extract
      meta=nil
      dal=SiSU_DAL::Make.new(@md,file_array).song
      SiSU_Screen::Ansi.new(@md.cmd,@md.fns,"~meta/#{@md.fns}.meta").output if @md.cmd =~/v/
      tell=SiSU_Screen::Ansi.new(@md.cmd,"dal -> #{@my_make_fns.meta}") if @md.cmd =~/M/
      tell.txt_grey unless @md.cmd =~/q/
      dal.each{|s| dal_array << "#{s.strip}\n\n" unless s.strip.empty?}
      dal_array
    end
    def read_fnm
      dal=[]
      dal=if FileTest.file?(@fnm)
        if RUBY_VERSION < '1.9'
          File.open(@fnm){ |f| dal=Marshal.load(f)}
        else File.open(@fnm,'r:utf-8'){ |f| dal=Marshal.load(f)}
        end
      else SiSU_DAL::Source.new(@opt).create_dal
      end
    end
    def read_fnm_idx_html
      dal=[]
      dal=if FileTest.file?(@fnm_idx_html)
        if RUBY_VERSION < '1.9'
          File.open(@fnm_idx_html){ |f| dal=Marshal.load(f)}
        else File.open(@fnm_idx_html,'r:utf-8'){ |f| dal=Marshal.load(f)}
        end
      else nil
        #SiSU_DAL::Source.new(@opt).create_dal
      end
    end
  end
  class Output
    def initialize(md,data)
      @md,@data=md,data
      @my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @dir=SiSU_Env::Info_env.new(@md.fns)
    end
    def hard_output
      if @md.cmd =~/M/
        filename_meta=@my_make.file_meta
        @data.each {|s| filename_meta.puts s.strip + "\n\n" unless s.strip.empty?}
      else
        hard="#{@dir.path.dal}/#{@md.fns}.meta"
        File.unlink(hard) if FileTest.file?(hard)
      end
    end
    def marshal
      marshal_meta=@my_make.marshal_meta
      File.open(marshal_meta,'w'){|f| Marshal.dump(@data.to_a,f)}
    end
    def idx_html_hard_output
      if @md.book_idx and @md.cmd =~/M/
        filename_meta=@my_make.file_meta_idx_html
        @data.each {|s| filename_meta.puts s.strip + "\n" unless s.strip.empty?}
      else
        hard_idx_html="#{@dir.path.dal}/#{@md.fns}.idx.html"
        File.unlink(hard_idx_html) if FileTest.file?(hard_idx_html)
      end
    end
    def idx_html_marshal
      marshal_meta=@my_make.marshal_meta_idx_html
      File.open(marshal_meta,'w'){|f| Marshal.dump(@data.to_a,f)}
    end
  end
  class Make
    @@dp=nil
    def initialize(md,data)
      @md,@data=md,data
      @env=SiSU_Env::Info_env.new(@md.fns)
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def reset
      @@flag_vocab=0
      @@line_mode=''
    end
    def song
      reset
      data=@data
      @metafile="#{@env.path.dal}/#{@md.fns}.meta"
      my_make_source_file=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      data=data.join.split("\n\n")
      data=SiSU_insertions::Insertions.new(data).expand_insertions?
      data=SiSU_document_structure::Code.new(@md,data).code
      data=SiSU_substitute_and_insert::SI.new(@md,data).substitutions_and_insertions?
      data_new=[]
      data.each do |x|
        data_new << if x =~ /\n\n/m; x.split(/\n\n+/)
        else x
        end
      end
      data=data_new.flatten
      data=SiSU_Syntax::Markup.new(@md,data).songsheet
      data,endnote_array=SiSU_character_check::Check.new(data).character_check_and_oldstyle_endnote_array
      data=SiSU_images::Images.new(@md,data).images
      data=SiSU_document_structure::Tables.new(@md,data).tables
      data=SiSU_numbering::Numbering.new(@md,data).numbering_song
      data,book_index,html_idx=SiSU_book_index::Book_index.new(@md,data,@env).indexing_song if @md.book_idx
      data=SiSU_endnotes::Endnotes.new(@md,data,endnote_array).endnotes
      data=SiSU_hash::Object_digest.new(@md,data,@env).object_digest
      meta=SiSU_metadata::Metadata.new(@md,data).metadata
      #meta=metadata(data)
      outputdata=data + meta
      if @md.cmd =~/[mM]/
        SiSU_DAL::Output.new(@md,outputdata).hard_output
        SiSU_DAL::Output.new(@md,outputdata).marshal
        SiSU_DAL::Output.new(@md,html_idx).idx_html_hard_output
        SiSU_DAL::Output.new(@md,html_idx).idx_html_marshal
      end
      reset
      outputdata
    end
  protected
  end
end
__END__
dal output, rules to simplify parsing
nodes === objects === paragraphs === text blocks separated by \n\n

dal output:
:verse :group and :code have -end
:table is not used
